/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document.viewing;

import com.ibm.icu.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.data.engine.api.ISortDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.cache.SortSpec;
import org.eclipse.birt.data.engine.impl.ColumnInfo;
import org.eclipse.birt.data.engine.impl.QueryExecutorUtil;
import org.eclipse.birt.data.engine.odi.IQuery;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.mozilla.javascript.Context;

public class ViewingUtil {
    public static List getSortList(List sorts, Context cx) {
        IQuery.SortSpec[] sortSpecs = null;
        if (sorts != null && sorts.size() > 0) {
            sortSpecs = new IQuery.SortSpec[sorts.size()];
            Iterator it = sorts.iterator();
            int i = 0;
            while (it.hasNext()) {
                IQuery.SortSpec dest;
                ISortDefinition src = (ISortDefinition)it.next();
                int sortIndex = -1;
                String sortKey = src.getColumn();
                if (sortKey == null || sortKey.length() == 0) {
                    ColumnInfo columnInfo = QueryExecutorUtil.getColInfoFromJSExpr(cx, src.getExpression().getText());
                    sortIndex = columnInfo.getColumnIndex();
                    sortKey = columnInfo.getColumnName();
                }
                sortSpecs[i] = dest = new IQuery.SortSpec(sortIndex, sortKey, src.getSortDirection() == 0, (Comparator)(src.getSortStrength() == -1 ? null : Collator.getInstance()));
                ++i;
            }
        }
        if (sortSpecs == null) {
            return null;
        }
        return Arrays.asList(sortSpecs);
    }

    public static SortSpec getSortSpec(IQuery.GroupSpec[] groupDefns, IQuery.SortSpec[] sortDefns, IResultClass rsMeta) throws DataException {
        int groupCount = 0;
        int sortCount = 0;
        if (groupDefns != null) {
            int i = 0;
            while (i < groupDefns.length) {
                if (groupDefns[i].getKeyIndex() >= 0) {
                    ++groupCount;
                }
                ++i;
            }
        }
        if (sortDefns != null) {
            sortCount = sortDefns.length;
        }
        boolean doGroupSort = false;
        int i = 0;
        while (i < groupCount) {
            if (groupDefns[i].getSortDirection() != -1) {
                doGroupSort = true;
                break;
            }
            ++i;
        }
        if (!doGroupSort) {
            groupCount = 0;
        }
        int[] sortKeyIndexes = new int[groupCount + sortCount];
        String[] sortKeyNames = new String[groupCount + sortCount];
        boolean[] sortAscending = new boolean[groupCount + sortCount];
        Comparator[] comparator = new Comparator[groupCount + sortCount];
        int i2 = 0;
        while (i2 < groupCount) {
            int index = groupDefns[i2].getKeyIndex();
            if (index >= 0) {
                sortKeyIndexes[i2] = groupDefns[i2].getKeyIndex();
                sortKeyNames[i2] = groupDefns[i2].getKeyColumn();
                sortAscending[i2] = groupDefns[i2].getSortDirection() != 1;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < sortCount) {
            int keyIndex = sortDefns[i2].getIndex();
            String keyName = sortDefns[i2].getField();
            if (keyName != null) {
                keyIndex = rsMeta.getFieldIndex(keyName);
            }
            if (keyIndex < 1 || keyIndex > rsMeta.getFieldCount()) {
                throw new DataException("data.engine.InvalidSortKeyColumn", keyName);
            }
            sortKeyIndexes[groupCount + i2] = keyIndex;
            sortKeyNames[groupCount + i2] = sortDefns[i2].getField();
            sortAscending[groupCount + i2] = sortDefns[i2].isAscendingOrder();
            comparator[groupCount + i2] = sortDefns[i2].getComparator();
            ++i2;
        }
        return new SortSpec(sortKeyIndexes, sortKeyNames, sortAscending, comparator);
    }
}

