/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import java.util.Hashtable;
import java.util.logging.Level;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.odaconsumer.DataSetCapabilities;
import org.eclipse.birt.data.engine.odaconsumer.LogHelper;
import org.eclipse.birt.data.engine.odaconsumer.PreparedStatement;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IDataSetMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class Connection {
    private String m_dataSourceId;
    private IConnection m_connection;
    private Hashtable m_cachedDsMetaData;
    private static String sm_className = Connection.class.getName();
    private static String sm_loggerName = "org.eclipse.birt.data.engine.odaconsumer";
    private static LogHelper sm_logger = LogHelper.getInstance(sm_loggerName);

    Connection(IConnection connection, String dataSourceId) throws OdaException {
        String methodName = "Connection";
        if (sm_logger.isLoggingEnterExitLevel()) {
            sm_logger.entering(sm_className, methodName, new Object[]{connection, dataSourceId});
        }
        assert (connection != null && connection.isOpen());
        this.m_dataSourceId = dataSourceId;
        this.m_connection = connection;
        sm_logger.exiting(sm_className, methodName, this);
    }

    public int getMaxQueries() throws DataException {
        String methodName = "getMaxQueries";
        sm_logger.entering(sm_className, methodName);
        try {
            int ret = this.m_connection.getMaxQueries();
            sm_logger.exiting(sm_className, methodName, ret);
            return ret;
        }
        catch (OdaException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, methodName, "Cannot get max queries.", ex);
            throw new DataException("odaconsumer.CannotGetMaxStatements", ex);
        }
        catch (UnsupportedOperationException ex) {
            sm_logger.logp(Level.INFO, sm_className, methodName, "Cannot get max queries.", ex);
            return 0;
        }
    }

    public DataSetCapabilities getMetaData(String dataSetType) throws DataException {
        String methodName = "getMetaData";
        sm_logger.entering(sm_className, methodName, dataSetType);
        String cachedKey = dataSetType == null ? this.getDataSourceId() : dataSetType;
        DataSetCapabilities capabilities = (DataSetCapabilities)this.getCachedDsMetaData().get(cachedKey);
        if (capabilities == null) {
            IDataSetMetaData dsMetaData = null;
            try {
                dsMetaData = this.m_connection.getMetaData(dataSetType);
            }
            catch (OdaException ex) {
                sm_logger.logp(Level.SEVERE, sm_className, methodName, "Cannot get data set metadata.", ex);
                throw new DataException("odaconsumer.CannotGetDataSetMetaData", (Throwable)ex, new Object[]{dataSetType});
            }
            catch (UnsupportedOperationException ex) {
                sm_logger.logp(Level.SEVERE, sm_className, methodName, "Cannot get data set metadata.", ex);
                throw new DataException("odaconsumer.CannotGetDataSetMetaData", (Throwable)ex, new Object[]{dataSetType});
            }
            capabilities = new DataSetCapabilities(dsMetaData);
            this.getCachedDsMetaData().put(cachedKey, capabilities);
        }
        sm_logger.exiting(sm_className, methodName, capabilities);
        return capabilities;
    }

    public PreparedStatement prepareStatement(String query, String dataSetType) throws DataException {
        String methodName = "prepareStatement";
        if (sm_logger.isLoggingEnterExitLevel()) {
            sm_logger.entering(sm_className, methodName, new Object[]{query, dataSetType});
        }
        IQuery statement = this.prepareOdaQuery(query, dataSetType);
        PreparedStatement ret = new PreparedStatement(statement, dataSetType, this, query);
        sm_logger.exiting(sm_className, methodName, ret);
        return ret;
    }

    public void close() throws DataException {
        String methodName = "close";
        sm_logger.entering(sm_className, methodName);
        try {
            this.m_connection.close();
        }
        catch (OdaException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, methodName, "Cannot close connection.", ex);
            throw new DataException("odaconsumer.CannotCloseConnection", ex);
        }
        catch (UnsupportedOperationException ex) {
            sm_logger.logp(Level.WARNING, sm_className, methodName, "Cannot close connection.", ex);
        }
        sm_logger.exiting(sm_className, methodName);
    }

    private Hashtable getCachedDsMetaData() {
        if (this.m_cachedDsMetaData == null) {
            this.m_cachedDsMetaData = new Hashtable();
        }
        return this.m_cachedDsMetaData;
    }

    String getDataSourceId() {
        return this.m_dataSourceId;
    }

    IQuery prepareOdaQuery(String query, String dataSetType) throws DataException {
        String methodName = "prepareOdaQuery";
        if (sm_logger.isLoggingEnterExitLevel()) {
            sm_logger.entering(sm_className, methodName, new Object[]{query, dataSetType});
        }
        try {
            assert (this.m_connection.isOpen());
            IQuery statement = this.m_connection.newQuery(dataSetType);
            statement.prepare(query);
            sm_logger.exiting(sm_className, methodName, statement);
            return statement;
        }
        catch (OdaException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, methodName, "Cannot prepare statement.", ex);
            throw new DataException("odaconsumer.CannotPrepareStatement", (Throwable)ex, new Object[]{query, dataSetType});
        }
        catch (UnsupportedOperationException ex) {
            sm_logger.logp(Level.SEVERE, sm_className, methodName, "Cannot prepare statement.", ex);
            throw new DataException("odaconsumer.CannotPrepareStatement", (Throwable)ex, new Object[]{query, dataSetType});
        }
    }
}

