/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import java.util.Hashtable;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.odaconsumer.Driver;
import org.eclipse.birt.data.engine.odaconsumer.LogHelper;
import org.eclipse.datatools.connectivity.oda.IDriver;
import org.eclipse.datatools.connectivity.oda.util.manifest.ExtensionManifest;

public class DriverManager {
    private static DriverManager sm_driverManager = null;
    private Hashtable m_loadedDrivers;
    private static final String sm_className = DriverManager.class.getName();
    private static LogHelper sm_logger;

    private DriverManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DriverManager getInstance() {
        if (sm_driverManager != null) return sm_driverManager;
        Class<DriverManager> clazz = DriverManager.class;
        synchronized (DriverManager.class) {
            if (sm_driverManager != null) return sm_driverManager;
            sm_driverManager = new DriverManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sm_driverManager;
        }
    }

    static void releaseInstance() {
        sm_driverManager = null;
        sm_logger = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static LogHelper getLogger() {
        if (sm_logger != null) return sm_logger;
        Class<DriverManager> clazz = DriverManager.class;
        synchronized (DriverManager.class) {
            if (sm_logger != null) return sm_logger;
            sm_logger = LogHelper.getInstance("org.eclipse.birt.data.engine.odaconsumer");
            // ** MonitorExit[var0] (shouldn't be in output)
            return sm_logger;
        }
    }

    public IDriver getDriverHelper(String dataSourceElementId) throws DataException {
        DriverManager.getLogger().entering(sm_className, "getDriverHelper", dataSourceElementId);
        Driver driver = this.getDriver(dataSourceElementId);
        IDriver ret = driver.getDriverHelper();
        DriverManager.getLogger().exiting(sm_className, "getDriverHelper", ret);
        return ret;
    }

    public String getExtensionDataSourceId(String dataSourceElementId) throws DataException {
        DriverManager.getLogger().entering(sm_className, "getExtensionDataSourceId", dataSourceElementId);
        Driver driver = this.getDriver(dataSourceElementId);
        ExtensionManifest config = driver.getDriverExtensionConfig();
        String ret = config.getDataSourceElementID();
        DriverManager.getLogger().exiting(sm_className, "getExtensionDataSourceId", ret);
        return ret;
    }

    private Driver getDriver(String dataSourceElementId) {
        assert (dataSourceElementId != null && dataSourceElementId.length() != 0);
        Driver driver = (Driver)this.getLoadedDrivers().get(dataSourceElementId);
        if (driver == null) {
            driver = new Driver(dataSourceElementId);
            this.getLoadedDrivers().put(dataSourceElementId, driver);
        }
        return driver;
    }

    Hashtable getLoadedDrivers() {
        if (this.m_loadedDrivers == null) {
            this.m_loadedDrivers = new Hashtable();
        }
        return this.m_loadedDrivers;
    }
}

