/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.api;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.FileArchiveReader;
import org.eclipse.birt.core.archive.FileArchiveWriter;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.impl.document.stream.VersionManager;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.api.IComputedMeasureHelper;
import org.eclipse.birt.data.engine.olap.data.api.ICubeQueryExcutorHelper;
import org.eclipse.birt.data.engine.olap.data.api.IDimensionResultIterator;
import org.eclipse.birt.data.engine.olap.data.api.MeasureInfo;
import org.eclipse.birt.data.engine.olap.data.api.cube.ICube;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDimension;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentManager;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationResultSetSaveUtil;
import org.eclipse.birt.data.engine.olap.data.impl.Cube;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationExecutor;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.DataSet4AggregationFactory;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.IDataSet4Aggregation;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter.AggrMeasureFilterHelper;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter.AggregationFilterHelper;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter.LevelFilter;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter.LevelFilterHelper;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter.SimpleLevelFilter;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.sort.AggrSortHelper;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.sort.ITargetSort;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Dimension;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionResultIterator;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.FactTableRowIterator;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;
import org.eclipse.birt.data.engine.olap.util.filter.IAggrMeasureFilterEvalHelper;
import org.eclipse.birt.data.engine.olap.util.filter.ICubePosFilter;
import org.eclipse.birt.data.engine.olap.util.filter.IJSFilterHelper;
import org.eclipse.birt.data.engine.olap.util.filter.IJSMeasureFilterEvalHelper;
import org.eclipse.birt.data.engine.olap.util.sort.IJSSortHelper;

public class CubeQueryExecutorHelper
implements ICubeQueryExcutorHelper {
    private Cube cube;
    private List levelFilters = null;
    private List simpleLevelFilters = null;
    private List measureFilters = null;
    private Map dimJSFilterMap = null;
    private Map dimRowForFilterMap = null;
    private List rowSort = null;
    private List columnSort = null;
    private List pageSort = null;
    private boolean isBreakHierarchy = true;
    private IComputedMeasureHelper computedMeasureHelper = null;
    private List aggrFilterHelpers;
    private List aggrMeasureFilters;
    private List cubePosFilters;
    private static Logger logger = Logger.getLogger(CubeQueryExecutorHelper.class.getName());

    public CubeQueryExecutorHelper(ICube cube) throws DataException {
        this(cube, null);
    }

    public CubeQueryExecutorHelper(ICube cube, IComputedMeasureHelper computedMeasureHelper) throws DataException {
        Object[] params = new Object[]{cube, computedMeasureHelper};
        logger.entering(CubeQueryExecutorHelper.class.getName(), "CubeQueryExecutorHelper", params);
        this.cube = (Cube)cube;
        this.computedMeasureHelper = computedMeasureHelper;
        if (this.computedMeasureHelper != null) {
            this.validateComputedMeasureNames();
        }
        this.simpleLevelFilters = new ArrayList();
        this.levelFilters = new ArrayList();
        this.measureFilters = new ArrayList();
        this.aggrFilterHelpers = new ArrayList();
        this.aggrMeasureFilters = new ArrayList();
        this.dimJSFilterMap = new HashMap();
        this.dimRowForFilterMap = new HashMap();
        this.rowSort = new ArrayList();
        this.columnSort = new ArrayList();
        this.pageSort = new ArrayList();
        logger.exiting(CubeQueryExecutorHelper.class.getName(), "CubeQueryExecutorHelper");
    }

    public IDiskArray getLevelMembers(DimLevel level) {
        return null;
    }

    public static ICube loadCube(String cubeName, IDocumentManager documentManager, StopSign stopSign) throws IOException, DataException {
        Cube cube = new Cube(cubeName, documentManager);
        cube.load(stopSign);
        return cube;
    }

    public static void saveAggregationResultSet(IDocArchiveWriter writer, String name, IAggregationResultSet[] resultSets) throws IOException {
        AggregationResultSetSaveUtil.save(name, resultSets, writer);
    }

    public static void saveAggregationResultSet(String pathName, String name, IAggregationResultSet[] resultSets) throws IOException {
        FileArchiveWriter writer = new FileArchiveWriter(CubeQueryExecutorHelper.getTmpFileName(pathName, name));
        AggregationResultSetSaveUtil.save(name, resultSets, (IDocArchiveWriter)writer);
        writer.flush();
        writer.finish();
    }

    public static IAggregationResultSet[] loadAggregationResultSet(IDocArchiveReader reader, String name) throws IOException {
        return AggregationResultSetSaveUtil.load(name, reader, VersionManager.getLatestVersion());
    }

    public static IAggregationResultSet[] loadAggregationResultSet(String pathName, String name) throws IOException {
        FileArchiveReader reader = new FileArchiveReader(CubeQueryExecutorHelper.getTmpFileName(pathName, name));
        IAggregationResultSet[] result = AggregationResultSetSaveUtil.load(name, (IDocArchiveReader)reader, VersionManager.getLatestVersion());
        reader.close();
        return result;
    }

    private static String getTmpFileName(String pathName, String name) {
        return String.valueOf(pathName) + File.separator + "cubequeryresult" + name;
    }

    public void addRowSort(ITargetSort sort) {
        this.rowSort.add(sort);
    }

    public List getRowSort() {
        return this.rowSort;
    }

    public List getColumnSort() {
        return this.columnSort;
    }

    public void addColumnSort(ITargetSort sort) {
        this.columnSort.add(sort);
    }

    public List getPageSort() {
        return this.pageSort;
    }

    public void addPageSort(ITargetSort sort) {
        this.pageSort.add(sort);
    }

    public void addFilter(LevelFilter levelFilter) {
        this.levelFilters.add(levelFilter);
    }

    public void addSimpleLevelFilter(SimpleLevelFilter simpleLevelFilter) {
        this.simpleLevelFilters.add(simpleLevelFilter);
    }

    public void clear() {
        this.levelFilters.clear();
        this.aggrFilterHelpers.clear();
        this.aggrMeasureFilters.clear();
        this.dimJSFilterMap.clear();
        this.dimRowForFilterMap.clear();
        this.rowSort.clear();
        this.columnSort.clear();
    }

    public void close() {
        this.levelFilters = null;
        this.aggrFilterHelpers = null;
        this.aggrMeasureFilters = null;
        this.dimJSFilterMap = null;
        this.dimRowForFilterMap = null;
        this.rowSort = null;
        this.columnSort = null;
    }

    public IAggregationResultSet[] execute(AggregationDefinition[] aggregations, StopSign stopSign) throws IOException, BirtException {
        IAggregationResultSet[] resultSet = this.onePassExecute(aggregations, stopSign);
        this.applyAggrFilters(aggregations, resultSet, stopSign);
        this.applyAggrSort(resultSet);
        return resultSet;
    }

    private void applyAggrSort(IAggregationResultSet[] resultSet) throws DataException {
        if (!this.columnSort.isEmpty()) {
            AggrSortHelper.sort(this.columnSort, resultSet);
            this.closeSortHelpers(this.columnSort);
        }
        if (!this.rowSort.isEmpty()) {
            AggrSortHelper.sort(this.rowSort, resultSet);
            this.closeSortHelpers(this.rowSort);
        }
    }

    private void closeSortHelpers(List sorts) {
        for (ITargetSort targetSot : sorts) {
            if (!(targetSot instanceof IJSSortHelper)) continue;
            IJSSortHelper sortHelper = (IJSSortHelper)targetSot;
            sortHelper.close();
        }
    }

    private void applyAggrFilters(AggregationDefinition[] aggregations, IAggregationResultSet[] resultSet, StopSign stopSign) throws IOException, DataException, BirtException {
        boolean recalculate = false;
        if (!this.aggrMeasureFilters.isEmpty()) {
            AggrMeasureFilterHelper filter = new AggrMeasureFilterHelper(this.cube, resultSet);
            this.cubePosFilters = filter.getCubePosFilters(this.aggrMeasureFilters);
            recalculate = true;
        }
        if (!this.aggrFilterHelpers.isEmpty()) {
            AggregationFilterHelper filterHelper = new AggregationFilterHelper(this.cube, this.aggrFilterHelpers);
            List newFilters = filterHelper.generateLevelFilters(aggregations, resultSet);
            if (newFilters == null) {
                int i = 0;
                while (i < resultSet.length) {
                    resultSet[i].clear();
                    recalculate = false;
                    ++i;
                }
            } else {
                this.levelFilters.addAll(newFilters);
                int i = 0;
                while (i < resultSet.length) {
                    resultSet[i].close();
                    resultSet[i] = null;
                    ++i;
                }
                recalculate = true;
            }
        }
        if (recalculate) {
            IAggregationResultSet[] temp = this.onePassExecute(aggregations, stopSign);
            System.arraycopy(temp, 0, resultSet, 0, resultSet.length);
        }
    }

    private IAggregationResultSet[] onePassExecute(AggregationDefinition[] aggregations, StopSign stopSign) throws DataException, IOException, BirtException {
        IDiskArray[] dimPosition = this.getFilterResult();
        int count = 0;
        int i = 0;
        while (i < dimPosition.length) {
            if (dimPosition[i] != null) {
                ++count;
            }
            ++i;
        }
        IDimension[] dimensions = this.cube.getDimesions();
        String[] validDimensionName = new String[count];
        IDiskArray[] validDimPosition = new IDiskArray[count];
        int pos = 0;
        int i2 = 0;
        while (i2 < dimPosition.length) {
            if (dimPosition[i2] != null) {
                validDimPosition[pos] = dimPosition[i2];
                validDimensionName[pos] = dimensions[i2].getName();
                ++pos;
            }
            ++i2;
        }
        FactTableRowIterator factTableRowIterator = new FactTableRowIterator(this.cube.getFactTable(), validDimensionName, validDimPosition, this.computedMeasureHelper, stopSign);
        if (this.cubePosFilters != null && !this.cubePosFilters.isEmpty()) {
            for (ICubePosFilter cubePosFilter : this.cubePosFilters) {
                factTableRowIterator.addCubePosFilter(cubePosFilter);
            }
        }
        int i3 = 0;
        while (i3 < this.measureFilters.size()) {
            factTableRowIterator.addMeasureFilter((IJSMeasureFilterEvalHelper)this.measureFilters.get(i3));
            ++i3;
        }
        IDimensionResultIterator[] dimensionResultIterators = this.populateDimensionResultIterator(dimPosition, stopSign);
        IDataSet4Aggregation dataSet4Aggregation = DataSet4AggregationFactory.createDataSet4Aggregation(factTableRowIterator, dimensionResultIterators);
        AggregationExecutor aggregationCalculatorExecutor = new AggregationExecutor(dataSet4Aggregation, aggregations);
        return aggregationCalculatorExecutor.execute(stopSign);
    }

    public static IAggregationResultSet computeNestAggregation(IAggregationResultSet aggrResultSet, AggregationDefinition aggrDef, StopSign stopSign) throws IOException, BirtException {
        IDataSet4Aggregation dataSet4Aggregation = DataSet4AggregationFactory.createDataSet4Aggregation(aggrResultSet);
        AggregationExecutor aggregationCalculatorExecutor = new AggregationExecutor(dataSet4Aggregation, new AggregationDefinition[]{aggrDef});
        return aggregationCalculatorExecutor.execute(stopSign)[0];
    }

    private DimensionResultIterator[] populateDimensionResultIterator(IDiskArray[] position, StopSign stopSign) throws DataException, IOException {
        IDimension[] dimensions = this.cube.getDimesions();
        DimensionResultIterator[] dimResultSet = new DimensionResultIterator[dimensions.length];
        int i = 0;
        while (i < dimensions.length) {
            dimResultSet[i] = position[i] == null ? new DimensionResultIterator((Dimension)dimensions[i], dimensions[i].findAll(), stopSign) : new DimensionResultIterator((Dimension)dimensions[i], position[i], stopSign);
            ++i;
        }
        return dimResultSet;
    }

    private List getDimensionJSFilterList(String dimensionName) {
        Object value = this.dimJSFilterMap.get(dimensionName);
        if (value != null) {
            return (List)value;
        }
        ArrayList list = new ArrayList();
        this.dimJSFilterMap.put(dimensionName, list);
        return list;
    }

    private IDiskArray[] getFilterResult() throws DataException, IOException {
        IDimension[] dimensions = this.cube.getDimesions();
        IDiskArray[] dimPosition = new IDiskArray[dimensions.length];
        int i = 0;
        while (i < dimPosition.length) {
            Dimension dimension = (Dimension)dimensions[i];
            List jsFilters = this.getDimensionJSFilterList(dimension.getName());
            LevelFilterHelper filterHelper = new LevelFilterHelper(dimension, this.simpleLevelFilters, this.levelFilters);
            dimPosition[i] = filterHelper.getJSFilterResult(jsFilters, this.isBreakHierarchy);
            ++i;
        }
        return dimPosition;
    }

    public void addAggrMeasureFilter(IAggrMeasureFilterEvalHelper aggrFilterHelper) {
        this.aggrMeasureFilters.add(aggrFilterHelper);
    }

    public void addJSFilter(IJSFilterHelper filterEvalHelper) {
        if (!filterEvalHelper.isAggregationFilter()) {
            String dimesionName = filterEvalHelper.getDimensionName();
            List filterList = this.getDimensionJSFilterList(dimesionName);
            filterList.add(filterEvalHelper);
        } else {
            this.aggrFilterHelpers.add(filterEvalHelper);
        }
    }

    public void addJSFilter(List filterEvalHelperList) {
        int i = 0;
        while (i < filterEvalHelperList.size()) {
            this.addJSFilter((IJSFilterHelper)filterEvalHelperList.get(i));
            ++i;
        }
    }

    public void addMeasureFilter(IJSMeasureFilterEvalHelper measureFilter) {
        this.measureFilters.add(measureFilter);
    }

    public void setBreakHierarchy(boolean isBreakHierarchy) {
        this.isBreakHierarchy = isBreakHierarchy;
    }

    private void validateComputedMeasureNames() throws DataException {
        HashSet<String> existNames = new HashSet<String>((Collection)Arrays.asList(this.cube.getMeasureNames()));
        MeasureInfo[] mis = this.computedMeasureHelper.getAllComputedMeasureInfos();
        int i = 0;
        while (i < mis.length) {
            String name = mis[i].getMeasureName();
            if (existNames.contains(name)) {
                throw new DataException("data.olap.duplicateMeasureName", name);
            }
            existNames.add(name);
            ++i;
        }
    }
}

