/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.aggregation;

import java.io.IOException;
import java.util.Arrays;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.i18n.DataResourceHandle;
import org.eclipse.birt.data.engine.olap.data.api.IDimensionResultIterator;
import org.eclipse.birt.data.engine.olap.data.api.ILevel;
import org.eclipse.birt.data.engine.olap.data.api.MeasureInfo;
import org.eclipse.birt.data.engine.olap.data.impl.DimColumn;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.IDataSet4Aggregation;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Member;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.IFactTableRowIterator;

class DataSetFromOriginalCube
implements IDataSet4Aggregation {
    IFactTableRowIterator factTableRowIterator;
    IDimensionResultIterator[] dimensionResultIterators;
    private int[] positions = null;

    public DataSetFromOriginalCube(IFactTableRowIterator factTableRowIterator, IDimensionResultIterator[] dimensionResultIterators) {
        this.dimensionResultIterators = dimensionResultIterators;
        this.factTableRowIterator = factTableRowIterator;
        this.positions = new int[dimensionResultIterators.length];
        Arrays.fill(this.positions, 0);
    }

    public IDataSet4Aggregation.MetaInfo getMetaInfo() {
        return new IDataSet4Aggregation.MetaInfo(){

            public String[] getAttributeNames(int dimIndex, int levelIndex) {
                IDimensionResultIterator itr = DataSetFromOriginalCube.this.dimensionResultIterators[dimIndex];
                return itr.getDimesion().getHierarchy().getLevels()[levelIndex].getAttributeNames();
            }

            public IDataSet4Aggregation.ColumnInfo getColumnInfo(DimColumn dimColumn) throws DataException {
                String dimensionName = dimColumn.getDimensionName();
                String levelName = dimColumn.getLevelName();
                String columnName = dimColumn.getColumnName();
                int dimIndex = this.getDimensionIndex(dimensionName);
                if (dimIndex < 0) {
                    throw new DataException(String.valueOf(DataResourceHandle.getInstance().getMessage("data.olap.NonexistentDimension")) + dimensionName);
                }
                IDimensionResultIterator itr = DataSetFromOriginalCube.this.dimensionResultIterators[dimIndex];
                int levelIndex = itr.getLevelIndex(levelName);
                if (levelIndex < 0) {
                    throw new DataException(String.valueOf(DataResourceHandle.getInstance().getMessage("data.olap.NonexistentLevel")) + "<" + dimensionName + " , " + levelName + ">");
                }
                ILevel levelInfo = itr.getDimesion().getHierarchy().getLevels()[levelIndex];
                int columnIndex = -1;
                boolean isKey = false;
                int i = 0;
                while (i < levelInfo.getKeyNames().length) {
                    if (levelInfo.getKeyNames()[i].equals(columnName)) {
                        columnIndex = i;
                        isKey = true;
                        break;
                    }
                    ++i;
                }
                if (!isKey) {
                    i = 0;
                    while (i < levelInfo.getAttributeNames().length) {
                        if (levelInfo.getAttributeNames()[i].equals(columnName)) {
                            columnIndex = i;
                            break;
                        }
                        ++i;
                    }
                }
                if (columnIndex < 0) {
                    throw new DataException(String.valueOf(DataResourceHandle.getInstance().getMessage("data.olap.NonexistentKeyOrAttr")) + "<" + dimensionName + " , " + levelName + " , " + columnName + ">");
                }
                return new IDataSet4Aggregation.ColumnInfo(dimIndex, levelIndex, columnIndex, isKey);
            }

            public int getDimensionIndex(String dimensionName) {
                int i = 0;
                while (i < DataSetFromOriginalCube.this.dimensionResultIterators.length) {
                    if (DataSetFromOriginalCube.this.dimensionResultIterators[i].getDimesion().getName().equals(dimensionName)) {
                        return i;
                    }
                    ++i;
                }
                return -1;
            }

            public String[] getKeyNames(int dimIndex, int levelIndex) {
                IDimensionResultIterator itr = DataSetFromOriginalCube.this.dimensionResultIterators[dimIndex];
                return itr.getDimesion().getHierarchy().getLevels()[levelIndex].getKeyNames();
            }

            public int getLevelIndex(String dimensionName, String levelName) {
                int dimIndex = this.getDimensionIndex(dimensionName);
                if (dimIndex >= 0) {
                    IDimensionResultIterator itr = DataSetFromOriginalCube.this.dimensionResultIterators[dimIndex];
                    return itr.getLevelIndex(levelName);
                }
                return -1;
            }

            public int getMeasureIndex(String measureName) {
                return DataSetFromOriginalCube.this.factTableRowIterator.getMeasureIndex(measureName);
            }

            public MeasureInfo[] getMeasureInfos() {
                return DataSetFromOriginalCube.this.factTableRowIterator.getMeasureInfos();
            }
        };
    }

    public boolean next() throws DataException, IOException {
        return this.factTableRowIterator.next();
    }

    public Object getMeasureValue(int measureIndex) {
        return this.factTableRowIterator.getMeasure(measureIndex);
    }

    public Member getMember(int dimIndex, int levelIndex) throws BirtException, IOException {
        String dimensionName = this.dimensionResultIterators[dimIndex].getDimesion().getName();
        int indexInFact = this.factTableRowIterator.getDimensionIndex(dimensionName);
        return this.getLevelObject(dimIndex, levelIndex, this.factTableRowIterator.getDimensionPosition(indexInFact));
    }

    private Member getLevelObject(int dimIndex, int levelIndex, int dimensionPosition) throws BirtException, IOException {
        block2: {
            while (true) {
                this.dimensionResultIterators[dimIndex].seek(this.positions[dimIndex]);
                int curDimPosition = this.dimensionResultIterators[dimIndex].getDimesionPosition();
                if (curDimPosition > dimensionPosition) {
                    int n = dimIndex;
                    this.positions[n] = this.positions[n] - 1;
                    if (this.positions[dimIndex] >= 0) continue;
                    this.positions[dimIndex] = 0;
                    return null;
                }
                if (curDimPosition >= dimensionPosition) break block2;
                int n = dimIndex;
                this.positions[n] = this.positions[n] + 1;
                if (this.positions[dimIndex] >= this.dimensionResultIterators[dimIndex].length()) break;
            }
            int n = dimIndex;
            this.positions[n] = this.positions[n] - 1;
            return null;
        }
        return this.dimensionResultIterators[dimIndex].getLevelMember(levelIndex);
    }
}

