/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.aggregation.sort;

import java.io.IOException;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultRow;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationResultRow;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.sort.CombinedAggrResultRow;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;

class WrapperedDiskArray
implements IDiskArray {
    private int index;
    private IDiskArray baseArray;
    private IDiskArray[] keyValueArrays;

    WrapperedDiskArray(IDiskArray base, IDiskArray[] keyValueArrays) {
        this.baseArray = base;
        this.keyValueArrays = keyValueArrays;
        this.index = 0;
    }

    private Object getCurrentBaseRow() throws IOException {
        return this.baseArray.get(this.index);
    }

    private Object[] getCurrentKeyRow() throws IOException {
        Object[] keys = new Object[this.keyValueArrays.length];
        int i = 0;
        while (i < this.keyValueArrays.length) {
            keys[i] = this.keyValueArrays[i].get(this.index);
            ++i;
        }
        return keys;
    }

    public boolean add(Object o) throws IOException {
        assert (o instanceof CombinedAggrResultRow);
        CombinedAggrResultRow obj = (CombinedAggrResultRow)o;
        AggregationResultRow baseRow = new AggregationResultRow();
        baseRow.setLevelMembers(obj.getLevelMembers());
        this.baseArray.add(baseRow);
        Object[] aggrValues = obj.getAggregationValues();
        int i = 0;
        while (i < this.keyValueArrays.length) {
            this.keyValueArrays[i].add(aggrValues[i]);
            ++i;
        }
        return true;
    }

    public void clear() throws IOException {
        this.baseArray.clear();
        int i = 0;
        while (i < this.keyValueArrays.length) {
            this.keyValueArrays[i].clear();
            ++i;
        }
    }

    public void close() throws IOException {
        this.baseArray.close();
        int i = 0;
        while (i < this.keyValueArrays.length) {
            this.keyValueArrays[i].close();
            ++i;
        }
    }

    public Object get(int index) throws IOException {
        this.index = index;
        return new CombinedAggrResultRow((IAggregationResultRow)this.getCurrentBaseRow(), this.getCurrentKeyRow());
    }

    public int size() {
        return this.baseArray.size();
    }
}

