/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.core.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.RSEPreferencesManager;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.IPropertySet;
import org.eclipse.rse.core.model.IPropertySetContainer;
import org.eclipse.rse.core.model.IRSEPersistableContainer;
import org.eclipse.rse.core.model.ISystemHostPool;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.RSEModelObject;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;

public class Host
extends RSEModelObject
implements IHost {
    private boolean ucId = true;
    private boolean userIdCaseSensitive = true;
    private ISystemHostPool pool;
    protected String previousUserIdKey;
    private static final String ENCODING_PROPERTY_SET = "EncodingPropertySet";
    private static final String ENCODING_REMOTE_PROPERTY_KEY = "EncodingRemotePropertyKey";
    private static final String ENCODING_NON_REMOTE_PROPERTY_KEY = "EncodingNonRemotePropertyKey";
    private IRSESystemType systemType = null;
    private String aliasName = null;
    private String hostName = null;
    private String description = null;
    private String defaultUserId = null;
    private boolean promptable = false;
    private boolean offline = false;
    private ISystemProfile _profile;

    public Host(ISystemProfile profile) {
        this._profile = profile;
    }

    public void setHostPool(ISystemHostPool pool) {
        this.pool = pool;
        this.previousUserIdKey = this.getPreferencesKey();
    }

    public ISystemHostPool getHostPool() {
        return this.pool;
    }

    public IConnectorService[] getConnectorServices() {
        return RSECorePlugin.getTheSystemRegistry().getConnectorServices(this);
    }

    public ISubSystem[] getSubSystems() {
        return RSECorePlugin.getTheSystemRegistry().getSubSystems(this);
    }

    public void deletingHost() {
        String oldUserId = null;
        if (this.previousUserIdKey != null) {
            oldUserId = Host.getLocalDefaultUserId(this.previousUserIdKey);
        }
        if (oldUserId != null) {
            RSEPreferencesManager.clearUserId(this.previousUserIdKey);
        }
    }

    public void renamingSystemProfile(String oldName, String newName) {
        String userIdValue = null;
        if (this.previousUserIdKey != null) {
            userIdValue = Host.getLocalDefaultUserId(this.previousUserIdKey);
        }
        String newKey = this.getPreferencesKey(newName, this.getAliasName());
        if (userIdValue != null && userIdValue.length() > 0) {
            RSEPreferencesManager.clearUserId(this.previousUserIdKey);
            RSEPreferencesManager.setUserId(newKey, userIdValue);
        }
        this.previousUserIdKey = newKey;
    }

    public ISystemProfile getSystemProfile() {
        return this._profile;
    }

    public String getSystemProfileName() {
        ISystemProfile profile;
        String result = null;
        if (this._profile != null) {
            result = this._profile.getName();
        } else if (this.pool != null && (profile = this.pool.getSystemProfile()) != null) {
            result = profile.getName();
        }
        return result;
    }

    public void setAliasName(String newName) {
        String userIdValue = null;
        if (this.previousUserIdKey != null) {
            userIdValue = Host.getLocalDefaultUserId(this.previousUserIdKey);
        }
        this.setAliasNameGen(newName);
        String newKey = this.getPreferencesKey(this.getSystemProfileName(), newName);
        if (userIdValue != null && userIdValue.length() > 0) {
            RSEPreferencesManager.clearUserId(this.previousUserIdKey);
            RSEPreferencesManager.setUserId(newKey, userIdValue);
        }
        this.previousUserIdKey = newKey;
    }

    public void setSystemType(IRSESystemType systemType) {
        if (systemType != null) {
            String systemTypeId = systemType.getId();
            boolean forceUC = systemTypeId.equals("org.eclipse.rse.systemtype.iseries");
            boolean caseSensitiveUID = systemTypeId.equals("org.eclipse.rse.systemtype.unix") || systemTypeId.equals("org.eclipse.rse.systemtype.linux") || systemType.isLocal() && !systemType.isWindows();
            this.setForceUserIdToUpperCase(forceUC);
            this.setUserIdCaseSensitive(caseSensitiveUID);
        }
        this.setSystemTypeGen(systemType);
    }

    public void setHostName(String name) {
        if (name != null) {
            name = name.toUpperCase(Locale.US);
        }
        this.setHostNameGen(name);
    }

    public void setDefaultUserId(String newId) {
        if (newId != null && this.ucId) {
            newId = newId.toUpperCase();
        }
        if (newId == null || newId.length() == 0) {
            this.clearLocalDefaultUserId();
        } else {
            String key = this.getPreferencesKey();
            if (key != null) {
                RSEPreferencesManager.setUserId(key, newId);
            }
        }
    }

    public String getDefaultUserId() {
        String uid = this.getLocalDefaultUserId();
        if ((uid == null || uid.length() == 0) && (uid = RSEPreferencesManager.getUserId(this.getSystemType().getId())) != null && this.ucId) {
            uid = uid.toUpperCase();
        }
        return uid;
    }

    protected static String getLocalDefaultUserId(String key) {
        String uid = null;
        if (key != null && key.length() > 0) {
            uid = RSEPreferencesManager.getUserId(key);
        }
        return uid;
    }

    public String getLocalDefaultUserId() {
        return Host.getLocalDefaultUserId(this.getPreferencesKey());
    }

    public void clearLocalDefaultUserId() {
        if (this.previousUserIdKey != null) {
            RSEPreferencesManager.clearUserId(this.previousUserIdKey);
        }
    }

    protected String getPreferencesKey() {
        if (this.getSystemProfileName() == null || this.getAliasName() == null) {
            return null;
        }
        return this.getPreferencesKey(this.getSystemProfileName());
    }

    protected String getPreferencesKey(String profileName) {
        String connectionName = this.getAliasName();
        if (connectionName == null) {
            return null;
        }
        return this.getPreferencesKey(profileName, connectionName);
    }

    protected String getPreferencesKey(String profileName, String connectionName) {
        return String.valueOf(profileName) + "." + connectionName;
    }

    public void setForceUserIdToUpperCase(boolean force) {
        this.ucId = force;
    }

    public void setUserIdCaseSensitive(boolean caseSensitive) {
        this.userIdCaseSensitive = caseSensitive;
    }

    public boolean getForceUserIdToUpperCase() {
        return this.ucId;
    }

    public boolean getUserIdCaseSensitive() {
        return this.userIdCaseSensitive;
    }

    public boolean compareUserIds(String userId1, String userId2) {
        if (userId1 == null) {
            userId1 = "";
        }
        if (userId2 == null) {
            userId2 = "";
        }
        if (this.userIdCaseSensitive) {
            return userId1.equals(userId2);
        }
        return userId1.equalsIgnoreCase(userId2);
    }

    public String toString() {
        if (this.getAliasName() == null) {
            StringBuffer result = new StringBuffer(super.toString());
            result.append(" (systemType: ");
            result.append(this.systemType);
            result.append(", aliasName: ");
            result.append(this.aliasName);
            result.append(", hostName: ");
            result.append(this.hostName);
            result.append(", description: ");
            result.append(this.description);
            result.append(", defaultUserId: ");
            result.append(this.defaultUserId);
            result.append(", promptable: ");
            result.append(this.promptable);
            result.append(", offline: ");
            result.append(this.offline);
            result.append(')');
            return result.toString();
        }
        return this.getAliasName();
    }

    public Object getAdapter(Class adapterType) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapterType);
    }

    public IRSESystemType getSystemType() {
        return this.systemType;
    }

    public String getName() {
        return this.getAliasName();
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String newDescription) {
        this.setDirty(!this.compareStrings(this.description, newDescription));
        this.description = newDescription;
    }

    public boolean isPromptable() {
        return this.promptable;
    }

    public void setPromptable(boolean newPromptable) {
        this.setDirty(this.promptable ^ newPromptable);
        this.promptable = newPromptable;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public void setOffline(boolean newOffline) {
        this.setDirty(this.offline ^ newOffline);
        this.offline = newOffline;
    }

    private void setSystemTypeGen(IRSESystemType newSystemType) {
        this.setDirty(this.systemType == null ? newSystemType == null : !this.systemType.equals(newSystemType));
        this.systemType = newSystemType;
    }

    private void setAliasNameGen(String newAliasName) {
        this.setDirty(!this.compareStrings(this.aliasName, newAliasName));
        this.aliasName = newAliasName;
    }

    private void setHostNameGen(String newHostName) {
        this.setDirty(!this.compareStrings(this.hostName, newHostName));
        this.hostName = newHostName;
    }

    public boolean commit() {
        ISystemProfile profile = this.getSystemProfile();
        boolean result = profile.commit();
        return result;
    }

    public IRSEPersistableContainer getPersistableParent() {
        return this._profile;
    }

    public IRSEPersistableContainer[] getPersistableChildren() {
        ArrayList<IPropertySetContainer> children = new ArrayList<IPropertySetContainer>(10);
        children.addAll(Arrays.asList(this.getPropertySets()));
        children.addAll(Arrays.asList(this.getConnectorServices()));
        IRSEPersistableContainer[] result = new IRSEPersistableContainer[children.size()];
        children.toArray(result);
        return result;
    }

    public String getDefaultEncoding(boolean fromRemote) {
        IPropertySet encPropertySet = this.getPropertySet(ENCODING_PROPERTY_SET);
        if (encPropertySet == null) {
            return null;
        }
        String nonRemoteEncoding = encPropertySet.getPropertyValue(ENCODING_NON_REMOTE_PROPERTY_KEY);
        if (nonRemoteEncoding != null) {
            return nonRemoteEncoding;
        }
        if (!fromRemote) {
            return null;
        }
        String remoteEncoding = encPropertySet.getPropertyValue(ENCODING_REMOTE_PROPERTY_KEY);
        return remoteEncoding;
    }

    public void setDefaultEncoding(String encoding, boolean fromRemote) {
        boolean commit = false;
        IPropertySet encPropertySet = this.getPropertySet(ENCODING_PROPERTY_SET);
        if (encPropertySet == null) {
            encPropertySet = this.createPropertySet(ENCODING_PROPERTY_SET);
        }
        if (encPropertySet != null) {
            String savedNonRemoteEncoding = encPropertySet.getPropertyValue(ENCODING_NON_REMOTE_PROPERTY_KEY);
            String savedRemoteEncoding = encPropertySet.getPropertyValue(ENCODING_REMOTE_PROPERTY_KEY);
            if (encoding != null) {
                if (!fromRemote && !encoding.equals(savedNonRemoteEncoding)) {
                    encPropertySet.addProperty(ENCODING_NON_REMOTE_PROPERTY_KEY, encoding);
                    commit = true;
                } else if (fromRemote && !encoding.equals(savedRemoteEncoding)) {
                    encPropertySet.addProperty(ENCODING_REMOTE_PROPERTY_KEY, encoding);
                    commit = true;
                }
            } else if (!fromRemote && savedNonRemoteEncoding != null) {
                encPropertySet.removeProperty(ENCODING_NON_REMOTE_PROPERTY_KEY);
                commit = true;
            } else if (fromRemote && savedRemoteEncoding != null) {
                encPropertySet.removeProperty(ENCODING_REMOTE_PROPERTY_KEY);
                commit = true;
            }
        }
        if (commit) {
            this.commit();
        }
    }
}

