/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.publisher.eclipse;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.frameworkadmin.equinox.EquinoxFwConfigFileParser;
import org.eclipse.equinox.internal.frameworkadmin.equinox.EquinoxManipulatorImpl;
import org.eclipse.equinox.internal.frameworkadmin.utils.Utils;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.publisher.Activator;
import org.eclipse.equinox.internal.provisional.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.provisional.frameworkadmin.ConfigData;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdmin;
import org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdminRuntimeException;
import org.eclipse.equinox.internal.provisional.frameworkadmin.LauncherData;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.service.packageadmin.PackageAdmin;

public class DataLoader {
    private static final String FILTER_OBJECTCLASS;
    private static final String filterFwName = "(org.eclipse.equinox.frameworkhandler.framework.name=Equinox)";
    private static final String filterLauncherName = "(org.eclipse.equinox.frameworkhandler.launcher.name=Eclipse.exe)";
    private static final String frameworkAdminFillter;
    private static final String ORG_ECLIPSE_EQUINOX_SIMPLECONFIGURATOR_CONFIGURL = "org.eclipse.equinox.simpleconfigurator.configUrl";
    private static final String ORG_ECLIPSE_EQUINOX_SIMPLECONFIGURATOR_MANIPULATOR = "org.eclipse.equinox.simpleconfigurator.manipulator";
    private static final String ORG_ECLIPSE_EQUINOX_FRAMEWORKADMIN_EQUINOX = "org.eclipse.equinox.frameworkadmin.equinox";
    private static final String PARAMETER_BASEURL = "org.eclipse.equinox.simpleconfigurator.baseUrl";
    private Manipulator manipulator;
    private File configurationLocation;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        StringBuffer stringBuffer = new StringBuffer("(objectClass=");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        FILTER_OBJECTCLASS = stringBuffer.append(clazz.getName()).append(")").toString();
        frameworkAdminFillter = "(&" + FILTER_OBJECTCLASS + filterFwName + filterLauncherName + ")";
    }

    public static BundleInfo[] readConfiguration(URL url) throws IOException {
        ArrayList<BundleInfo> bundles = new ArrayList<BundleInfo>();
        try {
            BufferedReader r = new BufferedReader(new InputStreamReader(url.openStream()));
            try {
                String line;
                URL baseUrl = new URL(url, "./");
                while ((line = r.readLine()) != null) {
                    if (line.startsWith("#") || (line = line.trim()).length() == 0) continue;
                    if (line.startsWith("org.eclipse.equinox.simpleconfigurator.baseUrl=")) {
                        String baseUrlSt = line.substring("org.eclipse.equinox.simpleconfigurator.baseUrl=".length());
                        if (!baseUrlSt.endsWith("/")) {
                            baseUrlSt = String.valueOf(baseUrlSt) + "/";
                        }
                        baseUrl = new URL(url, baseUrlSt);
                        continue;
                    }
                    StringTokenizer tok = new StringTokenizer(line, ",", true);
                    String symbolicName = tok.nextToken();
                    if (symbolicName.equals(",")) {
                        symbolicName = null;
                    } else {
                        tok.nextToken();
                    }
                    String version = tok.nextToken();
                    if (version.equals(",")) {
                        version = null;
                    } else {
                        tok.nextToken();
                    }
                    String urlSt = tok.nextToken();
                    if (urlSt.equals(",")) {
                        urlSt = symbolicName != null && version != null ? String.valueOf(symbolicName) + "_" + version + ".jar" : null;
                    } else {
                        tok.nextToken();
                    }
                    try {
                        new URL(urlSt);
                    }
                    catch (MalformedURLException malformedURLException) {
                        urlSt = Utils.getUrlInFull((String)urlSt, (URL)baseUrl).toExternalForm();
                    }
                    int sl = Integer.parseInt(tok.nextToken().trim());
                    tok.nextToken();
                    boolean markedAsStarted = Boolean.valueOf(tok.nextToken());
                    BundleInfo bInfo = new BundleInfo(symbolicName, version, urlSt, sl, markedAsStarted);
                    bundles.add(bInfo);
                }
            }
            catch (Throwable throwable) {
                try {
                    r.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                r.close();
            }
            catch (IOException iOException) {}
        }
        catch (MalformedURLException malformedURLException) {}
        return bundles.toArray(new BundleInfo[bundles.size()]);
    }

    public DataLoader(File configurationLocation, File executableLocation) {
        this.configurationLocation = configurationLocation;
        this.initializeFrameworkManipulator(configurationLocation.getParentFile(), executableLocation);
    }

    private void initializeFrameworkManipulator(File config, File executable) {
        this.getFrameworkManipulator();
        LauncherData launcherData = this.manipulator.getLauncherData();
        launcherData.setFwPersistentDataLocation(config, true);
        launcherData.setLauncher(executable);
        try {
            this.manipulator.load();
        }
        catch (IllegalStateException e2) {
            e2.printStackTrace();
        }
        catch (FrameworkAdminRuntimeException e2) {
            e2.printStackTrace();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public ConfigData getConfigData() {
        ConfigData data;
        String value;
        if (this.manipulator == null) {
            return null;
        }
        EquinoxFwConfigFileParser parser = new EquinoxFwConfigFileParser(Activator.getContext());
        try {
            if (this.configurationLocation != null && this.configurationLocation.exists()) {
                parser.readFwConfig(this.manipulator, this.configurationLocation);
            }
        }
        catch (IOException e) {
            LogHelper.log((IStatus)new Status(4, Activator.ID, "Error loading config.", (Throwable)e));
        }
        if ((value = (data = this.manipulator.getConfigData()).getFwIndependentProp(ORG_ECLIPSE_EQUINOX_SIMPLECONFIGURATOR_CONFIGURL)) != null) {
            try {
                BundleInfo[] bundleInfos = DataLoader.readConfiguration(new URL(value));
                data.setBundles(bundleInfos);
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {}
            try {
                data.setFwIndependentProp(ORG_ECLIPSE_EQUINOX_SIMPLECONFIGURATOR_CONFIGURL, EquinoxManipulatorImpl.makeRelative((String)value, (URL)this.configurationLocation.toURL()));
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return data;
    }

    public LauncherData getLauncherData() {
        return this.manipulator == null ? null : this.manipulator.getLauncherData();
    }

    private void getFrameworkManipulator() {
        FrameworkAdmin admin = this.getFrameworkAdmin();
        if (admin == null) {
            throw new RuntimeException("Framework admin service not found");
        }
        this.manipulator = admin.getManipulator();
        if (this.manipulator == null) {
            throw new RuntimeException("Framework manipulator not found");
        }
    }

    private FrameworkAdmin getFrameworkAdmin() {
        FrameworkAdmin frameworkAdmin;
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((frameworkAdmin = (FrameworkAdmin)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName(), (String)frameworkAdminFillter)) == null) {
            this.startBundle(ORG_ECLIPSE_EQUINOX_FRAMEWORKADMIN_EQUINOX);
            this.startBundle(ORG_ECLIPSE_EQUINOX_SIMPLECONFIGURATOR_MANIPULATOR);
            BundleContext bundleContext2 = Activator.getContext();
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.frameworkadmin.FrameworkAdmin");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            frameworkAdmin = (FrameworkAdmin)ServiceHelper.getService((BundleContext)bundleContext2, (String)clazz2.getName(), (String)frameworkAdminFillter);
        }
        return frameworkAdmin;
    }

    private boolean startBundle(String bundleId) {
        PackageAdmin packageAdmin;
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.osgi.service.packageadmin.PackageAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((packageAdmin = (PackageAdmin)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            return false;
        }
        Bundle[] bundles = packageAdmin.getBundles(bundleId, null);
        if (bundles != null && bundles.length > 0) {
            int i = 0;
            while (i < bundles.length) {
                try {
                    if ((bundles[0].getState() & 4) > 0) {
                        bundles[0].start();
                        return true;
                    }
                }
                catch (BundleException bundleException) {}
                ++i;
            }
        }
        return false;
    }
}

