/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.publisher;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.FileUtils;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.publisher.Activator;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.ArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IFileArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.processing.ProcessingStepDescriptor;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.MetadataFactory;
import org.eclipse.equinox.internal.provisional.p2.metadata.ProvidedCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.RequiredCapability;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.actions.ICapabilityAdvice;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

public abstract class AbstractPublisherAction
implements IPublisherAction {
    public static final int AS_IS = 1;
    public static final String CONFIG_SEGMENT_SEPARATOR = ".";
    private static final String CONFIG_ANY = "ANY";
    static /* synthetic */ Class class$0;

    public static IArtifactDescriptor createPack200ArtifactDescriptor(IArtifactKey key, File pathOnDisk, String installSize) {
        ArtifactDescriptor result = new ArtifactDescriptor(key);
        if (pathOnDisk != null) {
            result.setProperty("artifact.size", installSize);
            result.setProperty("download.size", Long.toString(pathOnDisk.length()));
        }
        ProcessingStepDescriptor[] steps = new ProcessingStepDescriptor[]{new ProcessingStepDescriptor("org.eclipse.equinox.p2.processing.Pack200Unpacker", null, true)};
        result.setProcessingSteps(steps);
        result.setProperty("format", "packed");
        return result;
    }

    public static String[] getArrayFromString(String list, String separator) {
        if (list == null || list.trim().equals("")) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(list, separator);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equals("")) continue;
            result.add(token);
        }
        return result.toArray(new String[result.size()]);
    }

    public static ProvidedCapability createSelfCapability(String installableUnitId, Version installableUnitVersion) {
        return MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)installableUnitId, (Version)installableUnitVersion);
    }

    public static String[] parseConfigSpec(String configSpec) {
        String[] result = AbstractPublisherAction.getArrayFromString(configSpec, CONFIG_SEGMENT_SEPARATOR);
        int i = 0;
        while (i < result.length) {
            if (result[i].equals("*")) {
                result[i] = CONFIG_ANY;
            }
            ++i;
        }
        return result;
    }

    public static String createFilterSpec(String configSpec) {
        String[] config = AbstractPublisherAction.parseConfigSpec(configSpec);
        if (config[0] != null || config[1] != null || config[2] != null) {
            String filterArch;
            String filterWs = config[0] != null && config[0] != CONFIG_ANY ? "(osgi.ws=" + config[0] + ")" : "";
            String filterOs = config[1] != null && config[1] != CONFIG_ANY ? "(osgi.os=" + config[1] + ")" : "";
            String string = filterArch = config[2] != null && config[2] != CONFIG_ANY ? "(osgi.arch=" + config[2] + ")" : "";
            if (filterWs.length() == 0 && filterOs.length() == 0 && filterArch.length() == 0) {
                return null;
            }
            return "(& " + filterWs + filterOs + filterArch + ")";
        }
        return null;
    }

    public static String createIdString(String configSpec) {
        String[] config = AbstractPublisherAction.parseConfigSpec(configSpec);
        return String.valueOf(config[0]) + '.' + config[1] + '.' + config[2];
    }

    public static String createConfigSpec(String ws, String os, String arch) {
        return String.valueOf(ws) + '.' + os + '.' + arch;
    }

    public static FileUtils.IPathComputer createRootPrefixComputer(File root) {
        return FileUtils.createRootPathComputer((File)root);
    }

    public static Collection createIURequirements(Collection children) {
        ArrayList<RequiredCapability> result = new ArrayList<RequiredCapability>(children.size());
        Iterator i = children.iterator();
        while (i.hasNext()) {
            IInstallableUnit iu = (IInstallableUnit)i.next();
            VersionRange range = new VersionRange(iu.getVersion(), true, iu.getVersion(), true);
            result.add(MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.iu", (String)iu.getId(), (VersionRange)range, (String)iu.getFilter(), (boolean)false, (boolean)false));
        }
        return result;
    }

    public static FileUtils.IPathComputer createParentPrefixComputer(int segmentsToKeep) {
        return FileUtils.createParentPrefixComputer((int)segmentsToKeep);
    }

    protected void publishArtifact(IArtifactDescriptor descriptor, File[] inclusions, File[] exclusions, IPublisherInfo info, FileUtils.IPathComputer prefixComputer) {
        if (inclusions == null || inclusions.length < 1) {
            return;
        }
        IArtifactRepository destination = info.getArtifactRepository();
        if (destination == null || destination.contains(descriptor)) {
            return;
        }
        if ((info.getArtifactOptions() & 2) == 0) {
            destination.addDescriptor(descriptor);
            return;
        }
        File tempFile = null;
        try {
            OutputStream output = destination.getOutputStream(descriptor);
            if (output == null) {
                return;
            }
            try {
                output = new BufferedOutputStream(output);
                tempFile = File.createTempFile("p2.generator", "");
                FileUtils.zip((File[])inclusions, (File[])exclusions, (File)tempFile, (FileUtils.IPathComputer)prefixComputer);
                if (output != null) {
                    FileUtils.copyStream((InputStream)new BufferedInputStream(new FileInputStream(tempFile)), (boolean)true, (OutputStream)output, (boolean)true);
                }
            }
            catch (ProvisionException e) {
                LogHelper.log((IStatus)e.getStatus());
            }
            catch (IOException e) {
                LogHelper.log((IStatus)new Status(4, Activator.ID, "Error publishing artifacts", (Throwable)e));
                e.printStackTrace();
            }
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    protected void publishArtifact(IArtifactDescriptor descriptor, File inclusion, IPublisherInfo info) {
        File descriptorFile;
        if (inclusion == null) {
            return;
        }
        IArtifactRepository destination = info.getArtifactRepository();
        if (destination == null || destination.contains(descriptor)) {
            return;
        }
        if (destination instanceof IFileArtifactRepository && inclusion.equals(descriptorFile = ((IFileArtifactRepository)destination).getArtifactFile(descriptor))) {
            destination.addDescriptor(descriptor);
            return;
        }
        if ((info.getArtifactOptions() & 2) == 0) {
            destination.addDescriptor(descriptor);
            return;
        }
        try {
            if (destination instanceof IFileArtifactRepository && inclusion.equals(descriptorFile = ((IFileArtifactRepository)destination).getArtifactFile(descriptor))) {
                destination.addDescriptor(descriptor);
                return;
            }
            OutputStream output = destination.getOutputStream(descriptor);
            if (output == null) {
                return;
            }
            output = new BufferedOutputStream(output);
            FileUtils.copyStream((InputStream)new BufferedInputStream(new FileInputStream(inclusion)), (boolean)true, (OutputStream)output, (boolean)true);
        }
        catch (ProvisionException e) {
            LogHelper.log((IStatus)e.getStatus());
        }
        catch (IOException e) {
            LogHelper.log((IStatus)new Status(4, Activator.ID, "Error publishing artifacts", (Throwable)e));
        }
    }

    public abstract IStatus perform(IPublisherInfo var1, IPublisherResult var2);

    protected void processCapabilityAdvice(MetadataFactory.InstallableUnitDescription iu, IPublisherInfo info) {
        String string = iu.getId();
        Version version = iu.getVersion();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.p2.publisher.actions.ICapabilityAdvice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Collection advice = info.getAdvice(null, false, string, version, clazz);
        Iterator i = advice.iterator();
        while (i.hasNext()) {
            RequiredCapability[] result;
            RequiredCapability[] current;
            ICapabilityAdvice entry = (ICapabilityAdvice)i.next();
            RequiredCapability[] requiredAdvice = entry.getRequiredCapabilities(iu);
            ProvidedCapability[] providedAdvice = entry.getProvidedCapabilities(iu);
            if (providedAdvice != null) {
                current = iu.getRequiredCapabilities();
                result = new RequiredCapability[requiredAdvice.length + current.length];
                System.arraycopy(requiredAdvice, 0, result, 0, requiredAdvice.length);
                System.arraycopy(current, 0, result, requiredAdvice.length, current.length);
                iu.setRequiredCapabilities(result);
            }
            if (providedAdvice == null) continue;
            current = iu.getProvidedCapabilities();
            result = new ProvidedCapability[providedAdvice.length + current.length];
            System.arraycopy(providedAdvice, 0, result, 0, providedAdvice.length);
            System.arraycopy(current, 0, result, providedAdvice.length, current.length);
            iu.setCapabilities((ProvidedCapability[])result);
        }
    }

    public MetadataFactory.InstallableUnitDescription createParentIU(Collection children, String id, Version version) {
        MetadataFactory.InstallableUnitDescription root = this.createIUShell(id, version);
        root.addRequiredCapabilities(AbstractPublisherAction.createIURequirements(children));
        this.addSelfCapability(root);
        return root;
    }

    public void addSelfCapability(MetadataFactory.InstallableUnitDescription root) {
        root.setCapabilities(new ProvidedCapability[]{AbstractPublisherAction.createSelfCapability(root.getId(), root.getVersion())});
    }

    public MetadataFactory.InstallableUnitDescription createIUShell(String id, Version version) {
        MetadataFactory.InstallableUnitDescription root = new MetadataFactory.InstallableUnitDescription();
        root.setId(id);
        root.setVersion(version);
        return root;
    }
}

