/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.publisher;

import java.io.File;
import java.net.MalformedURLException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.internal.p2.artifact.repository.ArtifactRepositoryManager;
import org.eclipse.equinox.internal.p2.core.ProvisioningEventBus;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.metadata.repository.MetadataRepositoryManager;
import org.eclipse.equinox.internal.p2.publisher.Activator;
import org.eclipse.equinox.internal.p2.publisher.Messages;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.Publisher;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public abstract class AbstractPublisherApplication
implements IApplication {
    protected static final String[][] INPLACE_MAPPING_RULES = new String[][]{{"(& (classifier=osgi.bundle) (format=packed)", "${repoUrl}/features/${id}_${version}.jar.pack.gz"}, {"(& (classifier=osgi.bundle))", "${repoUrl}/plugins/${id}_${version}.jar"}, {"(& (classifier=binary))", "${repoUrl}/binary/${id}_${version}"}, {"(& (classifier=org.eclipse.update.feature))", "${repoUrl}/features/${id}_${version}.jar"}};
    public static final String PUBLISH_PACK_FILES_AS_SIBLINGS = "publishPackFilesAsSiblings";
    private ArtifactRepositoryManager defaultArtifactManager;
    private ServiceRegistration registrationDefaultArtifactManager;
    private MetadataRepositoryManager defaultMetadataManager;
    private ServiceRegistration registrationDefaultMetadataManager;
    private IProvisioningEventBus bus;
    private ServiceRegistration registrationBus;
    protected PublisherInfo info;
    protected String source;
    protected String metadataLocation;
    protected String metadataRepoName;
    protected String artifactLocation;
    protected String artifactRepoName;
    protected boolean compress = false;
    protected boolean inplace = false;
    protected boolean append = false;
    protected boolean reusePackedFiles = false;
    protected String[] configurations;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected void initialize(PublisherInfo info) throws ProvisionException {
        if (this.inplace) {
            File location = new File(this.source);
            try {
                if (this.metadataLocation == null) {
                    this.metadataLocation = location.toURL().toExternalForm();
                }
                if (this.artifactLocation == null) {
                    this.artifactLocation = location.toURL().toExternalForm();
                }
            }
            catch (MalformedURLException malformedURLException) {}
            info.setArtifactOptions(info.getArtifactOptions() | 1 | 2);
        } else {
            info.setArtifactOptions(info.getArtifactOptions() | 1 | 2 | 4);
        }
        this.initializeRepositories(info);
    }

    protected void initializeRepositories(PublisherInfo info) throws ProvisionException {
        info.setArtifactRepository(Publisher.createArtifactRepository(this.artifactLocation, this.artifactRepoName, this.append, this.compress, this.reusePackedFiles));
        info.setMetadataRepository(Publisher.createMetadataRepository(this.metadataLocation, this.metadataRepoName, this.append, this.compress));
    }

    protected void processCommandLineArguments(String[] args, PublisherInfo info) throws Exception {
        if (args == null) {
            return;
        }
        int i = 0;
        while (i < args.length) {
            this.processFlag(args[i], info);
            if (i != args.length - 1 && !args[i + 1].startsWith("-")) {
                this.processParameter(args[i], args[++i], info);
            }
            ++i;
        }
    }

    protected void processParameter(String arg, String parameter, PublisherInfo info) {
        if (arg.equalsIgnoreCase("-metadataRepository") || arg.equalsIgnoreCase("-mr")) {
            this.metadataLocation = parameter;
        }
        if (arg.equalsIgnoreCase("-metadataRepositoryName")) {
            this.metadataRepoName = parameter;
        }
        if (arg.equalsIgnoreCase("-source")) {
            this.source = parameter;
        }
        if (arg.equalsIgnoreCase("-artifactRepository") | arg.equalsIgnoreCase("-ar")) {
            this.artifactLocation = parameter;
        }
        if (arg.equalsIgnoreCase("-artifactRepositoryName")) {
            this.artifactRepoName = parameter;
        }
        if (arg.equalsIgnoreCase("-configs")) {
            info.setConfigurations(AbstractPublisherAction.getArrayFromString(parameter, ","));
        }
    }

    protected void processFlag(String arg, PublisherInfo info) {
        if (arg.equalsIgnoreCase("-publishArtifacts") || arg.equalsIgnoreCase("-pa")) {
            info.setArtifactOptions(info.getArtifactOptions() | 2);
        }
        if (arg.equalsIgnoreCase("-publishArtifactRepository") || arg.equalsIgnoreCase("-par")) {
            info.setArtifactOptions(info.getArtifactOptions() | 1);
        }
        if (arg.equalsIgnoreCase("-overwriteArtifacts")) {
            info.setArtifactOptions(info.getArtifactOptions() | 4);
        }
        if (arg.equalsIgnoreCase("-append")) {
            this.append = true;
        }
        if (arg.equalsIgnoreCase("-compress")) {
            this.compress = true;
        }
        if (arg.equalsIgnoreCase("-reusePack200Files")) {
            this.reusePackedFiles = true;
        }
        if (arg.equalsIgnoreCase("-inplace")) {
            this.inplace = true;
        }
    }

    private void registerDefaultArtifactRepoManager() {
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName()) == null) {
            this.defaultArtifactManager = new ArtifactRepositoryManager();
            BundleContext bundleContext2 = Activator.getContext();
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.registrationDefaultArtifactManager = bundleContext2.registerService(clazz2.getName(), (Object)this.defaultArtifactManager, null);
        }
    }

    private void registerDefaultMetadataRepoManager() {
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName()) == null) {
            this.defaultMetadataManager = new MetadataRepositoryManager();
            BundleContext bundleContext2 = Activator.getContext();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.registrationDefaultMetadataManager = bundleContext2.registerService(clazz2.getName(), (Object)this.defaultMetadataManager, null);
        }
    }

    private void registerEventBus() {
        if (ServiceHelper.getService((BundleContext)Activator.getContext(), (String)IProvisioningEventBus.SERVICE_NAME) == null) {
            this.bus = new ProvisioningEventBus();
            this.registrationBus = Activator.getContext().registerService(IProvisioningEventBus.SERVICE_NAME, (Object)this.bus, null);
        }
    }

    public Object run(String[] args) throws Exception {
        this.info = this.createPublisherInfo();
        this.processCommandLineArguments(args, this.info);
        Object result = this.run(this.info);
        if (result != IApplication.EXIT_OK) {
            int i = 0;
            while (i < args.length) {
                System.out.println(args[i]);
                ++i;
            }
        }
        return result;
    }

    protected PublisherInfo createPublisherInfo() {
        return new PublisherInfo();
    }

    public Object run(PublisherInfo info) throws Exception {
        this.registerEventBus();
        this.registerDefaultMetadataRepoManager();
        this.registerDefaultArtifactRepoManager();
        this.initialize(info);
        this.validateInfo(info);
        System.out.println(NLS.bind((String)Messages.message_generatingMetadata, (Object)info.getSummary()));
        long before = System.currentTimeMillis();
        IPublisherAction[] actions = this.createActions();
        Publisher publisher = this.createPublisher(info);
        IStatus result = publisher.publish(actions);
        long after = System.currentTimeMillis();
        if (result.isOK()) {
            System.out.println(NLS.bind((String)Messages.message_generationCompleted, (Object)String.valueOf((after - before) / 1000L)));
            return IApplication.EXIT_OK;
        }
        System.out.println(result);
        return new Integer(1);
    }

    protected abstract IPublisherAction[] createActions();

    protected Publisher createPublisher(PublisherInfo info) {
        return new Publisher(info);
    }

    protected void validateInfo(PublisherInfo info) {
    }

    public Object start(IApplicationContext context) throws Exception {
        return this.run((String[])context.getArguments().get("application.args"));
    }

    public void stop() {
        if (this.registrationDefaultMetadataManager != null) {
            this.registrationDefaultMetadataManager.unregister();
            this.registrationDefaultMetadataManager = null;
        }
        if (this.registrationDefaultArtifactManager != null) {
            this.registrationDefaultArtifactManager.unregister();
            this.registrationDefaultArtifactManager = null;
        }
        if (this.registrationBus != null) {
            this.registrationBus.unregister();
            this.registrationBus = null;
        }
    }

    public void setArtifactLocation(String location) {
        this.artifactLocation = location;
    }

    public void setMetadataLocation(String location) {
        this.metadataLocation = location;
    }

    public boolean reuseExistingPack200Files() {
        return this.reusePackedFiles;
    }

    public void setReuseExistingPackedFiles(boolean value) {
        this.reusePackedFiles = value;
    }
}

