/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.publisher;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.publisher.Activator;
import org.eclipse.equinox.internal.p2.publisher.Messages;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.PublisherResult;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;

public class Publisher {
    public static final String PUBLISH_PACK_FILES_AS_SIBLINGS = "publishPackFilesAsSiblings";
    private IPublisherInfo info;
    private IPublisherResult results;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static IMetadataRepository createMetadataRepository(String location, String name, boolean append, boolean compress) throws ProvisionException {
        URL url;
        try {
            url = new URL(location);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.exception_metadataRepoLocationURL, (Object)location));
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IMetadataRepositoryManager manager = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)Activator.context, (String)clazz.getName());
        try {
            IMetadataRepository result = manager.loadRepository(url, null);
            if (result != null) {
                result.setProperty("p2.compressed", compress ? "true" : "false");
                if (!result.isModifiable()) {
                    throw new IllegalArgumentException(NLS.bind((String)Messages.exception_metadataRepoNotWritable, (Object)url));
                }
                if (!append) {
                    result.removeAll();
                }
                return result;
            }
        }
        catch (ProvisionException provisionException) {}
        String repositoryName = name == null ? String.valueOf(location) + " - metadata" : name;
        IMetadataRepository result = manager.createRepository(url, repositoryName, "org.eclipse.equinox.p2.metadata.repository.simpleRepository", null);
        manager.addRepository(result.getLocation());
        if (result != null) {
            result.setProperty("p2.compressed", compress ? "true" : "false");
        }
        return result;
    }

    public static IArtifactRepository createArtifactRepository(String location, String name, boolean append, boolean compress, boolean reusePackedFiles) throws ProvisionException {
        URL url;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IArtifactRepositoryManager manager = (IArtifactRepositoryManager)ServiceHelper.getService((BundleContext)Activator.context, (String)clazz.getName());
        try {
            url = new URL(location);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.exception_artifactRepoLocationURL, (Object)location));
        }
        try {
            IArtifactRepository result = manager.loadRepository(url, null);
            if (!result.isModifiable()) {
                throw new IllegalArgumentException(NLS.bind((String)Messages.exception_artifactRepoNotWritable, (Object)url));
            }
            result.setProperty("p2.compressed", compress ? "true" : "false");
            if (reusePackedFiles) {
                result.setProperty(PUBLISH_PACK_FILES_AS_SIBLINGS, "true");
            }
            if (!append) {
                result.removeAll();
            }
            return result;
        }
        catch (ProvisionException provisionException) {
            String repositoryName = name != null ? name : String.valueOf(location) + " - artifacts";
            IArtifactRepository result = manager.createRepository(url, repositoryName, "org.eclipse.equinox.p2.artifact.repository.simpleRepository", null);
            manager.addRepository(result.getLocation());
            result.setProperty("p2.compressed", compress ? "true" : "false");
            if (reusePackedFiles) {
                result.setProperty(PUBLISH_PACK_FILES_AS_SIBLINGS, "true");
            }
            return result;
        }
    }

    public Publisher(IPublisherInfo info) {
        this.info = info;
        this.results = new PublisherResult();
    }

    public Publisher(IPublisherInfo info, IPublisherResult results) {
        this.info = info;
        this.results = results;
    }

    public IStatus publish(IPublisherAction[] actions) {
        MultiStatus finalStatus = new MultiStatus("this", 0, "publishing result", null);
        int i = 0;
        while (i < actions.length) {
            IStatus status = actions[i].perform(this.info, this.results);
            finalStatus.merge(status);
            ++i;
        }
        if (!finalStatus.isOK()) {
            return finalStatus;
        }
        IMetadataRepository metadataRepository = this.info.getMetadataRepository();
        if (metadataRepository != null) {
            Collection ius = this.results.getIUs(null, null);
            metadataRepository.addInstallableUnits(ius.toArray(new IInstallableUnit[ius.size()]));
        }
        return Status.OK_STATUS;
    }
}

