/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.publisher.actions;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.internal.p2.publisher.Activator;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.MetadataFactory;
import org.eclipse.equinox.internal.provisional.p2.metadata.ProvidedCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.RequiredCapability;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public class JREAction
extends AbstractPublisherAction {
    private static final Version DEFAULT_JRE_VERSION = new Version("1.6");
    private File location;

    public static IArtifactDescriptor createJREData(File jreLocation, IPublisherResult results) {
        MetadataFactory.InstallableUnitDescription iu = new MetadataFactory.InstallableUnitDescription();
        iu.setSingleton(false);
        String id = "a.jre";
        Version version = DEFAULT_JRE_VERSION;
        iu.setId(id);
        iu.setVersion(version);
        iu.setTouchpointType(PublisherHelper.TOUCHPOINT_NATIVE);
        MetadataFactory.InstallableUnitFragmentDescription cu = new MetadataFactory.InstallableUnitFragmentDescription();
        String configId = "config." + id;
        cu.setId(configId);
        cu.setVersion(version);
        cu.setHost(new RequiredCapability[]{MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.iu", (String)id, (VersionRange)new VersionRange(version, true, PublisherHelper.versionMax, true), null, (boolean)false, (boolean)false)});
        cu.setProperty("org.eclipse.equinox.p2.type.fragment", Boolean.TRUE.toString());
        cu.setCapabilities(new ProvidedCapability[]{PublisherHelper.createSelfCapability(configId, version)});
        cu.setTouchpointType(PublisherHelper.TOUCHPOINT_NATIVE);
        HashMap<String, String> touchpointData = new HashMap<String, String>();
        if (jreLocation == null || !jreLocation.exists()) {
            iu.setVersion(version);
            iu.setCapabilities(JREAction.generateJRECapability(id, version, null));
            results.addIU(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iu), "root");
            touchpointData.put("install", "");
            cu.addTouchpointData(MetadataFactory.createTouchpointData(touchpointData));
            results.addIU(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)cu), "root");
            return null;
        }
        JREAction.generateJREIUData(iu, id, version, jreLocation);
        ArtifactKey key = new ArtifactKey("binary", id, version);
        iu.setArtifacts(new IArtifactKey[]{key});
        results.addIU(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iu), "root");
        String configurationData = "unzip(source:@artifact, target:${installFolder});";
        touchpointData.put("install", configurationData);
        String unConfigurationData = "cleanupzip(source:@artifact, target:${installFolder});";
        touchpointData.put("uninstall", unConfigurationData);
        cu.addTouchpointData(MetadataFactory.createTouchpointData(touchpointData));
        results.addIU(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)cu), "root");
        return PublisherHelper.createArtifactDescriptor((IArtifactKey)key, jreLocation);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ProvidedCapability[] generateJRECapability(String installableUnitId, Version installableUnitVersion, InputStream profileStream) {
        if (profileStream == null) {
            try {
                profileStream = Activator.getContext().getBundle().getEntry("/profiles/JavaSE-1.6.profile").openStream();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        Properties p = new Properties();
        p.load(profileStream);
        ManifestElement[] jrePackages = ManifestElement.parseHeader((String)"org.osgi.framework.system.packages", (String)((String)p.get("org.osgi.framework.system.packages")));
        ProvidedCapability[] exportedPackageAsCapabilities = new ProvidedCapability[jrePackages.length + 1];
        exportedPackageAsCapabilities[0] = PublisherHelper.createSelfCapability(installableUnitId, installableUnitVersion);
        int i = 1;
        while (i <= jrePackages.length) {
            exportedPackageAsCapabilities[i] = MetadataFactory.createProvidedCapability((String)"java.package", (String)jrePackages[i - 1].getValue(), null);
            ++i;
        }
        ProvidedCapability[] providedCapabilityArray = exportedPackageAsCapabilities;
        if (profileStream == null) return providedCapabilityArray;
        try {
            profileStream.close();
            return providedCapabilityArray;
        }
        catch (IOException iOException) {}
        return providedCapabilityArray;
        catch (IOException e) {
            e.printStackTrace();
            if (profileStream == null) return new ProvidedCapability[0];
            try {
                profileStream.close();
                return new ProvidedCapability[0];
            }
            catch (IOException iOException) {}
            return new ProvidedCapability[0];
        }
        catch (BundleException e2) {
            e2.printStackTrace();
            if (profileStream == null) return new ProvidedCapability[0];
            {
                catch (Throwable throwable) {
                    if (profileStream == null) throw throwable;
                    try {
                        profileStream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                profileStream.close();
                return new ProvidedCapability[0];
            }
            catch (IOException iOException) {}
            return new ProvidedCapability[0];
        }
    }

    private static void generateJREIUData(MetadataFactory.InstallableUnitDescription iu, String installableUnitId, Version installableUnitVersion, File jreLocation) {
        File[] profiles = jreLocation.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getAbsolutePath().endsWith(".profile");
            }
        });
        if (profiles.length != 1) {
            iu.setVersion(DEFAULT_JRE_VERSION);
            iu.setCapabilities(JREAction.generateJRECapability(installableUnitId, installableUnitVersion, null));
            return;
        }
        String profileName = new Path(profiles[0].getAbsolutePath()).lastSegment();
        Version version = DEFAULT_JRE_VERSION;
        if (profileName.indexOf("1.6") > 0) {
            version = new Version("1.6");
        } else if (profileName.indexOf("1.5") > 0) {
            version = new Version("1.5");
        } else if (profileName.indexOf("1.4") > 0) {
            version = new Version("1.4");
        }
        iu.setVersion(version);
        try {
            iu.setCapabilities(JREAction.generateJRECapability(installableUnitId, installableUnitVersion, new FileInputStream(profiles[0])));
        }
        catch (FileNotFoundException fileNotFoundException) {}
    }

    public JREAction(IPublisherInfo info, File location) {
        this.location = location;
    }

    public IStatus perform(IPublisherInfo info, IPublisherResult results) {
        IArtifactDescriptor artifact = JREAction.createJREData(this.location, results);
        if (artifact != null) {
            this.publishArtifact(artifact, new File[]{this.location}, null, info, JREAction.createRootPrefixComputer(this.location));
        }
        return Status.OK_STATUS;
    }
}

