/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.publisher.actions;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.MetadataFactory;
import org.eclipse.equinox.internal.provisional.p2.metadata.ProvidedCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.RequiredCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.actions.IRootIUAdvice;
import org.eclipse.equinox.p2.publisher.actions.IVersionAdvice;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

public class RootIUAction
extends AbstractPublisherAction {
    private Version version;
    private String id;
    private String name;
    private Collection versionAdvice;
    private IPublisherInfo info;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public RootIUAction(String id, Version version, String name) {
        this.id = id;
        this.version = version;
        this.name = name;
    }

    public IStatus perform(IPublisherInfo info, IPublisherResult results) {
        this.info = info;
        this.generateRootIU(results);
        return Status.OK_STATUS;
    }

    protected void generateRootIU(IPublisherResult result) {
        Collection children = this.getChildren(result);
        MetadataFactory.InstallableUnitDescription descriptor = RootIUAction.createTopLevelIUDescription(children, this.id, this.version, this.name, null, false);
        this.processCapabilityAdvice(descriptor, this.info);
        IInstallableUnit rootIU = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)descriptor);
        if (rootIU == null) {
            return;
        }
        result.addIU(rootIU, "non_root");
    }

    private Collection getChildren(IPublisherResult result) {
        Collection rootAdvice;
        HashSet<Object> children = new HashSet<Object>();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.p2.publisher.actions.IRootIUAdvice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((rootAdvice = this.info.getAdvice(null, true, null, null, clazz)) == null) {
            return children;
        }
        Iterator i = rootAdvice.iterator();
        while (i.hasNext()) {
            IRootIUAdvice advice = (IRootIUAdvice)i.next();
            Collection list = advice.getChildren(result);
            if (list == null) continue;
            Iterator j = list.iterator();
            while (j.hasNext()) {
                Object object = j.next();
                if (object instanceof String) {
                    String childId = (String)object;
                    IInstallableUnit iu = result.getIU(childId, null);
                    if (iu == null) {
                        iu = this.queryFor(childId);
                    }
                    if (iu == null) continue;
                    children.add(iu);
                    continue;
                }
                if (!(object instanceof IInstallableUnit)) continue;
                children.add(object);
            }
        }
        return children;
    }

    private IInstallableUnit queryFor(String iuId) {
        InstallableUnitQuery query = new InstallableUnitQuery(iuId, this.getVersionAdvice(iuId));
        if (this.info.getMetadataRepository() == null) {
            return null;
        }
        Collector result = this.info.getMetadataRepository().query((Query)query, new Collector(), (IProgressMonitor)new NullProgressMonitor());
        if (!result.isEmpty()) {
            return (IInstallableUnit)result.iterator().next();
        }
        return null;
    }

    public static MetadataFactory.InstallableUnitDescription createTopLevelIUDescription(Collection children, String id, Version version, String name, Collection requires, boolean configureLauncherData) {
        MetadataFactory.InstallableUnitDescription root = new MetadataFactory.InstallableUnitDescription();
        root.setSingleton(true);
        root.setId(id);
        root.setVersion(version);
        root.setProperty("org.eclipse.equinox.p2.name", name);
        Collection requiredCapabilities = RootIUAction.createIURequirements(children);
        if (requires != null) {
            requiredCapabilities.addAll(requires);
        }
        root.setRequiredCapabilities(requiredCapabilities.toArray(new RequiredCapability[requiredCapabilities.size()]));
        root.setArtifacts(new IArtifactKey[0]);
        root.setProperty("lineUp", "true");
        root.setUpdateDescriptor(MetadataFactory.createUpdateDescriptor((String)id, (VersionRange)VersionRange.emptyRange, (int)0, null));
        root.setProperty("org.eclipse.equinox.p2.type.group", Boolean.TRUE.toString());
        root.setCapabilities(new ProvidedCapability[]{RootIUAction.createSelfCapability(id, version)});
        root.setTouchpointType(PublisherHelper.TOUCHPOINT_OSGI);
        return root;
    }

    private Version getVersionAdvice(String iuID) {
        if (this.versionAdvice == null) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.equinox.p2.publisher.actions.IVersionAdvice");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.versionAdvice = this.info.getAdvice(null, true, null, null, clazz);
            if (this.versionAdvice == null) {
                return null;
            }
        }
        Iterator i = this.versionAdvice.iterator();
        while (i.hasNext()) {
            IVersionAdvice advice = (IVersionAdvice)i.next();
            Version result = advice.getVersion("bundle", iuID);
            if (result != null) {
                return result;
            }
            result = advice.getVersion("feature", iuID);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

