/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.publisher.eclipse;

import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.publisher.eclipse.DataLoader;
import org.eclipse.equinox.internal.provisional.frameworkadmin.ConfigData;
import org.eclipse.equinox.internal.provisional.frameworkadmin.LauncherData;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.eclipse.ConfigAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.LaunchingAdvice;

public class AccumulateConfigDataAction
extends AbstractPublisherAction {
    private String configSpec;
    private DataLoader loader;

    public AccumulateConfigDataAction(IPublisherInfo info, String configSpec, File configurationLocation, File executableLocation) {
        this.configSpec = configSpec;
        this.loader = new DataLoader(configurationLocation, executableLocation);
    }

    public IStatus perform(IPublisherInfo info, IPublisherResult results) {
        this.storeConfigData(info, this.configSpec, results);
        return Status.OK_STATUS;
    }

    protected void storeConfigData(IPublisherInfo info, String configSpec, IPublisherResult result) {
        ConfigData data = this.loader.getConfigData();
        if (data == null) {
            return;
        }
        info.addAdvice(new ConfigAdvice(data, configSpec));
        LauncherData launcherData = this.loader.getLauncherData();
        if (launcherData == null) {
            return;
        }
        info.addAdvice(new LaunchingAdvice(launcherData, configSpec));
    }
}

