/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.publisher.eclipse;

import org.eclipse.equinox.internal.p2.publisher.eclipse.BrandingIron;
import org.eclipse.equinox.internal.p2.publisher.eclipse.ExecutablesDescriptor;
import org.eclipse.equinox.internal.p2.publisher.eclipse.ProductFile;
import org.eclipse.equinox.p2.publisher.eclipse.EquinoxExecutableAction;
import org.osgi.framework.Version;

public class BrandedExecutableAction
extends EquinoxExecutableAction {
    private ProductFile product;

    public BrandedExecutableAction(ExecutablesDescriptor executables, String productLocation, String flavor, String configSpec) {
        this.executables = executables;
        this.flavor = flavor;
        this.configSpec = configSpec;
        this.product = this.loadProduct(productLocation);
        this.idBase = this.product.getProductName();
        this.version = new Version(this.product.getVersion());
    }

    private ProductFile loadProduct(String productLocation) {
        ProductFile result = null;
        try {
            result = new ProductFile(productLocation);
        }
        catch (Exception exception) {}
        if (result == null) {
            throw new IllegalArgumentException("unable to load product file");
        }
        return result;
    }

    protected ExecutablesDescriptor brandExecutables(ExecutablesDescriptor descriptor) {
        ExecutablesDescriptor result = new ExecutablesDescriptor(descriptor);
        result.makeTemporaryCopy();
        BrandingIron iron = new BrandingIron();
        String os = BrandedExecutableAction.parseConfigSpec(this.configSpec)[1];
        iron.setIcons(this.product.getIcons(os));
        iron.setName(this.product.getLauncherName());
        iron.setOS(os);
        iron.setRoot(result.getLocation().getAbsolutePath());
        try {
            iron.brand();
            result.setExecutableName(this.product.getLauncherName(), true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

