/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.publisher.eclipse;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.internal.p2.publisher.Activator;
import org.eclipse.equinox.internal.p2.publisher.Messages;
import org.eclipse.equinox.internal.p2.publisher.eclipse.GeneratorBundleInfo;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.ArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.internal.provisional.p2.metadata.MetadataFactory;
import org.eclipse.equinox.internal.provisional.p2.metadata.ProvidedCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.RequiredCapability;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.actions.ICapabilityAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.IBundleAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.IBundleShapeAdvice;
import org.eclipse.equinox.spi.p2.publisher.LocalizationHelper;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;
import org.eclipse.osgi.service.pluginconversion.PluginConversionException;
import org.eclipse.osgi.service.pluginconversion.PluginConverter;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public class BundlesAction
extends AbstractPublisherAction {
    protected static final String ORG_ECLIPSE_EQUINOX_SIMPLECONFIGURATOR = "org.eclipse.equinox.simpleconfigurator";
    protected static final String ORG_ECLIPSE_UPDATE_CONFIGURATOR = "org.eclipse.update.configurator";
    public static final String TYPE_ECLIPSE_BUNDLE = "bundle";
    public static final String TYPE_ECLIPSE_SOURCE = "source";
    public static final String OSGI_BUNDLE_CLASSIFIER = "osgi.bundle";
    private static final String CAPABILITY_NS_OSGI_BUNDLE = "osgi.bundle";
    private static final String CAPABILITY_NS_OSGI_FRAGMENT = "osgi.fragment";
    public static final ProvidedCapability BUNDLE_CAPABILITY = MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.eclipse.type", (String)"bundle", (Version)new Version(1, 0, 0));
    public static final ProvidedCapability SOURCE_BUNDLE_CAPABILITY = MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.eclipse.type", (String)"source", (Version)new Version(1, 0, 0));
    static final String DEFAULT_BUNDLE_LOCALIZATION = "plugin";
    static final String PROPERTIES_FILE_EXTENSION = ".properties";
    static final String ADVICE_INSTRUCTIONS_PREFIX = "instructions.";
    private static final String[] BUNDLE_IU_PROPERTY_MAP = new String[]{"Bundle-Name", "org.eclipse.equinox.p2.name", "Bundle-Description", "org.eclipse.equinox.p2.description", "Bundle-Vendor", "org.eclipse.equinox.p2.provider", "Bundle-ContactAddress", "org.eclipse.equinox.p2.contact", "Bundle-DocURL", "org.eclipse.equinox.p2.doc.url"};
    public static final String[] BUNDLE_LOCALIZED_PROPERTIES = new String[]{"Bundle-Name", "Bundle-Description", "Bundle-Vendor", "Bundle-ContactAddress", "Bundle-DocURL", "Bundle-UpdateLocation"};
    public static final int BUNDLE_LOCALIZATION_INDEX = BUNDLE_LOCALIZED_PROPERTIES.length;
    public static final String DIR = "dir";
    public static final String JAR = "jar";
    private static final String FEATURE_FILENAME_DESCRIPTOR = "feature.xml";
    private static final String PLUGIN_FILENAME_DESCRIPTOR = "plugin.xml";
    private static final String FRAGMENT_FILENAME_DESCRIPTOR = "fragment.xml";
    public static String BUNDLE_SHAPE = "Eclipse-BundleShape";
    private File[] locations;
    private BundleDescription[] bundles;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public static IArtifactKey createBundleArtifactKey(String bsn, String version) {
        return new ArtifactKey("osgi.bundle", bsn, new Version(version));
    }

    public static IInstallableUnit createBundleConfigurationUnit(String hostId, Version hostVersion, boolean isBundleFragment, GeneratorBundleInfo configInfo, String configurationFlavor, String filter) {
        if (configInfo == null) {
            return null;
        }
        MetadataFactory.InstallableUnitFragmentDescription cu = new MetadataFactory.InstallableUnitFragmentDescription();
        String configUnitId = String.valueOf(configurationFlavor) + hostId;
        cu.setId(configUnitId);
        cu.setVersion(hostVersion);
        cu.setHost(new RequiredCapability[]{MetadataFactory.createRequiredCapability((String)"osgi.bundle", (String)hostId, (VersionRange)new VersionRange(hostVersion, true, PublisherHelper.versionMax, true), null, (boolean)false, (boolean)false, (boolean)true), MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.eclipse.type", (String)TYPE_ECLIPSE_BUNDLE, (VersionRange)new VersionRange(new Version(1, 0, 0), true, new Version(2, 0, 0), false), null, (boolean)false, (boolean)false, (boolean)false)});
        cu.setProperty("org.eclipse.equinox.p2.type.fragment", Boolean.TRUE.toString());
        cu.setCapabilities(new ProvidedCapability[]{PublisherHelper.createSelfCapability(configUnitId, hostVersion), MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.flavor", (String)configurationFlavor, (Version)new Version(1, 0, 0))});
        HashMap<String, String> touchpointData = new HashMap<String, String>();
        touchpointData.put("install", "installBundle(bundle:${artifact})");
        touchpointData.put("uninstall", "uninstallBundle(bundle:${artifact})");
        touchpointData.put("configure", BundlesAction.createConfigScript(configInfo, isBundleFragment));
        touchpointData.put("unconfigure", BundlesAction.createUnconfigScript(configInfo, isBundleFragment));
        cu.addTouchpointData(MetadataFactory.createTouchpointData(touchpointData));
        cu.setFilter(filter);
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)cu);
    }

    public static IInstallableUnit createBundleIU(BundleDescription bd, Map manifest, boolean isFolderPlugin, IArtifactKey key, IPublisherInfo info) {
        Map manifestLocalizations = null;
        if (manifest != null && bd.getLocation() != null) {
            manifestLocalizations = BundlesAction.getManifestLocalizations(manifest, new File(bd.getLocation()));
        }
        return BundlesAction.createBundleIU(bd, manifest, isFolderPlugin, key, manifestLocalizations, info);
    }

    public static IInstallableUnit createBundleIU(BundleDescription bd, Map manifest, boolean isFolderPlugin, IArtifactKey key, Map manifestLocalizations, IPublisherInfo info) {
        MetadataFactory.InstallableUnitDescription iu = new MetadataFactory.InstallableUnitDescription();
        iu.setSingleton(bd.isSingleton());
        iu.setId(bd.getSymbolicName());
        iu.setVersion(bd.getVersion());
        iu.setFilter(bd.getPlatformFilter());
        iu.setUpdateDescriptor(MetadataFactory.createUpdateDescriptor((String)bd.getSymbolicName(), (VersionRange)new VersionRange(new Version(0, 0, 0), true, bd.getVersion(), false), (int)0, null));
        iu.setArtifacts(new IArtifactKey[]{key});
        iu.setTouchpointType(PublisherHelper.TOUCHPOINT_OSGI);
        boolean isFragment = bd.getHost() != null;
        BundleSpecification[] requiredBundles = bd.getRequiredBundles();
        ArrayList<RequiredCapability> reqsDeps = new ArrayList<RequiredCapability>();
        if (isFragment) {
            reqsDeps.add(MetadataFactory.createRequiredCapability((String)"osgi.bundle", (String)bd.getHost().getName(), (VersionRange)bd.getHost().getVersionRange(), null, (boolean)false, (boolean)false));
        }
        int j = 0;
        while (j < requiredBundles.length) {
            reqsDeps.add(MetadataFactory.createRequiredCapability((String)"osgi.bundle", (String)requiredBundles[j].getName(), (VersionRange)(requiredBundles[j].getVersionRange() == VersionRange.emptyRange ? null : requiredBundles[j].getVersionRange()), null, (boolean)requiredBundles[j].isOptional(), (boolean)false));
            ++j;
        }
        ImportPackageSpecification[] osgiImports = bd.getImportPackages();
        int i = 0;
        while (i < osgiImports.length) {
            ImportPackageSpecification importSpec = osgiImports[i];
            String importPackageName = importSpec.getName();
            if (importPackageName.indexOf(42) == -1) {
                VersionRange versionRange = importSpec.getVersionRange() == VersionRange.emptyRange ? null : importSpec.getVersionRange();
                reqsDeps.add(MetadataFactory.createRequiredCapability((String)"java.package", (String)importPackageName, (VersionRange)versionRange, null, (boolean)BundlesAction.isOptional(importSpec), (boolean)false));
            }
            ++i;
        }
        iu.setRequiredCapabilities(reqsDeps.toArray(new RequiredCapability[reqsDeps.size()]));
        ArrayList<ProvidedCapability> providedCapabilities = new ArrayList<ProvidedCapability>();
        providedCapabilities.add(PublisherHelper.createSelfCapability(bd.getSymbolicName(), bd.getVersion()));
        providedCapabilities.add(MetadataFactory.createProvidedCapability((String)"osgi.bundle", (String)bd.getSymbolicName(), (Version)bd.getVersion()));
        ExportPackageDescription[] exports = bd.getExportPackages();
        int i2 = 0;
        while (i2 < exports.length) {
            providedCapabilities.add(MetadataFactory.createProvidedCapability((String)"java.package", (String)exports[i2].getName(), exports[i2].getVersion() == Version.emptyVersion ? null : exports[i2].getVersion()));
            ++i2;
        }
        if (manifest != null && manifest.containsKey("Eclipse-SourceBundle")) {
            providedCapabilities.add(SOURCE_BUNDLE_CAPABILITY);
        } else {
            providedCapabilities.add(BUNDLE_CAPABILITY);
        }
        if (isFragment) {
            providedCapabilities.add(MetadataFactory.createProvidedCapability((String)CAPABILITY_NS_OSGI_FRAGMENT, (String)bd.getHost().getName(), (Version)bd.getVersion()));
        }
        if (manifestLocalizations != null) {
            Iterator iter = manifestLocalizations.keySet().iterator();
            while (iter.hasNext()) {
                Locale locale = (Locale)iter.next();
                Properties translatedStrings = (Properties)manifestLocalizations.get(locale);
                Enumeration<?> propertyKeys = translatedStrings.propertyNames();
                while (propertyKeys.hasMoreElements()) {
                    String nextKey = (String)propertyKeys.nextElement();
                    iu.setProperty(String.valueOf(locale.toString()) + '.' + nextKey, translatedStrings.getProperty(nextKey));
                }
                providedCapabilities.add(PublisherHelper.makeTranslationCapability(bd.getSymbolicName(), locale));
            }
        }
        iu.setCapabilities(providedCapabilities.toArray(new ProvidedCapability[providedCapabilities.size()]));
        BundlesAction.processCapabilityAdvice(iu, bd, info);
        if (manifest != null) {
            i = 0;
            while (i < BUNDLE_IU_PROPERTY_MAP.length) {
                String value;
                if (manifest.containsKey(BUNDLE_IU_PROPERTY_MAP[i]) && (value = (String)manifest.get(BUNDLE_IU_PROPERTY_MAP[i])) != null && value.length() > 0) {
                    iu.setProperty(BUNDLE_IU_PROPERTY_MAP[i + 1], value);
                }
                i += 2;
            }
        }
        HashMap<String, String> touchpointData = new HashMap<String, String>();
        if (isFolderPlugin) {
            touchpointData.put("zipped", "true");
        }
        touchpointData.put("manifest", BundlesAction.toManifestString(manifest));
        BundlesAction.processInstructionsAdvice(touchpointData, bd.getLocation(), info);
        iu.addTouchpointData(MetadataFactory.createTouchpointData(touchpointData));
        BundlesAction.processPropertiesAdvice(iu, bd.getLocation(), info);
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iu);
    }

    private static void processPropertiesAdvice(MetadataFactory.InstallableUnitDescription bundle, String location, IPublisherInfo info) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.p2.publisher.eclipse.IBundleAdvice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Collection advice = info.getAdvice(null, false, null, null, clazz);
        File bundleFile = new File(location);
        Iterator i = advice.iterator();
        while (i.hasNext()) {
            IBundleAdvice entry = (IBundleAdvice)i.next();
            Properties props = entry.getIUProperties(bundleFile);
            if (props == null) continue;
            Iterator<Object> j = props.keySet().iterator();
            while (j.hasNext()) {
                String key = (String)j.next();
                bundle.setProperty(key, props.getProperty(key));
            }
        }
    }

    private static void processCapabilityAdvice(MetadataFactory.InstallableUnitDescription iu, BundleDescription bundle, IPublisherInfo info) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.p2.publisher.actions.ICapabilityAdvice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Collection advice = info.getAdvice(null, false, null, null, clazz);
        Iterator i = advice.iterator();
        while (i.hasNext()) {
            RequiredCapability[] result;
            RequiredCapability[] current;
            ICapabilityAdvice entry = (ICapabilityAdvice)i.next();
            RequiredCapability[] requiredAdvice = entry.getRequiredCapabilities(iu);
            ProvidedCapability[] providedAdvice = entry.getProvidedCapabilities(iu);
            if (providedAdvice != null) {
                current = iu.getRequiredCapabilities();
                result = new RequiredCapability[requiredAdvice.length + current.length];
                System.arraycopy(requiredAdvice, 0, result, 0, requiredAdvice.length);
                System.arraycopy(current, 0, result, requiredAdvice.length, current.length);
                iu.setRequiredCapabilities(result);
            }
            if (providedAdvice == null) continue;
            current = iu.getProvidedCapabilities();
            result = new ProvidedCapability[providedAdvice.length + current.length];
            System.arraycopy(providedAdvice, 0, result, 0, providedAdvice.length);
            System.arraycopy(current, 0, result, providedAdvice.length, current.length);
            iu.setCapabilities((ProvidedCapability[])result);
        }
    }

    private static void processInstructionsAdvice(Map touchpointData, String location, IPublisherInfo info) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.p2.publisher.eclipse.IBundleAdvice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Collection advice = info.getAdvice(null, false, null, null, clazz);
        File bundleFile = new File(location);
        Iterator i = advice.iterator();
        while (i.hasNext()) {
            IBundleAdvice entry = (IBundleAdvice)i.next();
            Map bundleAdvice = entry.getInstructions(bundleFile);
            if (bundleAdvice == null) continue;
            Iterator iterator = bundleAdvice.keySet().iterator();
            while (iterator.hasNext()) {
                String instructions;
                String key = (String)iterator.next();
                if (!key.startsWith(ADVICE_INSTRUCTIONS_PREFIX)) continue;
                String phase = key.substring(ADVICE_INSTRUCTIONS_PREFIX.length());
                String string = instructions = touchpointData.containsKey(phase) ? (String)touchpointData.get(phase) : "";
                if (instructions.length() > 0) {
                    instructions = String.valueOf(instructions) + ";";
                }
                instructions = String.valueOf(instructions) + ((String)bundleAdvice.get(key)).trim();
                touchpointData.put(phase, instructions);
            }
        }
    }

    public static void createHostLocalizationFragment(IInstallableUnit bundleIU, BundleDescription bd, String hostId, String[] hostBundleManifestValues, Set localizationIUs) {
        Map hostLocalizations = BundlesAction.getHostLocalizations(new File(bd.getLocation()), hostBundleManifestValues);
        if (hostLocalizations != null) {
            IInstallableUnitFragment localizationFragment = BundlesAction.createLocalizationFragmentOfHost(bd, hostId, hostBundleManifestValues, hostLocalizations);
            localizationIUs.add(localizationFragment);
        }
    }

    private static IInstallableUnitFragment createLocalizationFragmentOfHost(BundleDescription bd, String hostId, String[] hostManifestValues, Map hostLocalizations) {
        MetadataFactory.InstallableUnitFragmentDescription fragment = new MetadataFactory.InstallableUnitFragmentDescription();
        String fragmentId = BundlesAction.makeHostLocalizationFragmentId(bd.getSymbolicName());
        fragment.setId(fragmentId);
        fragment.setVersion(bd.getVersion());
        HostSpecification hostSpec = bd.getHost();
        RequiredCapability[] hostReqs = new RequiredCapability[]{MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.iu", (String)hostSpec.getName(), (VersionRange)hostSpec.getVersionRange(), null, (boolean)false, (boolean)false, (boolean)false)};
        fragment.setHost(hostReqs);
        fragment.setSingleton(true);
        fragment.setProperty("org.eclipse.equinox.p2.type.fragment", Boolean.TRUE.toString());
        ArrayList<ProvidedCapability> providedCapabilities = new ArrayList<ProvidedCapability>(hostLocalizations.keySet().size());
        Iterator iter = hostLocalizations.keySet().iterator();
        while (iter.hasNext()) {
            Locale locale = (Locale)iter.next();
            Properties translatedStrings = (Properties)hostLocalizations.get(locale);
            Enumeration<?> propertyKeys = translatedStrings.propertyNames();
            while (propertyKeys.hasMoreElements()) {
                String nextKey = (String)propertyKeys.nextElement();
                fragment.setProperty(String.valueOf(locale.toString()) + '.' + nextKey, translatedStrings.getProperty(nextKey));
            }
            providedCapabilities.add(PublisherHelper.makeTranslationCapability(hostId, locale));
        }
        fragment.setCapabilities(providedCapabilities.toArray(new ProvidedCapability[providedCapabilities.size()]));
        return MetadataFactory.createInstallableUnitFragment((MetadataFactory.InstallableUnitFragmentDescription)fragment);
    }

    private static String makeHostLocalizationFragmentId(String id) {
        return String.valueOf(id) + ".translated_host_properties";
    }

    private static String createConfigScript(GeneratorBundleInfo configInfo, boolean isBundleFragment) {
        if (configInfo == null) {
            return "";
        }
        String configScript = "";
        if (!isBundleFragment && configInfo.getStartLevel() != -1) {
            configScript = String.valueOf(configScript) + "setStartLevel(startLevel:" + configInfo.getStartLevel() + ");";
        }
        if (!isBundleFragment && configInfo.isMarkedAsStarted()) {
            configScript = String.valueOf(configScript) + "markStarted(started: true);";
        }
        if (configInfo.getSpecialConfigCommands() != null) {
            configScript = String.valueOf(configScript) + configInfo.getSpecialConfigCommands();
        }
        return configScript;
    }

    private static String createDefaultBundleConfigScript(GeneratorBundleInfo configInfo) {
        return BundlesAction.createConfigScript(configInfo, false);
    }

    public static IInstallableUnit createDefaultBundleConfigurationUnit(GeneratorBundleInfo configInfo, GeneratorBundleInfo unconfigInfo, String configurationFlavor) {
        MetadataFactory.InstallableUnitFragmentDescription cu = new MetadataFactory.InstallableUnitFragmentDescription();
        String configUnitId = PublisherHelper.createDefaultConfigUnitId("osgi.bundle", configurationFlavor);
        cu.setId(configUnitId);
        Version configUnitVersion = new Version(1, 0, 0);
        cu.setVersion(configUnitVersion);
        cu.setProperty("org.eclipse.equinox.p2.type.fragment", Boolean.TRUE.toString());
        cu.setCapabilities(new ProvidedCapability[]{PublisherHelper.createSelfCapability(configUnitId, configUnitVersion), MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.flavor", (String)configurationFlavor, (Version)new Version(1, 0, 0))});
        RequiredCapability[] reqs = new RequiredCapability[]{MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.eclipse.type", (String)TYPE_ECLIPSE_BUNDLE, (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)true, (boolean)false)};
        cu.setHost(reqs);
        HashMap<String, String> touchpointData = new HashMap<String, String>();
        touchpointData.put("install", "installBundle(bundle:${artifact})");
        touchpointData.put("uninstall", "uninstallBundle(bundle:${artifact})");
        touchpointData.put("configure", BundlesAction.createDefaultBundleConfigScript(configInfo));
        touchpointData.put("unconfigure", BundlesAction.createDefaultBundleUnconfigScript(unconfigInfo));
        cu.addTouchpointData(MetadataFactory.createTouchpointData(touchpointData));
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)cu);
    }

    private static String createDefaultBundleUnconfigScript(GeneratorBundleInfo unconfigInfo) {
        return BundlesAction.createUnconfigScript(unconfigInfo, false);
    }

    private static String createUnconfigScript(GeneratorBundleInfo unconfigInfo, boolean isBundleFragment) {
        if (unconfigInfo == null) {
            return "";
        }
        String unconfigScript = "";
        if (!isBundleFragment && unconfigInfo.getStartLevel() != -1) {
            unconfigScript = String.valueOf(unconfigScript) + "setStartLevel(startLevel:-1);";
        }
        if (!isBundleFragment && unconfigInfo.isMarkedAsStarted()) {
            unconfigScript = String.valueOf(unconfigScript) + "markStarted(started: false);";
        }
        if (unconfigInfo.getSpecialUnconfigCommands() != null) {
            unconfigScript = String.valueOf(unconfigScript) + unconfigInfo.getSpecialUnconfigCommands();
        }
        return unconfigScript;
    }

    private static boolean isOptional(ImportPackageSpecification importedPackage) {
        return importedPackage.getDirective("resolution").equals("dynamic") || importedPackage.getDirective("resolution").equals("optional");
    }

    private static String toManifestString(Map p) {
        if (p == null) {
            return null;
        }
        Set properties = p.entrySet();
        StringBuffer result = new StringBuffer();
        Iterator iterator = properties.iterator();
        while (iterator.hasNext()) {
            Map.Entry aProperty = (Map.Entry)iterator.next();
            if (aProperty.getKey().equals(BUNDLE_SHAPE)) continue;
            result.append(aProperty.getKey()).append(": ").append(aProperty.getValue()).append('\n');
        }
        return result.toString();
    }

    private static Map getManifestLocalizations(Map manifest, File bundleLocation) {
        Locale defaultLocale = null;
        String[] bundleManifestValues = BundlesAction.getManifestCachedValues(manifest);
        String bundleLocalization = bundleManifestValues[BUNDLE_LOCALIZATION_INDEX];
        Map localizations = JAR.equalsIgnoreCase(new Path(bundleLocation.getName()).getFileExtension()) && bundleLocation.isFile() ? LocalizationHelper.getJarPropertyLocalizations(bundleLocation, bundleLocalization, defaultLocale, bundleManifestValues) : LocalizationHelper.getDirPropertyLocalizations(bundleLocation, bundleLocalization, defaultLocale, bundleManifestValues);
        return localizations;
    }

    public static String[] getManifestCachedValues(Map manifest) {
        String[] cachedValues = new String[BUNDLE_LOCALIZED_PROPERTIES.length + 1];
        int j = 0;
        while (j < PublisherHelper.BUNDLE_LOCALIZED_PROPERTIES.length) {
            String value = (String)manifest.get(BUNDLE_LOCALIZED_PROPERTIES[j]);
            if (value != null && value.length() > 1 && value.charAt(0) == '%') {
                cachedValues[j] = value.substring(1);
            }
            ++j;
        }
        String localizationFile = (String)manifest.get("Bundle-Localization");
        cachedValues[BundlesAction.BUNDLE_LOCALIZATION_INDEX] = localizationFile != null ? localizationFile : DEFAULT_BUNDLE_LOCALIZATION;
        return cachedValues;
    }

    public static Map getHostLocalizations(File bundleLocation, String[] hostBundleManifestValues) {
        Locale defaultLocale = null;
        String hostBundleLocalization = hostBundleManifestValues[BUNDLE_LOCALIZATION_INDEX];
        Map localizations = JAR.equalsIgnoreCase(new Path(bundleLocation.getName()).getFileExtension()) && bundleLocation.isFile() ? LocalizationHelper.getJarPropertyLocalizations(bundleLocation, hostBundleLocalization, defaultLocale, hostBundleManifestValues) : LocalizationHelper.getDirPropertyLocalizations(bundleLocation, hostBundleLocalization, defaultLocale, hostBundleManifestValues);
        return localizations;
    }

    private static PluginConverter acquirePluginConverter() {
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.osgi.service.pluginconversion.PluginConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (PluginConverter)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName());
    }

    private static Dictionary convertPluginManifest(File bundleLocation, boolean logConversionException) {
        PluginConverter converter;
        block6: {
            try {
                converter = BundlesAction.acquirePluginConverter();
                if (converter != null) break block6;
                LogHelper.log((IStatus)new Status(4, Activator.ID, "Unable to aquire PluginConverter service during generation for: " + bundleLocation));
                return null;
            }
            catch (PluginConversionException convertException) {
                if (bundleLocation.getName().equals(FEATURE_FILENAME_DESCRIPTOR)) {
                    return null;
                }
                if (!new File(bundleLocation, PLUGIN_FILENAME_DESCRIPTOR).exists() && !new File(bundleLocation, FRAGMENT_FILENAME_DESCRIPTOR).exists()) {
                    return null;
                }
                if (logConversionException) {
                    Status status = new Status(2, Activator.ID, 0, NLS.bind((String)Messages.exception_errorConverting, (Object)bundleLocation.getAbsolutePath()), (Throwable)convertException);
                    LogHelper.log((IStatus)status);
                }
                return null;
            }
        }
        return converter.convertManifest(bundleLocation, false, null, true, null);
    }

    public static BundleDescription createBundleDescription(Dictionary enhancedManifest, File bundleLocation) {
        try {
            BundleDescription descriptor = StateObjectFactory.defaultFactory.createBundleDescription(null, enhancedManifest, bundleLocation == null ? null : bundleLocation.getAbsolutePath(), 1L);
            descriptor.setUserObject((Object)enhancedManifest);
            return descriptor;
        }
        catch (BundleException e) {
            String message = NLS.bind((String)Messages.exception_stateAddition, (Object)(bundleLocation == null ? null : bundleLocation.getAbsoluteFile()));
            Status status = new Status(2, Activator.ID, message, (Throwable)e);
            LogHelper.log((IStatus)status);
            return null;
        }
    }

    public static BundleDescription createBundleDescription(File bundleLocation) {
        Dictionary manifest = BundlesAction.loadManifest(bundleLocation);
        if (manifest == null) {
            return null;
        }
        return BundlesAction.createBundleDescription(manifest, bundleLocation);
    }

    public static BundleDescription createBundleDescription(InputStream manifestStream, File bundleLocation) {
        Hashtable entries = new Hashtable();
        try {
            ManifestElement.parseBundleManifest((InputStream)manifestStream, entries);
            return BundlesAction.createBundleDescription(entries, bundleLocation);
        }
        catch (IOException e) {
            String message = "An error occurred while reading the bundle description " + (bundleLocation == null ? "" : String.valueOf(bundleLocation.getAbsolutePath()) + '.');
            Status status = new Status(4, Activator.ID, message, (Throwable)e);
            LogHelper.log((IStatus)status);
        }
        catch (BundleException e) {
            String message = "An error occurred while reading the bundle description " + (bundleLocation == null ? "" : String.valueOf(bundleLocation.getAbsolutePath()) + '.');
            Status status = new Status(4, Activator.ID, message, (Throwable)e);
            LogHelper.log((IStatus)status);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static Dictionary loadManifest(File bundleLocation) {
        manifestStream /* !! */  = null;
        jarFile = null;
        try {
            if ("jar".equalsIgnoreCase(new Path(bundleLocation.getName()).getFileExtension()) && bundleLocation.isFile()) {
                jarFile = new ZipFile(bundleLocation, 1);
                manifestEntry = jarFile.getEntry("META-INF/MANIFEST.MF");
                if (manifestEntry != null) {
                    manifestStream /* !! */  = jarFile.getInputStream(manifestEntry);
                }
            } else {
                manifestFile = new File(bundleLocation, "META-INF/MANIFEST.MF");
                if (manifestFile.exists()) {
                    manifestStream /* !! */  = new BufferedInputStream(new FileInputStream(manifestFile));
                }
            }
        }
        catch (IOException e) {
            LogHelper.log((IStatus)new Status(2, Activator.ID, "An error occurred while loading the bundle manifest " + bundleLocation, (Throwable)e));
        }
        manifest = null;
        if (manifestStream /* !! */  != null) {
            try {
                manifestMap = ManifestElement.parseBundleManifest(manifestStream /* !! */ , null);
                manifest = new Hashtable<K, V>(manifestMap);
            }
            catch (IOException e) {
                LogHelper.log((IStatus)new Status(4, Activator.ID, "An error occurred while loading the bundle manifest " + bundleLocation, (Throwable)e));
lbl25:
                // 2 sources

                while (true) {
                    try {
                        if (jarFile != null) {
                            jarFile.close();
                        }
                    }
                    catch (IOException v0) {}
                    return null;
                }
            }
            catch (BundleException e) {
                try {
                    LogHelper.log((IStatus)new Status(4, Activator.ID, "An error occurred while loading the bundle manifest " + bundleLocation, (Throwable)e));
                    ** continue;
                }
                catch (Throwable var5_8) {
                    try {
                        if (jarFile != null) {
                            jarFile.close();
                        }
                    }
                    catch (IOException v1) {}
                    throw var5_8;
                }
            }
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException v2) {}
        } else {
            manifest = BundlesAction.convertPluginManifest(bundleLocation, true);
        }
        if (manifest == null) {
            return null;
        }
        if (manifest.get("Bundle-SymbolicName") == null) {
            manifest = BundlesAction.convertPluginManifest(bundleLocation, true);
        }
        if (manifest == null) {
            return null;
        }
        if (manifest.get(BundlesAction.BUNDLE_SHAPE) == null) {
            manifest.put(BundlesAction.BUNDLE_SHAPE, bundleLocation.isDirectory() != false ? "dir" : "jar");
        }
        return manifest;
    }

    public BundlesAction(File[] locations) {
        this.locations = locations;
    }

    public BundlesAction(BundleDescription[] bundles) {
        this.bundles = bundles;
    }

    public IStatus perform(IPublisherInfo info, IPublisherResult results) {
        if (this.bundles == null && this.locations == null) {
            throw new IllegalStateException("No bundles or locations provided");
        }
        if (this.bundles == null) {
            this.bundles = this.getBundleDescriptions(this.expandLocations(this.locations));
        }
        this.generateBundleIUs(this.bundles, results, info);
        this.bundles = null;
        return Status.OK_STATUS;
    }

    protected void publishArtifact(IArtifactDescriptor descriptor, File base, File[] inclusions, IPublisherInfo info) {
        File packFile;
        IArtifactRepository destination = info.getArtifactRepository();
        if (descriptor == null || destination == null) {
            return;
        }
        this.publishArtifact(descriptor, inclusions, null, info, BundlesAction.createRootPrefixComputer(base));
        boolean reuse = "true".equals(destination.getProperties().get("publishPackFilesAsSiblings"));
        if (base != null && reuse && (info.getArtifactOptions() & 2) > 0 && (packFile = new Path(base.getAbsolutePath()).addFileExtension("pack.gz").toFile()).exists()) {
            IArtifactDescriptor ad200 = BundlesAction.createPack200ArtifactDescriptor(descriptor.getArtifactKey(), packFile, descriptor.getProperty("artifact.size"));
            this.publishArtifact(ad200, packFile, info);
        }
    }

    private File[] expandLocations(File[] list) {
        ArrayList result = new ArrayList();
        this.expandLocations(list, result);
        return result.toArray(new File[result.size()]);
    }

    private void expandLocations(File[] list, ArrayList result) {
        if (list == null) {
            return;
        }
        int i = 0;
        while (i < list.length) {
            File location = list[i];
            if (location.isDirectory()) {
                if (!new File(location, "META-INF/MANIFEST.MF").exists()) {
                    this.expandLocations(location.listFiles(), result);
                } else {
                    result.add(location);
                }
            } else {
                result.add(location);
            }
            ++i;
        }
    }

    protected void generateBundleIUs(BundleDescription[] bundles, IPublisherResult result, IPublisherInfo info) {
        HashMap<String, String[]> bundleLocalizationMap = new HashMap<String, String[]>(bundles.length);
        HashSet localizationIUs = new HashSet(32);
        int phase = 0;
        while (phase <= 1) {
            int i = 0;
            while (i < bundles.length) {
                BundleDescription bd = bundles[i];
                if (bd != null && bd.getSymbolicName() != null && bd.getVersion() != null) {
                    Map bundleManifest = (Map)bd.getUserObject();
                    if (phase == 0) {
                        if (bundleManifest != null) {
                            String[] cachedValues = BundlesAction.getManifestCachedValues(bundleManifest);
                            bundleLocalizationMap.put(this.makeSimpleKey(bd), cachedValues);
                        }
                    } else {
                        String hostId;
                        String hostKey;
                        String[] cachedValues;
                        IArtifactKey key = BundlesAction.createBundleArtifactKey(bd.getSymbolicName(), bd.getVersion().toString());
                        File location = new File(bd.getLocation());
                        IArtifactDescriptor ad = PublisherHelper.createArtifactDescriptor(key, location);
                        this.addProperties((ArtifactDescriptor)ad, location, info);
                        boolean isDir = this.isDir(bd, info);
                        if (isDir) {
                            this.publishArtifact(ad, new File(bd.getLocation()), new File(bd.getLocation()).listFiles(), info);
                        } else {
                            this.publishArtifact(ad, new File(bd.getLocation()), info);
                        }
                        IInstallableUnit bundleIU = BundlesAction.createBundleIU(bd, bundleManifest, isDir, key, info);
                        if (this.isFragment(bd) && (cachedValues = (String[])bundleLocalizationMap.get(hostKey = this.makeSimpleKey(hostId = bd.getHost().getName()))) != null) {
                            BundlesAction.createHostLocalizationFragment(bundleIU, bd, hostId, cachedValues, localizationIUs);
                        }
                        result.addIU(bundleIU, "root");
                        result.addIUs(localizationIUs, "non_root");
                        localizationIUs.clear();
                    }
                }
                ++i;
            }
            ++phase;
        }
    }

    private void addProperties(ArtifactDescriptor descriptor, File location, IPublisherInfo info) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.p2.publisher.eclipse.IBundleAdvice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Collection advice = info.getAdvice(null, false, null, null, clazz);
        Iterator i = advice.iterator();
        while (i.hasNext()) {
            IBundleAdvice entry = (IBundleAdvice)i.next();
            Properties props = entry.getArtifactProperties(location);
            if (props == null) continue;
            Iterator<Object> j = props.keySet().iterator();
            while (j.hasNext()) {
                String key = (String)j.next();
                descriptor.setRepositoryProperty(key, props.getProperty(key));
            }
        }
    }

    private boolean isDir(BundleDescription bundle, IPublisherInfo info) {
        String shape;
        Collection advice;
        String string = bundle.getSymbolicName();
        Version version = bundle.getVersion();
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.equinox.p2.publisher.eclipse.IBundleShapeAdvice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((advice = info.getAdvice(null, true, string, version, clazz)) != null && !advice.isEmpty() && (shape = ((IBundleShapeAdvice)advice.iterator().next()).getShape()) != null) {
            return shape.equals(DIR);
        }
        Map manifest = (Map)bundle.getUserObject();
        String format = (String)manifest.get(BUNDLE_SHAPE);
        return DIR.equals(format);
    }

    private String makeSimpleKey(BundleDescription bd) {
        return this.makeSimpleKey(bd.getSymbolicName());
    }

    private String makeSimpleKey(String id) {
        return id;
    }

    private boolean isFragment(BundleDescription bd) {
        return bd.getHost() != null;
    }

    protected BundleDescription[] getBundleDescriptions(File[] bundleLocations) {
        if (bundleLocations == null) {
            return new BundleDescription[0];
        }
        boolean addSimpleConfigurator = false;
        boolean scIn = false;
        int i = 0;
        while (i < bundleLocations.length) {
            if (!addSimpleConfigurator) {
                boolean bl = addSimpleConfigurator = bundleLocations[i].toString().indexOf(ORG_ECLIPSE_UPDATE_CONFIGURATOR) > 0;
            }
            if (!scIn) {
                boolean bl = scIn = bundleLocations[i].toString().indexOf(ORG_ECLIPSE_EQUINOX_SIMPLECONFIGURATOR) > 0;
                if (scIn) break;
            }
            ++i;
        }
        if (scIn) {
            addSimpleConfigurator = false;
        }
        BundleDescription[] result = new BundleDescription[bundleLocations.length + (addSimpleConfigurator ? 1 : 0)];
        int i2 = 0;
        while (i2 < bundleLocations.length) {
            result[i2] = BundlesAction.createBundleDescription(bundleLocations[i2]);
            ++i2;
        }
        if (addSimpleConfigurator) {
            try {
                URL configuratorURL = FileLocator.toFileURL((URL)Activator.getContext().getBundle().getEntry("org.eclipse.equinox.simpleconfigurator.jar"));
                if (configuratorURL == null) {
                    System.out.println("Could not find simpleconfigurator bundle");
                } else {
                    File location = new File(configuratorURL.getFile());
                    result[result.length - 1] = BundlesAction.createBundleDescription(location);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }
}

