/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.publisher.eclipse;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.FileUtils;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.internal.p2.publisher.eclipse.ExecutablesDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.MetadataFactory;
import org.eclipse.equinox.internal.provisional.p2.metadata.ProvidedCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.RequiredCapability;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.eclipse.ConfigCUsAction;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

public class EquinoxExecutableAction
extends AbstractPublisherAction {
    private static String TYPE = "executable";
    protected String configSpec;
    protected String idBase;
    protected Version version;
    protected ExecutablesDescriptor executables;
    protected String flavor;

    protected EquinoxExecutableAction() {
    }

    public EquinoxExecutableAction(ExecutablesDescriptor executables, String configSpec, String idBase, Version version, String flavor) {
        this.executables = executables;
        this.configSpec = configSpec;
        this.idBase = idBase == null ? "org.eclipse" : idBase;
        this.version = version;
        this.flavor = flavor;
    }

    public IStatus perform(IPublisherInfo info, IPublisherResult result) {
        ExecutablesDescriptor brandedExecutables = this.brandExecutables(this.executables);
        this.publishExecutableIU(info, brandedExecutables, result);
        this.publishExecutableCU(info, brandedExecutables, result);
        this.publishExecutableSetter(brandedExecutables, result);
        return Status.OK_STATUS;
    }

    private void publishExecutableSetter(ExecutablesDescriptor brandedExecutables, IPublisherResult result) {
        MetadataFactory.InstallableUnitDescription iud = new MetadataFactory.InstallableUnitDescription();
        String executableName = brandedExecutables.getExecutableName();
        String id = String.valueOf(this.getExecutableId()) + '.' + executableName;
        iud.setId(id);
        iud.setVersion(this.version);
        iud.setTouchpointType(PublisherHelper.TOUCHPOINT_OSGI);
        iud.setCapabilities(new ProvidedCapability[]{EquinoxExecutableAction.createSelfCapability(id, this.version)});
        String filter = EquinoxExecutableAction.createFilterSpec(this.configSpec);
        if (filter.length() > 0) {
            iud.setFilter(filter);
        }
        HashMap<String, String> touchpointData = new HashMap<String, String>();
        touchpointData.put("configure", "setLauncherName(name:" + executableName + ")");
        touchpointData.put("unconfigure", "setLauncherName()");
        iud.addTouchpointData(MetadataFactory.createTouchpointData(touchpointData));
        result.addIU(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iud), "root");
    }

    protected void publishExecutableIU(IPublisherInfo info, ExecutablesDescriptor execDescriptor, IPublisherResult result) {
        MetadataFactory.InstallableUnitDescription iu = new MetadataFactory.InstallableUnitDescription();
        String id = this.getExecutableId();
        iu.setId(id);
        iu.setVersion(this.version);
        String filter = EquinoxExecutableAction.createFilterSpec(this.configSpec);
        iu.setFilter(filter);
        iu.setSingleton(true);
        iu.setTouchpointType(PublisherHelper.TOUCHPOINT_NATIVE);
        String namespace = ConfigCUsAction.getAbstractCUCapabilityNamespace(this.idBase, TYPE, this.flavor, this.configSpec);
        String capabilityId = ConfigCUsAction.getAbstractCUCapabilityId(this.idBase, TYPE, this.flavor, this.configSpec);
        ProvidedCapability executableCapability = MetadataFactory.createProvidedCapability((String)namespace, (String)capabilityId, (Version)this.version);
        ProvidedCapability selfCapability = EquinoxExecutableAction.createSelfCapability(id, this.version);
        iu.setCapabilities(new ProvidedCapability[]{selfCapability, executableCapability});
        ArtifactKey key = PublisherHelper.createBinaryArtifactKey(id, this.version);
        iu.setArtifacts(new IArtifactKey[]{key});
        IArtifactDescriptor descriptor = PublisherHelper.createArtifactDescriptor((IArtifactKey)key, null);
        this.publishArtifact(descriptor, execDescriptor.getFiles(), null, info, EquinoxExecutableAction.createRootPrefixComputer(execDescriptor.getLocation()));
        if (execDescriptor.isTemporary()) {
            FileUtils.deleteAll((File)execDescriptor.getLocation());
        }
        String[] config = EquinoxExecutableAction.parseConfigSpec(this.configSpec);
        String ws = config[0];
        String os = config[1];
        String arch = config[2];
        String launcherFragment = "org.eclipse.equinox.launcher." + ws + '.' + os;
        if (!"macosx".equals(os)) {
            launcherFragment = String.valueOf(launcherFragment) + '.' + arch;
        }
        iu.setRequiredCapabilities(new RequiredCapability[]{MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.iu", (String)launcherFragment, (VersionRange)VersionRange.emptyRange, (String)filter, (boolean)false, (boolean)false)});
        result.addIU(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iu), "root");
    }

    private String getExecutableId() {
        return ConfigCUsAction.getCUId(this.idBase, TYPE, "", this.configSpec);
    }

    private void publishExecutableCU(IPublisherInfo info, ExecutablesDescriptor execDescriptor, IPublisherResult result) {
        MetadataFactory.InstallableUnitFragmentDescription cu = new MetadataFactory.InstallableUnitFragmentDescription();
        String id = ConfigCUsAction.getCUId(this.idBase, TYPE, this.flavor, this.configSpec);
        cu.setId(id);
        cu.setVersion(this.version);
        cu.setFilter(EquinoxExecutableAction.createFilterSpec(this.configSpec));
        String executableId = this.getExecutableId();
        cu.setHost(new RequiredCapability[]{MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.iu", (String)executableId, (VersionRange)new VersionRange(this.version, true, this.version, true), null, (boolean)false, (boolean)false)});
        cu.setProperty("org.eclipse.equinox.p2.type.fragment", Boolean.TRUE.toString());
        cu.setCapabilities(new ProvidedCapability[]{PublisherHelper.createSelfCapability(id, this.version)});
        cu.setTouchpointType(PublisherHelper.TOUCHPOINT_NATIVE);
        String[] config = EquinoxExecutableAction.parseConfigSpec(this.configSpec);
        String os = config[1];
        Map touchpointData = this.computeInstallActions(execDescriptor, os);
        cu.addTouchpointData(MetadataFactory.createTouchpointData((Map)touchpointData));
        IInstallableUnit unit = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)cu);
        result.addIU(unit, "root");
    }

    private Map computeInstallActions(ExecutablesDescriptor execDescriptor, String os) {
        HashMap<String, String> touchpointData = new HashMap<String, String>();
        String configurationData = "unzip(source:@artifact, target:${installFolder});";
        if ("macosx".equals(os)) {
            String execName = execDescriptor.getExecutableName();
            configurationData = String.valueOf(configurationData) + " chmod(targetDir:${installFolder}/" + execName + ".app/Contents/MacOS/, targetFile:" + execName + ", permissions:755);";
        } else if (!"win32".equals(os)) {
            File[] fileList = execDescriptor.getFiles();
            int i = 0;
            while (i < fileList.length) {
                configurationData = String.valueOf(configurationData) + " chmod(targetDir:${installFolder}, targetFile:" + fileList[i].getName() + ", permissions:755);";
                ++i;
            }
        }
        touchpointData.put("install", configurationData);
        String unConfigurationData = "cleanupzip(source:@artifact, target:${installFolder});";
        touchpointData.put("uninstall", unConfigurationData);
        return touchpointData;
    }

    protected ExecutablesDescriptor brandExecutables(ExecutablesDescriptor descriptor) {
        ExecutablesDescriptor result = new ExecutablesDescriptor(descriptor);
        result.makeTemporaryCopy();
        File[] list = descriptor.getFiles();
        int i = 0;
        while (i < list.length) {
            this.mungeExecutableFileName(list[i], descriptor);
            ++i;
        }
        result.setExecutableName("eclipse", true);
        return result;
    }

    private void mungeExecutableFileName(File file, ExecutablesDescriptor descriptor) {
        if (file.getName().equals("launcher")) {
            File newFile = new File(file.getParentFile(), "eclipse");
            file.renameTo(newFile);
            descriptor.replace(file, newFile);
        } else if (file.getName().equals("launcher.exe")) {
            File newFile = new File(file.getParentFile(), "eclipse.exe");
            file.renameTo(newFile);
            descriptor.replace(file, newFile);
        }
    }
}

