/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.publisher.eclipse;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.publisher.eclipse.GeneratorBundleInfo;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.actions.IVersionAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.BundlesAction;
import org.osgi.framework.Version;

public class EquinoxLauncherCUAction
extends AbstractPublisherAction {
    public static final String ORG_ECLIPSE_EQUINOX_LAUNCHER = "org.eclipse.equinox.launcher";
    private String flavor;
    private String[] configSpecs;
    static /* synthetic */ Class class$0;

    public EquinoxLauncherCUAction(String flavor, String[] configSpecs) {
        this.flavor = flavor;
        this.configSpecs = configSpecs;
    }

    public IStatus perform(IPublisherInfo info, IPublisherResult results) {
        this.publishCU(ORG_ECLIPSE_EQUINOX_LAUNCHER, null, info, results);
        this.publishLauncherFragmentCUs(info, results);
        return Status.OK_STATUS;
    }

    private void publishLauncherFragmentCUs(IPublisherInfo info, IPublisherResult results) {
        int i = 0;
        while (i < this.configSpecs.length) {
            String configSpec = this.configSpecs[i];
            String id = "org.eclipse.equinox.launcher." + configSpec;
            this.publishCU(id, configSpec, info, results);
            ++i;
        }
    }

    private void publishCU(String id, String configSpec, IPublisherInfo info, IPublisherResult results) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.p2.publisher.actions.IVersionAdvice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Collection advice = info.getAdvice(configSpec, true, id, null, clazz);
        Iterator j = advice.iterator();
        while (j.hasNext()) {
            IVersionAdvice versionSpec = (IVersionAdvice)j.next();
            Version version = versionSpec.getVersion("org.eclipse.equinox.p2.iu", id);
            if (version == null) continue;
            GeneratorBundleInfo bundle = new GeneratorBundleInfo();
            bundle.setSymbolicName(id);
            bundle.setVersion(version.toString());
            if (id.equals(ORG_ECLIPSE_EQUINOX_LAUNCHER)) {
                bundle.setSpecialConfigCommands("addProgramArg(programArg:-startup);addProgramArg(programArg:@artifact);");
                bundle.setSpecialUnconfigCommands("removeProgramArg(programArg:-startup);removeProgramArg(programArg:@artifact);");
            } else {
                bundle.setSpecialConfigCommands("addProgramArg(programArg:--launcher.library);addProgramArg(programArg:@artifact);");
                bundle.setSpecialUnconfigCommands("removeProgramArg(programArg:--launcher.library);removeProgramArg(programArg:@artifact);");
            }
            if (configSpec != null) {
                EquinoxLauncherCUAction.createFilterSpec(configSpec);
            }
            IInstallableUnit cu = BundlesAction.createBundleConfigurationUnit(id, version, false, bundle, this.flavor, null);
            if (cu == null) continue;
            results.addIU(cu, "root");
        }
    }
}

