/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.publisher.eclipse;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.FileUtils;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.internal.p2.publisher.Activator;
import org.eclipse.equinox.internal.p2.publisher.FileSetDescriptor;
import org.eclipse.equinox.internal.p2.publisher.eclipse.FeatureParser;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.ArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.metadata.Copyright;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.License;
import org.eclipse.equinox.internal.provisional.p2.metadata.MetadataFactory;
import org.eclipse.equinox.internal.provisional.p2.metadata.ProvidedCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.RequiredCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.RequirementChange;
import org.eclipse.equinox.internal.provisional.p2.metadata.TouchpointType;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.eclipse.BundleShapeAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.Feature;
import org.eclipse.equinox.p2.publisher.eclipse.FeatureEntry;
import org.eclipse.equinox.p2.publisher.eclipse.IFeatureAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.URLEntry;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

public class FeaturesAction
extends AbstractPublisherAction {
    public static final String INSTALL_FEATURES_FILTER = "(org.eclipse.update.install.features=true)";
    private File[] locations;
    protected Feature[] features;
    static /* synthetic */ Class class$0;

    public static String getTransformedId(String original, boolean isPlugin, boolean isGroup) {
        return isPlugin ? original : String.valueOf(original) + (isGroup ? ".feature.group" : ".feature.jar");
    }

    public static IArtifactKey createFeatureArtifactKey(String id, String version) {
        return new ArtifactKey("org.eclipse.update.feature", id, new Version(version));
    }

    public static Object[] createFeatureRootFileIU(String featureId, String featureVersion, File location, FileSetDescriptor descriptor) {
        MetadataFactory.InstallableUnitDescription iu = new MetadataFactory.InstallableUnitDescription();
        iu.setSingleton(true);
        String id = String.valueOf(featureId) + '_' + descriptor.getKey();
        iu.setId(id);
        Version version = new Version(featureVersion);
        iu.setVersion(version);
        iu.setCapabilities(new ProvidedCapability[]{PublisherHelper.createSelfCapability(id, version)});
        iu.setTouchpointType(PublisherHelper.TOUCHPOINT_NATIVE);
        String configSpec = descriptor.getConfigSpec();
        if (configSpec != null) {
            iu.setFilter(AbstractPublisherAction.createFilterSpec(configSpec));
        }
        File[] fileResult = FeaturesAction.attachFiles(iu, descriptor, location);
        FeaturesAction.setupLinks(iu, descriptor);
        FeaturesAction.setupPermissions(iu, descriptor);
        IInstallableUnit iuResult = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iu);
        return new Object[]{iuResult, fileResult};
    }

    private static File[] attachFiles(MetadataFactory.InstallableUnitDescription iu, FileSetDescriptor descriptor, File location) {
        String fileList = descriptor.getFiles();
        String[] fileSpecs = FeaturesAction.getArrayFromString(fileList, ",");
        File[] files = new File[fileSpecs.length];
        if (fileSpecs.length > 0) {
            int i = 0;
            while (i < fileSpecs.length) {
                String spec = fileSpecs[i];
                if (spec.startsWith("file:")) {
                    spec = spec.substring(5);
                }
                files[i] = new File(location, spec);
                ++i;
            }
        }
        HashMap<String, String> touchpointData = new HashMap<String, String>(2);
        String configurationData = "unzip(source:@artifact, target:${installFolder});";
        touchpointData.put("install", configurationData);
        String unConfigurationData = "cleanupzip(source:@artifact, target:${installFolder});";
        touchpointData.put("uninstall", unConfigurationData);
        iu.addTouchpointData(MetadataFactory.createTouchpointData(touchpointData));
        ArtifactKey key = new ArtifactKey("binary", iu.getId(), iu.getVersion());
        iu.setArtifacts(new IArtifactKey[]{key});
        return files;
    }

    private static void setupPermissions(MetadataFactory.InstallableUnitDescription iu, FileSetDescriptor descriptor) {
        HashMap<String, String> touchpointData = new HashMap<String, String>();
        String[][] permsList = descriptor.getPermissions();
        int i = 0;
        while (i < permsList.length) {
            String[] permSpec = permsList[i];
            String configurationData = " chmod(targetDir:${installFolder}, targetFile:" + permSpec[1] + ", permissions:" + permSpec[0] + ");";
            touchpointData.put("install", configurationData);
            iu.addTouchpointData(MetadataFactory.createTouchpointData(touchpointData));
            ++i;
        }
    }

    private static void setupLinks(MetadataFactory.InstallableUnitDescription iu, FileSetDescriptor descriptor) {
    }

    public FeaturesAction(File[] locations) {
        this.locations = locations;
    }

    public FeaturesAction(Feature[] features) {
        this.features = features;
    }

    public IStatus perform(IPublisherInfo info, IPublisherResult results) {
        if (this.features == null && this.locations == null) {
            throw new IllegalStateException("No features or locations provided");
        }
        if (this.features == null) {
            this.features = this.getFeatures(this.expandLocations(this.locations));
        }
        this.generateFeatureIUs(this.features, results, info);
        return Status.OK_STATUS;
    }

    private File[] expandLocations(File[] list) {
        ArrayList result = new ArrayList();
        this.expandLocations(list, result);
        return result.toArray(new File[result.size()]);
    }

    private void expandLocations(File[] list, ArrayList result) {
        if (list == null) {
            return;
        }
        int i = 0;
        while (i < list.length) {
            File location = list[i];
            if (location.isDirectory()) {
                if (new File(location, "feature.xml").exists()) {
                    result.add(location);
                } else {
                    this.expandLocations(location.listFiles(), result);
                }
            } else {
                result.add(location);
            }
            ++i;
        }
    }

    protected void generateFeatureIUs(Feature[] features, IPublisherResult result, IPublisherInfo info) {
        int i = 0;
        while (i < features.length) {
            Feature feature = features[i];
            ArrayList childIUs = this.generateRootFileIUs(feature, result, info);
            Properties props = this.getFeatureAdvice(feature, info);
            IInstallableUnit featureIU = this.createFeatureJarIU(feature, childIUs, props);
            this.publishFeatureArtifacts(feature, featureIU, info);
            result.addIU(featureIU, "root");
            this.generateSiteReferences(feature, result, info);
            this.gatherBundleShapeAdvice(feature, info);
            IInstallableUnit groupIU = this.createGroupIU(feature, featureIU, props);
            result.addIU(groupIU, "root");
            ++i;
        }
    }

    private void generateSiteReferences(Feature feature, IPublisherResult result, IPublisherInfo info) {
        String updateURL = feature.getUpdateSiteURL();
        if (updateURL != null) {
            this.generateSiteReference(updateURL, feature.getId(), info.getMetadataRepository());
        }
        URLEntry[] discoverySites = feature.getDiscoverySites();
        int j = 0;
        while (j < discoverySites.length) {
            this.generateSiteReference(discoverySites[j].getURL(), feature.getId(), info.getMetadataRepository());
            ++j;
        }
    }

    private void generateSiteReference(String location, String featureId, IMetadataRepository metadataRepo) {
        try {
            URL associateLocation = new URL(location);
            metadataRepo.addReference(associateLocation, 0, 0);
            metadataRepo.addReference(associateLocation, 1, 0);
        }
        catch (MalformedURLException malformedURLException) {
            String message = "Invalid site reference: " + location;
            if (featureId != null) {
                message = String.valueOf(message) + " in feature: " + featureId;
            }
            LogHelper.log((IStatus)new Status(4, Activator.ID, message));
        }
    }

    protected void publishFeatureArtifacts(Feature feature, IInstallableUnit featureIU, IPublisherInfo info) {
        IArtifactKey[] artifacts = featureIU.getArtifacts();
        int j = 0;
        while (j < artifacts.length) {
            File file = new File(feature.getLocation());
            IArtifactDescriptor ad = PublisherHelper.createArtifactDescriptor(artifacts[j], file);
            this.addProperties((ArtifactDescriptor)ad, feature, info);
            ((ArtifactDescriptor)ad).setProperty("download.contentType", "application/zip");
            if (file.isDirectory()) {
                this.publishArtifact(ad, new File[]{file}, null, info, FeaturesAction.createRootPrefixComputer(file));
            } else {
                this.publishArtifact(ad, file, info);
            }
            ++j;
        }
    }

    private void addProperties(ArtifactDescriptor descriptor, Feature feature, IPublisherInfo info) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.p2.publisher.eclipse.IFeatureAdvice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Collection advice = info.getAdvice(null, false, null, null, clazz);
        Iterator i = advice.iterator();
        while (i.hasNext()) {
            IFeatureAdvice entry = (IFeatureAdvice)i.next();
            Properties props = entry.getArtifactProperties(feature);
            if (props == null) continue;
            Iterator<Object> j = props.keySet().iterator();
            while (j.hasNext()) {
                String key = (String)j.next();
                descriptor.setRepositoryProperty(key, props.getProperty(key));
            }
        }
    }

    private Properties getFeatureAdvice(Feature feature, IPublisherInfo info) {
        Properties result = new Properties();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.p2.publisher.eclipse.IFeatureAdvice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Collection advice = info.getAdvice(null, false, null, null, clazz);
        Iterator i = advice.iterator();
        while (i.hasNext()) {
            IFeatureAdvice entry = (IFeatureAdvice)i.next();
            Properties props = entry.getIUProperties(feature);
            if (props == null) continue;
            result.putAll((Map<?, ?>)props);
        }
        return result;
    }

    protected ArrayList generateRootFileIUs(Feature feature, IPublisherResult result, IPublisherInfo info) {
        File location = new File(feature.getLocation());
        Properties props = this.loadProperties(location, "build.properties");
        return this.generateRootFileIUs(feature.getId(), feature.getVersion(), props, location, result, info);
    }

    private ArrayList generateRootFileIUs(String featureId, String featureVersion, Properties props, File location, IPublisherResult result, IPublisherInfo info) {
        ArrayList<IInstallableUnit> ius = new ArrayList<IInstallableUnit>();
        FileSetDescriptor[] rootFileDescriptors = this.getRootFileDescriptors(props);
        int i = 0;
        while (i < rootFileDescriptors.length) {
            IInstallableUnit iu = this.generateRootFileIU(featureId, featureVersion, location, rootFileDescriptors[i], result, info);
            ius.add(iu);
            ++i;
        }
        return ius;
    }

    private Properties loadProperties(File location, String file) {
        Properties props = new Properties();
        File tempFile = null;
        try {
            try {
                if (!location.isDirectory()) {
                    tempFile = File.createTempFile("p2.generator", "");
                    FileUtils.unzipFile((File)location, (File)tempFile);
                    location = tempFile;
                }
                try {
                    InputStream in = null;
                    try {
                        in = new BufferedInputStream(new FileInputStream(new File(location, file)));
                        props.load(in);
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (IOException e) {
                    LogHelper.log((IStatus)new Status(4, Activator.ID, "Error parsing " + file, (Throwable)e));
                }
            }
            catch (IOException e) {
                LogHelper.log((IStatus)new Status(4, Activator.ID, "Error publishing artifacts", (Throwable)e));
                if (tempFile != null) {
                    tempFile.delete();
                }
            }
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
        return props;
    }

    private IInstallableUnit generateRootFileIU(String featureId, String featureVersion, File location, FileSetDescriptor rootFile, IPublisherResult result, IPublisherInfo info) {
        Object[] iuAndFiles = FeaturesAction.createFeatureRootFileIU(featureId, featureVersion, location, rootFile);
        IInstallableUnit iuResult = (IInstallableUnit)iuAndFiles[0];
        File[] fileResult = (File[])iuAndFiles[1];
        if (fileResult != null && fileResult.length > 0) {
            IArtifactKey artifact = iuResult.getArtifacts()[0];
            ArtifactDescriptor descriptor = new ArtifactDescriptor(artifact);
            this.publishArtifact((IArtifactDescriptor)descriptor, fileResult, null, info, FileUtils.createDynamicPathComputer((int)1));
        }
        result.addIU(iuResult, "non_root");
        return iuResult;
    }

    protected FileSetDescriptor[] getRootFileDescriptors(Properties props) {
        HashMap<String, FileSetDescriptor> result = new HashMap<String, FileSetDescriptor>();
        Iterator<Object> i = props.keySet().iterator();
        while (i.hasNext()) {
            FileSetDescriptor descriptor;
            String property = (String)i.next();
            if (!property.startsWith("root.")) continue;
            String[] spec = FeaturesAction.getArrayFromString(property, ".");
            String descriptorKey = spec[0];
            String configSpec = null;
            if (spec.length > 3) {
                configSpec = FeaturesAction.createConfigSpec(spec[2], spec[1], spec[3]);
                descriptorKey = String.valueOf(descriptorKey) + "." + FeaturesAction.createIdString(configSpec);
            }
            if ((descriptor = (FileSetDescriptor)result.get(descriptorKey)) == null) {
                descriptor = new FileSetDescriptor(descriptorKey, configSpec);
                result.put(descriptorKey, descriptor);
            }
            if (spec[spec.length - 1] == "link") {
                descriptor.setLinks(props.getProperty(property));
                continue;
            }
            if (spec[spec.length - 2].equals("permissions")) {
                descriptor.addPermissions(new String[]{spec[spec.length - 1], props.getProperty(property)});
                continue;
            }
            descriptor.setFiles(props.getProperty(property));
        }
        Collection values = result.values();
        return values.toArray(new FileSetDescriptor[values.size()]);
    }

    public void gatherBundleShapeAdvice(Feature feature, IPublisherInfo info) {
        FeatureEntry[] entries = feature.getEntries();
        int i = 0;
        while (i < entries.length) {
            FeatureEntry entry = entries[i];
            if (entry.isUnpack() && entry.isPlugin() && !entry.isRequires()) {
                info.addAdvice(new BundleShapeAdvice(entry.getId(), new Version(entry.getVersion()), "dir"));
            }
            ++i;
        }
    }

    public IInstallableUnit createFeatureJarIU(Feature feature, ArrayList childIUs, Properties extraProperties) {
        MetadataFactory.InstallableUnitDescription iu = new MetadataFactory.InstallableUnitDescription();
        String id = FeaturesAction.getTransformedId(feature.getId(), false, false);
        iu.setId(id);
        Version version = new Version(feature.getVersion());
        iu.setVersion(version);
        if (feature.getLicense() != null) {
            iu.setLicense(new License(feature.getLicenseURL(), feature.getLicense()));
        }
        if (feature.getCopyright() != null) {
            iu.setCopyright(new Copyright(feature.getCopyrightURL(), feature.getCopyright()));
        }
        iu.setTouchpointType(PublisherHelper.TOUCHPOINT_OSGI);
        iu.setFilter(INSTALL_FEATURES_FILTER);
        iu.setSingleton(true);
        if (feature.getInstallHandler() != null && feature.getInstallHandler().trim().length() > 0) {
            String installHandlerProperty = "handler=" + feature.getInstallHandler();
            if (feature.getInstallHandlerLibrary() != null) {
                installHandlerProperty = String.valueOf(installHandlerProperty) + ", library=" + feature.getInstallHandlerLibrary();
            }
            if (feature.getInstallHandlerURL() != null) {
                installHandlerProperty = String.valueOf(installHandlerProperty) + ", url=" + feature.getInstallHandlerURL();
            }
            iu.setProperty("org.eclipse.update.installHandler", installHandlerProperty);
        }
        iu.setCapabilities(new ProvidedCapability[]{PublisherHelper.createSelfCapability(id, version), PublisherHelper.FEATURE_CAPABILITY, MetadataFactory.createProvidedCapability((String)"org.eclipse.update.feature", (String)feature.getId(), (Version)version)});
        iu.setArtifacts(new IArtifactKey[]{FeaturesAction.createFeatureArtifactKey(feature.getId(), version.toString())});
        if (childIUs != null) {
            RequiredCapability[] required = new RequiredCapability[childIUs.size()];
            int i = 0;
            while (i < childIUs.size()) {
                IInstallableUnit child = (IInstallableUnit)childIUs.get(i);
                required[i] = MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.iu", (String)child.getId(), (VersionRange)new VersionRange(child.getVersion(), true, child.getVersion(), true), (String)INSTALL_FEATURES_FILTER, (boolean)false, (boolean)false);
                ++i;
            }
            iu.setRequiredCapabilities(required);
        }
        if (feature.getLocation() == null || !feature.getLocation().endsWith(".jar")) {
            HashMap<String, String> touchpointData = new HashMap<String, String>();
            touchpointData.put("zipped", "true");
            iu.addTouchpointData(MetadataFactory.createTouchpointData(touchpointData));
        }
        this.addExtraProperties(iu, extraProperties);
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iu);
    }

    private void addExtraProperties(MetadataFactory.InstallableUnitDescription iu, Properties extraProperties) {
        if (extraProperties != null) {
            Enumeration<?> e = extraProperties.propertyNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                iu.setProperty(name, extraProperties.getProperty(name));
            }
        }
    }

    public IInstallableUnit createGroupIU(Feature feature, IInstallableUnit featureIU, Properties extraProperties) {
        if (FeaturesAction.isPatch(feature)) {
            return this.createPatchIU(feature, featureIU, extraProperties);
        }
        MetadataFactory.InstallableUnitDescription iu = new MetadataFactory.InstallableUnitDescription();
        String id = FeaturesAction.getTransformedId(feature.getId(), false, true);
        iu.setId(id);
        Version version = new Version(feature.getVersion());
        iu.setVersion(version);
        iu.setProperty("org.eclipse.equinox.p2.name", feature.getLabel());
        if (feature.getDescription() != null) {
            iu.setProperty("org.eclipse.equinox.p2.description", feature.getDescription());
        }
        if (feature.getDescriptionURL() != null) {
            iu.setProperty("org.eclipse.equinox.p2.description.url", feature.getDescriptionURL());
        }
        if (feature.getProviderName() != null) {
            iu.setProperty("org.eclipse.equinox.p2.provider", feature.getProviderName());
        }
        if (feature.getLicense() != null) {
            iu.setLicense(new License(feature.getLicenseURL(), feature.getLicense()));
        }
        if (feature.getCopyright() != null) {
            iu.setCopyright(new Copyright(feature.getCopyrightURL(), feature.getCopyright()));
        }
        iu.setUpdateDescriptor(MetadataFactory.createUpdateDescriptor((String)id, (VersionRange)new VersionRange(new Version(0, 0, 0), true, new Version(feature.getVersion()), false), (int)0, null));
        FeatureEntry[] entries = feature.getEntries();
        RequiredCapability[] required = new RequiredCapability[entries.length + (featureIU == null ? 0 : 1)];
        int i = 0;
        while (i < entries.length) {
            VersionRange range = this.getVersionRange(entries[i]);
            String requiredId = FeaturesAction.getTransformedId(entries[i].getId(), entries[i].isPlugin(), true);
            required[i] = MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.iu", (String)requiredId, (VersionRange)range, (String)this.getFilter(entries[i]), (boolean)entries[i].isOptional(), (boolean)false);
            ++i;
        }
        if (featureIU != null) {
            required[entries.length] = MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.iu", (String)featureIU.getId(), (VersionRange)new VersionRange(featureIU.getVersion(), true, featureIU.getVersion(), true), (String)INSTALL_FEATURES_FILTER, (boolean)false, (boolean)false);
        }
        iu.setRequiredCapabilities(required);
        iu.setTouchpointType(TouchpointType.NONE);
        iu.setProperty("org.eclipse.equinox.p2.type.group", Boolean.TRUE.toString());
        ArrayList<ProvidedCapability> providedCapabilities = new ArrayList<ProvidedCapability>();
        providedCapabilities.add(FeaturesAction.createSelfCapability(id, version));
        Map localizations = feature.getLocalizations();
        if (localizations != null) {
            Iterator iter = localizations.keySet().iterator();
            while (iter.hasNext()) {
                Locale locale = (Locale)iter.next();
                Properties translatedStrings = (Properties)localizations.get(locale);
                Enumeration<?> propertyKeys = translatedStrings.propertyNames();
                while (propertyKeys.hasMoreElements()) {
                    String nextKey = (String)propertyKeys.nextElement();
                    iu.setProperty(String.valueOf(locale.toString()) + '.' + nextKey, translatedStrings.getProperty(nextKey));
                }
                providedCapabilities.add(PublisherHelper.makeTranslationCapability(id, locale));
            }
        }
        iu.setCapabilities(providedCapabilities.toArray(new ProvidedCapability[providedCapabilities.size()]));
        this.addExtraProperties(iu, extraProperties);
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iu);
    }

    private static boolean isPatch(Feature feature) {
        FeatureEntry[] entries = feature.getEntries();
        int i = 0;
        while (i < entries.length) {
            if (entries[i].isPatch()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public IInstallableUnit createPatchIU(Feature feature, IInstallableUnit featureIU, Properties extraProperties) {
        MetadataFactory.InstallableUnitPatchDescription iu = new MetadataFactory.InstallableUnitPatchDescription();
        String id = FeaturesAction.getTransformedId(feature.getId(), false, true);
        iu.setId(id);
        Version version = new Version(feature.getVersion());
        iu.setVersion(version);
        iu.setProperty("org.eclipse.equinox.p2.name", feature.getLabel());
        if (feature.getDescription() != null) {
            iu.setProperty("org.eclipse.equinox.p2.description", feature.getDescription());
        }
        if (feature.getDescriptionURL() != null) {
            iu.setProperty("org.eclipse.equinox.p2.description.url", feature.getDescriptionURL());
        }
        if (feature.getProviderName() != null) {
            iu.setProperty("org.eclipse.equinox.p2.provider", feature.getProviderName());
        }
        if (feature.getLicense() != null) {
            iu.setLicense(new License(feature.getLicenseURL(), feature.getLicense()));
        }
        if (feature.getCopyright() != null) {
            iu.setCopyright(new Copyright(feature.getCopyrightURL(), feature.getCopyright()));
        }
        iu.setUpdateDescriptor(MetadataFactory.createUpdateDescriptor((String)id, (VersionRange)new VersionRange(new Version(0, 0, 0), true, new Version(feature.getVersion()), false), (int)0, null));
        FeatureEntry[] entries = feature.getEntries();
        ArrayList<RequiredCapability> applicabilityScope = new ArrayList<RequiredCapability>();
        ArrayList<RequiredCapability> patchRequirements = new ArrayList<RequiredCapability>();
        ArrayList<RequirementChange> requirementChanges = new ArrayList<RequirementChange>();
        int i = 0;
        while (i < entries.length) {
            VersionRange range = this.getVersionRange(entries[i]);
            RequiredCapability req = MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.iu", (String)FeaturesAction.getTransformedId(entries[i].getId(), entries[i].isPlugin(), true), (VersionRange)range, (String)this.getFilter(entries[i]), (boolean)entries[i].isOptional(), (boolean)false);
            if (entries[i].isRequires()) {
                applicabilityScope.add(req);
            } else if (entries[i].isPlugin()) {
                RequiredCapability from = MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.iu", (String)FeaturesAction.getTransformedId(entries[i].getId(), entries[i].isPlugin(), true), (VersionRange)VersionRange.emptyRange, (String)this.getFilter(entries[i]), (boolean)entries[i].isOptional(), (boolean)false);
                requirementChanges.add(new RequirementChange(from, req));
            } else {
                patchRequirements.add(req);
            }
            ++i;
        }
        patchRequirements.add(MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.iu", (String)featureIU.getId(), (VersionRange)new VersionRange(featureIU.getVersion(), true, featureIU.getVersion(), true), (String)INSTALL_FEATURES_FILTER, (boolean)false, (boolean)false));
        iu.setRequiredCapabilities(patchRequirements.toArray(new RequiredCapability[patchRequirements.size()]));
        iu.setApplicabilityScope((RequiredCapability[][])new RequiredCapability[][]{applicabilityScope.toArray(new RequiredCapability[applicabilityScope.size()])});
        iu.setRequirementChanges(requirementChanges.toArray(new RequirementChange[requirementChanges.size()]));
        RequiredCapability lifeCycle = null;
        if (applicabilityScope.size() > 0) {
            RequiredCapability req = (RequiredCapability)applicabilityScope.get(0);
            lifeCycle = MetadataFactory.createRequiredCapability((String)req.getNamespace(), (String)req.getName(), (VersionRange)req.getRange(), null, (boolean)false, (boolean)false, (boolean)false);
            iu.setLifeCycle(lifeCycle);
        }
        iu.setTouchpointType(TouchpointType.NONE);
        iu.setProperty("org.eclipse.equinox.p2.type.group", Boolean.TRUE.toString());
        iu.setProperty("org.eclipse.equinox.p2.type.patch", Boolean.TRUE.toString());
        ArrayList<ProvidedCapability> providedCapabilities = new ArrayList<ProvidedCapability>();
        providedCapabilities.add(FeaturesAction.createSelfCapability(id, version));
        Map localizations = feature.getLocalizations();
        if (localizations != null) {
            Iterator iter = localizations.keySet().iterator();
            while (iter.hasNext()) {
                Locale locale = (Locale)iter.next();
                Properties translatedStrings = (Properties)localizations.get(locale);
                Enumeration<?> propertyKeys = translatedStrings.propertyNames();
                while (propertyKeys.hasMoreElements()) {
                    String nextKey = (String)propertyKeys.nextElement();
                    iu.setProperty(String.valueOf(locale.toString()) + '.' + nextKey, translatedStrings.getProperty(nextKey));
                }
                providedCapabilities.add(PublisherHelper.makeTranslationCapability(id, locale));
            }
        }
        iu.setCapabilities(providedCapabilities.toArray(new ProvidedCapability[providedCapabilities.size()]));
        this.addExtraProperties((MetadataFactory.InstallableUnitDescription)iu, extraProperties);
        return MetadataFactory.createInstallableUnitPatch((MetadataFactory.InstallableUnitPatchDescription)iu);
    }

    public VersionRange getVersionRange(FeatureEntry entry) {
        String versionSpec = entry.getVersion();
        if (versionSpec == null) {
            return VersionRange.emptyRange;
        }
        Version version = new Version(versionSpec);
        if (version.equals((Object)Version.emptyVersion)) {
            return VersionRange.emptyRange;
        }
        if (!entry.isRequires()) {
            return new VersionRange(version, true, version, true);
        }
        String match = entry.getMatch();
        if (match == null) {
            return null;
        }
        if (match.equals("perfect")) {
            return new VersionRange(version, true, version, true);
        }
        if (match.equals("equivalent")) {
            Version upper = new Version(version.getMajor(), version.getMinor() + 1, 0);
            return new VersionRange(version, true, upper, false);
        }
        if (match.equals("compatible")) {
            Version upper = new Version(version.getMajor() + 1, 0, 0);
            return new VersionRange(version, true, upper, false);
        }
        if (match.equals("greaterOrEqual")) {
            return new VersionRange(version, true, new VersionRange(null).getMaximum(), true);
        }
        return null;
    }

    public String getFilter(FeatureEntry entry) {
        StringBuffer result = new StringBuffer();
        result.append("(&");
        if (entry.getFilter() != null) {
            result.append(entry.getFilter());
        }
        if (entry.getOS() != null) {
            result.append("(osgi.os=" + entry.getOS() + ')');
        }
        if (entry.getWS() != null) {
            result.append("(osgi.ws=" + entry.getWS() + ')');
        }
        if (entry.getArch() != null) {
            result.append("(osgi.arch=" + entry.getArch() + ')');
        }
        if (entry.getNL() != null) {
            result.append("(osgi.nl=" + entry.getNL() + ')');
        }
        if (result.length() == 2) {
            return null;
        }
        result.append(')');
        return result.toString();
    }

    protected Feature[] getFeatures(File[] locations) {
        ArrayList<Feature> result = new ArrayList<Feature>(locations.length);
        int i = 0;
        while (i < locations.length) {
            Feature feature = new FeatureParser().parse(locations[i]);
            if (feature != null) {
                feature.setLocation(locations[i].getAbsolutePath());
                result.add(feature);
            }
            ++i;
        }
        return result.toArray(new Feature[result.size()]);
    }
}

