/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.publisher.eclipse;

import java.util.ArrayList;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.AbstractPublisherApplication;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.eclipse.EclipseInstallAction;
import org.osgi.framework.Version;

public class InstallPublisherApplication
extends AbstractPublisherApplication {
    protected String id;
    protected Version version = new Version("1.0.0");
    protected String name;
    protected String executableName;
    protected String flavor;
    protected String[] topLevel;
    protected boolean start;
    protected String[] rootExclusions;

    protected void processFlag(String arg, PublisherInfo info) {
        super.processFlag(arg, info);
        if (arg.equalsIgnoreCase("-startAll")) {
            this.start = true;
        }
    }

    protected void processParameter(String arg, String parameter, PublisherInfo info) {
        super.processParameter(arg, parameter, info);
        if (arg.equalsIgnoreCase("-id")) {
            this.id = parameter;
        }
        if (arg.equalsIgnoreCase("-version")) {
            this.version = new Version(parameter);
        }
        if (arg.equalsIgnoreCase("-name")) {
            this.name = parameter;
        }
        if (arg.equalsIgnoreCase("-executable")) {
            this.executableName = parameter;
        }
        if (arg.equalsIgnoreCase("-flavor")) {
            this.flavor = parameter;
        }
        if (arg.equalsIgnoreCase("-top")) {
            this.topLevel = AbstractPublisherAction.getArrayFromString(parameter, ",");
        }
        if (arg.equalsIgnoreCase("-rootExclusions")) {
            this.rootExclusions = AbstractPublisherAction.getArrayFromString(parameter, ",");
        }
    }

    protected IPublisherAction[] createActions() {
        ArrayList<IPublisherAction> result = new ArrayList<IPublisherAction>();
        result.add(this.createEclipseInstallAction());
        return result.toArray(new IPublisherAction[result.size()]);
    }

    private IPublisherAction createEclipseInstallAction() {
        String[] exclusions = this.getBaseExclusions();
        if (this.rootExclusions != null) {
            String[] result = new String[exclusions.length + this.rootExclusions.length];
            System.arraycopy(exclusions, 0, result, 0, exclusions.length);
            System.arraycopy(this.rootExclusions, 0, result, exclusions.length, this.rootExclusions.length);
            exclusions = result;
        }
        return new EclipseInstallAction(this.source, this.id, this.version, this.name, this.executableName, this.flavor, this.topLevel, exclusions, this.start);
    }

    protected String[] getBaseExclusions() {
        return new String[]{"plugins", "features", "configuration", "p2", "artifacts.xml"};
    }
}

