/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.publisher.eclipse;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.equinox.internal.p2.publisher.eclipse.ProductFile;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.actions.MergeResultsAction;
import org.eclipse.equinox.p2.publisher.actions.RootIUAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.EclipseInstallAction;
import org.eclipse.equinox.p2.publisher.eclipse.ProductFileAdvice;
import org.osgi.framework.Version;

public class ProductAction
extends EclipseInstallAction {
    private String productLocation;
    private File executablesFeatureLocation;

    public ProductAction(String source, String productLocation, String flavor, File executablesFeatureLocation) {
        this.source = source;
        this.flavor = flavor;
        this.executablesFeatureLocation = executablesFeatureLocation;
        this.productLocation = productLocation;
    }

    protected IPublisherAction[] createActions() {
        this.createAdvice();
        ArrayList<IPublisherAction> actions = new ArrayList<IPublisherAction>();
        if (this.source != null) {
            actions.add(new MergeResultsAction(new IPublisherAction[]{this.createFeaturesAction(), this.createBundlesAction()}, 2));
        }
        actions.add(this.createApplicationExecutableAction(this.info.getConfigurations()));
        actions.add(this.createJREAction());
        actions.add(this.createConfigCUsAction());
        actions.add(this.createDefaultCUsAction());
        actions.add(this.createRootIUAction());
        return actions.toArray(new IPublisherAction[actions.size()]);
    }

    private ProductFile loadProduct() {
        ProductFile product = null;
        try {
            product = new ProductFile(this.productLocation);
        }
        catch (Exception exception) {}
        if (product == null) {
            throw new IllegalArgumentException("unable to load product file");
        }
        return product;
    }

    private void createAdvice() {
        ProductFile product = this.loadProduct();
        this.executableName = product.getLauncherName();
        this.createProductAdvice(product);
        this.createRootAdvice(product);
    }

    protected void createRootAdvice(ProductFile product) {
        Collection list = product.useFeatures() ? this.listElements(product.getFeatures(), ".feature.group") : this.listElements(product.getBundles(true), "");
        this.info.addAdvice(new RootIUAdvice(list));
    }

    private void createProductAdvice(ProductFile product) {
        this.id = product.getId();
        this.version = new Version(product.getVersion());
        this.name = product.getId();
        String[] configSpecs = this.info.getConfigurations();
        int i = 0;
        while (i < configSpecs.length) {
            this.info.addAdvice(new ProductFileAdvice(product, configSpecs[i]));
            ++i;
        }
    }

    private Collection listElements(List elements, String suffix) {
        ArrayList<String> result = new ArrayList<String>(elements.size());
        Iterator i = elements.iterator();
        while (i.hasNext()) {
            result.add(String.valueOf((String)i.next()) + suffix);
        }
        return result;
    }

    protected File getExecutablesLocation() {
        return this.executablesFeatureLocation == null ? super.getExecutablesLocation() : this.executablesFeatureLocation;
    }
}

