/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.publisher.eclipse;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.equinox.internal.p2.publisher.eclipse.DataLoader;
import org.eclipse.equinox.internal.p2.publisher.eclipse.ProductFile;
import org.eclipse.equinox.internal.provisional.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.provisional.frameworkadmin.ConfigData;
import org.eclipse.equinox.p2.publisher.AbstractAdvice;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.eclipse.IConfigAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.ILaunchingAdvice;

public class ProductFileAdvice
extends AbstractAdvice
implements ILaunchingAdvice,
IConfigAdvice {
    private ProductFile product;
    private String configSpec;
    private String os;
    private ConfigData configData = null;

    public ProductFileAdvice(ProductFile product, String configSpec) {
        this.product = product;
        this.configSpec = configSpec;
        this.os = AbstractPublisherAction.parseConfigSpec(configSpec)[1];
        this.configData = this.getConfigData();
    }

    private ConfigData getConfigData() {
        DataLoader loader = this.createDataLoader();
        ConfigData result = loader != null ? loader.getConfigData() : this.generateConfigData();
        result.setFwIndependentProp("eclipse.product", this.product.getId());
        String location = this.getSplashLocation();
        if (location != null) {
            result.setFwIndependentProp("osgi.splashPath", location);
        }
        return result;
    }

    private ConfigData generateConfigData() {
        ConfigData result = new ConfigData(null, null, null, null);
        if (this.product.useFeatures()) {
            return result;
        }
        List bundles = this.product.getBundles(true);
        Iterator i = bundles.iterator();
        while (i.hasNext()) {
            String id = (String)i.next();
            BundleInfo bundleInfo = new BundleInfo();
            bundleInfo.setSymbolicName(id);
            result.addBundle(bundleInfo);
        }
        return result;
    }

    private String getSplashLocation() {
        return null;
    }

    protected String getConfigSpec() {
        return this.configSpec;
    }

    public String[] getProgramArguments() {
        String line = this.product.getProgramArguments(this.os);
        return AbstractPublisherAction.getArrayFromString(line, " ");
    }

    public String[] getVMArguments() {
        String line = this.product.getVMArguments(this.os);
        return AbstractPublisherAction.getArrayFromString(line, " ");
    }

    protected boolean matchConfig(String spec, boolean includeDefault) {
        String targetOS = AbstractPublisherAction.parseConfigSpec(spec)[1];
        return this.os.equals(targetOS);
    }

    public BundleInfo[] getBundles() {
        return this.configData.getBundles();
    }

    public Properties getProperties() {
        Properties result = new Properties();
        result.putAll((Map<?, ?>)this.configData.getFwDependentProps());
        result.putAll((Map<?, ?>)this.configData.getFwIndependentProps());
        return result;
    }

    private DataLoader createDataLoader() {
        String location = this.product.getConfigIniPath(this.os);
        if (location == null) {
            location = this.product.getConfigIniPath(null);
        }
        if (location == null) {
            return null;
        }
        File configFile = new File(location);
        if (!configFile.isAbsolute()) {
            configFile = new File(this.product.getLocation().getParentFile(), location);
        }
        return new DataLoader(configFile, new File(this.product.getLauncherName()).getAbsoluteFile());
    }

    public String getExecutableName() {
        return this.product.getLauncherName();
    }
}

