/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.core.ast.IAbstractFunctionDeclaration;
import org.eclipse.wst.jsdt.core.ast.IArgument;
import org.eclipse.wst.jsdt.core.ast.IJsDoc;
import org.eclipse.wst.jsdt.core.ast.IProgramElement;
import org.eclipse.wst.jsdt.core.compiler.CategorizedProblem;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.infer.InferredMethod;
import org.eclipse.wst.jsdt.core.infer.InferredType;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.CompilationResult;
import org.eclipse.wst.jsdt.internal.compiler.ast.Annotation;
import org.eclipse.wst.jsdt.internal.compiler.ast.Argument;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Javadoc;
import org.eclipse.wst.jsdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.Statement;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeParameter;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeReference;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.wst.jsdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CompilationUnitBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.parser.Parser;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortMethod;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortType;
import org.eclipse.wst.jsdt.internal.compiler.problem.ProblemSeverities;

public abstract class AbstractMethodDeclaration
extends Statement
implements IAbstractFunctionDeclaration,
ProblemSeverities,
ReferenceContext {
    public MethodScope scope;
    public char[] selector;
    public int declarationSourceStart;
    public int declarationSourceEnd;
    public int modifiers;
    public int modifiersSourceStart;
    public Annotation[] annotations;
    public Argument[] arguments;
    public TypeReference[] thrownExceptions;
    public Statement[] statements;
    public int explicitDeclarations;
    public MethodBinding binding;
    public boolean ignoreFurtherInvestigation = false;
    public boolean needFreeReturn = false;
    public Javadoc javadoc;
    public int bodyStart;
    public int bodyEnd = -1;
    public CompilationResult compilationResult;
    public InferredType inferredType;
    public InferredMethod inferredMethod;
    public boolean errorInSignature = false;
    public int exprStackPtr;

    AbstractMethodDeclaration(CompilationResult compilationResult) {
        this.compilationResult = compilationResult;
    }

    public void setArguments(IArgument[] args) {
        if (args instanceof Argument[]) {
            this.arguments = (Argument[])args;
        }
    }

    public IArgument[] getArguments() {
        return this.arguments;
    }

    public void abort(int abortLevel, CategorizedProblem problem) {
        switch (abortLevel) {
            case 2: {
                throw new AbortCompilation(this.compilationResult, problem);
            }
            case 4: {
                throw new AbortCompilationUnit(this.compilationResult, problem);
            }
            case 8: {
                throw new AbortType(this.compilationResult, problem);
            }
        }
        throw new AbortMethod(this.compilationResult, problem);
    }

    public FlowInfo analyseCode(BlockScope classScope, FlowContext initializationContext, FlowInfo info) {
        return this.analyseCode((Scope)classScope, initializationContext, info);
    }

    public abstract FlowInfo analyseCode(Scope var1, FlowContext var2, FlowInfo var3);

    public void bindArguments() {
        if (this.arguments != null) {
            ReferenceBinding declaringClass;
            if (this.binding == null) {
                int i = 0;
                int length = this.arguments.length;
                while (i < length) {
                    this.arguments[i].bind(this.scope, null, true);
                    ++i;
                }
                return;
            }
            if (this.arguments.length > 0 && this.binding.parameters.length == 0 && (declaringClass = this.binding.declaringClass) instanceof CompilationUnitBinding) {
                CompilationUnitBinding compilationUnitBinding = (CompilationUnitBinding)declaringClass;
                compilationUnitBinding.resolveTypesFor(this.binding, this);
            }
            boolean used = this.binding.isAbstract() || this.binding.isNative();
            AnnotationBinding[][] paramAnnotations = null;
            int i = 0;
            int length = this.arguments.length;
            while (i < length) {
                Argument argument = this.arguments[i];
                argument.bind(this.scope, this.binding.parameters[i], used);
                ++i;
            }
            if (paramAnnotations != null) {
                this.binding.setParameterAnnotations(paramAnnotations);
            }
        }
    }

    public void bindThrownExceptions() {
        block9: {
            if (this.thrownExceptions == null || this.binding == null || this.binding.thrownExceptions == null) break block9;
            int length = this.binding.thrownExceptions.length;
            int thrownExceptionLength = this.thrownExceptions.length;
            if (length == thrownExceptionLength) {
                int i = 0;
                while (i < length) {
                    this.thrownExceptions[i].resolvedType = this.binding.thrownExceptions[i];
                    ++i;
                }
            } else {
                int bindingIndex = 0;
                int i = 0;
                while (i < thrownExceptionLength && bindingIndex < length) {
                    TypeReference thrownException = this.thrownExceptions[i];
                    ReferenceBinding thrownExceptionBinding = this.binding.thrownExceptions[bindingIndex];
                    char[][] bindingCompoundName = thrownExceptionBinding.compoundName;
                    if (bindingCompoundName != null) {
                        if (thrownException instanceof SingleTypeReference) {
                            int lengthName = bindingCompoundName.length;
                            char[] thrownExceptionTypeName = thrownException.getTypeName()[0];
                            if (CharOperation.equals(thrownExceptionTypeName, bindingCompoundName[lengthName - 1])) {
                                thrownException.resolvedType = thrownExceptionBinding;
                                ++bindingIndex;
                            }
                        } else if (CharOperation.equals(thrownException.getTypeName(), bindingCompoundName)) {
                            thrownException.resolvedType = thrownExceptionBinding;
                            ++bindingIndex;
                        }
                    }
                    ++i;
                }
            }
        }
    }

    public CompilationResult compilationResult() {
        return this.compilationResult;
    }

    public boolean hasErrors() {
        return this.ignoreFurtherInvestigation;
    }

    public boolean isAbstract() {
        if (this.binding != null) {
            return this.binding.isAbstract();
        }
        return (this.modifiers & 0x400) != 0;
    }

    public boolean isAnnotationMethod() {
        return false;
    }

    public boolean isClinit() {
        return false;
    }

    public boolean isConstructor() {
        return false;
    }

    public boolean isDefaultConstructor() {
        return false;
    }

    public boolean isInitializationMethod() {
        return false;
    }

    public boolean isMethod() {
        return false;
    }

    public boolean isNative() {
        if (this.binding != null) {
            return this.binding.isNative();
        }
        return (this.modifiers & 0x100) != 0;
    }

    public boolean isStatic() {
        if (this.binding != null) {
            return this.binding.isStatic();
        }
        return (this.modifiers & 8) != 0;
    }

    public abstract void parseStatements(Parser var1, CompilationUnitDeclaration var2);

    public StringBuffer printStatement(int indent, StringBuffer output) {
        return this.print(indent, output);
    }

    public StringBuffer print(int tab, StringBuffer output) {
        if (this.javadoc != null) {
            this.javadoc.print(tab, output);
        }
        AbstractMethodDeclaration.printIndent(tab, output);
        AbstractMethodDeclaration.printModifiers(this.modifiers, output);
        output.append("function ");
        if (this.selector != null) {
            output.append(this.selector);
        }
        output.append('(');
        if (this.arguments != null) {
            int i = 0;
            while (i < this.arguments.length) {
                if (i > 0) {
                    output.append(", ");
                }
                this.arguments[i].print(0, output);
                ++i;
            }
        }
        output.append(')');
        this.printBody(tab + 1, output);
        return output;
    }

    public StringBuffer printBody(int indent, StringBuffer output) {
        if (this.isAbstract() || (this.modifiers & 0x1000000) != 0) {
            return output.append(';');
        }
        output.append(" {");
        if (this.statements != null) {
            int i = 0;
            while (i < this.statements.length) {
                output.append('\n');
                this.statements[i].printStatement(indent, output);
                ++i;
            }
        }
        output.append('\n');
        AbstractMethodDeclaration.printIndent(indent == 0 ? 0 : indent - 1, output).append('}');
        return output;
    }

    public StringBuffer printReturnType(int indent, StringBuffer output) {
        return output;
    }

    public void resolve(Scope upperScope) {
        if (this.scope == null) {
            CompilationUnitBinding compilationUnitBinding;
            MethodBinding methodBinding;
            this.scope = new MethodScope(upperScope, this, false);
            if (this.selector != null && (methodBinding = this.scope.createMethod(this, this.selector, compilationUnitBinding = upperScope.enclosingCompilationUnit(), false, true)) != null) {
                this.binding = methodBinding;
                if ((methodBinding = compilationUnitBinding.resolveTypesFor(methodBinding, this)) != null) {
                    MethodScope enclosingMethodScope = upperScope.enclosingMethodScope();
                    if (enclosingMethodScope != null) {
                        enclosingMethodScope.addLocalMethod(methodBinding);
                    } else {
                        compilationUnitBinding.addMethod(methodBinding);
                        upperScope.environment().defaultPackage.addBinding(methodBinding, methodBinding.selector, 8);
                    }
                }
            }
        }
        if (this.binding == null) {
            this.ignoreFurtherInvestigation = true;
        }
        try {
            this.bindArguments();
            this.resolveJavadoc();
            this.resolveStatements();
            if (this.binding != null && (this.binding.getAnnotationTagBits() & 0x400000000000L) == 0L && (this.binding.modifiers & 0x100000) != 0 && this.scope.compilerOptions().sourceLevel >= 0x310000L) {
                this.scope.problemReporter().missingDeprecatedAnnotationForMethod(this);
            }
        }
        catch (AbortMethod abortMethod) {
            this.ignoreFurtherInvestigation = true;
        }
    }

    public void resolveJavadoc() {
        if (this.binding == null) {
            return;
        }
        if (this.javadoc != null) {
            this.javadoc.resolve(this.scope);
            return;
        }
        if (this.binding.declaringClass != null && !this.binding.declaringClass.isLocalType()) {
            this.scope.problemReporter().javadocMissing(this.sourceStart, this.sourceEnd, this.binding.modifiers);
        }
    }

    public void resolveStatements() {
        if (this.statements != null) {
            int i = 0;
            int length = this.statements.length;
            while (i < length) {
                this.statements[i].resolve(this.scope);
                ++i;
            }
        } else if ((this.bits & 8) != 0) {
            this.scope.problemReporter().undocumentedEmptyBlock(this.bodyStart - 1, this.bodyEnd + 1);
        }
    }

    public void tagAsHavingErrors() {
        this.ignoreFurtherInvestigation = true;
    }

    public void traverse(ASTVisitor visitor, Scope classScope) {
    }

    public TypeParameter[] typeParameters() {
        return null;
    }

    public void resolve(BlockScope scope) {
        this.resolve((Scope)scope);
    }

    public boolean isInferred() {
        return this.inferredMethod != null;
    }

    public int getASTType() {
        return 1;
    }

    public IJsDoc getJsDoc() {
        return this.javadoc;
    }

    public IProgramElement[] getStatements() {
        return this.statements;
    }

    public char[] getName() {
        return this.selector;
    }

    public void setInferredType(InferredType type) {
        this.inferredType = type;
    }

    public InferredMethod getInferredMethod() {
        return this.inferredMethod;
    }

    public InferredType getInferredType() {
        return this.inferredType;
    }

    public char[] getSafeName() {
        if (this.selector != null) {
            return this.selector;
        }
        if (this.inferredMethod != null && this.inferredMethod.name != null) {
            return this.inferredMethod.name;
        }
        return new char[0];
    }
}

