/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.lookup;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.wst.jsdt.core.UnimplementedException;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.infer.InferredAttribute;
import org.eclipse.wst.jsdt.core.infer.InferredMethod;
import org.eclipse.wst.jsdt.core.infer.InferredType;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Argument;
import org.eclipse.wst.jsdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeReference;
import org.eclipse.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.wst.jsdt.internal.compiler.lookup.AnnotationHolder;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ClassScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodVerifier;
import org.eclipse.wst.jsdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SyntheticFieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.WildcardBinding;
import org.eclipse.wst.jsdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.wst.jsdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class SourceTypeBinding
extends ReferenceBinding {
    public ReferenceBinding superclass;
    public ReferenceBinding[] superInterfaces = Binding.NO_SUPERINTERFACES;
    protected FieldBinding[] fields;
    protected MethodBinding[] methods;
    public ReferenceBinding[] memberTypes = Binding.NO_MEMBER_TYPES;
    public TypeVariableBinding[] typeVariables = Binding.NO_TYPE_VARIABLES;
    public Scope scope;
    public ClassScope classScope;
    public static final int METHOD_EMUL = 0;
    public static final int FIELD_EMUL = 1;
    public static final int CLASS_LITERAL_EMUL = 2;
    public static final int RECEIVER_TYPE_EMUL = 3;
    HashMap[] synthetics;
    char[] genericReferenceTypeSignature;
    public SourceTypeBinding nextType;
    private SimpleLookupTable storedAnnotations = null;

    public SourceTypeBinding(char[][] compoundName, PackageBinding fPackage, Scope scope) {
        this.compoundName = compoundName;
        this.fPackage = fPackage;
        this.fileName = scope.referenceCompilationUnit().getFileName();
        if (scope instanceof ClassScope) {
            this.classScope = (ClassScope)scope;
            if (this.classScope.referenceContext != null) {
                this.modifiers = this.classScope.referenceContext.modifiers;
                this.sourceName = this.classScope.referenceContext.name;
            } else {
                this.sourceName = this.classScope.inferredType.getName();
                this.modifiers = 1;
            }
        }
        this.scope = scope;
        this.fields = Binding.NO_FIELDS;
        this.methods = Binding.NO_METHODS;
        this.computeId();
    }

    protected SourceTypeBinding() {
    }

    void buildFieldsAndMethods() {
        this.buildFields();
        this.buildMethods();
    }

    public InferredType getInferredType() {
        if (this.nextType != null) {
            throw new UnimplementedException("should not get here");
        }
        ClassScope classScope = this.scope.classScope();
        return classScope.inferredType;
    }

    private void buildFields() {
        FieldBinding prototype = new FieldBinding(TypeConstants.PROTOTYPE, TypeBinding.UNKNOWN, this.modifiers | 0x2000000, this, null);
        InferredType inferredType = this.classScope.inferredType;
        int size = inferredType.numberAttributes;
        if (size == 0) {
            this.setFields(new FieldBinding[]{prototype});
            return;
        }
        FieldBinding[] fieldBindings = new FieldBinding[size + 1];
        HashtableOfObject knownFieldNames = new HashtableOfObject(size);
        boolean duplicate = false;
        int count = 0;
        int i = 0;
        while (i < size) {
            InferredAttribute field = inferredType.attributes[i];
            int modifiers = 0;
            if (field.isStatic) {
                modifiers |= 8;
            }
            InferredType fieldType = field.type;
            TypeBinding fieldTypeBinding = null;
            if (fieldType != null) {
                fieldTypeBinding = fieldType.resolveType(this.scope, field.node);
            }
            if (fieldTypeBinding == null) {
                fieldTypeBinding = TypeBinding.UNKNOWN;
            }
            FieldBinding fieldBinding = new FieldBinding(field, fieldTypeBinding, modifiers | 0x2000000, this);
            fieldBinding.id = count;
            if (knownFieldNames.containsKey(field.name)) {
                duplicate = true;
                FieldBinding previousBinding = (FieldBinding)knownFieldNames.get(field.name);
                if (previousBinding != null) {
                    int f = 0;
                    while (f < i) {
                        InferredAttribute previousField = inferredType.attributes[f];
                        if (previousField.binding == previousBinding) {
                            this.scope.problemReporter().duplicateFieldInType(this, previousField);
                            previousField.binding = null;
                            break;
                        }
                        ++f;
                    }
                }
                knownFieldNames.put(field.name, null);
                this.scope.problemReporter().duplicateFieldInType(this, field);
                field.binding = null;
            } else {
                knownFieldNames.put(field.name, fieldBinding);
                if (fieldBinding != null) {
                    fieldBindings[count++] = fieldBinding;
                }
            }
            ++i;
        }
        fieldBindings[count++] = prototype;
        if (duplicate) {
            FieldBinding[] newFieldBindings = new FieldBinding[fieldBindings.length];
            size = count;
            count = 0;
            int i2 = 0;
            while (i2 < size) {
                FieldBinding fieldBinding = fieldBindings[i2];
                if (knownFieldNames.get(fieldBinding.name) != null) {
                    fieldBinding.id = count;
                    newFieldBindings[count++] = fieldBinding;
                }
                ++i2;
            }
            fieldBindings = newFieldBindings;
        }
        if (count != fieldBindings.length) {
            FieldBinding[] fieldBindingArray = fieldBindings;
            fieldBindings = new FieldBinding[count];
            System.arraycopy(fieldBindingArray, 0, fieldBindings, 0, count);
        }
        this.setFields(fieldBindings);
    }

    private void buildMethods() {
        int size;
        InferredType inferredType = this.classScope.inferredType;
        int n = size = inferredType.methods != null ? inferredType.methods.size() : 0;
        if (size == 0) {
            this.setMethods(Binding.NO_METHODS);
            return;
        }
        int count = 0;
        MethodBinding[] methodBindings = new MethodBinding[size];
        int i = 0;
        while (i < size) {
            MethodBinding methodBinding;
            InferredMethod method = (InferredMethod)inferredType.methods.get(i);
            MethodScope scope = new MethodScope(this.scope, (MethodDeclaration)method.getFunctionDeclaration(), false);
            method.methodBinding = methodBinding = scope.createMethod(method, this);
            if (methodBinding != null) {
                methodBindings[count++] = methodBinding;
            }
            ++i;
        }
        if (count != methodBindings.length) {
            MethodBinding[] methodBindingArray = methodBindings;
            methodBindings = new MethodBinding[count];
            System.arraycopy(methodBindingArray, 0, methodBindings, 0, count);
        }
        this.tagBits &= 0xFFFFFFFFFFFFBFFFL;
        this.setMethods(methodBindings);
    }

    public FieldBinding addSyntheticFieldForInnerclass(LocalVariableBinding actualOuterLocalVariable) {
        boolean needRecheck;
        FieldBinding synthField;
        if (this.synthetics == null) {
            this.synthetics = new HashMap[4];
        }
        if (this.synthetics[1] == null) {
            this.synthetics[1] = new HashMap(5);
        }
        if ((synthField = (FieldBinding)this.synthetics[1].get(actualOuterLocalVariable)) == null) {
            synthField = new SyntheticFieldBinding(CharOperation.concat(TypeConstants.SYNTHETIC_OUTER_LOCAL_PREFIX, actualOuterLocalVariable.name), actualOuterLocalVariable.type, 4114, this, Constant.NotAConstant, this.synthetics[1].size());
            this.synthetics[1].put(actualOuterLocalVariable, synthField);
        }
        int index = 1;
        block0: do {
            needRecheck = false;
            FieldBinding existingField = this.getField(synthField.name, true);
            if (existingField == null) continue;
            TypeDeclaration typeDecl = this.classScope.referenceContext;
            int i = 0;
            int max = typeDecl.fields.length;
            while (i < max) {
                FieldDeclaration fieldDecl = typeDecl.fields[i];
                if (fieldDecl.binding == existingField) {
                    synthField.name = CharOperation.concat(TypeConstants.SYNTHETIC_OUTER_LOCAL_PREFIX, actualOuterLocalVariable.name, ("$" + String.valueOf(index++)).toCharArray());
                    needRecheck = true;
                    continue block0;
                }
                ++i;
            }
        } while (needRecheck);
        return synthField;
    }

    public FieldBinding addSyntheticFieldForInnerclass(ReferenceBinding enclosingType) {
        boolean needRecheck;
        FieldBinding synthField;
        if (this.synthetics == null) {
            this.synthetics = new HashMap[4];
        }
        if (this.synthetics[1] == null) {
            this.synthetics[1] = new HashMap(5);
        }
        if ((synthField = (FieldBinding)this.synthetics[1].get(enclosingType)) == null) {
            synthField = new SyntheticFieldBinding(CharOperation.concat(TypeConstants.SYNTHETIC_ENCLOSING_INSTANCE_PREFIX, String.valueOf(enclosingType.depth()).toCharArray()), enclosingType, 4112, this, Constant.NotAConstant, this.synthetics[1].size());
            this.synthetics[1].put(enclosingType, synthField);
        }
        block0: do {
            needRecheck = false;
            FieldBinding existingField = this.getField(synthField.name, true);
            if (existingField == null) continue;
            TypeDeclaration typeDecl = this.classScope.referenceContext;
            int i = 0;
            int max = typeDecl.fields.length;
            while (i < max) {
                FieldDeclaration fieldDecl = typeDecl.fields[i];
                if (fieldDecl.binding == existingField) {
                    if (this.scope.compilerOptions().complianceLevel >= 0x310000L) {
                        synthField.name = CharOperation.concat(synthField.name, "$".toCharArray());
                        needRecheck = true;
                        continue block0;
                    }
                    this.scope.problemReporter().duplicateFieldInType(this, fieldDecl);
                    continue block0;
                }
                ++i;
            }
        } while (needRecheck);
        return synthField;
    }

    public FieldBinding addSyntheticFieldForClassLiteral(TypeBinding targetType, BlockScope blockScope) {
        FieldBinding existingField;
        FieldBinding synthField;
        if (this.synthetics == null) {
            this.synthetics = new HashMap[4];
        }
        if (this.synthetics[2] == null) {
            this.synthetics[2] = new HashMap(5);
        }
        if ((synthField = (FieldBinding)this.synthetics[2].get(targetType)) == null) {
            synthField = new SyntheticFieldBinding(CharOperation.concat(TypeConstants.SYNTHETIC_CLASS, String.valueOf(this.synthetics[2].size()).toCharArray()), blockScope.getJavaLangClass(), 4104, this, Constant.NotAConstant, this.synthetics[2].size());
            this.synthetics[2].put(targetType, synthField);
        }
        if ((existingField = this.getField(synthField.name, true)) != null) {
            TypeDeclaration typeDecl = blockScope.referenceType();
            int i = 0;
            int max = typeDecl.fields.length;
            while (i < max) {
                FieldDeclaration fieldDecl = typeDecl.fields[i];
                if (fieldDecl.binding == existingField) {
                    blockScope.problemReporter().duplicateFieldInType(this, fieldDecl);
                    break;
                }
                ++i;
            }
        }
        return synthField;
    }

    public FieldBinding addSyntheticFieldForAssert(BlockScope blockScope) {
        boolean needRecheck;
        FieldBinding synthField;
        if (this.synthetics == null) {
            this.synthetics = new HashMap[4];
        }
        if (this.synthetics[1] == null) {
            this.synthetics[1] = new HashMap(5);
        }
        if ((synthField = (FieldBinding)this.synthetics[1].get("assertionEmulation")) == null) {
            synthField = new SyntheticFieldBinding(TypeConstants.SYNTHETIC_ASSERT_DISABLED, TypeBinding.BOOLEAN, 4120, this, Constant.NotAConstant, this.synthetics[1].size());
            this.synthetics[1].put("assertionEmulation", synthField);
        }
        int index = 0;
        block0: do {
            needRecheck = false;
            FieldBinding existingField = this.getField(synthField.name, true);
            if (existingField == null) continue;
            TypeDeclaration typeDecl = this.classScope.referenceContext;
            int i = 0;
            int max = typeDecl.fields.length;
            while (i < max) {
                FieldDeclaration fieldDecl = typeDecl.fields[i];
                if (fieldDecl.binding == existingField) {
                    synthField.name = CharOperation.concat(TypeConstants.SYNTHETIC_ASSERT_DISABLED, ("_" + String.valueOf(index++)).toCharArray());
                    needRecheck = true;
                    continue block0;
                }
                ++i;
            }
        } while (needRecheck);
        return synthField;
    }

    public FieldBinding addSyntheticFieldForEnumValues() {
        boolean needRecheck;
        FieldBinding synthField;
        if (this.synthetics == null) {
            this.synthetics = new HashMap[4];
        }
        if (this.synthetics[1] == null) {
            this.synthetics[1] = new HashMap(5);
        }
        if ((synthField = (FieldBinding)this.synthetics[1].get("enumConstantValues")) == null) {
            synthField = new SyntheticFieldBinding(TypeConstants.SYNTHETIC_ENUM_VALUES, this.scope.createArrayType(this, 1), 4122, this, Constant.NotAConstant, this.synthetics[1].size());
            this.synthetics[1].put("enumConstantValues", synthField);
        }
        int index = 0;
        block0: do {
            needRecheck = false;
            FieldBinding existingField = this.getField(synthField.name, true);
            if (existingField == null) continue;
            TypeDeclaration typeDecl = this.classScope.referenceContext;
            int i = 0;
            int max = typeDecl.fields.length;
            while (i < max) {
                FieldDeclaration fieldDecl = typeDecl.fields[i];
                if (fieldDecl.binding == existingField) {
                    synthField.name = CharOperation.concat(TypeConstants.SYNTHETIC_ENUM_VALUES, ("_" + String.valueOf(index++)).toCharArray());
                    needRecheck = true;
                    continue block0;
                }
                ++i;
            }
        } while (needRecheck);
        return synthField;
    }

    public SyntheticMethodBinding addSyntheticMethod(FieldBinding targetField, boolean isReadAccess) {
        if (this.synthetics == null) {
            this.synthetics = new HashMap[4];
        }
        if (this.synthetics[0] == null) {
            this.synthetics[0] = new HashMap(5);
        }
        SyntheticMethodBinding accessMethod = null;
        SyntheticMethodBinding[] accessors = (SyntheticMethodBinding[])this.synthetics[0].get(targetField);
        if (accessors == null) {
            accessMethod = new SyntheticMethodBinding(targetField, isReadAccess, (ReferenceBinding)this);
            accessors = new SyntheticMethodBinding[2];
            this.synthetics[0].put(targetField, accessors);
            accessors[isReadAccess ? 0 : 1] = accessMethod;
        } else {
            accessMethod = accessors[isReadAccess ? 0 : 1];
            if (accessMethod == null) {
                accessMethod = new SyntheticMethodBinding(targetField, isReadAccess, (ReferenceBinding)this);
                accessors[isReadAccess ? 0 : 1] = accessMethod;
            }
        }
        return accessMethod;
    }

    public SyntheticMethodBinding addSyntheticEnumMethod(char[] selector) {
        if (this.synthetics == null) {
            this.synthetics = new HashMap[4];
        }
        if (this.synthetics[0] == null) {
            this.synthetics[0] = new HashMap(5);
        }
        SyntheticMethodBinding accessMethod = null;
        SyntheticMethodBinding[] accessors = (SyntheticMethodBinding[])this.synthetics[0].get(selector);
        if (accessors == null) {
            accessMethod = new SyntheticMethodBinding(this, selector);
            accessors = new SyntheticMethodBinding[2];
            this.synthetics[0].put(selector, accessors);
            accessors[0] = accessMethod;
        } else {
            accessMethod = accessors[0];
            if (accessMethod == null) {
                accessors[0] = accessMethod = new SyntheticMethodBinding(this, selector);
            }
        }
        return accessMethod;
    }

    public SyntheticFieldBinding addSyntheticFieldForSwitchEnum(char[] fieldName, String key) {
        boolean needRecheck;
        SyntheticFieldBinding synthField;
        if (this.synthetics == null) {
            this.synthetics = new HashMap[4];
        }
        if (this.synthetics[1] == null) {
            this.synthetics[1] = new HashMap(5);
        }
        if ((synthField = (SyntheticFieldBinding)this.synthetics[1].get(key)) == null) {
            synthField = new SyntheticFieldBinding(fieldName, this.scope.createArrayType(TypeBinding.INT, 1), 4106, this, Constant.NotAConstant, this.synthetics[1].size());
            this.synthetics[1].put(key, synthField);
        }
        int index = 0;
        block0: do {
            needRecheck = false;
            FieldBinding existingField = this.getField(synthField.name, true);
            if (existingField == null) continue;
            TypeDeclaration typeDecl = this.classScope.referenceContext;
            int i = 0;
            int max = typeDecl.fields.length;
            while (i < max) {
                FieldDeclaration fieldDecl = typeDecl.fields[i];
                if (fieldDecl.binding == existingField) {
                    synthField.name = CharOperation.concat(fieldName, ("_" + String.valueOf(index++)).toCharArray());
                    needRecheck = true;
                    continue block0;
                }
                ++i;
            }
        } while (needRecheck);
        return synthField;
    }

    public SyntheticMethodBinding addSyntheticMethodForSwitchEnum(TypeBinding enumBinding) {
        if (this.synthetics == null) {
            this.synthetics = new HashMap[4];
        }
        if (this.synthetics[0] == null) {
            this.synthetics[0] = new HashMap(5);
        }
        SyntheticMethodBinding accessMethod = null;
        char[] selector = CharOperation.concat(TypeConstants.SYNTHETIC_SWITCH_ENUM_TABLE, enumBinding.constantPoolName());
        CharOperation.replace(selector, '/', '$');
        String key = new String(selector);
        SyntheticMethodBinding[] accessors = (SyntheticMethodBinding[])this.synthetics[0].get(key);
        if (accessors == null) {
            SyntheticFieldBinding fieldBinding = this.addSyntheticFieldForSwitchEnum(selector, key);
            accessMethod = new SyntheticMethodBinding(fieldBinding, this, enumBinding, selector);
            accessors = new SyntheticMethodBinding[2];
            this.synthetics[0].put(key, accessors);
            accessors[0] = accessMethod;
        } else {
            accessMethod = accessors[0];
            if (accessMethod == null) {
                SyntheticFieldBinding fieldBinding = this.addSyntheticFieldForSwitchEnum(selector, key);
                accessors[0] = accessMethod = new SyntheticMethodBinding(fieldBinding, this, enumBinding, selector);
            }
        }
        return accessMethod;
    }

    public SyntheticMethodBinding addSyntheticMethod(MethodBinding targetMethod, boolean isSuperAccess) {
        if (this.synthetics == null) {
            this.synthetics = new HashMap[4];
        }
        if (this.synthetics[0] == null) {
            this.synthetics[0] = new HashMap(5);
        }
        SyntheticMethodBinding accessMethod = null;
        SyntheticMethodBinding[] accessors = (SyntheticMethodBinding[])this.synthetics[0].get(targetMethod);
        if (accessors == null) {
            accessMethod = new SyntheticMethodBinding(targetMethod, isSuperAccess, (ReferenceBinding)this);
            accessors = new SyntheticMethodBinding[2];
            this.synthetics[0].put(targetMethod, accessors);
            accessors[isSuperAccess ? 0 : 1] = accessMethod;
        } else {
            accessMethod = accessors[isSuperAccess ? 0 : 1];
            if (accessMethod == null) {
                accessMethod = new SyntheticMethodBinding(targetMethod, isSuperAccess, (ReferenceBinding)this);
                accessors[isSuperAccess ? 0 : 1] = accessMethod;
            }
        }
        return accessMethod;
    }

    public SyntheticMethodBinding addSyntheticBridgeMethod(MethodBinding inheritedMethodToBridge, MethodBinding targetMethod) {
        if (this.isInterface()) {
            return null;
        }
        if (inheritedMethodToBridge.returnType.erasure() == targetMethod.returnType.erasure() && inheritedMethodToBridge.areParameterErasuresEqual(targetMethod)) {
            return null;
        }
        if (this.synthetics == null) {
            this.synthetics = new HashMap[4];
        }
        if (this.synthetics[0] == null) {
            this.synthetics[0] = new HashMap(5);
        } else {
            Iterator synthMethods = this.synthetics[0].keySet().iterator();
            while (synthMethods.hasNext()) {
                Object synthetic = synthMethods.next();
                if (!(synthetic instanceof MethodBinding)) continue;
                MethodBinding method = (MethodBinding)synthetic;
                if (!CharOperation.equals(inheritedMethodToBridge.selector, method.selector) || inheritedMethodToBridge.returnType.erasure() != method.returnType.erasure() || !inheritedMethodToBridge.areParameterErasuresEqual(method)) continue;
                return null;
            }
        }
        SyntheticMethodBinding accessMethod = null;
        SyntheticMethodBinding[] accessors = (SyntheticMethodBinding[])this.synthetics[0].get(inheritedMethodToBridge);
        if (accessors == null) {
            accessMethod = new SyntheticMethodBinding(inheritedMethodToBridge, targetMethod, this);
            accessors = new SyntheticMethodBinding[2];
            this.synthetics[0].put(inheritedMethodToBridge, accessors);
            accessors[1] = accessMethod;
        } else {
            accessMethod = accessors[1];
            if (accessMethod == null) {
                accessors[1] = accessMethod = new SyntheticMethodBinding(inheritedMethodToBridge, targetMethod, this);
            }
        }
        return accessMethod;
    }

    public int kind() {
        if (this.typeVariables != Binding.NO_TYPE_VARIABLES) {
            return 2052;
        }
        return 4;
    }

    public char[] computeUniqueKey(boolean isLeaf) {
        char[] uniqueKey = super.computeUniqueKey(isLeaf);
        if (uniqueKey.length == 2) {
            return uniqueKey;
        }
        if (org.eclipse.wst.jsdt.internal.compiler.util.Util.isClassFileName(this.fileName) || Util.isMetadataFileName(new String(this.fileName))) {
            return uniqueKey;
        }
        int end = CharOperation.lastIndexOf('.', this.fileName);
        if (end != -1) {
            char[] topLevelType;
            int start = CharOperation.lastIndexOf('/', this.fileName) + 1;
            char[] mainTypeName = CharOperation.subarray(this.fileName, start, end);
            start = CharOperation.lastIndexOf('/', uniqueKey) + 1;
            if (start == 0) {
                start = 1;
            }
            if ((end = CharOperation.indexOf('$', uniqueKey, start)) == -1) {
                end = CharOperation.indexOf('<', uniqueKey, start);
            }
            if (end == -1) {
                end = CharOperation.indexOf(';', uniqueKey, start);
            }
            if (!CharOperation.equals(topLevelType = CharOperation.subarray(uniqueKey, start, end), mainTypeName)) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(uniqueKey, 0, start);
                buffer.append(mainTypeName);
                buffer.append('~');
                buffer.append(topLevelType);
                buffer.append(uniqueKey, end, uniqueKey.length - end);
                int length = buffer.length();
                uniqueKey = new char[length];
                buffer.getChars(0, length, uniqueKey, 0);
                return uniqueKey;
            }
        }
        return uniqueKey;
    }

    void faultInTypesForFieldsAndMethods() {
        ReferenceBinding enclosingType = this.enclosingType();
        if (enclosingType != null && enclosingType.isViewedAsDeprecated() && !this.isDeprecated()) {
            this.modifiers |= 0x200000;
        }
        this.fields();
        this.methods();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FieldBinding[] fields() {
        block18: {
            block17: {
                if ((this.tagBits & 8192L) != 0L) break block18;
                failed = 0;
                resolvedFields = this.fields;
                try {
                    if ((this.tagBits & 4096L) == 0L) {
                        length = this.fields.length;
                        if (length > 1) {
                            ReferenceBinding.sortFields(this.fields, 0, length);
                        }
                        this.tagBits |= 4096L;
                    }
                    i = 0;
                    length = this.fields.length;
                    while (i < length) {
                        if (this.resolveTypeFor(this.fields[i]) == null) {
                            if (resolvedFields == this.fields) {
                                resolvedFields = new FieldBinding[length];
                                System.arraycopy(this.fields, 0, resolvedFields, 0, length);
                            }
                            resolvedFields[i] = null;
                            ++failed;
                        }
                        ++i;
                    }
                    ** GOTO lbl-1000
                }
                catch (Throwable var6_6) {
                    var5_7 = null;
                    if (failed <= 0) throw var6_6;
                    newSize = resolvedFields.length - failed;
                    if (newSize == 0) {
                        this.fields = Binding.NO_FIELDS;
                        return Binding.NO_FIELDS;
                    }
                    newFields = new FieldBinding[newSize];
                    i = 0;
                    j = 0;
                    length = resolvedFields.length;
                }
                while (true) {
                    if (i >= length) {
                        this.fields = newFields;
                        throw var6_6;
                    }
                    if (resolvedFields[i] != null) {
                        newFields[j++] = resolvedFields[i];
                    }
                    ++i;
                }
lbl-1000:
                // 1 sources

                {
                    var5_8 = null;
                    if (failed <= 0) break block17;
                }
                newSize = resolvedFields.length - failed;
                if (newSize == 0) {
                    this.fields = Binding.NO_FIELDS;
                    return Binding.NO_FIELDS;
                }
                newFields = new FieldBinding[newSize];
                i = 0;
                j = 0;
                length = resolvedFields.length;
                while (true) {
                    if (i >= length) {
                        this.fields = newFields;
                        break;
                    }
                    if (resolvedFields[i] != null) {
                        newFields[j++] = resolvedFields[i];
                    }
                    ++i;
                }
            }
            this.tagBits |= 8192L;
        }
        if (this.nextType == null) return this.fields;
        moreFields = this.nextType.fields();
        combinedFields = new FieldBinding[this.fields.length + moreFields.length];
        System.arraycopy(this.fields, 0, combinedFields, 0, this.fields.length);
        System.arraycopy(moreFields, 0, combinedFields, this.fields.length, moreFields.length);
        return combinedFields;
    }

    public char[] genericTypeSignature() {
        if (this.genericReferenceTypeSignature == null) {
            this.genericReferenceTypeSignature = this.computeGenericTypeSignature(this.typeVariables);
        }
        return this.genericReferenceTypeSignature;
    }

    public char[] genericSignature() {
        int length;
        int i;
        StringBuffer sig = null;
        if (this.typeVariables != Binding.NO_TYPE_VARIABLES) {
            sig = new StringBuffer(10);
            sig.append('<');
            i = 0;
            length = this.typeVariables.length;
            while (i < length) {
                sig.append(this.typeVariables[i].genericSignature());
                ++i;
            }
            sig.append('>');
        } else {
            block9: {
                if (this.superclass == null || !this.superclass.isParameterizedType()) {
                    i = 0;
                    length = this.superInterfaces.length;
                    while (i < length) {
                        if (!this.superInterfaces[i].isParameterizedType()) {
                            ++i;
                            continue;
                        }
                        break block9;
                    }
                    return null;
                }
            }
            sig = new StringBuffer(10);
        }
        if (this.superclass != null) {
            sig.append(this.superclass.genericTypeSignature());
        } else {
            sig.append(this.scope.getJavaLangObject().genericTypeSignature());
        }
        i = 0;
        length = this.superInterfaces.length;
        while (i < length) {
            sig.append(this.superInterfaces[i].genericTypeSignature());
            ++i;
        }
        return sig.toString().toCharArray();
    }

    public long getAnnotationTagBits() {
        return this.tagBits;
    }

    public MethodBinding[] getDefaultAbstractMethods() {
        int count = 0;
        int i = this.methods.length;
        while (--i >= 0) {
            if (!this.methods[i].isDefaultAbstract()) continue;
            ++count;
        }
        if (count == 0) {
            return Binding.NO_METHODS;
        }
        MethodBinding[] result = new MethodBinding[count];
        count = 0;
        int i2 = this.methods.length;
        while (--i2 >= 0) {
            if (!this.methods[i2].isDefaultAbstract()) continue;
            result[count++] = this.methods[i2];
        }
        return result;
    }

    public MethodBinding getExactConstructor(TypeBinding[] argumentTypes) {
        MethodBinding exactConstructor = this.getExactConstructor0(argumentTypes);
        if (exactConstructor == null && this.nextType != null) {
            exactConstructor = this.nextType.getExactConstructor(argumentTypes);
        }
        return exactConstructor;
    }

    private MethodBinding getExactConstructor0(TypeBinding[] argumentTypes) {
        int cfr_ignored_0 = argumentTypes.length;
        if ((this.tagBits & 0x8000L) != 0L) {
            int end;
            int imethod;
            long range = ReferenceBinding.binarySearch(TypeConstants.INIT, this.methods);
            if (range >= 0L && (imethod = (int)range) <= (end = (int)(range >> 32))) {
                MethodBinding method = this.methods[imethod];
                return method;
            }
        } else {
            int end;
            int imethod;
            long range;
            if ((this.tagBits & 0x4000L) == 0L) {
                int length = this.methods.length;
                if (length > 1) {
                    ReferenceBinding.sortMethods(this.methods, 0, length);
                }
                this.tagBits |= 0x4000L;
            }
            if ((range = ReferenceBinding.binarySearch(TypeConstants.INIT, this.methods)) >= 0L && (imethod = (int)range) <= (end = (int)(range >> 32))) {
                MethodBinding method = this.methods[imethod];
                if (this.resolveTypesFor(method) == null || method.returnType == null) {
                    this.methods();
                    return this.getExactConstructor(argumentTypes);
                }
                return method;
            }
        }
        return null;
    }

    public MethodBinding getExactMethod(char[] selector, TypeBinding[] argumentTypes, CompilationUnitScope refScope) {
        MethodBinding exactMethod = this.getExactMethod0(selector, argumentTypes, refScope);
        if (exactMethod == null && this.nextType != null) {
            exactMethod = this.nextType.getExactMethod(selector, argumentTypes, refScope);
        }
        return exactMethod;
    }

    private MethodBinding getExactMethod0(char[] selector, TypeBinding[] argumentTypes, CompilationUnitScope refScope) {
        boolean foundNothing = true;
        if ((this.tagBits & 0x8000L) != 0L) {
            int end;
            int imethod;
            long range = ReferenceBinding.binarySearch(selector, this.methods);
            if (range >= 0L && (imethod = (int)range) <= (end = (int)(range >> 32))) {
                MethodBinding method = this.methods[imethod];
                foundNothing = false;
                return method;
            }
        } else {
            long range;
            if ((this.tagBits & 0x4000L) == 0L) {
                int length = this.methods.length;
                if (length > 1) {
                    ReferenceBinding.sortMethods(this.methods, 0, length);
                }
                this.tagBits |= 0x4000L;
            }
            if ((range = ReferenceBinding.binarySearch(selector, this.methods)) >= 0L) {
                int start = (int)range;
                int end = (int)(range >> 32);
                int imethod = start;
                while (imethod <= end) {
                    MethodBinding method = this.methods[imethod];
                    if (this.resolveTypesFor(method) == null || method.returnType == null) {
                        this.methods();
                        return this.getExactMethod(selector, argumentTypes, refScope);
                    }
                    ++imethod;
                }
                boolean isSource15 = this.scope.compilerOptions().sourceLevel >= 0x310000L;
                int i = start;
                while (i <= end) {
                    MethodBinding method1 = this.methods[i];
                    int j = end;
                    while (j > i) {
                        boolean paramsMatch;
                        MethodBinding method2 = this.methods[j];
                        boolean bl = paramsMatch = isSource15 ? method1.areParameterErasuresEqual(method2) : method1.areParametersEqual(method2);
                        if (paramsMatch) {
                            this.methods();
                            return this.getExactMethod(selector, argumentTypes, refScope);
                        }
                        --j;
                    }
                    ++i;
                }
                return this.methods[start];
            }
        }
        if (foundNothing && this.superclass != null && this.superclass != this) {
            if (refScope != null) {
                refScope.recordTypeReference(this.superclass);
            }
            return this.superclass.getExactMethod(selector, argumentTypes, refScope);
        }
        return null;
    }

    public FieldBinding getField(char[] fieldName, boolean needResolve) {
        FieldBinding field = this.getField0(fieldName, needResolve);
        if (field == null && this.nextType != null) {
            field = this.nextType.getField(fieldName, needResolve);
        }
        return field;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private FieldBinding getField0(char[] fieldName, boolean needResolve) {
        int length3;
        int i2;
        FieldBinding[] newFields2;
        Throwable throwable2;
        FieldBinding field;
        block13: {
            FieldBinding fieldBinding;
            if ((this.tagBits & 0x2000L) != 0L) {
                return ReferenceBinding.binarySearch(fieldName, this.fields);
            }
            if ((this.tagBits & 0x1000L) == 0L) {
                int length2 = this.fields.length;
                if (length2 > 1) {
                    ReferenceBinding.sortFields(this.fields, 0, length2);
                }
                this.tagBits |= 0x1000L;
            }
            if ((field = ReferenceBinding.binarySearch(fieldName, this.fields)) == null) return null;
            FieldBinding result = null;
            try {
                fieldBinding = result = this.resolveTypeFor(field);
                Object var5_7 = null;
                if (result != null) return fieldBinding;
            }
            catch (Throwable throwable2) {
                Object var5_8 = null;
                if (result != null) throw throwable2;
                int newSize = this.fields.length - 1;
                if (newSize == 0) {
                    this.fields = Binding.NO_FIELDS;
                    throw throwable2;
                }
                newFields2 = new FieldBinding[newSize];
                int index = 0;
                i2 = 0;
                length3 = this.fields.length;
                break block13;
            }
            int newSize = this.fields.length - 1;
            if (newSize == 0) {
                this.fields = Binding.NO_FIELDS;
                return fieldBinding;
            }
            FieldBinding[] newFields2 = new FieldBinding[newSize];
            int index = 0;
            int i2 = 0;
            int length3 = this.fields.length;
            while (true) {
                if (i2 >= length3) {
                    this.fields = newFields2;
                    return fieldBinding;
                }
                FieldBinding f = this.fields[i2];
                if (f != field) {
                    newFields2[index++] = f;
                }
                ++i2;
            }
        }
        while (true) {
            if (i2 >= length3) {
                this.fields = newFields2;
                throw throwable2;
            }
            FieldBinding f = this.fields[i2];
            if (f != field) {
                newFields2[index++] = f;
            }
            ++i2;
        }
    }

    public MethodBinding[] getMethods(char[] selector) {
        MethodBinding[] meths = this.getMethods0(selector);
        if (this.nextType == null) {
            return meths;
        }
        MethodBinding[] moreMethods = this.nextType.getMethods(selector);
        MethodBinding[] combinedMethods = new MethodBinding[meths.length + moreMethods.length];
        System.arraycopy(meths, 0, combinedMethods, 0, meths.length);
        System.arraycopy(moreMethods, 0, combinedMethods, meths.length, moreMethods.length);
        return combinedMethods;
    }

    private MethodBinding[] getMethods0(char[] selector) {
        MethodBinding method;
        int end;
        int start;
        long range;
        if ((this.tagBits & 0x8000L) != 0L) {
            long range2 = ReferenceBinding.binarySearch(selector, this.methods);
            if (range2 >= 0L) {
                int start2 = (int)range2;
                int end2 = (int)(range2 >> 32);
                int length = end2 - start2 + 1;
                MethodBinding[] result = new MethodBinding[length];
                System.arraycopy(this.methods, start2, result, 0, length);
                return result;
            }
            return Binding.NO_METHODS;
        }
        if ((this.tagBits & 0x4000L) == 0L) {
            int length = this.methods.length;
            if (length > 1) {
                ReferenceBinding.sortMethods(this.methods, 0, length);
            }
            this.tagBits |= 0x4000L;
        }
        if ((range = ReferenceBinding.binarySearch(selector, this.methods)) >= 0L) {
            start = (int)range;
            end = (int)(range >> 32);
            int i = start;
            while (i <= end) {
                method = this.methods[i];
                if (this.resolveTypesFor(method) == null || method.returnType == null) {
                    this.methods();
                    return this.getMethods(selector);
                }
                ++i;
            }
        } else {
            return Binding.NO_METHODS;
        }
        int length = end - start + 1;
        MethodBinding[] result = new MethodBinding[length];
        System.arraycopy(this.methods, start, result, 0, length);
        boolean isSource15 = this.scope.compilerOptions().sourceLevel >= 0x310000L;
        int i = 0;
        length = result.length - 1;
        while (i < length) {
            method = result[i];
            int j = length;
            while (j > i) {
                boolean paramsMatch;
                boolean bl = paramsMatch = isSource15 ? method.areParameterErasuresEqual(result[j]) : method.areParametersEqual(result[j]);
                if (paramsMatch) {
                    this.methods();
                    return this.getMethods(selector);
                }
                --j;
            }
            ++i;
        }
        return result;
    }

    public FieldBinding getSyntheticField(LocalVariableBinding actualOuterLocalVariable) {
        if (this.synthetics == null || this.synthetics[1] == null) {
            return null;
        }
        return (FieldBinding)this.synthetics[1].get(actualOuterLocalVariable);
    }

    public FieldBinding getSyntheticField(ReferenceBinding targetEnclosingType, boolean onlyExactMatch) {
        if (this.synthetics == null || this.synthetics[1] == null) {
            return null;
        }
        FieldBinding field = (FieldBinding)this.synthetics[1].get(targetEnclosingType);
        if (field != null) {
            return field;
        }
        if (!onlyExactMatch) {
            Iterator accessFields = this.synthetics[1].values().iterator();
            while (accessFields.hasNext()) {
                field = (FieldBinding)accessFields.next();
                if (!CharOperation.prefixEquals(TypeConstants.SYNTHETIC_ENCLOSING_INSTANCE_PREFIX, field.name) || field.type.findSuperTypeWithSameErasure(targetEnclosingType) == null) continue;
                return field;
            }
        }
        return null;
    }

    public SyntheticMethodBinding getSyntheticBridgeMethod(MethodBinding inheritedMethodToBridge) {
        if (this.synthetics == null) {
            return null;
        }
        if (this.synthetics[0] == null) {
            return null;
        }
        SyntheticMethodBinding[] accessors = (SyntheticMethodBinding[])this.synthetics[0].get(inheritedMethodToBridge);
        if (accessors == null) {
            return null;
        }
        return accessors[1];
    }

    public void initializeDeprecatedAnnotationTagBits() {
    }

    public boolean isEquivalentTo(TypeBinding otherType) {
        if (this == otherType) {
            return true;
        }
        if (otherType == null) {
            return false;
        }
        switch (otherType.kind()) {
            case 516: {
                return ((WildcardBinding)otherType).boundCheck(this);
            }
            case 260: {
                int otherLength;
                ReferenceBinding enclosing;
                if (!((otherType.tagBits & 0x40000000L) != 0L || this.isMemberType() && otherType.isMemberType())) {
                    return false;
                }
                ParameterizedTypeBinding otherParamType = (ParameterizedTypeBinding)otherType;
                if (this != otherParamType.genericType()) {
                    return false;
                }
                if (!this.isStatic() && (enclosing = this.enclosingType()) != null) {
                    ReferenceBinding otherEnclosing = otherParamType.enclosingType();
                    if (otherEnclosing == null) {
                        return false;
                    }
                    if ((otherEnclosing.tagBits & 0x40000000L) == 0L ? enclosing != otherEnclosing : !enclosing.isEquivalentTo(otherParamType.enclosingType())) {
                        return false;
                    }
                }
                int length = this.typeVariables == null ? 0 : this.typeVariables.length;
                TypeBinding[] otherArguments = otherParamType.arguments;
                int n = otherLength = otherArguments == null ? 0 : otherArguments.length;
                if (otherLength != length) {
                    return false;
                }
                int i = 0;
                while (i < length) {
                    if (!this.typeVariables[i].isTypeArgumentContainedBy(otherArguments[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            case 1028: {
                return otherType.erasure() == this;
            }
        }
        return false;
    }

    public boolean isGenericType() {
        return this.typeVariables != Binding.NO_TYPE_VARIABLES;
    }

    public ReferenceBinding[] memberTypes() {
        if (this.nextType == null) {
            return this.memberTypes;
        }
        ReferenceBinding[] moreTypes = this.nextType.memberTypes();
        ReferenceBinding[] combinedTypes = new ReferenceBinding[this.memberTypes.length + moreTypes.length];
        System.arraycopy(this.memberTypes, 0, combinedTypes, 0, this.memberTypes.length);
        System.arraycopy(moreTypes, 0, combinedTypes, this.memberTypes.length, moreTypes.length);
        return combinedTypes;
    }

    public FieldBinding getUpdatedFieldBinding(FieldBinding targetField, ReferenceBinding newDeclaringClass) {
        FieldBinding updatedField;
        Hashtable<ReferenceBinding, FieldBinding> fieldMap;
        if (this.synthetics == null) {
            this.synthetics = new HashMap[4];
        }
        if (this.synthetics[3] == null) {
            this.synthetics[3] = new HashMap(5);
        }
        if ((fieldMap = (Hashtable<ReferenceBinding, FieldBinding>)this.synthetics[3].get(targetField)) == null) {
            fieldMap = new Hashtable<ReferenceBinding, FieldBinding>(5);
            this.synthetics[3].put(targetField, fieldMap);
        }
        if ((updatedField = (FieldBinding)fieldMap.get(newDeclaringClass)) == null) {
            updatedField = new FieldBinding(targetField, newDeclaringClass);
            fieldMap.put(newDeclaringClass, updatedField);
        }
        return updatedField;
    }

    public MethodBinding getUpdatedMethodBinding(MethodBinding targetMethod, ReferenceBinding newDeclaringClass) {
        MethodBinding updatedMethod;
        Hashtable<ReferenceBinding, MethodBinding> methodMap;
        if (this.synthetics == null) {
            this.synthetics = new HashMap[4];
        }
        if (this.synthetics[3] == null) {
            this.synthetics[3] = new HashMap(5);
        }
        if ((methodMap = (Hashtable<ReferenceBinding, MethodBinding>)this.synthetics[3].get(targetMethod)) == null) {
            methodMap = new Hashtable<ReferenceBinding, MethodBinding>(5);
            this.synthetics[3].put(targetMethod, methodMap);
        }
        if ((updatedMethod = (MethodBinding)methodMap.get(newDeclaringClass)) == null) {
            updatedMethod = new MethodBinding(targetMethod, newDeclaringClass);
            updatedMethod.createFunctionTypeBinding(this.scope);
            methodMap.put(newDeclaringClass, updatedMethod);
        }
        return updatedMethod;
    }

    public boolean hasMemberTypes() {
        boolean hasMembers;
        boolean bl = hasMembers = this.memberTypes != null && this.memberTypes.length > 0;
        if (!hasMembers && this.nextType != null) {
            hasMembers = this.nextType.hasMemberTypes();
        }
        return hasMembers;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MethodBinding[] methods() {
        block41: {
            block40: {
                block39: {
                    if ((this.tagBits & 32768L) != 0L) break block41;
                    if ((this.tagBits & 16384L) == 0L) {
                        length = this.methods.length;
                        if (length > 1) {
                            ReferenceBinding.sortMethods(this.methods, 0, length);
                        }
                        this.tagBits |= 16384L;
                    }
                    failed = 0;
                    resolvedMethods = this.methods;
                    try {
                        i = 0;
                        length = this.methods.length;
                        while (true) {
                            block42: {
                                if (i < length) break block42;
                            }
                            if (this.resolveTypesFor(this.methods[i]) == null) {
                                if (resolvedMethods == this.methods) {
                                    resolvedMethods = new MethodBinding[length];
                                    System.arraycopy(this.methods, 0, resolvedMethods, 0, length);
                                }
                                resolvedMethods[i] = null;
                                ++failed;
                            }
                            ++i;
                        }
                        complyTo15 = this.scope != null && this.scope.compilerOptions().sourceLevel >= 0x310000L;
                        i = 0;
                        length = this.methods.length;
                        while (i < length) {
                            block43: {
                                method = resolvedMethods[i];
                                if (method == null) break block43;
                                selector = method.selector;
                                methodDecl = null;
                                j = i + 1;
                                while (j < length) {
                                    block44: {
                                        block46: {
                                            block45: {
                                                method2 = resolvedMethods[j];
                                                if (method2 == null) break block44;
                                                if (!CharOperation.equals(selector, method2.selector)) break;
                                                if (!complyTo15 || method.returnType == null || method2.returnType == null) break block45;
                                                params1 = method.parameters;
                                                pLength = params1.length;
                                                params2 = method2.parameters;
                                                if (pLength != params2.length) break block44;
                                                vars = method.typeVariables;
                                                vars2 = method2.typeVariables;
                                                equalTypeVars = vars == vars2;
                                                subMethod = method2;
                                                if (!equalTypeVars && (temp = method.computeSubstitutedMethod(method2, this.scope.environment())) != null) {
                                                    equalTypeVars = true;
                                                    subMethod = temp;
                                                }
                                                if ((equalParams = method.areParametersEqual(subMethod)) && equalTypeVars || method.returnType.erasure() == subMethod.returnType.erasure() && (equalParams || method.areParameterErasuresEqual(method2))) break block46;
                                                if (!equalTypeVars && vars != Binding.NO_TYPE_VARIABLES && vars2 != Binding.NO_TYPE_VARIABLES) break block44;
                                                if (pLength <= 0) break block46;
                                                index = pLength;
                                                while (--index >= 0 && params1[index] == params2[index].erasure()) {
                                                    if (params1[index] != params2[index] || !((type = params1[index].leafComponentType()) instanceof SourceTypeBinding) || type.typeVariables() == Binding.NO_TYPE_VARIABLES) continue;
                                                    index = pLength;
                                                    break;
                                                }
                                                if (index >= 0 && index < pLength) {
                                                    index = pLength;
                                                    while (--index >= 0 && params1[index].erasure() == params2[index]) {
                                                    }
                                                }
                                                if (index < 0) break block46;
                                                break block44;
                                            }
                                            if (!method.areParametersEqual(method2)) break block44;
                                        }
                                        v0 = isEnumSpecialMethod = this.isEnum() != false && (CharOperation.equals(selector, TypeConstants.VALUEOF) != false || CharOperation.equals(selector, TypeConstants.VALUES) != false);
                                        if (methodDecl == null && (methodDecl = method.sourceMethod()) != null && methodDecl.binding != null) {
                                            if (isEnumSpecialMethod) {
                                                this.scope.problemReporter().duplicateEnumSpecialMethod(this, methodDecl);
                                            } else {
                                                this.scope.problemReporter().duplicateMethodInType(this, methodDecl);
                                            }
                                            methodDecl.binding = null;
                                            if (resolvedMethods == this.methods) {
                                                resolvedMethods = new MethodBinding[length];
                                                System.arraycopy(this.methods, 0, resolvedMethods, 0, length);
                                            }
                                            resolvedMethods[i] = null;
                                            ++failed;
                                        }
                                        if ((method2Decl = method2.sourceMethod()) != null && method2Decl.binding != null) {
                                            if (isEnumSpecialMethod) {
                                                this.scope.problemReporter().duplicateEnumSpecialMethod(this, method2Decl);
                                            } else {
                                                this.scope.problemReporter().duplicateMethodInType(this, method2Decl);
                                            }
                                            method2Decl.binding = null;
                                            if (resolvedMethods == this.methods) {
                                                resolvedMethods = new MethodBinding[length];
                                                System.arraycopy(this.methods, 0, resolvedMethods, 0, length);
                                            }
                                            resolvedMethods[j] = null;
                                            ++failed;
                                        }
                                    }
                                    ++j;
                                }
                                if (method.returnType == null && methodDecl == null) {
                                    methodDecl = method.sourceMethod();
                                    if (methodDecl != null) {
                                        methodDecl.binding = null;
                                    }
                                    if (resolvedMethods == this.methods) {
                                        resolvedMethods = new MethodBinding[length];
                                        System.arraycopy(this.methods, 0, resolvedMethods, 0, length);
                                    }
                                    resolvedMethods[i] = null;
                                    ++failed;
                                }
                            }
                            ++i;
                        }
                        ** GOTO lbl-1000
                    }
                    catch (Throwable var22_24) {
                        var21_25 = null;
                        if (failed <= 0) break block39;
                        newSize = resolvedMethods.length - failed;
                        if (newSize == 0) {
                            this.methods = Binding.NO_METHODS;
                            break block39;
                        }
                        newMethods = new MethodBinding[newSize];
                        i = 0;
                        j = 0;
                        length = resolvedMethods.length;
                    }
                    while (true) {
                        if (i >= length) {
                            this.methods = newMethods;
                            break;
                        }
                        if (resolvedMethods[i] != null) {
                            newMethods[j++] = resolvedMethods[i];
                        }
                        ++i;
                    }
                }
                this.tagBits |= 32768L;
                throw var22_24;
lbl-1000:
                // 1 sources

                {
                    var21_26 = null;
                    if (failed <= 0) break block40;
                }
                newSize = resolvedMethods.length - failed;
                if (newSize == 0) {
                    this.methods = Binding.NO_METHODS;
                } else {
                    newMethods = new MethodBinding[newSize];
                    i = 0;
                    j = 0;
                    length = resolvedMethods.length;
                    while (true) {
                        if (i >= length) {
                            this.methods = newMethods;
                            break;
                        }
                        if (resolvedMethods[i] != null) {
                            newMethods[j++] = resolvedMethods[i];
                        }
                        ++i;
                    }
                }
            }
            this.tagBits |= 32768L;
        }
        if (this.nextType != null) {
            moreMethods = this.nextType.methods();
            combinedMethods = new MethodBinding[this.methods.length + moreMethods.length];
            System.arraycopy(this.methods, 0, combinedMethods, 0, this.methods.length);
            System.arraycopy(moreMethods, 0, combinedMethods, this.methods.length, moreMethods.length);
            return combinedMethods;
        }
        return this.methods;
    }

    private FieldBinding resolveTypeFor(FieldBinding field) {
        if ((field.modifiers & 0x2000000) == 0) {
            return field;
        }
        if (this.scope != null && this.scope.compilerOptions().sourceLevel >= 0x310000L && (field.getAnnotationTagBits() & 0x400000000000L) != 0L) {
            field.modifiers |= 0x100000;
        }
        if (this.isViewedAsDeprecated() && !field.isDeprecated()) {
            field.modifiers |= 0x200000;
        }
        if (this.hasRestrictedAccess()) {
            field.modifiers |= 0x40000;
        }
        return field;
    }

    public MethodBinding resolveTypesFor(MethodBinding method) {
        return this.resolveTypesFor(method, null);
    }

    public MethodBinding resolveTypesFor(MethodBinding method, AbstractMethodDeclaration methodDecl) {
        if ((method.modifiers & 0x2000000) == 0) {
            return method;
        }
        if (this.scope != null && this.scope.compilerOptions().sourceLevel >= 0x310000L && (method.getAnnotationTagBits() & 0x400000000000L) != 0L) {
            method.modifiers |= 0x100000;
        }
        if (this.isViewedAsDeprecated() && !method.isDeprecated()) {
            method.modifiers |= 0x200000;
        }
        if (this.hasRestrictedAccess()) {
            method.modifiers |= 0x40000;
        }
        if (methodDecl == null) {
            methodDecl = method.sourceMethod();
        }
        if (methodDecl == null) {
            return null;
        }
        methodDecl.typeParameters();
        boolean foundArgProblem = false;
        Argument[] arguments = methodDecl.arguments;
        if (arguments != null) {
            int size = arguments.length;
            method.parameters = Binding.NO_PARAMETERS;
            TypeBinding[] newParameters = new TypeBinding[size];
            int i = 0;
            while (i < size) {
                Argument arg = arguments[i];
                TypeBinding parameterType = TypeBinding.UNKNOWN;
                if (arg.type != null) {
                    parameterType = arg.type.resolveType(methodDecl.scope, true);
                } else if (arg.inferredType != null) {
                    parameterType = arg.inferredType.resolveType(methodDecl.scope, arg);
                }
                if (parameterType == null) {
                    parameterType = TypeBinding.ANY;
                }
                if (parameterType == TypeBinding.VOID) {
                    methodDecl.scope.problemReporter().argumentTypeCannotBeVoid(this, methodDecl, arg);
                    foundArgProblem = true;
                } else {
                    TypeBinding leafType = parameterType.leafComponentType();
                    if (leafType instanceof ReferenceBinding && (((ReferenceBinding)leafType).modifiers & 0x40000000) != 0) {
                        method.modifiers |= 0x40000000;
                    }
                    newParameters[i] = parameterType;
                    arg.binding = new LocalVariableBinding(arg, parameterType, arg.modifiers, true);
                }
                ++i;
            }
            if (!foundArgProblem) {
                method.parameters = newParameters;
            }
        }
        boolean foundReturnTypeProblem = false;
        if (!method.isConstructor()) {
            TypeReference returnType;
            TypeReference typeReference = returnType = methodDecl instanceof MethodDeclaration ? ((MethodDeclaration)methodDecl).returnType : null;
            if (returnType == null && !(methodDecl instanceof MethodDeclaration)) {
                methodDecl.scope.problemReporter().missingReturnType(methodDecl);
                method.returnType = null;
                foundReturnTypeProblem = true;
            } else {
                TypeBinding methodType;
                TypeBinding typeBinding = methodType = returnType != null ? returnType.resolveType(methodDecl.scope, true) : null;
                if (methodType == null) {
                    TypeBinding typeBinding2 = methodType = methodDecl.inferredType != null ? methodDecl.inferredType.resolveType(methodDecl.scope, methodDecl) : TypeBinding.UNKNOWN;
                }
                if (methodType == null) {
                    foundReturnTypeProblem = true;
                } else if (methodType.isArrayType() && ((ArrayBinding)methodType).leafComponentType == TypeBinding.VOID) {
                    methodDecl.scope.problemReporter().returnTypeCannotBeVoidArray((MethodDeclaration)methodDecl);
                    foundReturnTypeProblem = true;
                } else {
                    method.returnType = methodType;
                    TypeBinding leafType = methodType.leafComponentType();
                    if (leafType instanceof ReferenceBinding && (((ReferenceBinding)leafType).modifiers & 0x40000000) != 0) {
                        method.modifiers |= 0x40000000;
                    }
                }
            }
        }
        if (foundArgProblem) {
            methodDecl.binding = null;
            method.parameters = Binding.NO_PARAMETERS;
            return null;
        }
        if (foundReturnTypeProblem) {
            return method;
        }
        method.modifiers &= 0xFDFFFFFF;
        return method;
    }

    public AnnotationHolder retrieveAnnotationHolder(Binding binding, boolean forceInitialization) {
        if (forceInitialization) {
            binding.getAnnotationTagBits();
        }
        return super.retrieveAnnotationHolder(binding, false);
    }

    public void setFields(FieldBinding[] fields) {
        this.fields = fields;
    }

    public void setMethods(MethodBinding[] methods) {
        this.methods = methods;
    }

    public int sourceEnd() {
        if (this.classScope.referenceContext != null) {
            return this.classScope.referenceContext.sourceEnd;
        }
        return this.classScope.inferredType.sourceEnd;
    }

    public int sourceStart() {
        if (this.classScope.referenceContext != null) {
            return this.classScope.referenceContext.sourceStart;
        }
        return this.classScope.inferredType.sourceStart;
    }

    SimpleLookupTable storedAnnotations(boolean forceInitialize) {
        if (forceInitialize && this.storedAnnotations == null && this.scope != null) {
            this.scope.referenceCompilationUnit().compilationResult.hasAnnotations = true;
            if (!this.scope.environment().globalOptions.storeAnnotations) {
                return null;
            }
            this.storedAnnotations = new SimpleLookupTable(3);
        }
        return this.storedAnnotations;
    }

    public ReferenceBinding superclass() {
        if (this.nextType == null) {
            return this.superclass;
        }
        if (this.superclass != null && this.superclass.id != 1) {
            return this.superclass;
        }
        return this.nextType.superclass();
    }

    public ReferenceBinding[] superInterfaces() {
        return this.superInterfaces;
    }

    public SyntheticMethodBinding[] syntheticMethods() {
        if (this.synthetics == null || this.synthetics[0] == null || this.synthetics[0].size() == 0) {
            return null;
        }
        int index = 0;
        SyntheticMethodBinding[] bindings = new SyntheticMethodBinding[1];
        Iterator fieldsOrMethods = this.synthetics[0].keySet().iterator();
        while (fieldsOrMethods.hasNext()) {
            int numberOfAccessors;
            Object fieldOrMethod = fieldsOrMethods.next();
            if (fieldOrMethod instanceof MethodBinding) {
                SyntheticMethodBinding[] methodAccessors = (SyntheticMethodBinding[])this.synthetics[0].get(fieldOrMethod);
                numberOfAccessors = 0;
                if (methodAccessors[0] != null) {
                    ++numberOfAccessors;
                }
                if (methodAccessors[1] != null) {
                    ++numberOfAccessors;
                }
                if (index + numberOfAccessors > bindings.length) {
                    SyntheticMethodBinding[] syntheticMethodBindingArray = bindings;
                    bindings = new SyntheticMethodBinding[index + numberOfAccessors];
                    System.arraycopy(syntheticMethodBindingArray, 0, bindings, 0, index);
                }
                if (methodAccessors[0] != null) {
                    bindings[index++] = methodAccessors[0];
                }
                if (methodAccessors[1] == null) continue;
                bindings[index++] = methodAccessors[1];
                continue;
            }
            SyntheticMethodBinding[] fieldAccessors = (SyntheticMethodBinding[])this.synthetics[0].get(fieldOrMethod);
            numberOfAccessors = 0;
            if (fieldAccessors[0] != null) {
                ++numberOfAccessors;
            }
            if (fieldAccessors[1] != null) {
                ++numberOfAccessors;
            }
            if (index + numberOfAccessors > bindings.length) {
                SyntheticMethodBinding[] syntheticMethodBindingArray = bindings;
                bindings = new SyntheticMethodBinding[index + numberOfAccessors];
                System.arraycopy(syntheticMethodBindingArray, 0, bindings, 0, index);
            }
            if (fieldAccessors[0] != null) {
                bindings[index++] = fieldAccessors[0];
            }
            if (fieldAccessors[1] == null) continue;
            bindings[index++] = fieldAccessors[1];
        }
        int length = bindings.length;
        SyntheticMethodBinding[] sortedBindings = new SyntheticMethodBinding[length];
        int i = 0;
        while (i < length) {
            SyntheticMethodBinding binding;
            sortedBindings[binding.index] = binding = bindings[i];
            ++i;
        }
        return sortedBindings;
    }

    public FieldBinding[] syntheticFields() {
        SyntheticFieldBinding synthBinding;
        int i;
        Iterator elements;
        int literalSize;
        if (this.synthetics == null) {
            return null;
        }
        int fieldSize = this.synthetics[1] == null ? 0 : this.synthetics[1].size();
        int totalSize = fieldSize + (literalSize = this.synthetics[2] == null ? 0 : this.synthetics[2].size());
        if (totalSize == 0) {
            return null;
        }
        FieldBinding[] bindings = new FieldBinding[totalSize];
        if (this.synthetics[1] != null) {
            elements = this.synthetics[1].values().iterator();
            i = 0;
            while (i < fieldSize) {
                synthBinding = (SyntheticFieldBinding)elements.next();
                bindings[synthBinding.index] = synthBinding;
                ++i;
            }
        }
        if (this.synthetics[2] != null) {
            elements = this.synthetics[2].values().iterator();
            i = 0;
            while (i < literalSize) {
                synthBinding = (SyntheticFieldBinding)elements.next();
                bindings[fieldSize + synthBinding.index] = synthBinding;
                ++i;
            }
        }
        return bindings;
    }

    public String toString() {
        int length;
        int i;
        StringBuffer buffer = new StringBuffer(30);
        buffer.append("(id=");
        if (this.id == Integer.MAX_VALUE) {
            buffer.append("NoId");
        } else {
            buffer.append(this.id);
        }
        buffer.append(")\n");
        if (this.isDeprecated()) {
            buffer.append("deprecated ");
        }
        if (this.isPublic()) {
            buffer.append("public ");
        }
        if (this.isProtected()) {
            buffer.append("protected ");
        }
        if (this.isPrivate()) {
            buffer.append("private ");
        }
        if (this.isAbstract() && this.isClass()) {
            buffer.append("abstract ");
        }
        if (this.isStatic() && this.isNestedType()) {
            buffer.append("static ");
        }
        if (this.isFinal()) {
            buffer.append("final ");
        }
        if (this.isEnum()) {
            buffer.append("enum ");
        } else if (this.isAnnotationType()) {
            buffer.append("@interface ");
        } else if (this.isClass()) {
            buffer.append("class ");
        } else {
            buffer.append("interface ");
        }
        buffer.append(this.compoundName != null ? CharOperation.toString(this.compoundName) : "UNNAMED TYPE");
        if (this.typeVariables == null) {
            buffer.append("<NULL TYPE VARIABLES>");
        } else if (this.typeVariables != Binding.NO_TYPE_VARIABLES) {
            buffer.append("\n\t<");
            i = 0;
            length = this.typeVariables.length;
            while (i < length) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(this.typeVariables[i] != null ? this.typeVariables[i].toString() : "NULL TYPE VARIABLE");
                ++i;
            }
            buffer.append(">");
        }
        buffer.append("\n\textends ");
        buffer.append(this.superclass != null ? this.superclass.debugName() : "NULL TYPE");
        if (this.superInterfaces != null) {
            if (this.superInterfaces != Binding.NO_SUPERINTERFACES) {
                buffer.append("\n\timplements : ");
                i = 0;
                length = this.superInterfaces.length;
                while (i < length) {
                    if (i > 0) {
                        buffer.append(", ");
                    }
                    buffer.append(this.superInterfaces[i] != null ? this.superInterfaces[i].debugName() : "NULL TYPE");
                    ++i;
                }
            }
        } else {
            buffer.append("NULL SUPERINTERFACES");
        }
        if (this.enclosingType() != null) {
            buffer.append("\n\tenclosing type : ");
            buffer.append(this.enclosingType().debugName());
        }
        if (this.fields != null) {
            if (this.fields != Binding.NO_FIELDS) {
                buffer.append("\n/*   fields   */");
                i = 0;
                length = this.fields.length;
                while (i < length) {
                    buffer.append('\n').append(this.fields[i] != null ? this.fields[i].toString() : "NULL FIELD");
                    ++i;
                }
            }
        } else {
            buffer.append("NULL FIELDS");
        }
        if (this.methods != null) {
            if (this.methods != Binding.NO_METHODS) {
                buffer.append("\n/*   methods   */");
                i = 0;
                length = this.methods.length;
                while (i < length) {
                    buffer.append('\n').append(this.methods[i] != null ? this.methods[i].toString() : "NULL METHOD");
                    ++i;
                }
            }
        } else {
            buffer.append("NULL METHODS");
        }
        if (this.memberTypes != null) {
            if (this.memberTypes != Binding.NO_MEMBER_TYPES) {
                buffer.append("\n/*   members   */");
                i = 0;
                length = this.memberTypes.length;
                while (i < length) {
                    buffer.append('\n').append(this.memberTypes[i] != null ? this.memberTypes[i].toString() : "NULL TYPE");
                    ++i;
                }
            }
        } else {
            buffer.append("NULL MEMBER TYPES");
        }
        buffer.append("\n\n");
        return buffer.toString();
    }

    public TypeVariableBinding[] typeVariables() {
        return this.typeVariables;
    }

    void verifyMethods(MethodVerifier verifier) {
        verifier.verify(this);
    }

    public AbstractMethodDeclaration sourceMethod(MethodBinding binding) {
        if (this.classScope == null) {
            return null;
        }
        InferredType inferredType = this.classScope.inferredType;
        InferredMethod inferredMethod = inferredType.findMethod(binding.selector, null);
        if (inferredMethod != null) {
            return (AbstractMethodDeclaration)((Object)inferredMethod.getFunctionDeclaration());
        }
        return null;
    }

    public void addMethod(MethodBinding binding) {
        int length = this.methods.length;
        this.methods = new MethodBinding[length + 1];
        System.arraycopy(this.methods, 0, this.methods, 0, length);
        this.methods[length] = binding;
    }

    public void cleanup() {
        this.scope = null;
        this.classScope = null;
    }

    public boolean contains(ReferenceBinding binding) {
        if (binding == this) {
            return true;
        }
        if (this.nextType != null) {
            return this.nextType.contains(binding);
        }
        return false;
    }

    public void addNextType(SourceTypeBinding type) {
        SourceTypeBinding binding = this;
        while (binding.nextType != null) {
            binding = binding.nextType;
        }
        binding.nextType = type;
    }
}

