/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.actions.popup;

import java.util.Iterator;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.jdbc.JDBCCatalog;
import org.eclipse.datatools.connectivity.sqm.core.ui.explorer.virtual.IVirtualNode;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.actions.popup.RevisedAbstractAction;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.util.resources.ResourceLoader;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.actions.ActionFactory;

public class RevisedRefreshAction
extends RevisedAbstractAction {
    private IStructuredSelection selection;
    private StructuredViewer aViewer;

    public RevisedRefreshAction(StructuredViewer viewer) {
        this.setText(ResourceLoader.INSTANCE.queryString("DATATOOLS.SERVER.UI.EXPLORER.REFRESH"));
        this.setToolTipText(this.getText());
        this.setActionDefinitionId(ActionFactory.REFRESH.getId());
        this.setAccelerator(0x100000E);
        this.aViewer = viewer;
    }

    private void refreshCatalogObject(Object[] catalogObjects) {
        int i = 0;
        int n = catalogObjects.length;
        while (i < n) {
            if (catalogObjects[i] instanceof ICatalogObject) {
                ((ICatalogObject)catalogObjects[i]).refresh();
            }
            ++i;
        }
    }

    private void refreshVirtualNode(IVirtualNode virtualNode) {
        Object object = virtualNode.getParent();
        if (object != null && object instanceof JDBCCatalog && ((JDBCCatalog)object).getName().trim().length() == 0) {
            object = ((JDBCCatalog)object).getCatalogDatabase();
        }
        virtualNode.removeAllChildren();
        if (object instanceof ICatalogObject) {
            this.refreshCatalogObject((ICatalogObject)object);
        } else if (object instanceof IVirtualNode) {
            this.refreshVirtualNode((IVirtualNode)object);
        }
    }

    private void refreshCatalogObject(ICatalogObject catalogObject) {
        this.refreshCatalogObject(new ICatalogObject[]{catalogObject});
    }

    protected void setSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)selection;
        }
    }

    protected ISelection getSelection() {
        return this.selection;
    }

    public void selectionChanged(IAction action, ISelection sel) {
        if (sel instanceof IStructuredSelection && action != null) {
            if (((IStructuredSelection)sel).size() == 1) {
                action.setEnabled(true);
            } else {
                action.setEnabled(false);
            }
        }
        this.setSelection(sel);
    }

    public void run() {
        if (this.aViewer != null) {
            this.setSelection(this.aViewer.getSelection());
        }
        Iterator iterator = ((IStructuredSelection)this.getSelection()).iterator();
        while (iterator.hasNext()) {
            Object selectedObject = iterator.next();
            if (selectedObject instanceof IVirtualNode) {
                this.refreshVirtualNode((IVirtualNode)selectedObject);
                continue;
            }
            if (!(selectedObject instanceof ICatalogObject)) continue;
            this.refreshCatalogObject((ICatalogObject)selectedObject);
        }
    }
}

