/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.actions;

import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.preview.Activator;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.ReportEngine;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.viewer.utilities.WebViewer;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;
import org.eclipse.ui.forms.editor.FormEditor;

public class PreviewCascadingMenuGroup
implements IWorkbenchWindowPulldownDelegate2 {
    private Image previewIcon = Activator.getImageDescriptor("icons/etool16/preview.gif").createImage();
    private Image previewPDFIcon = Activator.getImageDescriptor("icons/etool16/preview_pdf.gif").createImage();
    private Image previewDOCIcon = Activator.getImageDescriptor("icons/etool16/preview_doc.gif").createImage();
    private Menu fMenu;

    public void dispose() {
        this.previewIcon.dispose();
        this.previewPDFIcon.dispose();
        this.previewDOCIcon.dispose();
    }

    public Menu getMenu(Control parent) {
        Menu menu;
        this.fMenu = menu = new Menu(parent);
        this.fillMenu(this.fMenu);
        return this.fMenu;
    }

    public Menu getMenu(Menu parent) {
        Menu menu;
        this.fMenu = menu = new Menu(parent);
        this.fillMenu(this.fMenu);
        return this.fMenu;
    }

    protected void fillMenu(Menu menu) {
        ReportEngine engine = new ReportEngine(new EngineConfig());
        Object[] supportedFormats = engine.getSupportedFormats();
        Arrays.sort(supportedFormats);
        MenuItem previewWebViewer = new MenuItem(menu, 8);
        previewWebViewer.setText("&1 " + Messages.getString((String)"designer.preview.run.webviewer"));
        previewWebViewer.setImage(this.previewIcon);
        previewWebViewer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreviewCascadingMenuGroup.this.preview("html", true);
            }
        });
        int i = 0;
        while (i < supportedFormats.length) {
            Object format = supportedFormats[i];
            MenuItem previewOption = new MenuItem(menu, 8);
            String indexPrefix = i > 7 ? " " : "&" + (i + 2);
            previewOption.setText(String.valueOf(indexPrefix) + " " + Messages.getFormattedString((String)"designer.preview.run", (Object[])new Object[]{((String)format).toUpperCase()}));
            if (((String)format).equals("pdf")) {
                previewOption.setImage(this.previewPDFIcon);
            } else if (((String)format).equals("doc")) {
                previewOption.setImage(this.previewDOCIcon);
            } else {
                previewOption.setImage(this.previewIcon);
            }
            previewOption.addSelectionListener((SelectionListener)new SelectionAdapter((String)format){
                private final /* synthetic */ String val$format;
                {
                    this.val$format = string;
                }

                public void widgetSelected(SelectionEvent e) {
                    PreviewCascadingMenuGroup.this.preview(this.val$format, false);
                }
            });
            ++i;
        }
    }

    protected boolean prePreview() {
        System.clearProperty("TransientSecurityID");
        System.clearProperty("MaxDataSetRows");
        System.clearProperty("MaxCubeRowLevels");
        System.clearProperty("MaxCubeColumnLevels");
        return true;
    }

    protected void preview(String format, boolean allowPage) {
        if (!this.prePreview()) {
            return;
        }
        FormEditor editor = UIUtil.getActiveReportEditor((boolean)false);
        ModuleHandle model = SessionHandleAdapter.getInstance().getReportDesignHandle();
        if (editor != null && model.needsSave()) {
            editor.doSave(null);
        }
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("FORMAT_KEY", format);
        options.put("ALLOW_PAGE_KEY", allowPage);
        options.put("RESOURCE_FOLDER_KEY", ReportPlugin.getDefault().getResourceFolder());
        WebViewer.display((String)model.getFileName(), options);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(this.isEnable());
    }

    private boolean isEnable() {
        IContentType[] contentTypes;
        IEditorPart editor = UIUtil.getActiveEditor((boolean)true);
        return editor != null && (contentTypes = Platform.getContentTypeManager().findContentTypesFor(editor.getEditorInput().getName())).length > 0 && contentTypes[0] != null && (contentTypes[0].getId().equals("org.eclipse.birt.report.designer.ui.editors.reportdesign") || contentTypes[0].getId().equals("org.eclipse.birt.report.designer.ui.editors.reporttemplate"));
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
    }
}

