/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.ide.navigator;

import java.util.HashMap;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.actions.IPreviewAction;
import org.eclipse.birt.report.designer.ui.ide.navigator.AbstractViewAction;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.birt.report.viewer.utilities.WebViewer;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;

public class GenerateDocumentAction
extends AbstractViewAction {
    protected boolean preGenerate() {
        System.clearProperty("MaxDataSetRows");
        System.clearProperty("MaxCubeRowLevels");
        System.clearProperty("MaxCubeColumnLevels");
        return true;
    }

    public void run(IAction action) {
        if (!this.preGenerate()) {
            return;
        }
        IFile file = this.getSelectedFile();
        if (file != null) {
            String url = file.getLocation().toOSString();
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("RESOURCE_FOLDER_KEY", ReportPlugin.getDefault().getResourceFolder(file.getProject()));
            options.put("SERVLET_NAME_KEY", "document");
            Object adapter = ElementAdapterManager.getAdapter((Object)action, IPreviewAction.class);
            if (adapter instanceof IPreviewAction) {
                IPreviewAction delegate = (IPreviewAction)adapter;
                delegate.setProperty("ReportPreviewOptions", options);
                delegate.setProperty("ReportFilePath", url);
                delegate.run();
                return;
            }
            try {
                WebViewer.display((String)url, options);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
                return;
            }
        } else {
            action.setEnabled(false);
        }
    }
}

