/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.observable.masterdetail;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.runtime.Assert;

public class DetailObservableValue
extends AbstractObservableValue
implements IObserving {
    private boolean updating = false;
    private IValueChangeListener innerChangeListener = new IValueChangeListener(){

        public void handleValueChange(ValueChangeEvent event) {
            if (!DetailObservableValue.this.updating) {
                DetailObservableValue.this.fireValueChange(event.diff);
            }
        }
    };
    private Object currentOuterValue;
    private IObservableValue innerObservableValue;
    private Object detailType;
    private IObservableValue outerObservableValue;
    private IObservableFactory factory;
    IValueChangeListener outerChangeListener = new IValueChangeListener(){

        public void handleValueChange(ValueChangeEvent event) {
            Object oldValue = DetailObservableValue.this.doGetValue();
            DetailObservableValue.this.updateInnerObservableValue(DetailObservableValue.this.outerObservableValue);
            DetailObservableValue.this.fireValueChange(Diffs.createValueDiff(oldValue, DetailObservableValue.this.doGetValue()));
        }
    };

    public DetailObservableValue(IObservableValue outerObservableValue, IObservableFactory factory, Object detailType) {
        super(outerObservableValue.getRealm());
        this.factory = factory;
        this.detailType = detailType;
        this.outerObservableValue = outerObservableValue;
        this.updateInnerObservableValue(outerObservableValue);
        outerObservableValue.addValueChangeListener(this.outerChangeListener);
    }

    private void updateInnerObservableValue(IObservableValue outerObservableValue) {
        this.currentOuterValue = outerObservableValue.getValue();
        if (this.innerObservableValue != null) {
            this.innerObservableValue.removeValueChangeListener(this.innerChangeListener);
            this.innerObservableValue.dispose();
        }
        if (this.currentOuterValue == null) {
            this.innerObservableValue = null;
        } else {
            this.innerObservableValue = (IObservableValue)this.factory.createObservable(this.currentOuterValue);
            Object innerValueType = this.innerObservableValue.getValueType();
            if (this.detailType != null) {
                Assert.isTrue((boolean)this.detailType.equals(innerValueType), (String)("Cannot change value type in a nested observable value, from " + innerValueType + " to " + this.detailType));
            }
            this.innerObservableValue.addValueChangeListener(this.innerChangeListener);
        }
    }

    public void doSetValue(Object value) {
        if (this.innerObservableValue != null) {
            this.innerObservableValue.setValue(value);
        }
    }

    public Object doGetValue() {
        return this.innerObservableValue == null ? null : this.innerObservableValue.getValue();
    }

    public Object getValueType() {
        return this.detailType;
    }

    public void dispose() {
        super.dispose();
        if (this.outerObservableValue != null) {
            this.outerObservableValue.removeValueChangeListener(this.outerChangeListener);
        }
        if (this.innerObservableValue != null) {
            this.innerObservableValue.removeValueChangeListener(this.innerChangeListener);
            this.innerObservableValue.dispose();
        }
        this.outerObservableValue = null;
        this.outerChangeListener = null;
        this.currentOuterValue = null;
        this.factory = null;
        this.innerObservableValue = null;
        this.innerChangeListener = null;
    }

    public Object getObserved() {
        if (this.innerObservableValue instanceof IObserving) {
            return ((IObserving)((Object)this.innerObservableValue)).getObserved();
        }
        return null;
    }
}

