/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.IncludedCssStyleSheetHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.birt.report.model.api.elements.structures.IncludedCssStyleSheet;
import org.eclipse.birt.report.model.api.elements.structures.TOC;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.css.CssStyleSheet;
import org.eclipse.birt.report.model.css.CssStyleSheetHandleAdapter;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.interfaces.IReportDesignModel;
import org.eclipse.birt.report.model.util.CommandLabelFactory;
import org.eclipse.birt.report.model.util.LevelContentIterator;
import org.eclipse.birt.report.model.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportDesignHandle
extends ModuleHandle
implements IReportDesignModel {
    public ReportDesignHandle(ReportDesign design) {
        super(design);
    }

    public String getAfterFactory() {
        return this.getStringProperty("afterFactory");
    }

    public String getAfterRender() {
        return this.getStringProperty("afterRender");
    }

    public String getBase() {
        return this.module.getStringProperty(this.module, "base");
    }

    public String getBeforeFactory() {
        return this.getStringProperty("beforeFactory");
    }

    public String getBeforeRender() {
        return this.getStringProperty("beforeRender");
    }

    public SlotHandle getBody() {
        return this.getSlot(6);
    }

    public int getRefreshRate() {
        return this.getIntProperty("refreshRate");
    }

    public SlotHandle getScratchPad() {
        return this.getSlot(7);
    }

    public Iterator includeLibraryScriptsIterator() {
        List libList = this.module.getAllLibraries();
        ArrayList includeLibScriptList = new ArrayList();
        if (libList != null) {
            int i = 0;
            while (i < libList.size()) {
                Library lib = (Library)libList.get(i);
                PropertyHandle propHandle = lib.getHandle(lib).getPropertyHandle("includeScripts");
                Iterator scriptIter = propHandle.iterator();
                while (scriptIter.hasNext()) {
                    includeLibScriptList.add(scriptIter.next());
                }
                ++i;
            }
        }
        return includeLibScriptList.iterator();
    }

    public void setAfterFactory(String value) {
        block2: {
            try {
                this.setStringProperty("afterFactory", value);
            }
            catch (SemanticException semanticException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    public void setAfterRender(String value) {
        block2: {
            try {
                this.setStringProperty("afterRender", value);
            }
            catch (SemanticException semanticException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    public void setBase(String base) {
        block2: {
            try {
                this.setProperty("base", base);
            }
            catch (SemanticException semanticException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    public void setBeforeFactory(String value) {
        block2: {
            try {
                this.setStringProperty("beforeFactory", value);
            }
            catch (SemanticException semanticException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    public void setBeforeRender(String value) {
        block2: {
            try {
                this.setStringProperty("beforeRender", value);
            }
            catch (SemanticException semanticException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    public void setRefreshRate(int rate) {
        block2: {
            try {
                this.setIntProperty("refreshRate", rate);
            }
            catch (SemanticException semanticException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    @Override
    public SlotHandle getStyles() {
        return this.getSlot(0);
    }

    public List getAllCssStyleSheets() {
        ReportDesign design = (ReportDesign)this.getElement();
        ArrayList<CssStyleSheetHandle> allStyles = new ArrayList<CssStyleSheetHandle>();
        List csses = design.getCsses();
        int i = 0;
        while (csses != null && i < csses.size()) {
            CssStyleSheet sheet = (CssStyleSheet)csses.get(i);
            allStyles.add(sheet.handle(this.getModule()));
            ++i;
        }
        return allStyles;
    }

    @Override
    public void importCssStyles(CssStyleSheetHandle stylesheet, List selectedStyles) {
        ActivityStack stack = this.module.getActivityStack();
        stack.startTrans(CommandLabelFactory.getCommandLabel("Message.ImportCSSStyles"));
        int i = 0;
        while (i < selectedStyles.size()) {
            block7: {
                SharedStyleHandle style = (SharedStyleHandle)selectedStyles.get(i);
                if (stylesheet.findStyle(style.getName()) != null) {
                    SharedStyleHandle newStyle = ModelUtil.TransferCssStyleToSharedStyle(this.module, style);
                    this.module.makeUniqueName(newStyle.getElement());
                    if (newStyle != null) {
                        try {
                            this.addElement(newStyle, 0);
                        }
                        catch (ContentException contentException) {
                            assert (false);
                        }
                        catch (NameException nameException) {
                            if ($assertionsDisabled) break block7;
                            throw new AssertionError();
                        }
                    }
                }
            }
            ++i;
        }
        stack.commit();
    }

    public void setDisplayNameKey(String displayNameKey) throws SemanticException {
        this.setStringProperty("displayNameID", displayNameKey);
    }

    public String getDisplayNameKey() {
        return this.getStringProperty("displayNameID");
    }

    public void setDisplayName(String displayName) throws SemanticException {
        this.setStringProperty("displayName", displayName);
    }

    public String getDisplayName() {
        return this.getStringProperty("displayName");
    }

    public void setIconFile(String iconFile) throws SemanticException {
        this.setStringProperty("iconFile", iconFile);
    }

    public String getIconFile() {
        return this.getStringProperty("iconFile");
    }

    public void setCheatSheet(String cheatSheet) throws SemanticException {
        this.setStringProperty("cheatSheet", cheatSheet);
    }

    public String getCheatSheet() {
        return this.getStringProperty("cheatSheet");
    }

    public void setThumbnail(byte[] data) throws SemanticException {
        block2: {
            try {
                this.setStringProperty("thumbnail", new String(data, "8859_1"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    public byte[] getThumbnail() {
        return ((ReportDesign)this.module).getThumbnail();
    }

    public void deleteThumbnail() throws SemanticException {
        this.clearProperty("thumbnail");
    }

    public List getAllBookmarks() {
        return ((ReportDesign)this.module).collectPropValues(6, "bookmark");
    }

    public List getAllTocs() {
        List tocs = ((ReportDesign)this.module).collectPropValues(6, "toc");
        ArrayList<Object> resultList = new ArrayList<Object>();
        for (TOC toc : tocs) {
            resultList.add(toc.getProperty(this.module, "expressionValue"));
        }
        return resultList;
    }

    public List getReportItemsBasedonTempalates() {
        ArrayList<DesignElementHandle> rtnList = new ArrayList<DesignElementHandle>();
        ArrayList tempList = new ArrayList();
        List contents = new ContainerContext(this.getElement(), 6).getContents(this.module);
        contents.addAll(new ContainerContext(this.getElement(), 4).getContents(this.module));
        this.findTemplateItemIn(contents.iterator(), tempList);
        Iterator iter = tempList.iterator();
        while (iter.hasNext()) {
            rtnList.add(((DesignElement)iter.next()).getHandle(this.module));
        }
        return Collections.unmodifiableList(rtnList);
    }

    private void findTemplateItemIn(Iterator contents, List addTo) {
        while (contents.hasNext()) {
            DesignElement e = (DesignElement)contents.next();
            if (e.isTemplateParameterValue(this.module)) {
                addTo.add(e);
                continue;
            }
            LevelContentIterator children = new LevelContentIterator(this.module, e, 1);
            this.findTemplateItemIn(children, addTo);
        }
    }

    @Override
    public SlotHandle getCubes() {
        return this.getSlot(9);
    }

    public String getLayoutPreference() {
        return this.getStringProperty("layoutPreference");
    }

    public void setLayoutPreference(String layout) throws SemanticException {
        this.setStringProperty("layoutPreference", layout);
    }

    public Iterator includeCssesIterator() {
        PropertyHandle propHandle = this.getPropertyHandle("cssStyleSheets");
        assert (propHandle != null);
        return propHandle.iterator();
    }

    public IncludedCssStyleSheetHandle findIncludedCssStyleSheetHandleByFileName(String fileName) {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        return adapter.findIncludedCssStyleSheetHandleByFileName(fileName);
    }

    public CssStyleSheetHandle findCssStyleSheetHandleByFileName(String fileName) {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        return adapter.findCssStyleSheetHandleByFileName(fileName);
    }

    public void addCss(CssStyleSheetHandle sheetHandle) throws SemanticException {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        adapter.addCss(sheetHandle);
    }

    public void addCss(String fileName) throws SemanticException {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        adapter.addCss(fileName);
    }

    public void addCss(IncludedCssStyleSheet cssStruct) throws SemanticException {
        if (cssStruct == null) {
            return;
        }
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        adapter.addCss(cssStruct);
    }

    public void renameCss(IncludedCssStyleSheetHandle handle, String newFileName) throws SemanticException {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        adapter.renameCss(handle, newFileName);
    }

    public boolean canRenameCss(IncludedCssStyleSheetHandle handle, String newFileName) throws SemanticException {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        return adapter.canRenameCss(handle, newFileName);
    }

    public void dropCss(CssStyleSheetHandle sheetHandle) throws SemanticException {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        adapter.dropCss(sheetHandle);
    }

    public boolean canDropCssStyleSheet(CssStyleSheetHandle sheetHandle) {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        return adapter.canDropCssStyleSheet(sheetHandle);
    }

    public boolean canAddCssStyleSheet(CssStyleSheetHandle sheetHandle) {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        return adapter.canAddCssStyleSheet(sheetHandle);
    }

    public boolean canAddCssStyleSheet(String fileName) {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        return adapter.canAddCssStyleSheet(fileName);
    }

    public void reloadCss(CssStyleSheetHandle sheetHandle) throws SemanticException {
        CssStyleSheetHandleAdapter adapter = new CssStyleSheetHandleAdapter(this.module, this.getElement());
        adapter.reloadCss(sheetHandle);
    }

    public String getBidiOrientation() {
        return this.getStringProperty("bidiLayoutOrientation");
    }

    public void setBidiOrientation(String bidiOrientation) throws SemanticException {
        this.setStringProperty("bidiLayoutOrientation", bidiOrientation);
    }

    @Override
    public boolean isDirectionRTL() {
        return "rtl".equals(this.getBidiOrientation());
    }

    public boolean isEnableACL() {
        return this.getBooleanProperty("enableACL");
    }

    public void setEnableACL(boolean enableACL) throws SemanticException {
        this.setProperty("enableACL", enableACL);
    }

    public String getACLExpression() {
        return this.getStringProperty("ACLExpression");
    }

    public void setACLExpression(String expr) throws SemanticException {
        this.setStringProperty("ACLExpression", expr);
    }

    public boolean cascadeACL() {
        return this.getBooleanProperty("cascadeACL");
    }

    public void setCascadeACL(boolean cascadeACL) throws SemanticException {
        this.setProperty("cascadeACL", cascadeACL);
    }

    public List<IncludedCssStyleSheetHandle> getAllExternalIncludedCsses() {
        int i;
        List libs;
        ArrayList<IncludedCssStyleSheetHandle> ret = new ArrayList<IncludedCssStyleSheetHandle>();
        List values = this.getNativeStructureList("cssStyleSheets");
        if (values != null && !values.isEmpty()) {
            int i2 = 0;
            while (i2 < values.size()) {
                IncludedCssStyleSheetHandle sheetHandle = (IncludedCssStyleSheetHandle)values.get(i2);
                if (sheetHandle.getExternalCssURI() != null) {
                    ret.add(sheetHandle);
                }
                ++i2;
            }
        }
        ArrayList<ThemeHandle> themeList = new ArrayList<ThemeHandle>();
        ThemeHandle themeHandle = this.getTheme();
        if (themeHandle != null) {
            themeList.add(themeHandle);
        }
        if ((libs = this.getAllLibraries()) != null) {
            i = 0;
            while (i < libs.size()) {
                LibraryHandle libHandle = (LibraryHandle)libs.get(i);
                themeHandle = libHandle.getTheme();
                if (themeHandle != null && !themeList.contains(themeHandle)) {
                    themeList.add(themeHandle);
                }
                ++i;
            }
        }
        i = 0;
        while (i < themeList.size()) {
            themeHandle = (ThemeHandle)themeList.get(i);
            Iterator iter = themeHandle.getPropertyHandle("cssStyleSheets").iterator();
            while (iter.hasNext()) {
                IncludedCssStyleSheetHandle sheetHandle = (IncludedCssStyleSheetHandle)iter.next();
                if (sheetHandle.getExternalCssURI() == null) continue;
                ret.add(sheetHandle);
            }
            ++i;
        }
        return ret;
    }
}

