/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.PropertyNameException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.IStructureDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.core.StructureContext;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.util.ModelUtil;

public class PropertyValueValidationUtil {
    private static Object validateStructure(DesignElementHandle element, ElementPropertyDefn propDefn, Object value) throws SemanticException {
        if (!(value instanceof IStructure)) {
            throw new PropertyValueException(value, "Error.PropertyValueException.INVALID_VALUE", 16);
        }
        IStructure item = (IStructure)value;
        if (item.getDefn() != propDefn.getStructDefn()) {
            throw new PropertyValueException(value, "Error.PropertyValueException.INVALID_VALUE", 16);
        }
        return PropertyValueValidationUtil.doValidateStructure(element, propDefn, null, item);
    }

    private static IStructure doValidateStructure(DesignElementHandle element, IPropertyDefn propDefn, IStructure parentStruct, IStructure item) throws SemanticException {
        IStructureDefn structDefn = propDefn.getStructDefn();
        Iterator iter = structDefn.propertiesIterator();
        while (iter.hasNext()) {
            PropertyDefn memberDefn = (PropertyDefn)iter.next();
            if (memberDefn.getTypeCode() == 16 && memberDefn.isList()) {
                PropertyValueValidationUtil.validateList(element, propDefn, item, memberDefn, ((Structure)item).getLocalProperty(element.getModule(), memberDefn));
                continue;
            }
            item.setProperty(memberDefn, memberDefn.validateValue(element.getModule(), ((Structure)item).getLocalProperty(element.getModule(), memberDefn)));
        }
        if (item instanceof Structure) {
            StructureContext context = null;
            context = parentStruct == null ? new StructureContext(element.getElement(), propDefn.getName()) : new StructureContext(parentStruct, propDefn.getName());
            ((Structure)item).setContext(context);
            List errorList = ((Structure)item).validate(element.getModule(), element.getElement());
            if (errorList.size() > 0) {
                throw (SemanticException)((Object)errorList.get(0));
            }
        }
        return item;
    }

    private static Object validateList(DesignElementHandle element, IPropertyDefn propDefn, IStructure item, IPropertyDefn memberDefn, Object value) throws SemanticException {
        if (!(value instanceof List)) {
            return null;
        }
        IPropertyDefn tmpPropDefn = propDefn;
        if (memberDefn != null) {
            tmpPropDefn = memberDefn;
        }
        assert (tmpPropDefn.isList());
        ArrayList<IStructure> retList = new ArrayList<IStructure>();
        List list = (List)value;
        IStructureDefn structDefn = tmpPropDefn.getStructDefn();
        int i = 0;
        while (i < list.size()) {
            IStructure tmpItem = (IStructure)list.get(i);
            if (tmpItem.getDefn() != structDefn) {
                if (memberDefn != null) {
                    throw new PropertyValueException(element.getElement(), propDefn, memberDefn, tmpItem, "Error.PropertyValueException.WRONG_ITEM_TYPE");
                }
                throw new PropertyValueException(element.getElement(), propDefn, (Object)tmpItem, "Error.PropertyValueException.WRONG_ITEM_TYPE");
            }
            retList.add(PropertyValueValidationUtil.doValidateStructure(element, tmpPropDefn, item, tmpItem));
            ++i;
        }
        return retList;
    }

    private static Object validateList(DesignElementHandle element, IPropertyDefn propDefn, Object value) throws SemanticException {
        return PropertyValueValidationUtil.validateList(element, propDefn, null, null, value);
    }

    public static Object validateProperty(DesignElementHandle element, String propName, Object propValue) throws SemanticException {
        ElementPropertyDefn propDefn = (ElementPropertyDefn)element.getPropertyDefn(propName);
        if (propDefn == null) {
            throw new PropertyNameException(element.getElement(), propName);
        }
        Object retValue = null;
        switch (propDefn.getTypeCode()) {
            case 17: {
                throw new PropertyValueException(propValue, "Error.PropertyValueException.INVALID_VALUE", propDefn.getTypeCode());
            }
            case 16: {
                if (propDefn.isList()) {
                    retValue = PropertyValueValidationUtil.validateList(element, propDefn, propValue);
                    break;
                }
                retValue = PropertyValueValidationUtil.validateStructure(element, propDefn, propValue);
                break;
            }
            default: {
                retValue = propDefn.validateValue(element.getModule(), propValue);
                if (retValue == null || !propDefn.isEncryptable()) break;
                String encrptID = element.getElement().getEncryptionID(propDefn);
                retValue = ModelUtil.encryptProperty(element.getElement(), propDefn, encrptID, retValue);
                element.setEncryption(propName, encrptID);
            }
        }
        return retValue;
    }
}

