/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.extension;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.model.api.extension.UndefinedPropertyInfo;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.extension.PeerExtensibilityProvider;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.parser.treebuild.ContentTree;
import org.eclipse.birt.report.model.util.ModelUtil;

public class SimplePeerExtensibilityProvider
extends PeerExtensibilityProvider {
    private LinkedHashMap invalidValueMap = null;
    private LinkedHashMap undefinedPropertyMap = null;
    private Map illegalChildrenMap = null;

    public SimplePeerExtensibilityProvider(DesignElement element, String extensionName) {
        super(element, extensionName);
    }

    public void handleInvalidPropertyValue(String propName, Object value) {
        assert (value != null);
        assert (propName != null);
        ElementPropertyDefn defn = this.element.getPropertyDefn(propName);
        if (defn.isExtended()) {
            if (this.invalidValueMap == null) {
                this.invalidValueMap = new LinkedHashMap();
            }
            String extensionVersion = this.element.getStringProperty(this.element.getRoot(), "extensionVersion");
            UndefinedPropertyInfo infor = new UndefinedPropertyInfo(propName, value, extensionVersion);
            this.invalidValueMap.put(propName, infor);
        }
    }

    public void handleIllegalChildren(String propName, DesignElement child) {
        ArrayList<UndefinedChildInfo> childList;
        ElementPropertyDefn propDefn = this.element.getPropertyDefn(propName);
        assert (propDefn != null);
        assert (child != null);
        if (this.illegalChildrenMap == null) {
            this.illegalChildrenMap = new HashMap();
        }
        if ((childList = (ArrayList<UndefinedChildInfo>)this.illegalChildrenMap.get(propName)) == null) {
            childList = new ArrayList<UndefinedChildInfo>();
        }
        int count = childList.size();
        List contents = (List)this.element.getProperty(null, propDefn);
        UndefinedChildInfo infor = new UndefinedChildInfo(child, count += contents == null ? 0 : contents.size());
        childList.add(infor);
        this.illegalChildrenMap.put(propName, childList);
    }

    public void handleUndefinedProperty(String propName, Object value) {
        assert (propName != null);
        assert (value != null);
        if (this.undefinedPropertyMap == null) {
            this.undefinedPropertyMap = new LinkedHashMap();
        }
        String extensionVersion = this.element.getStringProperty(this.element.getRoot(), "extensionVersion");
        UndefinedPropertyInfo infor = new UndefinedPropertyInfo(propName, value, extensionVersion);
        this.undefinedPropertyMap.put(propName, infor);
    }

    public ContentTree getContentTree() {
        return null;
    }

    public void copyFromWithNonElementType(PeerExtensibilityProvider source) {
        UndefinedPropertyInfo clonedInfor;
        UndefinedPropertyInfo infor;
        Iterator iter;
        super.copyFromWithNonElementType(source);
        SimplePeerExtensibilityProvider provider = (SimplePeerExtensibilityProvider)source;
        this.invalidValueMap = null;
        this.illegalChildrenMap = null;
        this.undefinedPropertyMap = null;
        if (provider.invalidValueMap != null && !provider.invalidValueMap.isEmpty()) {
            this.invalidValueMap = new LinkedHashMap();
            iter = provider.invalidValueMap.keySet().iterator();
            while (iter.hasNext()) {
                infor = (UndefinedPropertyInfo)provider.invalidValueMap.get(iter.next());
                if (infor == null) continue;
                clonedInfor = new UndefinedPropertyInfo(infor.getPropName(), infor.getValue(), infor.getExtensionVersion());
                this.invalidValueMap.put(clonedInfor.getPropName(), clonedInfor);
            }
        }
        if (provider.undefinedPropertyMap != null && !provider.undefinedPropertyMap.isEmpty()) {
            this.undefinedPropertyMap = new LinkedHashMap();
            iter = provider.undefinedPropertyMap.keySet().iterator();
            while (iter.hasNext()) {
                infor = (UndefinedPropertyInfo)provider.undefinedPropertyMap.get(iter.next());
                if (infor == null) continue;
                clonedInfor = new UndefinedPropertyInfo(infor.getPropName(), infor.getValue(), infor.getExtensionVersion());
                this.undefinedPropertyMap.put(clonedInfor.getPropName(), clonedInfor);
            }
        }
        if (provider.illegalChildrenMap != null && !provider.illegalChildrenMap.isEmpty()) {
            this.illegalChildrenMap = SimplePeerExtensibilityProvider.getCopiedIllegalContents(provider.illegalChildrenMap);
        }
    }

    public static Map getCopiedIllegalContents(Map illegalContentsMap) {
        if (illegalContentsMap == null || illegalContentsMap.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        HashMap ret = new HashMap();
        for (String propName : illegalContentsMap.keySet()) {
            List childList = (List)illegalContentsMap.get(propName);
            if (childList == null || childList.isEmpty()) continue;
            ArrayList<UndefinedChildInfo> clonedList = new ArrayList<UndefinedChildInfo>();
            int i = 0;
            while (i < childList.size()) {
                UndefinedChildInfo infor = (UndefinedChildInfo)childList.get(i);
                UndefinedChildInfo clonedInfor = new UndefinedChildInfo(null, -1);
                clonedInfor.copyFrom(infor);
                clonedList.add(clonedInfor);
                ++i;
            }
            ret.put(propName, clonedList);
        }
        return ret;
    }

    public Map getIllegalContents() {
        return this.illegalChildrenMap == null ? Collections.EMPTY_MAP : this.illegalChildrenMap;
    }

    public Map getInvalidPropertyValueMap() {
        return this.invalidValueMap == null ? Collections.EMPTY_MAP : this.invalidValueMap;
    }

    public Map getUndefinedPropertyMap() {
        return this.undefinedPropertyMap == null ? Collections.EMPTY_MAP : this.undefinedPropertyMap;
    }

    public static class UndefinedChildInfo {
        protected DesignElement child;
        protected int index;

        UndefinedChildInfo(DesignElement child, int index) {
            this.child = child;
            this.index = index;
        }

        void copyFrom(UndefinedChildInfo source) {
            if (source == null) {
                return;
            }
            this.child = source.child;
            this.index = source.index;
            if (this.child != null) {
                this.child = ModelUtil.getCopy(this.child);
            }
        }

        public DesignElement getChild() {
            return this.child;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

