/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClient;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClientManager;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaCorePlugin;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaLanguageSettings;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaTaskAttachmentHandler;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaTaskDataHandler;
import org.eclipse.mylyn.internal.bugzilla.core.UnrecognizedReponseException;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentHandler;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.eclipse.mylyn.tasks.core.data.TaskMapper;
import org.eclipse.mylyn.tasks.core.data.TaskRelation;
import org.eclipse.mylyn.tasks.core.sync.ISynchronizationSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugzillaRepositoryConnector
extends AbstractRepositoryConnector {
    private static final String BUG_ID = "&bug_id=";
    private static final String CHANGED_BUGS_CGI_ENDDATE = "&chfieldto=Now";
    private static final String CHANGED_BUGS_CGI_QUERY = "/buglist.cgi?query_format=advanced&chfieldfrom=";
    private static final String CLIENT_LABEL = "Bugzilla (supports uncustomized 2.18-3.0)";
    private static final String COMMENT_FORMAT = "yyyy-MM-dd HH:mm";
    private static final String DEADLINE_FORMAT = "yyyy-MM-dd";
    private final BugzillaTaskAttachmentHandler attachmentHandler = new BugzillaTaskAttachmentHandler(this);
    private final BugzillaTaskDataHandler taskDataHandler = new BugzillaTaskDataHandler(this);
    private BugzillaClientManager clientManager;
    private final Set<BugzillaLanguageSettings> languages = new LinkedHashSet<BugzillaLanguageSettings>();

    public String getLabel() {
        return CLIENT_LABEL;
    }

    public AbstractTaskAttachmentHandler getTaskAttachmentHandler() {
        return this.attachmentHandler;
    }

    public String getConnectorKind() {
        return "bugzilla";
    }

    public void updateTaskFromTaskData(TaskRepository repository, ITask task, TaskData taskData) {
        TaskMapper scheme = new TaskMapper(taskData);
        scheme.applyTo(task);
        task.setUrl(BugzillaClient.getBugUrlWithoutLogin(repository.getRepositoryUrl(), taskData.getTaskId()));
        boolean isComplete = false;
        TaskAttribute attributeStatus = taskData.getRoot().getMappedAttribute("task.common.status");
        if (attributeStatus != null) {
            boolean bl = isComplete = attributeStatus.getValue().equals("RESOLVED") || attributeStatus.getValue().equals("CLOSED") || attributeStatus.getValue().equals("VERIFIED");
        }
        if (taskData.isPartial()) {
            if (isComplete && task.getCompletionDate() == null) {
                task.setCompletionDate(new Date(0L));
            }
        } else {
            TaskAttribute attrSeverity;
            if (isComplete) {
                TaskAttribute attributeLastModified;
                TaskAttribute attributeCommentDate;
                TaskAttribute lastComment;
                Date completionDate = null;
                List taskComments = taskData.getAttributeMapper().getAttributesByType(taskData, "comment");
                if (taskComments != null && taskComments.size() > 0 && (lastComment = (TaskAttribute)taskComments.get(taskComments.size() - 1)) != null && (attributeCommentDate = lastComment.getMappedAttribute("task.common.comment.date")) != null) {
                    try {
                        completionDate = new SimpleDateFormat(COMMENT_FORMAT).parse(attributeCommentDate.getValue());
                    }
                    catch (ParseException parseException) {}
                }
                if (completionDate == null && (attributeLastModified = taskData.getRoot().getMappedAttribute("task.common.date.modified")) != null && attributeLastModified.getValue().length() > 0) {
                    completionDate = taskData.getAttributeMapper().getDateValue(attributeLastModified);
                }
                if (completionDate == null) {
                    completionDate = new Date();
                }
                task.setCompletionDate(completionDate);
            } else {
                task.setCompletionDate(null);
            }
            if (scheme.getProduct() != null) {
                task.setAttribute("task.common.product", scheme.getProduct());
            }
            if ((attrSeverity = taskData.getRoot().getMappedAttribute(BugzillaAttribute.BUG_SEVERITY.getKey())) != null && !attrSeverity.getValue().equals("")) {
                task.setAttribute(BugzillaAttribute.BUG_SEVERITY.getKey(), attrSeverity.getValue());
            }
            if (taskData.getRoot().getMappedAttribute(BugzillaAttribute.ESTIMATED_TIME.getKey()) != null) {
                Date dueDate = null;
                try {
                    TaskAttribute attributeDeadline = taskData.getRoot().getMappedAttribute(BugzillaAttribute.DEADLINE.getKey());
                    if (attributeDeadline != null) {
                        dueDate = new SimpleDateFormat(DEADLINE_FORMAT).parse(attributeDeadline.getValue());
                    }
                }
                catch (Exception exception) {}
                task.setDueDate(dueDate);
            }
        }
        this.updateExtendedAttributes(task, taskData);
    }

    private void updateExtendedAttributes(ITask task, TaskData taskData) {
        BugzillaAttribute[] bugzillaAttributeArray = BugzillaAttribute.EXTENDED_ATTRIBUTES;
        int n = BugzillaAttribute.EXTENDED_ATTRIBUTES.length;
        int n2 = 0;
        while (n2 < n) {
            BugzillaAttribute bugzillaReportElement = bugzillaAttributeArray[n2];
            TaskAttribute taskAttribute = taskData.getRoot().getAttribute(bugzillaReportElement.getKey());
            if (taskAttribute != null) {
                task.setAttribute(bugzillaReportElement.getKey(), taskAttribute.getValue());
            }
            ++n2;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void preSynchronization(ISynchronizationSession session, IProgressMonitor monitor) throws CoreException {
        repository = session.getTaskRepository();
        if (session.getTasks().isEmpty()) {
            return;
        }
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        try {
            monitor.beginTask("Checking for changed tasks", -1);
            if (repository.getSynchronizationTimeStamp() == null) {
                for (ITask task : session.getTasks()) {
                    session.markStale(task);
                }
                return;
            }
            try {
                dateString = repository.getSynchronizationTimeStamp();
                if (dateString == null) {
                    dateString = "";
                }
                urlQueryBase = String.valueOf(repository.getRepositoryUrl()) + "/buglist.cgi?query_format=advanced&chfieldfrom=" + URLEncoder.encode(dateString, repository.getCharacterEncoding()) + "&chfieldto=Now";
                urlQueryString = String.valueOf(urlQueryBase) + "&bug_id=";
                changedTasks = new HashSet<ITask>();
                itr = session.getTasks().iterator();
                queryCounter = 0;
                checking = new HashSet<ITask>();
                while (itr.hasNext()) {
                    task = (ITask)itr.next();
                    checking.add(task);
                    newurlQueryString = URLEncoder.encode(String.valueOf(task.getTaskId()) + ",", repository.getCharacterEncoding());
                    urlQueryString = String.valueOf(urlQueryString) + newurlQueryString;
                    if (++queryCounter >= 1000) {
                        this.queryForChanged(repository, changedTasks, urlQueryString, session);
                        queryCounter = 0;
                        urlQueryString = String.valueOf(urlQueryBase) + "&bug_id=";
                        newurlQueryString = "";
                    }
                    if (itr.hasNext() || queryCounter == 0) continue;
                    this.queryForChanged(repository, changedTasks, urlQueryString, session);
                }
                var12_15 = session.getTasks().iterator();
                while (true) {
                    if (!var12_15.hasNext()) ** continue;
                    task = (ITask)var12_15.next();
                    if (!changedTasks.contains(task)) ** continue;
                    session.markStale(task);
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.bugzilla", "Repository configured with unsupported encoding: " + repository.getCharacterEncoding() + "\n\n Unable to determine changed tasks.", (Throwable)e));
            }
        }
        finally {
            monitor.done();
        }
    }

    private void queryForChanged(TaskRepository repository, Set<ITask> changedTasks, String urlQueryString, ISynchronizationSession context) throws UnsupportedEncodingException, CoreException {
        HashMap<String, ITask> taskById = new HashMap<String, ITask>();
        for (ITask task : context.getTasks()) {
            taskById.put(task.getTaskId(), task);
        }
        final HashSet changedTaskData = new HashSet();
        TaskDataCollector collector = new TaskDataCollector(){

            public void accept(TaskData taskData) {
                changedTaskData.add(taskData);
            }
        };
        RepositoryQuery query = new RepositoryQuery(repository.getConnectorKind(), "");
        query.setSummary("Query for changed tasks");
        query.setUrl(urlQueryString);
        this.performQuery(repository, (IRepositoryQuery)query, collector, context, (IProgressMonitor)new NullProgressMonitor());
        for (TaskData data : changedTaskData) {
            ITask changedTask = (ITask)taskById.get(data.getTaskId());
            if (changedTask == null) continue;
            changedTasks.add(changedTask);
        }
    }

    public boolean canCreateTaskFromKey(TaskRepository repository) {
        return true;
    }

    public boolean canCreateNewTask(TaskRepository repository) {
        return true;
    }

    public IStatus performQuery(TaskRepository repository, IRepositoryQuery query, TaskDataCollector resultCollector, ISynchronizationSession event, IProgressMonitor monitor) {
        try {
            monitor.beginTask("Running query", -1);
            BugzillaClient client = this.getClientManager().getClient(repository, monitor);
            TaskAttributeMapper mapper = this.getTaskDataHandler().getAttributeMapper(repository);
            boolean hitsReceived = client.getSearchHits(query, resultCollector, mapper, monitor);
            if (!hitsReceived) {
                client.logout(monitor);
                client.getSearchHits(query, resultCollector, mapper, monitor);
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (UnrecognizedReponseException e) {
            Status status = new Status(4, "org.eclipse.mylyn.bugzilla", 1, "Unrecognized response from server", (Throwable)e);
            return status;
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.mylyn.bugzilla", 4, "Check repository configuration: " + e.getMessage(), (Throwable)e);
            return status;
        }
        catch (CoreException e) {
            IStatus iStatus = e.getStatus();
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    public String getRepositoryUrlFromTaskUrl(String url) {
        if (url == null) {
            return null;
        }
        int index = url.indexOf("/show_bug.cgi?id=");
        return index == -1 ? null : url.substring(0, index);
    }

    public String getTaskIdFromTaskUrl(String url) {
        int index;
        if (url == null) {
            return null;
        }
        int anchorIndex = url.lastIndexOf("#");
        String bugUrl = url;
        if (anchorIndex != -1) {
            bugUrl = url.substring(0, anchorIndex);
        }
        return (index = bugUrl.indexOf("/show_bug.cgi?id=")) == -1 ? null : bugUrl.substring(index + "/show_bug.cgi?id=".length());
    }

    public String getTaskUrl(String repositoryUrl, String taskId) {
        try {
            return BugzillaClient.getBugUrlWithoutLogin(repositoryUrl, taskId);
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.bugzilla", "Error constructing task url for " + repositoryUrl + "  id:" + taskId, (Throwable)e));
            return null;
        }
    }

    public String getTaskIdPrefix() {
        return "bug";
    }

    public BugzillaClientManager getClientManager() {
        if (this.clientManager == null) {
            this.clientManager = new BugzillaClientManager();
            BugzillaCorePlugin.setConnector(this);
            BugzillaLanguageSettings enSetting = new BugzillaLanguageSettings("en (default)");
            enSetting.addLanguageAttribute("error_login", "Login");
            enSetting.addLanguageAttribute("error_login", "log in");
            enSetting.addLanguageAttribute("error_login", "check e-mail");
            enSetting.addLanguageAttribute("error_login", "Invalid Username Or Password");
            enSetting.addLanguageAttribute("error_collision", "Mid-air collision!");
            enSetting.addLanguageAttribute("error_comment_required", "Comment Required");
            enSetting.addLanguageAttribute("error_logged_out", "logged out");
            enSetting.addLanguageAttribute("bad_login", "Login");
            enSetting.addLanguageAttribute("bad_login", "log in");
            enSetting.addLanguageAttribute("bad_login", "check e-mail");
            enSetting.addLanguageAttribute("bad_login", "Invalid Username Or Password");
            enSetting.addLanguageAttribute("bad_login", "error");
            enSetting.addLanguageAttribute("processed", "processed");
            enSetting.addLanguageAttribute("changes_submitted", "Changes submitted");
            this.languages.add(enSetting);
        }
        return this.clientManager;
    }

    public void updateRepositoryConfiguration(TaskRepository repository, IProgressMonitor monitor) throws CoreException {
        if (repository != null) {
            BugzillaCorePlugin.getRepositoryConfiguration(repository, true, monitor);
        }
    }

    public boolean isRepositoryConfigurationStale(TaskRepository repository, IProgressMonitor monitor) throws CoreException {
        if (super.isRepositoryConfigurationStale(repository, monitor)) {
            boolean result = true;
            try {
                String timestamp;
                BugzillaClient client = this.getClientManager().getClient(repository, monitor);
                if (client != null && (timestamp = client.getConfigurationTimestamp(monitor)) != null) {
                    String oldTimestamp = repository.getProperty("org.eclipse.mylyn.tasklist.repositories.config.timestamp");
                    if (oldTimestamp != null) {
                        result = !timestamp.equals(oldTimestamp);
                    }
                    repository.setProperty("org.eclipse.mylyn.tasklist.repositories.config.timestamp", timestamp);
                }
            }
            catch (MalformedURLException e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.bugzilla", "Error retrieving configuration timestamp for " + repository.getRepositoryUrl(), (Throwable)e));
            }
            return result;
        }
        return false;
    }

    public static int getBugId(String taskId) throws CoreException {
        try {
            return Integer.parseInt(taskId);
        }
        catch (NumberFormatException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.bugzilla", 0, "Invalid bug id: " + taskId, (Throwable)e));
        }
    }

    public void addLanguageSetting(BugzillaLanguageSettings language) {
        if (!this.languages.contains(language)) {
            this.languages.add(language);
        }
    }

    public Set<BugzillaLanguageSettings> getLanguageSettings() {
        return this.languages;
    }

    public BugzillaLanguageSettings getLanguageSetting(String label) {
        for (BugzillaLanguageSettings language : this.getLanguageSettings()) {
            if (!language.getLanguageName().equals(label)) continue;
            return language;
        }
        return BugzillaCorePlugin.getDefault().getLanguageSetting("en (default)");
    }

    public void postSynchronization(ISynchronizationSession event, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask("", 1);
            if (event.isFullSynchronization() && event.getStatus() == null) {
                event.getTaskRepository().setSynchronizationTimeStamp(this.getSynchronizationTimestamp(event));
            }
        }
        finally {
            monitor.done();
        }
    }

    public TaskData getTaskData(TaskRepository repository, String taskId, IProgressMonitor monitor) throws CoreException {
        return this.taskDataHandler.getTaskData(repository, taskId, monitor);
    }

    public AbstractTaskDataHandler getTaskDataHandler() {
        return this.taskDataHandler;
    }

    public boolean hasTaskChanged(TaskRepository taskRepository, ITask task, TaskData taskData) {
        TaskAttribute attrModification;
        if (taskData.isPartial()) {
            return false;
        }
        String lastKnownMod = task.getAttribute(BugzillaAttribute.DELTA_TS.getKey());
        if (lastKnownMod != null && (attrModification = taskData.getRoot().getMappedAttribute("task.common.date.modified")) != null) {
            return !lastKnownMod.equals(attrModification.getValue());
        }
        return true;
    }

    public Collection<TaskRelation> getTaskRelations(TaskData taskData) {
        ArrayList<TaskRelation> relations = new ArrayList<TaskRelation>();
        TaskAttribute attribute = taskData.getRoot().getAttribute(BugzillaAttribute.DEPENDSON.getKey());
        if (attribute != null && attribute.getValue().length() > 0) {
            String[] stringArray = attribute.getValue().split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String taskId = stringArray[n2];
                relations.add(TaskRelation.subtask((String)taskId.trim()));
                ++n2;
            }
        }
        return relations;
    }

    private String getSynchronizationTimestamp(ISynchronizationSession event) {
        Date mostRecent = new Date(0L);
        String mostRecentTimeStamp = event.getTaskRepository().getSynchronizationTimeStamp();
        for (ITask task : event.getChangedTasks()) {
            Date taskModifiedDate = task.getModificationDate();
            if (taskModifiedDate == null || !taskModifiedDate.after(mostRecent)) continue;
            mostRecent = taskModifiedDate;
            mostRecentTimeStamp = task.getAttribute(BugzillaAttribute.DELTA_TS.getKey());
        }
        return mostRecentTimeStamp;
    }

    public boolean hasRepositoryDueDate(TaskRepository taskRepository, ITask task, TaskData taskData) {
        return taskData.getRoot().getAttribute(BugzillaAttribute.ESTIMATED_TIME.getKey()) != null;
    }
}

