/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core;

import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import org.eclipse.mylyn.commons.net.HtmlStreamTokenizer;
import org.eclipse.mylyn.commons.net.HtmlTag;

public class XmlCleaner {
    public static StringBuffer clean(Reader in) {
        HtmlStreamTokenizer tokenizer = new HtmlStreamTokenizer(in, null);
        StringBuffer content = new StringBuffer();
        content.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        try {
            HtmlStreamTokenizer.Token token = tokenizer.nextToken();
            while (token.getType() != HtmlStreamTokenizer.Token.EOF) {
                if (token.getType() == HtmlStreamTokenizer.Token.TAG) {
                    String resourceID;
                    HtmlTag tag = (HtmlTag)token.getValue();
                    if (tag.getAttribute("resource") != null) {
                        resourceID = tag.getAttribute("resource");
                        tag.setAttribute("resource", resourceID.replace("&", "&amp;"));
                    }
                    if (tag.getAttribute("rdf:about") != null) {
                        resourceID = tag.getAttribute("rdf:about");
                        tag.setAttribute("rdf:about", resourceID.replace("&", "&amp;"));
                    }
                }
                if (!token.toString().startsWith("<?xml")) {
                    content.append(token.toString());
                }
                token = tokenizer.nextToken();
            }
        }
        catch (IOException iOException) {
        }
        catch (ParseException parseException) {}
        return content;
    }
}

