/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IBufferFactory;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.internal.corext.fix.CleanUpRegistry;
import org.eclipse.jdt.internal.corext.javadoc.JavaDocLocations;
import org.eclipse.jdt.internal.corext.template.java.AbstractJavaContextType;
import org.eclipse.jdt.internal.corext.template.java.CodeTemplateContextType;
import org.eclipse.jdt.internal.corext.template.java.CodeTemplates;
import org.eclipse.jdt.internal.corext.template.java.Templates;
import org.eclipse.jdt.internal.corext.util.OpenTypeHistory;
import org.eclipse.jdt.internal.corext.util.QualifiedTypeNameHistory;
import org.eclipse.jdt.internal.corext.util.TypeFilter;
import org.eclipse.jdt.internal.ui.CompatibilityTemplateStore;
import org.eclipse.jdt.internal.ui.InitializeAfterLoadJob;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.JavaUIPreferenceInitializer;
import org.eclipse.jdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.jdt.internal.ui.javaeditor.ClassFileDocumentProvider;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitDocumentProvider;
import org.eclipse.jdt.internal.ui.javaeditor.CustomBufferFactory;
import org.eclipse.jdt.internal.ui.javaeditor.DocumentAdapter;
import org.eclipse.jdt.internal.ui.javaeditor.ICompilationUnitDocumentProvider;
import org.eclipse.jdt.internal.ui.javaeditor.WorkingCopyManager;
import org.eclipse.jdt.internal.ui.javaeditor.saveparticipant.SaveParticipantRegistry;
import org.eclipse.jdt.internal.ui.preferences.MembersOrderPreferenceCache;
import org.eclipse.jdt.internal.ui.preferences.formatter.FormatterProfileStore;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.PropertiesFileDocumentProvider;
import org.eclipse.jdt.internal.ui.text.PreferencesAdapter;
import org.eclipse.jdt.internal.ui.text.folding.JavaFoldingStructureProviderRegistry;
import org.eclipse.jdt.internal.ui.text.java.ContentAssistHistory;
import org.eclipse.jdt.internal.ui.text.java.hover.JavaEditorTextHoverDescriptor;
import org.eclipse.jdt.internal.ui.text.spelling.SpellCheckEngine;
import org.eclipse.jdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jdt.internal.ui.viewsupport.ImagesOnFileSystemRegistry;
import org.eclipse.jdt.internal.ui.viewsupport.ProblemMarkerManager;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ClasspathAttributeConfigurationDescriptors;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.ConfigurationElementSorter;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.osgi.framework.BundleContext;

public class JavaPlugin
extends AbstractUIPlugin {
    private static final String TEMPLATES_KEY = "org.eclipse.jdt.ui.text.custom_templates";
    private static final String CODE_TEMPLATES_KEY = "org.eclipse.jdt.ui.text.custom_code_templates";
    private static final String TEMPLATES_MIGRATION_KEY = "org.eclipse.jdt.ui.text.templates_migrated";
    private static final String CODE_TEMPLATES_MIGRATION_KEY = "org.eclipse.jdt.ui.text.code_templates_migrated";
    private static JavaPlugin fgJavaPlugin;
    private static LinkedHashMap fgRepeatedMessages;
    private ContextTypeRegistry fContextTypeRegistry;
    private ContextTypeRegistry fCodeTemplateContextTypeRegistry;
    private TemplateStore fTemplateStore;
    private TemplateStore fCodeTemplateStore;
    private TypeFilter fTypeFilter;
    private WorkingCopyManager fWorkingCopyManager;
    private IBufferFactory fBufferFactory;
    private ICompilationUnitDocumentProvider fCompilationUnitDocumentProvider;
    private ClassFileDocumentProvider fClassFileDocumentProvider;
    private JavaTextTools fJavaTextTools;
    private ProblemMarkerManager fProblemMarkerManager;
    private ImageDescriptorRegistry fImageDescriptorRegistry;
    private MembersOrderPreferenceCache fMembersOrderPreferenceCache;
    private IPropertyChangeListener fFontPropertyChangeListener;
    private IPropertyChangeListener fPropertyChangeListener;
    private JavaEditorTextHoverDescriptor[] fJavaEditorTextHoverDescriptors;
    private ASTProvider fASTProvider;
    private IPreferenceStore fCombinedPreferenceStore;
    private JavaFoldingStructureProviderRegistry fFoldingStructureProviderRegistry;
    private IDocumentProvider fPropertiesFileDocumentProvider;
    private ContentAssistHistory fContentAssistHistory;
    private SaveParticipantRegistry fSaveParticipantRegistry;
    private CleanUpRegistry fCleanUpRegistry;
    private ClasspathAttributeConfigurationDescriptors fClasspathAttributeConfigurationDescriptors;
    private FormToolkit fDialogsFormToolkit;
    private ImagesOnFileSystemRegistry fImagesOnFSRegistry;
    private IPropertyChangeListener fThemeListener;
    private static final String DEPRECATED_EDITOR_TAB_WIDTH = "org.eclipse.jdt.ui.editor.tab.width";
    private static final String DEPRECATED_REFACTOR_ERROR_PAGE_SEVERITY_THRESHOLD = "Refactoring.ErrorPage.severityThreshold";
    private static final String DEPRECATED_CODEASSIST_ORDER_PROPOSALS = "content_assist_order_proposals";
    static /* synthetic */ Class class$0;

    static {
        fgRepeatedMessages = new LinkedHashMap(20, 0.75f, true){
            private static final long serialVersionUID = 1L;

            protected boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() >= 20;
            }
        };
    }

    public static JavaPlugin getDefault() {
        return fgJavaPlugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static IWorkbenchPage getActivePage() {
        return JavaPlugin.getDefault().internalGetActivePage();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return JavaPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = JavaPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static String getPluginId() {
        return "org.eclipse.jdt.ui";
    }

    public static void log(IStatus status) {
        JavaPlugin.getDefault().getLog().log(status);
    }

    public static void logErrorMessage(String message) {
        JavaPlugin.log((IStatus)new Status(4, JavaPlugin.getPluginId(), 10001, message, null));
    }

    public static void logErrorStatus(String message, IStatus status) {
        if (status == null) {
            JavaPlugin.logErrorMessage(message);
            return;
        }
        MultiStatus multi = new MultiStatus(JavaPlugin.getPluginId(), 10001, message, null);
        multi.add(status);
        JavaPlugin.log((IStatus)multi);
    }

    public static void log(Throwable e) {
        JavaPlugin.log((IStatus)new Status(4, JavaPlugin.getPluginId(), 10001, JavaUIMessages.JavaPlugin_internal_error, e));
    }

    public static void logRepeatedMessage(String message, String detail) {
        long now = System.currentTimeMillis();
        boolean writeToLog = true;
        if (fgRepeatedMessages.containsKey(message)) {
            long last = (Long)fgRepeatedMessages.get(message);
            writeToLog = now - last > 5000L;
        }
        fgRepeatedMessages.put(message, new Long(now));
        if (writeToLog) {
            JavaPlugin.log(new Exception(String.valueOf(message) + detail).fillInStackTrace());
        }
    }

    public static boolean isDebug() {
        return JavaPlugin.getDefault().isDebugging();
    }

    public static ImageDescriptorRegistry getImageDescriptorRegistry() {
        return JavaPlugin.getDefault().internalGetImageDescriptorRegistry();
    }

    public JavaPlugin() {
        fgJavaPlugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        WorkingCopyOwner.setPrimaryBufferProvider((WorkingCopyOwner)new WorkingCopyOwner(){

            public IBuffer createBuffer(ICompilationUnit workingCopy) {
                ICompilationUnit original = workingCopy.getPrimary();
                IResource resource = original.getResource();
                if (resource instanceof IFile) {
                    return new DocumentAdapter((IOpenable)workingCopy, (IFile)resource);
                }
                return DocumentAdapter.NULL;
            }
        });
        this.ensurePreferenceStoreBackwardsCompatibility();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.manipulation.JavaManipulation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        clazz.toString();
        if (PlatformUI.isWorkbenchRunning()) {
            this.getASTProvider();
            this.fThemeListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if ("CHANGE_CURRENT_THEME".equals(event.getProperty())) {
                        JavaUIPreferenceInitializer.setThemeBasedPreferences(PreferenceConstants.getPreferenceStore(), true);
                    }
                }
            };
            PlatformUI.getWorkbench().getThemeManager().addPropertyChangeListener(this.fThemeListener);
            new InitializeAfterLoadJob().schedule();
        }
    }

    static void initializeAfterLoad(IProgressMonitor monitor) {
        OpenTypeHistory.getInstance().checkConsistency(monitor);
    }

    private static IPreferenceStore getDeprecatedWorkbenchPreferenceStore() {
        return PlatformUI.getWorkbench().getPreferenceStore();
    }

    private void ensurePreferenceStoreBackwardsCompatibility() {
        boolean alphabetic;
        IPreferenceStore store = this.getPreferenceStore();
        this.fMembersOrderPreferenceCache = new MembersOrderPreferenceCache();
        this.fMembersOrderPreferenceCache.install(store);
        String fontPropagatedKey = "fontPropagated";
        if (store.contains("org.eclipse.jface.textfont") && !store.isDefault("org.eclipse.jface.textfont") && !store.getBoolean(fontPropagatedKey)) {
            PreferenceConverter.setValue((IPreferenceStore)JavaPlugin.getDeprecatedWorkbenchPreferenceStore(), (String)"org.eclipse.jdt.ui.editors.textfont", (FontData[])PreferenceConverter.getFontDataArray((IPreferenceStore)store, (String)"org.eclipse.jface.textfont"));
        }
        store.setValue(fontPropagatedKey, true);
        PreferenceConverter.putValue((IPreferenceStore)store, (String)"org.eclipse.jface.textfont", (FontData[])JFaceResources.getFontRegistry().getFontData("org.eclipse.jdt.ui.editors.textfont"));
        this.fFontPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("org.eclipse.jdt.ui.editors.textfont".equals(event.getProperty())) {
                    PreferenceConverter.putValue((IPreferenceStore)JavaPlugin.this.getPreferenceStore(), (String)"org.eclipse.jface.textfont", (FontData[])JFaceResources.getFontRegistry().getFontData("org.eclipse.jdt.ui.editors.textfont"));
                }
            }
        };
        JFaceResources.getFontRegistry().addListener(this.fFontPropertyChangeListener);
        String tabWidthPropagatedKey = "tabWidthPropagated";
        if (store.contains(DEPRECATED_EDITOR_TAB_WIDTH) && !store.isDefault(DEPRECATED_EDITOR_TAB_WIDTH) && !store.getBoolean(tabWidthPropagatedKey)) {
            store.setValue("tabWidth", store.getInt(DEPRECATED_EDITOR_TAB_WIDTH));
        }
        store.setValue(tabWidthPropagatedKey, true);
        store.putValue(DEPRECATED_EDITOR_TAB_WIDTH, store.getString("tabWidth"));
        this.fPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("tabWidth".equals(event.getProperty())) {
                    IPreferenceStore prefStore = JavaPlugin.this.getPreferenceStore();
                    prefStore.putValue(JavaPlugin.DEPRECATED_EDITOR_TAB_WIDTH, prefStore.getString("tabWidth"));
                }
            }
        };
        store.addPropertyChangeListener(this.fPropertyChangeListener);
        store.setToDefault(DEPRECATED_REFACTOR_ERROR_PAGE_SEVERITY_THRESHOLD);
        if (!store.getBoolean("org.eclipse.jdt.ui.javadoclocations.migrated")) {
            JavaDocLocations.migrateToClasspathAttributes();
        }
        FormatterProfileStore.checkCurrentOptionsVersion();
        String proposalOrderMigrated = "proposalOrderMigrated";
        if (store.contains(DEPRECATED_CODEASSIST_ORDER_PROPOSALS) && !store.getBoolean(proposalOrderMigrated) && (alphabetic = store.getBoolean(DEPRECATED_CODEASSIST_ORDER_PROPOSALS))) {
            store.setValue("content_assist_sorter", "org.eclipse.jdt.ui.AlphabeticSorter");
        }
        store.setValue(proposalOrderMigrated, true);
    }

    private void uninstallPreferenceStoreBackwardsCompatibility() {
        JFaceResources.getFontRegistry().removeListener(this.fFontPropertyChangeListener);
        this.getPreferenceStore().removePropertyChangeListener(this.fPropertyChangeListener);
    }

    protected ImageRegistry createImageRegistry() {
        return JavaPluginImages.getImageRegistry();
    }

    public void stop(BundleContext context) throws Exception {
        try {
            if (this.fImageDescriptorRegistry != null) {
                this.fImageDescriptorRegistry.dispose();
            }
            if (this.fASTProvider != null) {
                this.fASTProvider.dispose();
                this.fASTProvider = null;
            }
            if (this.fWorkingCopyManager != null) {
                this.fWorkingCopyManager.shutdown();
                this.fWorkingCopyManager = null;
            }
            if (this.fCompilationUnitDocumentProvider != null) {
                this.fCompilationUnitDocumentProvider.shutdown();
                this.fCompilationUnitDocumentProvider = null;
            }
            if (this.fJavaTextTools != null) {
                this.fJavaTextTools.dispose();
                this.fJavaTextTools = null;
            }
            if (this.fTypeFilter != null) {
                this.fTypeFilter.dispose();
                this.fTypeFilter = null;
            }
            if (this.fContentAssistHistory != null) {
                ContentAssistHistory.store(this.fContentAssistHistory, this.getPluginPreferences(), "content_assist_lru_history");
                this.fContentAssistHistory = null;
            }
            this.uninstallPreferenceStoreBackwardsCompatibility();
            if (this.fTemplateStore != null) {
                this.fTemplateStore.stopListeningForPreferenceChanges();
                this.fTemplateStore = null;
            }
            if (this.fCodeTemplateStore != null) {
                this.fCodeTemplateStore.stopListeningForPreferenceChanges();
                this.fCodeTemplateStore = null;
            }
            if (this.fMembersOrderPreferenceCache != null) {
                this.fMembersOrderPreferenceCache.dispose();
                this.fMembersOrderPreferenceCache = null;
            }
            if (this.fSaveParticipantRegistry != null) {
                this.fSaveParticipantRegistry.dispose();
                this.fSaveParticipantRegistry = null;
            }
            if (this.fDialogsFormToolkit != null) {
                this.fDialogsFormToolkit.dispose();
                this.fDialogsFormToolkit = null;
            }
            if (this.fThemeListener != null) {
                PlatformUI.getWorkbench().getThemeManager().removePropertyChangeListener(this.fThemeListener);
                this.fThemeListener = null;
            }
            if (this.fImagesOnFSRegistry != null) {
                this.fImagesOnFSRegistry.dispose();
                this.fImagesOnFSRegistry = null;
            }
            SpellCheckEngine.shutdownInstance();
            QualifiedTypeNameHistory.getDefault().save();
            OpenTypeHistory.shutdown();
        }
        finally {
            super.stop(context);
        }
    }

    private IWorkbenchPage internalGetActivePage() {
        IWorkbenchWindow window = this.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getActivePage();
    }

    public synchronized IBufferFactory getBufferFactory() {
        if (this.fBufferFactory == null) {
            this.fBufferFactory = new CustomBufferFactory();
        }
        return this.fBufferFactory;
    }

    public synchronized ICompilationUnitDocumentProvider getCompilationUnitDocumentProvider() {
        if (this.fCompilationUnitDocumentProvider == null) {
            this.fCompilationUnitDocumentProvider = new CompilationUnitDocumentProvider();
        }
        return this.fCompilationUnitDocumentProvider;
    }

    public synchronized IDocumentProvider getPropertiesFileDocumentProvider() {
        if (this.fPropertiesFileDocumentProvider == null) {
            this.fPropertiesFileDocumentProvider = new PropertiesFileDocumentProvider();
        }
        return this.fPropertiesFileDocumentProvider;
    }

    public synchronized ClassFileDocumentProvider getClassFileDocumentProvider() {
        if (this.fClassFileDocumentProvider == null) {
            this.fClassFileDocumentProvider = new ClassFileDocumentProvider();
        }
        return this.fClassFileDocumentProvider;
    }

    public synchronized WorkingCopyManager getWorkingCopyManager() {
        if (this.fWorkingCopyManager == null) {
            ICompilationUnitDocumentProvider provider = this.getCompilationUnitDocumentProvider();
            this.fWorkingCopyManager = new WorkingCopyManager(provider);
        }
        return this.fWorkingCopyManager;
    }

    public synchronized ProblemMarkerManager getProblemMarkerManager() {
        if (this.fProblemMarkerManager == null) {
            this.fProblemMarkerManager = new ProblemMarkerManager();
        }
        return this.fProblemMarkerManager;
    }

    public synchronized JavaTextTools getJavaTextTools() {
        if (this.fJavaTextTools == null) {
            this.fJavaTextTools = new JavaTextTools(this.getPreferenceStore(), JavaCore.getPlugin().getPluginPreferences());
        }
        return this.fJavaTextTools;
    }

    public synchronized ASTProvider getASTProvider() {
        if (this.fASTProvider == null) {
            this.fASTProvider = new ASTProvider();
        }
        return this.fASTProvider;
    }

    public synchronized MembersOrderPreferenceCache getMemberOrderPreferenceCache() {
        return this.fMembersOrderPreferenceCache;
    }

    public synchronized TypeFilter getTypeFilter() {
        if (this.fTypeFilter == null) {
            this.fTypeFilter = new TypeFilter();
        }
        return this.fTypeFilter;
    }

    public FormToolkit getDialogsFormToolkit() {
        if (this.fDialogsFormToolkit == null) {
            FormColors colors = new FormColors(Display.getCurrent());
            colors.setBackground(null);
            colors.setForeground(null);
            this.fDialogsFormToolkit = new FormToolkit(colors);
        }
        return this.fDialogsFormToolkit;
    }

    public synchronized JavaEditorTextHoverDescriptor[] getJavaEditorTextHoverDescriptors() {
        if (this.fJavaEditorTextHoverDescriptors == null) {
            this.fJavaEditorTextHoverDescriptors = JavaEditorTextHoverDescriptor.getContributedHovers();
            ConfigurationElementSorter sorter = new ConfigurationElementSorter(){

                public IConfigurationElement getConfigurationElement(Object object) {
                    return ((JavaEditorTextHoverDescriptor)object).getConfigurationElement();
                }
            };
            sorter.sort((Object[])this.fJavaEditorTextHoverDescriptors);
            int i = 0;
            while (i < this.fJavaEditorTextHoverDescriptors.length - 1) {
                if ("org.eclipse.jdt.ui.BestMatchHover".equals(this.fJavaEditorTextHoverDescriptors[i].getId())) {
                    JavaEditorTextHoverDescriptor hoverDescriptor = this.fJavaEditorTextHoverDescriptors[i];
                    int j = i;
                    while (j > 0) {
                        this.fJavaEditorTextHoverDescriptors[j] = this.fJavaEditorTextHoverDescriptors[j - 1];
                        --j;
                    }
                    this.fJavaEditorTextHoverDescriptors[0] = hoverDescriptor;
                    break;
                }
                ++i;
            }
        }
        return this.fJavaEditorTextHoverDescriptors;
    }

    public synchronized void resetJavaEditorTextHoverDescriptors() {
        this.fJavaEditorTextHoverDescriptors = null;
    }

    public static void createStandardGroups(IMenuManager menu) {
        if (!menu.isEmpty()) {
            return;
        }
        menu.add((IContributionItem)new Separator("group.new"));
        menu.add((IContributionItem)new GroupMarker("group.goto"));
        menu.add((IContributionItem)new Separator("group.open"));
        menu.add((IContributionItem)new GroupMarker("group.show"));
        menu.add((IContributionItem)new Separator("group.edit"));
        menu.add((IContributionItem)new Separator("group.reorganize"));
        menu.add((IContributionItem)new Separator("group.generate"));
        menu.add((IContributionItem)new Separator("group.search"));
        menu.add((IContributionItem)new Separator("group.build"));
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("group.viewerSetup"));
        menu.add((IContributionItem)new Separator("group.properties"));
    }

    public synchronized ContextTypeRegistry getTemplateContextRegistry() {
        if (this.fContextTypeRegistry == null) {
            ContributionContextTypeRegistry registry = new ContributionContextTypeRegistry();
            registry.addContextType("java");
            TemplateContextType all_contextType = registry.getContextType("java");
            ((AbstractJavaContextType)all_contextType).initializeContextTypeResolvers();
            JavaPlugin.registerJavaContext(registry, "java-members", all_contextType);
            JavaPlugin.registerJavaContext(registry, "java-statements", all_contextType);
            JavaPlugin.registerJavaContext(registry, "swt", all_contextType);
            all_contextType = registry.getContextType("swt");
            JavaPlugin.registerJavaContext(registry, "swt-members", all_contextType);
            JavaPlugin.registerJavaContext(registry, "swt-statements", all_contextType);
            registry.addContextType("javadoc");
            this.fContextTypeRegistry = registry;
        }
        return this.fContextTypeRegistry;
    }

    private static void registerJavaContext(ContributionContextTypeRegistry registry, String id, TemplateContextType parent) {
        registry.addContextType(id);
        TemplateContextType contextType = registry.getContextType(id);
        Iterator iter = parent.resolvers();
        while (iter.hasNext()) {
            contextType.addResolver((TemplateVariableResolver)iter.next());
        }
    }

    public TemplateStore getTemplateStore() {
        if (this.fTemplateStore == null) {
            IPreferenceStore store = this.getPreferenceStore();
            boolean alreadyMigrated = store.getBoolean(TEMPLATES_MIGRATION_KEY);
            if (alreadyMigrated) {
                this.fTemplateStore = new ContributionTemplateStore(this.getTemplateContextRegistry(), store, TEMPLATES_KEY);
            } else {
                this.fTemplateStore = new CompatibilityTemplateStore(this.getTemplateContextRegistry(), store, TEMPLATES_KEY, this.getOldTemplateStoreInstance());
                store.setValue(TEMPLATES_MIGRATION_KEY, true);
            }
            try {
                this.fTemplateStore.load();
            }
            catch (IOException e) {
                JavaPlugin.log(e);
            }
            this.fTemplateStore.startListeningForPreferenceChanges();
        }
        return this.fTemplateStore;
    }

    private Templates getOldTemplateStoreInstance() {
        return Templates.getInstance();
    }

    public ContextTypeRegistry getCodeTemplateContextRegistry() {
        if (this.fCodeTemplateContextTypeRegistry == null) {
            this.fCodeTemplateContextTypeRegistry = new ContributionContextTypeRegistry();
            CodeTemplateContextType.registerContextTypes(this.fCodeTemplateContextTypeRegistry);
        }
        return this.fCodeTemplateContextTypeRegistry;
    }

    public TemplateStore getCodeTemplateStore() {
        if (this.fCodeTemplateStore == null) {
            IPreferenceStore store = this.getPreferenceStore();
            boolean alreadyMigrated = store.getBoolean(CODE_TEMPLATES_MIGRATION_KEY);
            if (alreadyMigrated) {
                this.fCodeTemplateStore = new ContributionTemplateStore(this.getCodeTemplateContextRegistry(), store, CODE_TEMPLATES_KEY);
            } else {
                this.fCodeTemplateStore = new CompatibilityTemplateStore(this.getCodeTemplateContextRegistry(), store, CODE_TEMPLATES_KEY, this.getOldCodeTemplateStoreInstance());
                store.setValue(CODE_TEMPLATES_MIGRATION_KEY, true);
            }
            try {
                this.fCodeTemplateStore.load();
            }
            catch (IOException e) {
                JavaPlugin.log(e);
            }
            this.fCodeTemplateStore.startListeningForPreferenceChanges();
            CompatibilityTemplateStore.pruneDuplicates(this.fCodeTemplateStore, true);
        }
        return this.fCodeTemplateStore;
    }

    private CodeTemplates getOldCodeTemplateStoreInstance() {
        return CodeTemplates.getInstance();
    }

    private synchronized ImageDescriptorRegistry internalGetImageDescriptorRegistry() {
        if (this.fImageDescriptorRegistry == null) {
            this.fImageDescriptorRegistry = new ImageDescriptorRegistry();
        }
        return this.fImageDescriptorRegistry;
    }

    public IPreferenceStore getCombinedPreferenceStore() {
        if (this.fCombinedPreferenceStore == null) {
            IPreferenceStore generalTextStore = EditorsUI.getPreferenceStore();
            this.fCombinedPreferenceStore = new ChainedPreferenceStore(new IPreferenceStore[]{this.getPreferenceStore(), new PreferencesAdapter(JavaCore.getPlugin().getPluginPreferences()), generalTextStore});
        }
        return this.fCombinedPreferenceStore;
    }

    public synchronized JavaFoldingStructureProviderRegistry getFoldingStructureProviderRegistry() {
        if (this.fFoldingStructureProviderRegistry == null) {
            this.fFoldingStructureProviderRegistry = new JavaFoldingStructureProviderRegistry();
        }
        return this.fFoldingStructureProviderRegistry;
    }

    public synchronized SaveParticipantRegistry getSaveParticipantRegistry() {
        if (this.fSaveParticipantRegistry == null) {
            this.fSaveParticipantRegistry = new SaveParticipantRegistry();
        }
        return this.fSaveParticipantRegistry;
    }

    public synchronized CleanUpRegistry getCleanUpRegistry() {
        if (this.fCleanUpRegistry == null) {
            this.fCleanUpRegistry = new CleanUpRegistry();
        }
        return this.fCleanUpRegistry;
    }

    public ContentAssistHistory getContentAssistHistory() {
        if (this.fContentAssistHistory == null) {
            try {
                this.fContentAssistHistory = ContentAssistHistory.load(this.getPluginPreferences(), "content_assist_lru_history");
            }
            catch (CoreException x) {
                JavaPlugin.log(x);
            }
            if (this.fContentAssistHistory == null) {
                this.fContentAssistHistory = new ContentAssistHistory();
            }
        }
        return this.fContentAssistHistory;
    }

    public IDialogSettings getDialogSettingsSection(String name) {
        IDialogSettings dialogSettings = this.getDialogSettings();
        IDialogSettings section = dialogSettings.getSection(name);
        if (section == null) {
            section = dialogSettings.addNewSection(name);
        }
        return section;
    }

    public ClasspathAttributeConfigurationDescriptors getClasspathAttributeConfigurationDescriptors() {
        if (this.fClasspathAttributeConfigurationDescriptors == null) {
            this.fClasspathAttributeConfigurationDescriptors = new ClasspathAttributeConfigurationDescriptors();
        }
        return this.fClasspathAttributeConfigurationDescriptors;
    }

    public ImagesOnFileSystemRegistry getImagesOnFSRegistry() {
        if (this.fImagesOnFSRegistry == null) {
            this.fImagesOnFSRegistry = new ImagesOnFileSystemRegistry();
        }
        return this.fImagesOnFSRegistry;
    }

    public static final String getAdditionalInfoAffordanceString() {
        if (!EditorsUI.getPreferenceStore().getBoolean("showTextHoverAffordance")) {
            return null;
        }
        return JavaUIMessages.JavaPlugin_additionalInfo_affordance;
    }
}

