/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.formatter.IndentManipulation;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFix;
import org.eclipse.jdt.internal.corext.fix.Java50Fix;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModel;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalPositionGroup;
import org.eclipse.jdt.internal.corext.fix.UnimplementedCodeFix;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.fix.Java50CleanUp;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.JavadocTagsSubProcessor;
import org.eclipse.jdt.internal.ui.text.correction.QuickAssistProcessor;
import org.eclipse.jdt.internal.ui.text.correction.UnresolvedElementsSubProcessor;
import org.eclipse.jdt.internal.ui.text.correction.proposals.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.proposals.FixCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.proposals.LinkedCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.proposals.ModifierChangeCorrectionProposal;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class ModifierCorrectionSubProcessor {
    public static final int TO_STATIC = 1;
    public static final int TO_VISIBLE = 2;
    public static final int TO_NON_PRIVATE = 3;
    public static final int TO_NON_STATIC = 4;
    public static final int TO_NON_FINAL = 5;
    private static final String KEY_MODIFIER = "modifier";

    public static void addNonAccessibleReferenceProposal(IInvocationContext context, IProblemLocation problem, Collection proposals, int kind, int relevance) throws CoreException {
        String name;
        IMethodBinding bindingDecl;
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (selectedNode == null) {
            return;
        }
        IBinding binding = null;
        switch (selectedNode.getNodeType()) {
            case 42: {
                binding = ((SimpleName)selectedNode).resolveBinding();
                break;
            }
            case 40: {
                binding = ((QualifiedName)selectedNode).resolveBinding();
                break;
            }
            case 43: {
                binding = ((SimpleType)selectedNode).resolveBinding();
                break;
            }
            case 32: {
                binding = ((MethodInvocation)selectedNode).getName().resolveBinding();
                break;
            }
            case 48: {
                binding = ((SuperMethodInvocation)selectedNode).getName().resolveBinding();
                break;
            }
            case 22: {
                binding = ((FieldAccess)selectedNode).getName().resolveBinding();
                break;
            }
            case 47: {
                binding = ((SuperFieldAccess)selectedNode).getName().resolveBinding();
                break;
            }
            case 14: {
                binding = ((ClassInstanceCreation)selectedNode).resolveConstructorBinding();
                break;
            }
            case 46: {
                binding = ((SuperConstructorInvocation)selectedNode).resolveConstructorBinding();
                break;
            }
            default: {
                return;
            }
        }
        ITypeBinding typeBinding = null;
        boolean isLocalVar = false;
        if (binding instanceof IMethodBinding) {
            IMethodBinding methodDecl = (IMethodBinding)binding;
            bindingDecl = methodDecl.getMethodDeclaration();
            typeBinding = methodDecl.getDeclaringClass();
            name = BasicElementLabels.getJavaElementName(String.valueOf(methodDecl.getName()) + "()");
        } else if (binding instanceof IVariableBinding) {
            IVariableBinding varDecl = (IVariableBinding)binding;
            typeBinding = varDecl.getDeclaringClass();
            name = BasicElementLabels.getJavaElementName(binding.getName());
            isLocalVar = !varDecl.isField();
            bindingDecl = varDecl.getVariableDeclaration();
        } else if (binding instanceof ITypeBinding) {
            typeBinding = (ITypeBinding)binding;
            bindingDecl = typeBinding.getTypeDeclaration();
            name = BasicElementLabels.getJavaElementName(binding.getName());
        } else {
            return;
        }
        if (typeBinding != null && typeBinding.isFromSource() || isLocalVar) {
            ICompilationUnit targetCU;
            String label;
            int includedModifiers = 0;
            int excludedModifiers = 0;
            switch (kind) {
                case 2: {
                    excludedModifiers = 7;
                    includedModifiers = ModifierCorrectionSubProcessor.getNeededVisibility(selectedNode, typeBinding);
                    label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changevisibility_description, new String[]{name, ModifierCorrectionSubProcessor.getVisibilityString(includedModifiers)});
                    break;
                }
                case 1: {
                    label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemodifiertostatic_description, name);
                    includedModifiers = 8;
                    break;
                }
                case 4: {
                    label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemodifiertononstatic_description, name);
                    excludedModifiers = 8;
                    break;
                }
                case 3: {
                    label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemodifiertodefault_description, name);
                    excludedModifiers = 2;
                    break;
                }
                case 5: {
                    label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemodifiertononfinal_description, name);
                    excludedModifiers = 16;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("not supported");
                }
            }
            ICompilationUnit iCompilationUnit = targetCU = isLocalVar ? cu : ASTResolving.findCompilationUnitForBinding(cu, context.getASTRoot(), typeBinding.getTypeDeclaration());
            if (targetCU != null) {
                Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
                proposals.add(new ModifierChangeCorrectionProposal(label, targetCU, (IBinding)bindingDecl, selectedNode, includedModifiers, excludedModifiers, relevance, image));
            }
        }
        if (kind == 2 && bindingDecl.getKind() == 3) {
            UnresolvedElementsSubProcessor.getVariableProposals(context, problem, (IVariableBinding)bindingDecl, proposals);
        }
    }

    public static void addChangeOverriddenModfierProposal(IInvocationContext context, IProblemLocation problem, Collection proposals, int kind) throws JavaModelException {
        IMethodBinding defining;
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (!(selectedNode instanceof MethodDeclaration)) {
            return;
        }
        IMethodBinding method = ((MethodDeclaration)selectedNode).resolveBinding();
        ITypeBinding curr = method.getDeclaringClass();
        if (kind == 2 && problem.getProblemId() != 67109274 && (defining = Bindings.findOverriddenMethod(method, false)) != null) {
            int excludedModifiers = 7;
            int includedModifiers = JdtFlags.getVisibilityCode((IBinding)defining);
            String label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemethodvisibility_description, new String[]{ModifierCorrectionSubProcessor.getVisibilityString(includedModifiers)});
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            proposals.add(new ModifierChangeCorrectionProposal(label, cu, (IBinding)method, selectedNode, includedModifiers, excludedModifiers, 8, image));
        }
        IMethodBinding overriddenInClass = null;
        while (overriddenInClass == null && curr.getSuperclass() != null) {
            curr = curr.getSuperclass();
            overriddenInClass = Bindings.findOverriddenMethodInType(curr, method);
        }
        if (overriddenInClass != null) {
            IMethodBinding overriddenDecl = overriddenInClass.getMethodDeclaration();
            ICompilationUnit targetCU = ASTResolving.findCompilationUnitForBinding(cu, context.getASTRoot(), overriddenDecl.getDeclaringClass());
            if (targetCU != null) {
                String label;
                int includedModifiers;
                int excludedModifiers;
                String methodLabel = BasicElementLabels.getJavaElementName(String.valueOf(curr.getName()) + '.' + overriddenInClass.getName());
                switch (kind) {
                    case 2: {
                        excludedModifiers = 7;
                        includedModifiers = JdtFlags.getVisibilityCode((IBinding)method);
                        label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changeoverriddenvisibility_description, new String[]{methodLabel, ModifierCorrectionSubProcessor.getVisibilityString(includedModifiers)});
                        break;
                    }
                    case 5: {
                        label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemethodtononfinal_description, methodLabel);
                        excludedModifiers = 16;
                        includedModifiers = 0;
                        break;
                    }
                    case 4: {
                        label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemethodtononstatic_description, methodLabel);
                        excludedModifiers = 8;
                        includedModifiers = 0;
                        break;
                    }
                    default: {
                        Assert.isTrue((boolean)false, (String)"not supported");
                        return;
                    }
                }
                Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
                proposals.add(new ModifierChangeCorrectionProposal(label, targetCU, (IBinding)overriddenDecl, selectedNode, includedModifiers, excludedModifiers, 7, image));
            }
        }
    }

    public static void addNonFinalLocalProposal(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (!(selectedNode instanceof SimpleName)) {
            return;
        }
        IBinding binding = ((SimpleName)selectedNode).resolveBinding();
        if (binding instanceof IVariableBinding) {
            binding = ((IVariableBinding)binding).getVariableDeclaration();
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            String label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemodifiertofinal_description, BasicElementLabels.getJavaElementName(binding.getName()));
            proposals.add(new ModifierChangeCorrectionProposal(label, cu, binding, selectedNode, 16, 0, 5, image));
        }
    }

    public static void addRemoveInvalidModfiersProposal(IInvocationContext context, IProblemLocation problem, Collection proposals, int relevance) {
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (selectedNode instanceof MethodDeclaration) {
            selectedNode = ((MethodDeclaration)selectedNode).getName();
        }
        if (!(selectedNode instanceof SimpleName)) {
            return;
        }
        IBinding binding = ((SimpleName)selectedNode).resolveBinding();
        if (binding != null) {
            ASTNode parentType;
            ITypeBinding declClass;
            String methodName = BasicElementLabels.getJavaElementName(binding.getName());
            String label = null;
            int problemId = problem.getProblemId();
            int excludedModifiers = 0;
            int includedModifiers = 0;
            switch (problemId) {
                case 67109225: 
                case 67109271: {
                    excludedModifiers = 8;
                    label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemethodtononstatic_description, methodName);
                    break;
                }
                case 33554778: {
                    excludedModifiers = 8;
                    label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changefieldmodifiertononstatic_description, methodName);
                    break;
                }
                case 33554777: {
                    excludedModifiers = 64;
                    label = CorrectionMessages.ModifierCorrectionSubProcessor_removevolatile_description;
                    break;
                }
                case 67109223: {
                    excludedModifiers = -1026;
                    break;
                }
                case 16777519: {
                    excludedModifiers = -3074;
                    break;
                }
                case 16777518: {
                    excludedModifiers = -3090;
                    break;
                }
                case 33554775: {
                    excludedModifiers = -26;
                    break;
                }
                case 0x1000131: 
                case 16777525: {
                    excludedModifiers = -2058;
                    break;
                }
                case 0x1000130: {
                    excludedModifiers = -3104;
                    break;
                }
                case 16777522: {
                    excludedModifiers = -3089;
                    break;
                }
                case 67109220: {
                    excludedModifiers = -17;
                    break;
                }
                case 33554774: {
                    excludedModifiers = -224;
                    break;
                }
                case 67109222: {
                    excludedModifiers = -3392;
                    break;
                }
                case 67109233: {
                    excludedModifiers = -8;
                    break;
                }
                case 67109260: {
                    excludedModifiers = -17;
                    break;
                }
                case 16777966: {
                    excludedModifiers = -2050;
                    break;
                }
                case 33555183: {
                    excludedModifiers = -1;
                    break;
                }
                case 67109624: {
                    excludedModifiers = -3;
                    break;
                }
                case 16777969: {
                    excludedModifiers = -2064;
                    break;
                }
                default: {
                    Assert.isTrue((boolean)false, (String)"not supported");
                    return;
                }
            }
            if (label == null) {
                label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_removeinvalidmodifiers_description, methodName);
            }
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            proposals.add(new ModifierChangeCorrectionProposal(label, cu, binding, selectedNode, includedModifiers, excludedModifiers, relevance, image));
            if (problemId == 33554777) {
                proposals.add(new ModifierChangeCorrectionProposal(CorrectionMessages.ModifierCorrectionSubProcessor_removefinal_description, cu, binding, selectedNode, 0, 16, relevance + 1, image));
            }
            if (problemId == 33554778 && binding instanceof IVariableBinding && (declClass = ((IVariableBinding)binding).getDeclaringClass()).isMember()) {
                proposals.add(new ModifierChangeCorrectionProposal(CorrectionMessages.ModifierCorrectionSubProcessor_changemodifiertostaticfinal_description, cu, binding, selectedNode, 16, 64, relevance + 1, image));
                parentType = context.getASTRoot().findDeclaringNode((IBinding)declClass);
                if (parentType != null) {
                    proposals.add(new ModifierChangeCorrectionProposal(CorrectionMessages.ModifierCorrectionSubProcessor_addstatictoparenttype_description, cu, (IBinding)declClass, parentType, 8, 0, relevance - 1, image));
                }
            }
            if (problemId == 67109225 && binding instanceof IMethodBinding && (declClass = ((IMethodBinding)binding).getDeclaringClass()).isMember() && (parentType = context.getASTRoot().findDeclaringNode((IBinding)declClass)) != null) {
                proposals.add(new ModifierChangeCorrectionProposal(CorrectionMessages.ModifierCorrectionSubProcessor_addstatictoparenttype_description, cu, (IBinding)declClass, parentType, 8, 0, relevance - 1, image));
            }
        }
    }

    private static String getVisibilityString(int code) {
        if (Modifier.isPublic((int)code)) {
            return "public";
        }
        if (Modifier.isProtected((int)code)) {
            return "protected";
        }
        if (Modifier.isPrivate((int)code)) {
            return "private";
        }
        return CorrectionMessages.ModifierCorrectionSubProcessor_default;
    }

    private static int getNeededVisibility(ASTNode currNode, ITypeBinding targetType) {
        ITypeBinding currNodeBinding = Bindings.getBindingOfParentType(currNode);
        if (currNodeBinding == null) {
            return 1;
        }
        if (Bindings.isSuperType(targetType, currNodeBinding)) {
            return 4;
        }
        if (currNodeBinding.getPackage().getKey().equals(targetType.getPackage().getKey())) {
            return 0;
        }
        return 1;
    }

    public static void addAbstractMethodProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        String label;
        MethodDeclaration decl;
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (selectedNode == null) {
            return;
        }
        if (selectedNode instanceof SimpleName) {
            decl = (MethodDeclaration)selectedNode.getParent();
        } else if (selectedNode instanceof MethodDeclaration) {
            decl = (MethodDeclaration)selectedNode;
        } else {
            return;
        }
        ASTNode parentType = ASTResolving.findParentType((ASTNode)decl);
        TypeDeclaration parentTypeDecl = null;
        boolean parentIsAbstractClass = false;
        if (parentType instanceof TypeDeclaration) {
            parentTypeDecl = (TypeDeclaration)parentType;
            parentIsAbstractClass = !parentTypeDecl.isInterface() && Modifier.isAbstract((int)parentTypeDecl.getModifiers());
        }
        boolean hasNoBody = decl.getBody() == null;
        int id = problem.getProblemId();
        if (id == 67109227 || id == 67109622 || parentIsAbstractClass) {
            AST ast = astRoot.getAST();
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            Modifier modifierNode = ASTNodes.findModifierNode(1024, decl.modifiers());
            if (modifierNode != null) {
                rewrite.remove((ASTNode)modifierNode, null);
            }
            if (hasNoBody) {
                Block newBody = ast.newBlock();
                rewrite.set((ASTNode)decl, (StructuralPropertyDescriptor)MethodDeclaration.BODY_PROPERTY, (Object)newBody, null);
                Expression expr = ASTNodeFactory.newDefaultExpression(ast, decl.getReturnType2(), decl.getExtraDimensions());
                if (expr != null) {
                    ReturnStatement returnStatement = ast.newReturnStatement();
                    returnStatement.setExpression(expr);
                    newBody.statements().add(returnStatement);
                }
            }
            String label2 = CorrectionMessages.ModifierCorrectionSubProcessor_removeabstract_description;
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label2, cu, rewrite, 6, image);
            proposals.add(proposal);
        }
        if (!hasNoBody && id == 603979889) {
            ASTRewrite rewrite = ASTRewrite.create((AST)decl.getAST());
            rewrite.remove((ASTNode)decl.getBody(), null);
            label = CorrectionMessages.ModifierCorrectionSubProcessor_removebody_description;
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            ASTRewriteCorrectionProposal proposal2 = new ASTRewriteCorrectionProposal(label, cu, rewrite, 5, image);
            proposals.add(proposal2);
        }
        if (id == 67109227 && parentTypeDecl != null) {
            UnimplementedCodeFix.MakeTypeAbstractOperation operation = new UnimplementedCodeFix.MakeTypeAbstractOperation(parentTypeDecl);
            label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_addabstract_description, BasicElementLabels.getJavaElementName(parentTypeDecl.getName().getIdentifier()));
            UnimplementedCodeFix fix = new UnimplementedCodeFix(label, astRoot, new CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation[]{operation});
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            FixCorrectionProposal proposal = new FixCorrectionProposal(fix, null, 5, image, context);
            proposals.add(proposal);
        }
    }

    public static void addNativeMethodProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        MethodDeclaration decl;
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        ASTNode selectedNode = problem.getCoveringNode(astRoot);
        if (selectedNode == null) {
            return;
        }
        if (selectedNode instanceof SimpleName) {
            decl = (MethodDeclaration)selectedNode.getParent();
        } else if (selectedNode instanceof MethodDeclaration) {
            decl = (MethodDeclaration)selectedNode;
        } else {
            return;
        }
        AST ast = astRoot.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        Modifier modifierNode = ASTNodes.findModifierNode(256, decl.modifiers());
        if (modifierNode != null) {
            rewrite.remove((ASTNode)modifierNode, null);
        }
        Block newBody = ast.newBlock();
        rewrite.set((ASTNode)decl, (StructuralPropertyDescriptor)MethodDeclaration.BODY_PROPERTY, (Object)newBody, null);
        Expression expr = ASTNodeFactory.newDefaultExpression(ast, decl.getReturnType2(), decl.getExtraDimensions());
        if (expr != null) {
            ReturnStatement returnStatement = ast.newReturnStatement();
            returnStatement.setExpression(expr);
            newBody.statements().add(returnStatement);
        }
        String label = CorrectionMessages.ModifierCorrectionSubProcessor_removenative_description;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, 6, image);
        proposals.add(proposal);
        if (decl.getBody() != null) {
            ASTRewrite rewrite2 = ASTRewrite.create((AST)decl.getAST());
            rewrite2.remove((ASTNode)decl.getBody(), null);
            String label2 = CorrectionMessages.ModifierCorrectionSubProcessor_removebody_description;
            Image image2 = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            ASTRewriteCorrectionProposal proposal2 = new ASTRewriteCorrectionProposal(label2, cu, rewrite2, 5, image2);
            proposals.add(proposal2);
        }
    }

    public static void addMethodRequiresBodyProposals(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        Type returnType;
        Expression expression;
        ICompilationUnit cu = context.getCompilationUnit();
        AST ast = context.getASTRoot().getAST();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (!(selectedNode instanceof MethodDeclaration)) {
            return;
        }
        MethodDeclaration decl = (MethodDeclaration)selectedNode;
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        Modifier modifierNode = ASTNodes.findModifierNode(1024, decl.modifiers());
        if (modifierNode != null) {
            rewrite.remove((ASTNode)modifierNode, null);
        }
        Block body = ast.newBlock();
        rewrite.set((ASTNode)decl, (StructuralPropertyDescriptor)MethodDeclaration.BODY_PROPERTY, (Object)body, null);
        if (!decl.isConstructor() && (expression = ASTNodeFactory.newDefaultExpression(ast, returnType = decl.getReturnType2(), decl.getExtraDimensions())) != null) {
            ReturnStatement returnStatement = ast.newReturnStatement();
            returnStatement.setExpression(expression);
            body.statements().add(returnStatement);
        }
        String label = CorrectionMessages.ModifierCorrectionSubProcessor_addmissingbody_description;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, 9, image);
        proposals.add(proposal);
        rewrite = ASTRewrite.create((AST)ast);
        Modifier newModifier = ast.newModifier(Modifier.ModifierKeyword.ABSTRACT_KEYWORD);
        rewrite.getListRewrite((ASTNode)decl, MethodDeclaration.MODIFIERS2_PROPERTY).insertLast((ASTNode)newModifier, null);
        String label2 = CorrectionMessages.ModifierCorrectionSubProcessor_setmethodabstract_description;
        Image image2 = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        LinkedCorrectionProposal proposal2 = new LinkedCorrectionProposal(label2, cu, rewrite, 8, image2);
        proposal2.addLinkedPosition(rewrite.track((ASTNode)newModifier), true, KEY_MODIFIER);
        proposals.add(proposal2);
    }

    public static void addNeedToEmulateProposal(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (!(selectedNode instanceof SimpleName)) {
            return;
        }
        IBinding binding = ((SimpleName)selectedNode).resolveBinding();
        if (binding instanceof IVariableBinding) {
            binding = ((IVariableBinding)binding).getVariableDeclaration();
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            String label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_changemodifiertofinal_description, BasicElementLabels.getJavaElementName(binding.getName()));
            proposals.add(new ModifierChangeCorrectionProposal(label, cu, binding, selectedNode, 16, 0, 5, image));
        }
    }

    public static void addOverrideAnnotationProposal(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        Java50Fix fix = Java50Fix.createAddOverrideAnnotationFix(context.getASTRoot(), problem);
        if (fix != null) {
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            Hashtable<String, String> options = new Hashtable<String, String>();
            options.put("cleanup.add_missing_annotations", "true");
            options.put("cleanup.add_missing_override_annotations", "true");
            FixCorrectionProposal proposal = new FixCorrectionProposal(fix, new Java50CleanUp(options), 5, image, context);
            proposals.add(proposal);
        }
    }

    public static void addDeprecatedAnnotationProposal(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        Java50Fix fix = Java50Fix.createAddDeprectatedAnnotation(context.getASTRoot(), problem);
        if (fix != null) {
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            Hashtable<String, String> options = new Hashtable<String, String>();
            options.put("cleanup.add_missing_annotations", "true");
            options.put("cleanup.add_missing_deprecated_annotations", "true");
            FixCorrectionProposal proposal = new FixCorrectionProposal(fix, new Java50CleanUp(options), 5, image, context);
            proposals.add(proposal);
        }
    }

    public static void addOverridingDeprecatedMethodProposal(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        Javadoc javadoc;
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (!(selectedNode instanceof MethodDeclaration)) {
            return;
        }
        boolean is50OrHigher = JavaModelUtil.is50OrHigher(cu.getJavaProject());
        MethodDeclaration methodDecl = (MethodDeclaration)selectedNode;
        AST ast = methodDecl.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        if (is50OrHigher) {
            MarkerAnnotation annot = ast.newMarkerAnnotation();
            annot.setTypeName(ast.newName("Deprecated"));
            rewrite.getListRewrite((ASTNode)methodDecl, methodDecl.getModifiersProperty()).insertFirst((ASTNode)annot, null);
        }
        if ((javadoc = methodDecl.getJavadoc()) != null || !is50OrHigher) {
            if (!is50OrHigher) {
                javadoc = ast.newJavadoc();
                rewrite.set((ASTNode)methodDecl, (StructuralPropertyDescriptor)MethodDeclaration.JAVADOC_PROPERTY, (Object)javadoc, null);
            }
            TagElement newTag = ast.newTagElement();
            newTag.setTagName("@deprecated");
            JavadocTagsSubProcessor.insertTag(rewrite.getListRewrite((ASTNode)javadoc, Javadoc.TAGS_PROPERTY), newTag, null);
        }
        String label = CorrectionMessages.ModifierCorrectionSubProcessor_overrides_deprecated_description;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, 15, image);
        proposals.add(proposal);
    }

    public static void removeOverrideAnnotationProposal(IInvocationContext context, IProblemLocation problem, Collection proposals) throws CoreException {
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (!(selectedNode instanceof MethodDeclaration)) {
            return;
        }
        MethodDeclaration methodDecl = (MethodDeclaration)selectedNode;
        Annotation annot = ModifierCorrectionSubProcessor.findAnnotation("java.lang.Override", methodDecl.modifiers());
        if (annot != null) {
            ASTRewrite rewrite = ASTRewrite.create((AST)annot.getAST());
            rewrite.remove((ASTNode)annot, null);
            String label = CorrectionMessages.ModifierCorrectionSubProcessor_remove_override;
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, 6, image);
            proposals.add(proposal);
            QuickAssistProcessor.getCreateInSuperClassProposals(context, (ASTNode)methodDecl.getName(), proposals);
        }
    }

    public static void addSynchronizedMethodProposal(IInvocationContext context, IProblemLocation problem, Collection proposals) {
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (!(selectedNode instanceof MethodDeclaration)) {
            return;
        }
        IMethodBinding binding = ((MethodDeclaration)selectedNode).resolveBinding();
        if (binding instanceof IMethodBinding) {
            binding = binding.getMethodDeclaration();
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            String label = Messages.format(CorrectionMessages.ModifierCorrectionSubProcessor_addsynchronized_description, BasicElementLabels.getJavaElementName(binding.getName()));
            proposals.add(new ModifierChangeCorrectionProposal(label, cu, (IBinding)binding, selectedNode, 32, 0, 5, image));
        }
    }

    public static void installLinkedVisibilityProposals(LinkedProposalModel linkedProposalModel, ASTRewrite rewrite, List modifiers, boolean inInterface) {
        Modifier modifier = ModifierCorrectionSubProcessor.findVisibilityModifier(modifiers);
        if (modifier != null) {
            int[] nArray;
            int selected = modifier.getKeyword().toFlagValue();
            LinkedProposalPositionGroup positionGroup = linkedProposalModel.getPositionGroup(KEY_MODIFIER, true);
            positionGroup.addPosition(rewrite.track((ASTNode)modifier), false);
            positionGroup.addProposal(new ModifierLinkedModeProposal(selected, 10));
            if (inInterface) {
                int[] nArray2 = new int[2];
                nArray = nArray2;
                nArray2[0] = 1;
            } else {
                int[] nArray3 = new int[4];
                nArray3[0] = 1;
                nArray3[2] = 4;
                nArray = nArray3;
                nArray3[3] = 2;
            }
            int[] flagValues = nArray;
            int i = 0;
            while (i < flagValues.length) {
                if (flagValues[i] != selected) {
                    positionGroup.addProposal(new ModifierLinkedModeProposal(flagValues[i], 9 - i));
                }
                ++i;
            }
        }
    }

    private static Modifier findVisibilityModifier(List modifiers) {
        int i = 0;
        while (i < modifiers.size()) {
            Modifier modifier;
            Modifier.ModifierKeyword keyword;
            Object curr = modifiers.get(i);
            if (curr instanceof Modifier && ((keyword = (modifier = (Modifier)curr).getKeyword()) == Modifier.ModifierKeyword.PUBLIC_KEYWORD || keyword == Modifier.ModifierKeyword.PROTECTED_KEYWORD || keyword == Modifier.ModifierKeyword.PRIVATE_KEYWORD)) {
                return modifier;
            }
            ++i;
        }
        return null;
    }

    private static Annotation findAnnotation(String qualifiedTypeName, List modifiers) {
        int i = 0;
        while (i < modifiers.size()) {
            Annotation annot;
            ITypeBinding binding;
            Object curr = modifiers.get(i);
            if (curr instanceof Annotation && (binding = (annot = (Annotation)curr).getTypeName().resolveTypeBinding()) != null && qualifiedTypeName.equals(binding.getQualifiedName())) {
                return annot;
            }
            ++i;
        }
        return null;
    }

    private static class ModifierLinkedModeProposal
    extends LinkedProposalPositionGroup.Proposal {
        private final int fModifier;

        public ModifierLinkedModeProposal(int modifier, int relevance) {
            super(null, null, relevance);
            this.fModifier = modifier;
        }

        public String getAdditionalProposalInfo() {
            return this.getDisplayString();
        }

        public String getDisplayString() {
            if (this.fModifier == 0) {
                return CorrectionMessages.ModifierCorrectionSubProcessor_default_visibility_label;
            }
            return Modifier.ModifierKeyword.fromFlagValue((int)this.fModifier).toString();
        }

        public TextEdit computeEdits(int offset, LinkedPosition currentPosition, char trigger, int stateMask, LinkedModeModel model) throws CoreException {
            try {
                IDocument document = currentPosition.getDocument();
                MultiTextEdit edit = new MultiTextEdit();
                int documentLen = document.getLength();
                if (this.fModifier == 0) {
                    int end;
                    int k = end = currentPosition.offset + currentPosition.length;
                    while (k < documentLen && IndentManipulation.isIndentChar((char)document.getChar(k))) {
                        ++k;
                    }
                    edit.addChild((TextEdit)new ReplaceEdit(end, k - end, new String()));
                    edit.addChild((TextEdit)new ReplaceEdit(currentPosition.offset, currentPosition.length, new String()));
                } else {
                    edit.addChild((TextEdit)new ReplaceEdit(currentPosition.offset, currentPosition.length, Modifier.ModifierKeyword.fromFlagValue((int)this.fModifier).toString()));
                    int end = currentPosition.offset + currentPosition.length;
                    if (end < documentLen && !Character.isWhitespace(document.getChar(end))) {
                        edit.addChild((TextEdit)new ReplaceEdit(end, 0, String.valueOf(' ')));
                    }
                }
                return edit;
            }
            catch (BadLocationException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ui", 4, e.getMessage(), (Throwable)e));
            }
        }
    }
}

