/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.dom.SelectionAnalyzer;
import org.eclipse.jdt.internal.corext.dom.TokenScanner;
import org.eclipse.jdt.internal.corext.fix.ControlStatementsFix;
import org.eclipse.jdt.internal.corext.fix.ConvertLoopFix;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModel;
import org.eclipse.jdt.internal.corext.fix.VariableDeclarationFix;
import org.eclipse.jdt.internal.corext.refactoring.code.ConvertAnonymousToNestedRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.code.ExtractConstantRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.code.ExtractMethodRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.code.ExtractTempRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.code.InlineTempRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.code.PromoteTempToFieldRefactoring;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.fix.ControlStatementsCleanUp;
import org.eclipse.jdt.internal.ui.fix.ConvertLoopCleanUp;
import org.eclipse.jdt.internal.ui.fix.VariableDeclarationCleanUp;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.LocalCorrectionsSubProcessor;
import org.eclipse.jdt.internal.ui.text.correction.proposals.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.proposals.AssignToVariableAssistProposal;
import org.eclipse.jdt.internal.ui.text.correction.proposals.CUCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.proposals.FixCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.proposals.LinkedCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.proposals.LinkedNamesAssistProposal;
import org.eclipse.jdt.internal.ui.text.correction.proposals.NewDefiningMethodProposal;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickAssistProcessor;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.swt.graphics.Image;

public class QuickAssistProcessor
implements IQuickAssistProcessor {
    public static final String SPLIT_JOIN_VARIABLE_DECLARATION_ID = "org.eclipse.jdt.ui.correction.splitJoinVariableDeclaration.assist";
    public static final String CONVERT_FOR_LOOP_ID = "org.eclipse.jdt.ui.correction.convertForLoop.assist";
    public static final String ASSIGN_TO_LOCAL_ID = "org.eclipse.jdt.ui.correction.assignToLocal.assist";
    public static final String ASSIGN_TO_FIELD_ID = "org.eclipse.jdt.ui.correction.assignToField.assist";
    public static final String ASSIGN_PARAM_TO_FIELD_ID = "org.eclipse.jdt.ui.correction.assignParamToField.assist";
    public static final String ADD_BLOCK_ID = "org.eclipse.jdt.ui.correction.addBlock.assist";
    public static final String EXTRACT_LOCAL_ID = "org.eclipse.jdt.ui.correction.extractLocal.assist";
    public static final String EXTRACT_LOCAL_NOT_REPLACE_ID = "org.eclipse.jdt.ui.correction.extractLocalNotReplaceOccurrences.assist";
    public static final String EXTRACT_CONSTANT_ID = "org.eclipse.jdt.ui.correction.extractConstant.assist";
    public static final String INLINE_LOCAL_ID = "org.eclipse.jdt.ui.correction.inlineLocal.assist";
    public static final String CONVERT_LOCAL_TO_FIELD_ID = "org.eclipse.jdt.ui.correction.convertLocalToField.assist";
    public static final String CONVERT_ANONYMOUS_TO_LOCAL_ID = "org.eclipse.jdt.ui.correction.convertAnonymousToLocal.assist";
    public static final String CONVERT_TO_STRING_BUFFER_ID = "org.eclipse.jdt.ui.correction.convertToStringBuffer.assist";
    public static final String CONVERT_TO_MESSAGE_FORMAT_ID = "org.eclipse.jdt.ui.correction.convertToMessageFormat.assist";

    public boolean hasAssists(IInvocationContext context) throws CoreException {
        ASTNode coveringNode = context.getCoveringNode();
        if (coveringNode != null) {
            return QuickAssistProcessor.getCatchClauseToThrowsProposals(context, coveringNode, null) || QuickAssistProcessor.getRenameLocalProposals(context, coveringNode, null, false, null) || QuickAssistProcessor.getAssignToVariableProposals(context, coveringNode, null) || QuickAssistProcessor.getUnWrapProposals(context, coveringNode, null) || QuickAssistProcessor.getAssignParamToFieldProposals(context, coveringNode, null) || QuickAssistProcessor.getJoinVariableProposals(context, coveringNode, null) || QuickAssistProcessor.getAddFinallyProposals(context, coveringNode, null) || QuickAssistProcessor.getAddElseProposals(context, coveringNode, null) || QuickAssistProcessor.getSplitVariableProposals(context, coveringNode, null) || QuickAssistProcessor.getAddBlockProposals(context, coveringNode, null) || QuickAssistProcessor.getArrayInitializerToArrayCreation(context, coveringNode, null) || QuickAssistProcessor.getCreateInSuperClassProposals(context, coveringNode, null) || QuickAssistProcessor.getInvertEqualsProposal(context, coveringNode, null) || QuickAssistProcessor.getConvertForLoopProposal(context, coveringNode, null) || QuickAssistProcessor.getExtractLocalProposal(context, null) || QuickAssistProcessor.getExtractMethodProposal(context, coveringNode, null) || QuickAssistProcessor.getInlineLocalProposal(context, coveringNode, null) || QuickAssistProcessor.getConvertLocalToFieldProposal(context, coveringNode, null) || QuickAssistProcessor.getConvertAnonymousToNestedProposal(context, coveringNode, null) || QuickAssistProcessor.getConvertIterableLoopProposal(context, coveringNode, null) || QuickAssistProcessor.getRemoveBlockProposals(context, coveringNode, null) || QuickAssistProcessor.getMakeVariableDeclarationFinalProposals(context, null) || QuickAssistProcessor.getMissingCaseStatementProposals(context, coveringNode, null) || QuickAssistProcessor.getConvertStringConcatenationProposals(context, null);
        }
        return false;
    }

    public IJavaCompletionProposal[] getAssists(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        ASTNode coveringNode = context.getCoveringNode();
        if (coveringNode != null) {
            ArrayList resultingCollections = new ArrayList();
            boolean noErrorsAtLocation = this.noErrorsAtLocation(locations);
            QuickAssistProcessor.getRenameLocalProposals(context, coveringNode, locations, noErrorsAtLocation, resultingCollections);
            QuickAssistProcessor.getAssignToVariableProposals(context, coveringNode, resultingCollections);
            QuickAssistProcessor.getAssignParamToFieldProposals(context, coveringNode, resultingCollections);
            if (noErrorsAtLocation) {
                QuickAssistProcessor.getCatchClauseToThrowsProposals(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getUnWrapProposals(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getSplitVariableProposals(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getJoinVariableProposals(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getAddFinallyProposals(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getAddElseProposals(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getAddBlockProposals(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getInvertEqualsProposal(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getArrayInitializerToArrayCreation(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getCreateInSuperClassProposals(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getExtractLocalProposal(context, resultingCollections);
                QuickAssistProcessor.getExtractMethodProposal(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getInlineLocalProposal(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getConvertLocalToFieldProposal(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getConvertAnonymousToNestedProposal(context, coveringNode, resultingCollections);
                if (!QuickAssistProcessor.getConvertForLoopProposal(context, coveringNode, resultingCollections)) {
                    QuickAssistProcessor.getConvertIterableLoopProposal(context, coveringNode, resultingCollections);
                }
                QuickAssistProcessor.getRemoveBlockProposals(context, coveringNode, resultingCollections);
                QuickAssistProcessor.getMakeVariableDeclarationFinalProposals(context, resultingCollections);
                QuickAssistProcessor.getConvertStringConcatenationProposals(context, resultingCollections);
                QuickAssistProcessor.getMissingCaseStatementProposals(context, coveringNode, resultingCollections);
            }
            return resultingCollections.toArray(new IJavaCompletionProposal[resultingCollections.size()]);
        }
        return null;
    }

    private boolean noErrorsAtLocation(IProblemLocation[] locations) {
        if (locations != null) {
            int i = 0;
            while (i < locations.length) {
                if (locations[i].isError()) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private static int getIndex(int offset, List statements) {
        int i = 0;
        while (i < statements.size()) {
            Statement s = (Statement)statements.get(i);
            if (offset < s.getStartPosition()) {
                return i;
            }
            if (offset < s.getStartPosition() + s.getLength()) {
                return -1;
            }
            ++i;
        }
        return statements.size();
    }

    private static boolean getExtractMethodProposal(IInvocationContext context, ASTNode coveringNode, Collection proposals) throws CoreException {
        if (!(coveringNode instanceof Expression || coveringNode instanceof Statement || coveringNode instanceof Block)) {
            return false;
        }
        if (coveringNode instanceof Block) {
            List statements = ((Block)coveringNode).statements();
            int startIndex = QuickAssistProcessor.getIndex(context.getSelectionOffset(), statements);
            if (startIndex == -1) {
                return false;
            }
            int endIndex = QuickAssistProcessor.getIndex(context.getSelectionOffset() + context.getSelectionLength(), statements);
            if (endIndex == -1 || endIndex <= startIndex) {
                return false;
            }
        }
        if (proposals == null) {
            return true;
        }
        ICompilationUnit cu = context.getCompilationUnit();
        ExtractMethodRefactoring extractMethodRefactoring = new ExtractMethodRefactoring(context.getASTRoot(), context.getSelectionOffset(), context.getSelectionLength());
        extractMethodRefactoring.setMethodName("extracted");
        if (extractMethodRefactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
            String label = CorrectionMessages.QuickAssistProcessor_extractmethod_description;
            LinkedProposalModel linkedProposalModel = new LinkedProposalModel();
            extractMethodRefactoring.setLinkedProposalModel(linkedProposalModel);
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.methpub_obj.gif");
            RefactoringCorrectionProposal proposal = new RefactoringCorrectionProposal(label, cu, extractMethodRefactoring, 4, image);
            proposal.setCommandId(EXTRACT_CONSTANT_ID);
            proposal.setLinkedProposalModel(linkedProposalModel);
            proposals.add(proposal);
        }
        return true;
    }

    private static boolean getExtractLocalProposal(IInvocationContext context, Collection proposals) throws CoreException {
        ExtractConstantRefactoring extractConstRefactoring;
        ASTNode node = context.getCoveredNode();
        if (!(node instanceof Expression)) {
            return false;
        }
        Expression expression = (Expression)node;
        ITypeBinding binding = expression.resolveTypeBinding();
        if (binding == null || Bindings.isVoidType(binding)) {
            return false;
        }
        if (proposals == null) {
            return true;
        }
        ICompilationUnit cu = context.getCompilationUnit();
        ExtractTempRefactoring extractTempRefactoring = new ExtractTempRefactoring(context.getASTRoot(), expression.getStartPosition(), expression.getLength());
        if (extractTempRefactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
            LinkedProposalModel linkedProposalModel = new LinkedProposalModel();
            extractTempRefactoring.setLinkedProposalModel(linkedProposalModel);
            extractTempRefactoring.setCheckResultForCompileProblems(false);
            String label = CorrectionMessages.QuickAssistProcessor_extract_to_local_all_description;
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.localvariable_obj.gif");
            RefactoringCorrectionProposal proposal = new RefactoringCorrectionProposal(label, cu, extractTempRefactoring, 6, image){

                protected void init(Refactoring refactoring) throws CoreException {
                    ExtractTempRefactoring etr = (ExtractTempRefactoring)refactoring;
                    etr.setTempName(etr.guessTempName());
                }
            };
            proposal.setCommandId(EXTRACT_LOCAL_ID);
            proposal.setLinkedProposalModel(linkedProposalModel);
            proposals.add(proposal);
        }
        ExtractTempRefactoring extractTempRefactoringSelectedOnly = new ExtractTempRefactoring(context.getASTRoot(), expression.getStartPosition(), expression.getLength());
        extractTempRefactoringSelectedOnly.setReplaceAllOccurrences(false);
        if (extractTempRefactoringSelectedOnly.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
            LinkedProposalModel linkedProposalModel = new LinkedProposalModel();
            extractTempRefactoringSelectedOnly.setLinkedProposalModel(linkedProposalModel);
            extractTempRefactoringSelectedOnly.setCheckResultForCompileProblems(false);
            String label = CorrectionMessages.QuickAssistProcessor_extract_to_local_description;
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.localvariable_obj.gif");
            RefactoringCorrectionProposal proposal = new RefactoringCorrectionProposal(label, cu, extractTempRefactoringSelectedOnly, 5, image){

                protected void init(Refactoring refactoring) throws CoreException {
                    ExtractTempRefactoring etr = (ExtractTempRefactoring)refactoring;
                    etr.setTempName(etr.guessTempName());
                }
            };
            proposal.setCommandId(EXTRACT_LOCAL_NOT_REPLACE_ID);
            proposal.setLinkedProposalModel(linkedProposalModel);
            proposals.add(proposal);
        }
        if ((extractConstRefactoring = new ExtractConstantRefactoring(context.getASTRoot(), expression.getStartPosition(), expression.getLength())).checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
            LinkedProposalModel linkedProposalModel = new LinkedProposalModel();
            extractConstRefactoring.setLinkedProposalModel(linkedProposalModel);
            extractConstRefactoring.setCheckResultForCompileProblems(false);
            String label = CorrectionMessages.QuickAssistProcessor_extract_to_constant_description;
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.localvariable_obj.gif");
            RefactoringCorrectionProposal proposal = new RefactoringCorrectionProposal(label, cu, extractConstRefactoring, 4, image){

                protected void init(Refactoring refactoring) throws CoreException {
                    ExtractConstantRefactoring etr = (ExtractConstantRefactoring)refactoring;
                    etr.setConstantName(etr.guessConstantName());
                }
            };
            proposal.setCommandId(EXTRACT_CONSTANT_ID);
            proposal.setLinkedProposalModel(linkedProposalModel);
            proposals.add(proposal);
        }
        return false;
    }

    private static boolean getConvertAnonymousToNestedProposal(IInvocationContext context, ASTNode node, Collection proposals) throws CoreException {
        if (!(node instanceof Name)) {
            return false;
        }
        ASTNode normalized = ASTNodes.getNormalizedNode(node);
        if (normalized.getLocationInParent() != ClassInstanceCreation.TYPE_PROPERTY) {
            return false;
        }
        AnonymousClassDeclaration anonymTypeDecl = ((ClassInstanceCreation)normalized.getParent()).getAnonymousClassDeclaration();
        if (anonymTypeDecl == null || anonymTypeDecl.resolveBinding() == null) {
            return false;
        }
        if (proposals == null) {
            return true;
        }
        ICompilationUnit cu = context.getCompilationUnit();
        ConvertAnonymousToNestedRefactoring refactoring = new ConvertAnonymousToNestedRefactoring(anonymTypeDecl);
        String extTypeName = BasicElementLabels.getJavaElementName(ASTNodes.getSimpleNameIdentifier((Name)node));
        if (anonymTypeDecl.resolveBinding().getInterfaces().length == 0) {
            refactoring.setClassName(Messages.format(CorrectionMessages.QuickAssistProcessor_name_extension_from_interface, extTypeName));
        } else {
            refactoring.setClassName(Messages.format(CorrectionMessages.QuickAssistProcessor_name_extension_from_class, extTypeName));
        }
        if (refactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
            LinkedProposalModel linkedProposalModel = new LinkedProposalModel();
            refactoring.setLinkedProposalModel(linkedProposalModel);
            String label = CorrectionMessages.QuickAssistProcessor_convert_anonym_to_nested;
            Image image = JavaPlugin.getImageDescriptorRegistry().get(JavaElementImageProvider.getTypeImageDescriptor(true, false, 2, false));
            RefactoringCorrectionProposal proposal = new RefactoringCorrectionProposal(label, cu, refactoring, 5, image);
            proposal.setLinkedProposalModel(linkedProposalModel);
            proposal.setCommandId(CONVERT_ANONYMOUS_TO_LOCAL_ID);
            proposals.add(proposal);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean getJoinVariableProposals(IInvocationContext context, ASTNode node, Collection resultingCollections) {
        ASTNode parent = node.getParent();
        VariableDeclarationFragment fragment = null;
        boolean onFirstAccess = false;
        if (node instanceof SimpleName && node.getLocationInParent() == Assignment.LEFT_HAND_SIDE_PROPERTY) {
            onFirstAccess = true;
            SimpleName name = (SimpleName)node;
            IBinding binding = name.resolveBinding();
            if (!(binding instanceof IVariableBinding)) {
                return false;
            }
            ASTNode declaring = context.getASTRoot().findDeclaringNode(binding);
            if (!(declaring instanceof VariableDeclarationFragment)) return false;
            fragment = (VariableDeclarationFragment)declaring;
        } else {
            if (!(parent instanceof VariableDeclarationFragment)) return false;
            fragment = (VariableDeclarationFragment)parent;
        }
        IVariableBinding binding = fragment.resolveBinding();
        if (fragment.getInitializer() != null || binding == null || binding.isField()) {
            return false;
        }
        if (!(fragment.getParent() instanceof VariableDeclarationStatement)) {
            return false;
        }
        VariableDeclarationStatement statement = (VariableDeclarationStatement)fragment.getParent();
        SimpleName[] names = LinkedNodeFinder.findByBinding(statement.getParent(), (IBinding)binding);
        if (names.length <= 1 || names[0] != fragment.getName()) {
            return false;
        }
        SimpleName firstAccess = names[1];
        if (onFirstAccess ? firstAccess != node : firstAccess.getLocationInParent() != Assignment.LEFT_HAND_SIDE_PROPERTY) {
            return false;
        }
        Assignment assignment = (Assignment)firstAccess.getParent();
        if (assignment.getLocationInParent() != ExpressionStatement.EXPRESSION_PROPERTY) {
            return false;
        }
        ExpressionStatement assignParent = (ExpressionStatement)assignment.getParent();
        if (resultingCollections == null) {
            return true;
        }
        AST ast = statement.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        String label = CorrectionMessages.QuickAssistProcessor_joindeclaration_description;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.localvariable_obj.gif");
        LinkedCorrectionProposal proposal = new LinkedCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        proposal.setCommandId(SPLIT_JOIN_VARIABLE_DECLARATION_ID);
        Expression placeholder = (Expression)rewrite.createMoveTarget((ASTNode)assignment.getRightHandSide());
        rewrite.set((ASTNode)fragment, (StructuralPropertyDescriptor)VariableDeclarationFragment.INITIALIZER_PROPERTY, (Object)placeholder, null);
        if (onFirstAccess) {
            rewrite.replace((ASTNode)assignParent, rewrite.createMoveTarget((ASTNode)statement), null);
        } else if (ASTNodes.isControlStatementBody(assignParent.getLocationInParent())) {
            Block block = ast.newBlock();
            rewrite.replace((ASTNode)assignParent, (ASTNode)block, null);
        } else {
            rewrite.remove((ASTNode)assignParent, null);
        }
        proposal.setEndPosition(rewrite.track((ASTNode)fragment.getName()));
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean getSplitVariableProposals(IInvocationContext context, ASTNode node, Collection resultingCollections) {
        ExpressionStatement newStatement;
        VariableDeclarationStatement statement;
        VariableDeclarationFragment fragment;
        if (node instanceof VariableDeclarationFragment) {
            fragment = (VariableDeclarationFragment)node;
        } else if (node.getLocationInParent() == VariableDeclarationFragment.NAME_PROPERTY) {
            fragment = (VariableDeclarationFragment)node.getParent();
        } else {
            return false;
        }
        if (fragment.getInitializer() == null) {
            return false;
        }
        ASTNode fragParent = fragment.getParent();
        if (fragParent instanceof VariableDeclarationStatement) {
            statement = (VariableDeclarationStatement)fragParent;
        } else if (fragParent instanceof VariableDeclarationExpression) {
            statement = (Statement)fragParent.getParent();
        } else {
            return false;
        }
        ASTNode statementParent = statement.getParent();
        StructuralPropertyDescriptor property = statement.getLocationInParent();
        if (!property.isChildListProperty()) {
            return false;
        }
        List list = (List)statementParent.getStructuralProperty(property);
        if (resultingCollections == null) {
            return true;
        }
        AST ast = statement.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        String label = CorrectionMessages.QuickAssistProcessor_splitdeclaration_description;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.localvariable_obj.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        proposal.setCommandId(SPLIT_JOIN_VARIABLE_DECLARATION_ID);
        int insertIndex = list.indexOf(statement);
        Expression placeholder = (Expression)rewrite.createMoveTarget((ASTNode)fragment.getInitializer());
        ITypeBinding binding = fragment.getInitializer().resolveTypeBinding();
        if (placeholder instanceof ArrayInitializer && binding != null && binding.isArray()) {
            ArrayCreation creation = ast.newArrayCreation();
            creation.setInitializer((ArrayInitializer)placeholder);
            ITypeBinding componentType = binding.getElementType();
            Object type = null;
            type = componentType.isPrimitive() ? ast.newPrimitiveType(PrimitiveType.toCode((String)componentType.getName())) : ast.newSimpleType((Name)ast.newSimpleName(componentType.getName()));
            creation.setType(ast.newArrayType((Type)type, binding.getDimensions()));
            placeholder = creation;
        }
        Assignment assignment = ast.newAssignment();
        assignment.setRightHandSide(placeholder);
        assignment.setLeftHandSide((Expression)ast.newSimpleName(fragment.getName().getIdentifier()));
        if (statement instanceof VariableDeclarationStatement) {
            newStatement = ast.newExpressionStatement((Expression)assignment);
            ++insertIndex;
        } else {
            rewrite.replace(fragment.getParent(), (ASTNode)assignment, null);
            VariableDeclarationFragment newFrag = ast.newVariableDeclarationFragment();
            newFrag.setName(ast.newSimpleName(fragment.getName().getIdentifier()));
            newFrag.setExtraDimensions(fragment.getExtraDimensions());
            VariableDeclarationExpression oldVarDecl = (VariableDeclarationExpression)fragParent;
            VariableDeclarationStatement newVarDec = ast.newVariableDeclarationStatement(newFrag);
            newVarDec.setType((Type)ASTNode.copySubtree((AST)ast, (ASTNode)oldVarDecl.getType()));
            newVarDec.modifiers().addAll(ASTNodeFactory.newModifiers(ast, oldVarDecl.getModifiers()));
            newStatement = newVarDec;
        }
        ListRewrite listRewriter = rewrite.getListRewrite(statementParent, (ChildListPropertyDescriptor)property);
        listRewriter.insertAt((ASTNode)newStatement, insertIndex, null);
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean getConvertStringConcatenationProposals(IInvocationContext context, Collection resultingCollections) {
        ASTNode node = context.getCoveringNode();
        BodyDeclaration parentDecl = ASTResolving.findParentBodyDeclaration(node);
        if (!(parentDecl instanceof MethodDeclaration) && !(parentDecl instanceof Initializer)) {
            return false;
        }
        AST ast = node.getAST();
        ITypeBinding stringBinding = ast.resolveWellKnownType("java.lang.String");
        if (node instanceof StringLiteral || node instanceof SimpleName) {
            node = node.getParent();
        }
        if (node instanceof VariableDeclarationFragment) {
            node = ((VariableDeclarationFragment)node).getInitializer();
        } else if (node instanceof Assignment) {
            node = ((Assignment)node).getRightHandSide();
        }
        InfixExpression oldInfixExpression = null;
        while (node instanceof InfixExpression) {
            InfixExpression curr = (InfixExpression)node;
            if (curr.resolveTypeBinding() != stringBinding || curr.getOperator() != InfixExpression.Operator.PLUS) break;
            oldInfixExpression = curr;
            node = node.getParent();
        }
        if (oldInfixExpression == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        LinkedCorrectionProposal stringBufferProposal = QuickAssistProcessor.getConvertToStringBufferProposal(context, ast, oldInfixExpression);
        resultingCollections.add(stringBufferProposal);
        ASTRewriteCorrectionProposal messageFormatProposal = QuickAssistProcessor.getConvertToMessageFormatProposal(context, ast, oldInfixExpression);
        if (messageFormatProposal != null) {
            resultingCollections.add(messageFormatProposal);
        }
        return true;
    }

    private static LinkedCorrectionProposal getConvertToStringBufferProposal(IInvocationContext context, AST ast, InfixExpression oldInfixExpression) {
        ListRewrite listRewrite;
        ICompilationUnit cu = context.getCompilationUnit();
        String bufferOrBuilderName = JavaModelUtil.is50OrHigher(cu.getJavaProject()) ? "StringBuilder" : "StringBuffer";
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        String label = Messages.format(CorrectionMessages.QuickAssistProcessor_convert_to_string_buffer_description, BasicElementLabels.getJavaElementName(bufferOrBuilderName));
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        LinkedCorrectionProposal proposal = new LinkedCorrectionProposal(label, cu, rewrite, 1, image);
        proposal.setCommandId(CONVERT_TO_STRING_BUFFER_ID);
        VariableDeclarationFragment frag = ast.newVariableDeclarationFragment();
        List<String> fExcludedVariableNames = Arrays.asList(ASTResolving.getUsedVariableNames((ASTNode)oldInfixExpression));
        SimpleType bufferType = ast.newSimpleType(ast.newName(bufferOrBuilderName));
        ClassInstanceCreation newBufferExpression = ast.newClassInstanceCreation();
        String[] newBufferNames = StubUtility.getVariableNameSuggestions(5, cu.getJavaProject(), bufferOrBuilderName, 0, fExcludedVariableNames, true);
        String newBufferName = newBufferNames[0];
        SimpleName bufferNameDeclaration = ast.newSimpleName(newBufferName);
        frag.setName(bufferNameDeclaration);
        String groupID = "nameId";
        proposal.addLinkedPosition(rewrite.track((ASTNode)bufferNameDeclaration), true, groupID);
        int i = 0;
        while (i < newBufferNames.length) {
            proposal.addLinkedPositionProposal(groupID, newBufferNames[i], null);
            ++i;
        }
        newBufferExpression.setType((Type)bufferType);
        frag.setInitializer((Expression)newBufferExpression);
        VariableDeclarationStatement bufferDeclaration = ast.newVariableDeclarationStatement(frag);
        bufferDeclaration.setType((Type)ast.newSimpleType(ast.newName(bufferOrBuilderName)));
        Statement statement = ASTResolving.findParentStatement((ASTNode)oldInfixExpression);
        if (ASTNodes.isControlStatementBody(statement.getLocationInParent())) {
            Block newBlock = ast.newBlock();
            listRewrite = rewrite.getListRewrite((ASTNode)newBlock, Block.STATEMENTS_PROPERTY);
            listRewrite.insertFirst((ASTNode)bufferDeclaration, null);
            listRewrite.insertLast(rewrite.createMoveTarget((ASTNode)statement), null);
            rewrite.replace((ASTNode)statement, (ASTNode)newBlock, null);
        } else {
            listRewrite = rewrite.getListRewrite(statement.getParent(), (ChildListPropertyDescriptor)statement.getLocationInParent());
            listRewrite.insertBefore((ASTNode)bufferDeclaration, (ASTNode)statement, null);
        }
        ArrayList<ASTNode> operands = new ArrayList<ASTNode>();
        operands.add(rewrite.createCopyTarget((ASTNode)oldInfixExpression.getLeftOperand()));
        operands.add(rewrite.createCopyTarget((ASTNode)oldInfixExpression.getRightOperand()));
        int i2 = 0;
        while (i2 < oldInfixExpression.extendedOperands().size()) {
            ASTNode extNode = (ASTNode)oldInfixExpression.extendedOperands().get(i2);
            operands.add(rewrite.createCopyTarget(extNode));
            ++i2;
        }
        VariableDeclarationStatement lastAppend = bufferDeclaration;
        Iterator iter = operands.iterator();
        while (iter.hasNext()) {
            Expression operand = (Expression)iter.next();
            MethodInvocation appendIncovationExpression = ast.newMethodInvocation();
            appendIncovationExpression.setName(ast.newSimpleName("append"));
            SimpleName bufferNameReference = ast.newSimpleName(newBufferName);
            proposal.addLinkedPosition(rewrite.track((ASTNode)bufferNameReference), true, groupID);
            appendIncovationExpression.setExpression((Expression)bufferNameReference);
            appendIncovationExpression.arguments().add(operand);
            ExpressionStatement appendExpressionStatement = ast.newExpressionStatement((Expression)appendIncovationExpression);
            listRewrite.insertAfter((ASTNode)appendExpressionStatement, (ASTNode)lastAppend, null);
            lastAppend = appendExpressionStatement;
        }
        MethodInvocation bufferToString = ast.newMethodInvocation();
        bufferToString.setName(ast.newSimpleName("toString"));
        SimpleName bufferNameReference = ast.newSimpleName(newBufferName);
        bufferToString.setExpression((Expression)bufferNameReference);
        proposal.addLinkedPosition(rewrite.track((ASTNode)bufferNameReference), true, groupID);
        rewrite.replace((ASTNode)oldInfixExpression, (ASTNode)bufferToString, null);
        proposal.setEndPosition(rewrite.track((ASTNode)bufferToString));
        return proposal;
    }

    private static ASTRewriteCorrectionProposal getConvertToMessageFormatProposal(IInvocationContext context, AST ast, InfixExpression oldInfixExpression) {
        ICompilationUnit cu = context.getCompilationUnit();
        boolean is50OrHigher = JavaModelUtil.is50OrHigher(cu.getJavaProject());
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        CompilationUnit root = context.getASTRoot();
        ImportRewrite importRewrite = ImportRewrite.create((CompilationUnit)root, (boolean)true);
        ContextSensitiveImportRewriteContext importContext = new ContextSensitiveImportRewriteContext(context.getASTRoot(), oldInfixExpression.getStartPosition(), importRewrite);
        ArrayList<Object> operands = new ArrayList<Object>();
        operands.add(oldInfixExpression.getLeftOperand());
        operands.add(oldInfixExpression.getRightOperand());
        int i = 0;
        while (i < oldInfixExpression.extendedOperands().size()) {
            ASTNode extNode = (ASTNode)oldInfixExpression.extendedOperands().get(i);
            operands.add(extNode);
            ++i;
        }
        ArrayList<ASTNode> formatArguments = new ArrayList<ASTNode>();
        String formatString = "";
        int i2 = 0;
        Iterator iterator = operands.iterator();
        while (iterator.hasNext()) {
            ASTNode argument;
            Expression operand = (Expression)iterator.next();
            if (operand instanceof StringLiteral) {
                String value = ((StringLiteral)operand).getEscapedValue();
                value = value.substring(1, value.length() - 1);
                value = value.replaceAll("'", "''");
                formatString = String.valueOf(formatString) + value;
                continue;
            }
            formatString = String.valueOf(formatString) + "{" + i2 + "}";
            if (is50OrHigher) {
                argument = rewrite.createCopyTarget((ASTNode)operand);
            } else {
                ITypeBinding boxedBinding;
                ITypeBinding binding = operand.resolveTypeBinding();
                if (binding == null) {
                    return null;
                }
                argument = rewrite.createCopyTarget((ASTNode)operand);
                if (binding.isPrimitive() && (boxedBinding = Bindings.getBoxedTypeBinding(binding, ast)) != binding) {
                    Type boxedType = importRewrite.addImport(boxedBinding, ast, (ImportRewrite.ImportRewriteContext)importContext);
                    ClassInstanceCreation cic = ast.newClassInstanceCreation();
                    cic.setType(boxedType);
                    cic.arguments().add(argument);
                    argument = cic;
                }
            }
            formatArguments.add(argument);
            ++i2;
        }
        if (formatArguments.size() == 0) {
            return null;
        }
        String label = CorrectionMessages.QuickAssistProcessor_convert_to_message_format;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, 0, image);
        proposal.setCommandId(CONVERT_TO_MESSAGE_FORMAT_ID);
        proposal.setImportRewrite(importRewrite);
        String messageType = importRewrite.addImport("java.text.MessageFormat", (ImportRewrite.ImportRewriteContext)importContext);
        MethodInvocation formatInvocation = ast.newMethodInvocation();
        formatInvocation.setExpression((Expression)ast.newName(messageType));
        formatInvocation.setName(ast.newSimpleName("format"));
        List arguments = formatInvocation.arguments();
        StringLiteral formatStringArgument = ast.newStringLiteral();
        formatStringArgument.setEscapedValue("\"" + formatString + "\"");
        arguments.add(formatStringArgument);
        if (is50OrHigher) {
            Iterator iterator2 = formatArguments.iterator();
            while (iterator2.hasNext()) {
                arguments.add(iterator2.next());
            }
        } else {
            ArrayCreation objectArrayCreation = ast.newArrayCreation();
            SimpleType objectType = ast.newSimpleType((Name)ast.newSimpleName("Object"));
            ArrayType arrayType = ast.newArrayType((Type)objectType);
            objectArrayCreation.setType(arrayType);
            ArrayInitializer arrayInitializer = ast.newArrayInitializer();
            List initializerExpressions = arrayInitializer.expressions();
            Iterator iterator3 = formatArguments.iterator();
            while (iterator3.hasNext()) {
                initializerExpressions.add(iterator3.next());
            }
            objectArrayCreation.setInitializer(arrayInitializer);
            arguments.add(objectArrayCreation);
        }
        rewrite.replace((ASTNode)oldInfixExpression, (ASTNode)formatInvocation, null);
        return proposal;
    }

    private static boolean getAssignToVariableProposals(IInvocationContext context, ASTNode node, Collection resultingCollections) {
        Statement statement = ASTResolving.findParentStatement(node);
        if (!(statement instanceof ExpressionStatement)) {
            return false;
        }
        ExpressionStatement expressionStatement = (ExpressionStatement)statement;
        Expression expression = expressionStatement.getExpression();
        if (expression.getNodeType() == 7) {
            return false;
        }
        ITypeBinding typeBinding = expression.resolveTypeBinding();
        if ((typeBinding = Bindings.normalizeTypeBinding(typeBinding)) == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        ICompilationUnit cu = context.getCompilationUnit();
        AssignToVariableAssistProposal localProposal = new AssignToVariableAssistProposal(cu, 1, expressionStatement, typeBinding, 2);
        localProposal.setCommandId(ASSIGN_TO_LOCAL_ID);
        resultingCollections.add(localProposal);
        ASTNode type = ASTResolving.findParentType((ASTNode)expression);
        if (type != null) {
            AssignToVariableAssistProposal fieldProposal = new AssignToVariableAssistProposal(cu, 2, expressionStatement, typeBinding, 1);
            fieldProposal.setCommandId(ASSIGN_TO_FIELD_ID);
            resultingCollections.add(fieldProposal);
        }
        return false;
    }

    private static boolean getAssignParamToFieldProposals(IInvocationContext context, ASTNode node, Collection resultingCollections) {
        ASTNode parent = (node = ASTNodes.getNormalizedNode(node)).getParent();
        if (!(parent instanceof SingleVariableDeclaration) || !(parent.getParent() instanceof MethodDeclaration)) {
            return false;
        }
        SingleVariableDeclaration paramDecl = (SingleVariableDeclaration)parent;
        IVariableBinding binding = paramDecl.resolveBinding();
        MethodDeclaration methodDecl = (MethodDeclaration)parent.getParent();
        if (binding == null || methodDecl.getBody() == null) {
            return false;
        }
        ITypeBinding typeBinding = binding.getType();
        if (typeBinding == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        ITypeBinding parentType = Bindings.getBindingOfParentType(node);
        if (parentType != null) {
            CompilationUnit root = context.getASTRoot();
            IVariableBinding[] declaredFields = parentType.getDeclaredFields();
            boolean isStaticContext = ASTResolving.isInStaticContext(node);
            int i = 0;
            while (i < declaredFields.length) {
                VariableDeclarationFragment fragment;
                ASTNode fieldDeclFrag;
                IVariableBinding curr = declaredFields[i];
                if (isStaticContext == Modifier.isStatic((int)curr.getModifiers()) && typeBinding.isAssignmentCompatible(curr.getType()) && (fieldDeclFrag = root.findDeclaringNode((IBinding)curr)) instanceof VariableDeclarationFragment && (fragment = (VariableDeclarationFragment)fieldDeclFrag).getInitializer() == null) {
                    resultingCollections.add(new AssignToVariableAssistProposal(context.getCompilationUnit(), paramDecl, fragment, typeBinding, 1));
                }
                ++i;
            }
        }
        AssignToVariableAssistProposal fieldProposal = new AssignToVariableAssistProposal(context.getCompilationUnit(), paramDecl, null, typeBinding, 3);
        fieldProposal.setCommandId(ASSIGN_PARAM_TO_FIELD_ID);
        resultingCollections.add(fieldProposal);
        return true;
    }

    private static boolean getAddFinallyProposals(IInvocationContext context, ASTNode node, Collection resultingCollections) {
        TryStatement tryStatement = ASTResolving.findParentTryStatement(node);
        if (tryStatement == null || tryStatement.getFinally() != null) {
            return false;
        }
        Statement statement = ASTResolving.findParentStatement(node);
        if (tryStatement != statement && tryStatement.getBody() != statement) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = tryStatement.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        Block finallyBody = ast.newBlock();
        rewrite.set((ASTNode)tryStatement, (StructuralPropertyDescriptor)TryStatement.FINALLY_PROPERTY, (Object)finallyBody, null);
        String label = CorrectionMessages.QuickAssistProcessor_addfinallyblock_description;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.add_correction.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean getAddElseProposals(IInvocationContext context, ASTNode node, Collection resultingCollections) {
        if (!(node instanceof IfStatement)) {
            return false;
        }
        IfStatement ifStatement = (IfStatement)node;
        if (ifStatement.getElseStatement() != null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = node.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        Block body = ast.newBlock();
        rewrite.set((ASTNode)ifStatement, (StructuralPropertyDescriptor)IfStatement.ELSE_STATEMENT_PROPERTY, (Object)body, null);
        String label = CorrectionMessages.QuickAssistProcessor_addelseblock_description;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.add_correction.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        resultingCollections.add(proposal);
        return true;
    }

    public static boolean getCatchClauseToThrowsProposals(IInvocationContext context, ASTNode node, Collection resultingCollections) {
        CatchClause catchClause = (CatchClause)ASTResolving.findAncestor(node, 12);
        if (catchClause == null) {
            return false;
        }
        Statement statement = ASTResolving.findParentStatement(node);
        if (statement != catchClause.getParent() && statement != catchClause.getBody()) {
            return false;
        }
        Type type = catchClause.getException().getType();
        if (!type.isSimpleType()) {
            return false;
        }
        BodyDeclaration bodyDeclaration = ASTResolving.findParentBodyDeclaration((ASTNode)catchClause);
        if (!(bodyDeclaration instanceof MethodDeclaration) && !(bodyDeclaration instanceof Initializer)) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = bodyDeclaration.getAST();
        if (bodyDeclaration instanceof MethodDeclaration) {
            MethodDeclaration methodDeclaration = (MethodDeclaration)bodyDeclaration;
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            QuickAssistProcessor.removeCatchBlock(rewrite, catchClause);
            ITypeBinding binding = type.resolveBinding();
            if (binding == null || QuickAssistProcessor.isNotYetThrown(binding, methodDeclaration.thrownExceptions())) {
                Name name = ((SimpleType)type).getName();
                Name newName = (Name)ASTNode.copySubtree((AST)ast, (ASTNode)name);
                ListRewrite listRewriter = rewrite.getListRewrite((ASTNode)methodDeclaration, MethodDeclaration.THROWN_EXCEPTIONS_PROPERTY);
                listRewriter.insertLast((ASTNode)newName, null);
            }
            String label = CorrectionMessages.QuickAssistProcessor_catchclausetothrows_description;
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.jexception_obj.gif");
            ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 4, image);
            resultingCollections.add(proposal);
        }
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        QuickAssistProcessor.removeCatchBlock(rewrite, catchClause);
        String label = CorrectionMessages.QuickAssistProcessor_removecatchclause_description;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.jexception_obj.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 5, image);
        resultingCollections.add(proposal);
        return true;
    }

    private static void removeCatchBlock(ASTRewrite rewrite, CatchClause catchClause) {
        TryStatement tryStatement = (TryStatement)catchClause.getParent();
        if (tryStatement.catchClauses().size() > 1 || tryStatement.getFinally() != null) {
            rewrite.remove((ASTNode)catchClause, null);
        } else {
            Block block = tryStatement.getBody();
            List statements = block.statements();
            int nStatements = statements.size();
            if (nStatements == 1) {
                ASTNode first = (ASTNode)statements.get(0);
                rewrite.replace((ASTNode)tryStatement, rewrite.createCopyTarget(first), null);
            } else if (nStatements > 1) {
                ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)block, Block.STATEMENTS_PROPERTY);
                ASTNode first = (ASTNode)statements.get(0);
                ASTNode last = (ASTNode)statements.get(statements.size() - 1);
                ASTNode newStatement = listRewrite.createCopyTarget(first, last);
                if (ASTNodes.isControlStatementBody(tryStatement.getLocationInParent())) {
                    Block newBlock = rewrite.getAST().newBlock();
                    newBlock.statements().add(newStatement);
                    newStatement = newBlock;
                }
                rewrite.replace((ASTNode)tryStatement, newStatement, null);
            } else {
                rewrite.remove((ASTNode)tryStatement, null);
            }
        }
    }

    private static boolean isNotYetThrown(ITypeBinding binding, List thrownExcpetions) {
        int i = 0;
        while (i < thrownExcpetions.size()) {
            Name name = (Name)thrownExcpetions.get(i);
            ITypeBinding elem = (ITypeBinding)name.resolveBinding();
            if (elem != null && Bindings.isSuperType(elem, binding)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean getRenameLocalProposals(IInvocationContext context, ASTNode node, IProblemLocation[] locations, boolean noErrorsAtLocation, Collection resultingCollections) {
        if (!(node instanceof SimpleName)) {
            return false;
        }
        SimpleName name = (SimpleName)node;
        IBinding binding = name.resolveBinding();
        if (binding != null && binding.getKind() == 1) {
            return false;
        }
        if (locations != null) {
            int i = 0;
            while (i < locations.length) {
                switch (locations[i].getProblemId()) {
                    case 536871002: 
                    case 536871006: 
                    case 536871007: 
                    case 570425435: 
                    case 570425436: 
                    case 570425437: {
                        return false;
                    }
                }
                ++i;
            }
        }
        if (resultingCollections == null) {
            return true;
        }
        LinkedNamesAssistProposal proposal = new LinkedNamesAssistProposal(context.getCompilationUnit(), name);
        if (!noErrorsAtLocation) {
            proposal.setRelevance(1);
        }
        resultingCollections.add(proposal);
        return true;
    }

    public static ASTNode getCopyOfInner(ASTRewrite rewrite, ASTNode statement, boolean toControlStatementBody) {
        if (statement.getNodeType() == 8) {
            Block block = (Block)statement;
            List innerStatements = block.statements();
            int nStatements = innerStatements.size();
            if (nStatements == 1) {
                return rewrite.createCopyTarget((ASTNode)innerStatements.get(0));
            }
            if (nStatements > 1) {
                if (toControlStatementBody) {
                    return rewrite.createCopyTarget((ASTNode)block);
                }
                ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)block, Block.STATEMENTS_PROPERTY);
                ASTNode first = (ASTNode)innerStatements.get(0);
                ASTNode last = (ASTNode)innerStatements.get(nStatements - 1);
                return listRewrite.createCopyTarget(first, last);
            }
            return null;
        }
        return rewrite.createCopyTarget(statement);
    }

    private static boolean getUnWrapProposals(IInvocationContext context, ASTNode node, Collection resultingCollections) {
        MethodInvocation invocation;
        ASTNode outer = node;
        Block block = null;
        if (outer.getNodeType() == 8) {
            block = (Block)outer;
            outer = block.getParent();
        }
        Statement body = null;
        String label = null;
        if (outer instanceof IfStatement) {
            IfStatement ifStatement = (IfStatement)outer;
            Statement elseBlock = ifStatement.getElseStatement();
            if (elseBlock == null || elseBlock instanceof Block && ((Block)elseBlock).statements().isEmpty()) {
                body = ifStatement.getThenStatement();
            }
            label = CorrectionMessages.QuickAssistProcessor_unwrap_ifstatement;
        } else if (outer instanceof WhileStatement) {
            body = ((WhileStatement)outer).getBody();
            label = CorrectionMessages.QuickAssistProcessor_unwrap_whilestatement;
        } else if (outer instanceof ForStatement) {
            body = ((ForStatement)outer).getBody();
            label = CorrectionMessages.QuickAssistProcessor_unwrap_forstatement;
        } else if (outer instanceof DoStatement) {
            body = ((DoStatement)outer).getBody();
            label = CorrectionMessages.QuickAssistProcessor_unwrap_dostatement;
        } else if (outer instanceof TryStatement) {
            TryStatement tryStatement = (TryStatement)outer;
            if (tryStatement.catchClauses().isEmpty()) {
                body = tryStatement.getBody();
            }
            label = CorrectionMessages.QuickAssistProcessor_unwrap_trystatement;
        } else if (outer instanceof AnonymousClassDeclaration) {
            List decls = ((AnonymousClassDeclaration)outer).bodyDeclarations();
            int i = 0;
            while (i < decls.size()) {
                ASTNode elem = (ASTNode)decls.get(i);
                if (elem instanceof MethodDeclaration) {
                    Block curr = ((MethodDeclaration)elem).getBody();
                    if (curr != null && !curr.statements().isEmpty()) {
                        if (body != null) {
                            return false;
                        }
                        body = curr;
                    }
                } else if (elem instanceof TypeDeclaration) {
                    return false;
                }
                ++i;
            }
            label = CorrectionMessages.QuickAssistProcessor_unwrap_anonymous;
            if ((outer = ASTResolving.findParentStatement(outer)) == null) {
                return false;
            }
        } else if (outer instanceof Block) {
            body = block;
            outer = block;
            label = CorrectionMessages.QuickAssistProcessor_unwrap_block;
        } else if (!(outer instanceof ParenthesizedExpression) && outer instanceof MethodInvocation && (invocation = (MethodInvocation)outer).arguments().size() == 1) {
            int kind;
            body = (ASTNode)invocation.arguments().get(0);
            if (invocation.getParent().getNodeType() == 21 && (kind = body.getNodeType()) != 7 && kind != 38 && kind != 37 && kind != 32 && kind != 48) {
                body = null;
            }
            label = CorrectionMessages.QuickAssistProcessor_unwrap_methodinvocation;
        }
        if (body == null) {
            return false;
        }
        ASTRewrite rewrite = ASTRewrite.create((AST)outer.getAST());
        ASTNode inner = QuickAssistProcessor.getCopyOfInner(rewrite, (ASTNode)body, ASTNodes.isControlStatementBody(outer.getLocationInParent()));
        if (inner == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        rewrite.replace(outer, inner, null);
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.jexception_obj.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean isControlStatementWithBlock(ASTNode node) {
        switch (node.getNodeType()) {
            case 19: 
            case 24: 
            case 25: 
            case 61: {
                return true;
            }
        }
        return false;
    }

    private static boolean getRemoveBlockProposals(IInvocationContext context, ASTNode coveringNode, Collection resultingCollections) {
        ControlStatementsFix[] fixes = ControlStatementsFix.createRemoveBlockFix(context.getASTRoot(), coveringNode);
        if (fixes != null) {
            if (resultingCollections == null) {
                return true;
            }
            Hashtable<String, String> options = new Hashtable<String, String>();
            options.put("cleanup.use_blocks", "true");
            options.put("cleanup.never_use_blocks", "true");
            ControlStatementsCleanUp cleanUp = new ControlStatementsCleanUp(options);
            int i = 0;
            while (i < fixes.length) {
                ControlStatementsFix fix = fixes[i];
                Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
                FixCorrectionProposal proposal = new FixCorrectionProposal(fix, cleanUp, 0, image, context);
                resultingCollections.add(proposal);
                ++i;
            }
            return true;
        }
        return false;
    }

    private static boolean getAddBlockProposals(IInvocationContext context, ASTNode node, Collection resultingCollections) {
        if (!(node instanceof Statement)) {
            return false;
        }
        if (!QuickAssistProcessor.isControlStatementWithBlock(node) && QuickAssistProcessor.isControlStatementWithBlock(node.getParent())) {
            int statementStart = node.getStartPosition();
            int statementEnd = statementStart + node.getLength();
            int offset = context.getSelectionOffset();
            int length = context.getSelectionLength();
            if (length == 0 ? offset != statementEnd : offset > statementStart || offset + length < statementEnd) {
                return false;
            }
            node = node.getParent();
        }
        ChildPropertyDescriptor childProperty = null;
        Statement child = null;
        switch (node.getNodeType()) {
            case 25: {
                Statement then = ((IfStatement)node).getThenStatement();
                Statement elseStatement = ((IfStatement)node).getElseStatement();
                if (then instanceof Block && (elseStatement instanceof Block || elseStatement == null)) break;
                int thenEnd = then.getStartPosition() + then.getLength();
                int selectionEnd = context.getSelectionOffset() + context.getSelectionLength();
                if (!(then instanceof Block)) {
                    if (selectionEnd <= thenEnd) {
                        childProperty = IfStatement.THEN_STATEMENT_PROPERTY;
                        child = then;
                        break;
                    }
                    if (elseStatement != null && selectionEnd < elseStatement.getStartPosition()) {
                        try {
                            TokenScanner scanner = new TokenScanner((ITypeRoot)context.getCompilationUnit());
                            int elseTokenStart = scanner.getNextStartOffset(thenEnd, true);
                            if (selectionEnd < elseTokenStart) {
                                childProperty = IfStatement.THEN_STATEMENT_PROPERTY;
                                child = then;
                                break;
                            }
                        }
                        catch (CoreException coreException) {}
                    }
                }
                if (elseStatement == null || elseStatement instanceof Block || context.getSelectionOffset() < thenEnd) break;
                childProperty = IfStatement.ELSE_STATEMENT_PROPERTY;
                child = elseStatement;
                break;
            }
            case 61: {
                Statement whileBody = ((WhileStatement)node).getBody();
                if (whileBody instanceof Block) break;
                childProperty = WhileStatement.BODY_PROPERTY;
                child = whileBody;
                break;
            }
            case 24: {
                Statement forBody = ((ForStatement)node).getBody();
                if (forBody instanceof Block) break;
                childProperty = ForStatement.BODY_PROPERTY;
                child = forBody;
                break;
            }
            case 19: {
                Statement doBody = ((DoStatement)node).getBody();
                if (doBody instanceof Block) break;
                childProperty = DoStatement.BODY_PROPERTY;
                child = doBody;
            }
        }
        if (child == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = node.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        ASTNode childPlaceholder = rewrite.createMoveTarget((ASTNode)child);
        Block replacingBody = ast.newBlock();
        replacingBody.statements().add(childPlaceholder);
        rewrite.set(node, (StructuralPropertyDescriptor)childProperty, (Object)replacingBody, null);
        String label = childProperty == IfStatement.THEN_STATEMENT_PROPERTY ? CorrectionMessages.QuickAssistProcessor_replacethenwithblock_description : (childProperty == IfStatement.ELSE_STATEMENT_PROPERTY ? CorrectionMessages.QuickAssistProcessor_replaceelsewithblock_description : CorrectionMessages.QuickAssistProcessor_replacebodywithblock_description);
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        LinkedCorrectionProposal proposal = new LinkedCorrectionProposal(label, context.getCompilationUnit(), rewrite, 6, image);
        proposal.setCommandId(ADD_BLOCK_ID);
        proposal.setEndPosition(rewrite.track((ASTNode)child));
        resultingCollections.add(proposal);
        if (node.getNodeType() == 25) {
            IfStatement ifStatement;
            Statement elseStatment;
            rewrite = ASTRewrite.create((AST)ast);
            while (node.getLocationInParent() == IfStatement.ELSE_STATEMENT_PROPERTY) {
                node = node.getParent();
            }
            boolean missingBlockFound = false;
            boolean foundElse = false;
            do {
                ifStatement = (IfStatement)node;
                Statement thenStatment = ifStatement.getThenStatement();
                elseStatment = ifStatement.getElseStatement();
                if (!(thenStatment instanceof Block)) {
                    ASTNode childPlaceholder1 = rewrite.createMoveTarget((ASTNode)thenStatment);
                    Block replacingBody1 = ast.newBlock();
                    replacingBody1.statements().add(childPlaceholder1);
                    rewrite.set((ASTNode)ifStatement, (StructuralPropertyDescriptor)IfStatement.THEN_STATEMENT_PROPERTY, (Object)replacingBody1, null);
                    if (thenStatment != child) {
                        missingBlockFound = true;
                    }
                }
                if (elseStatment != null) {
                    foundElse = true;
                }
                node = elseStatment;
            } while (elseStatment instanceof IfStatement);
            if (elseStatment != null && !(elseStatment instanceof Block)) {
                ASTNode childPlaceholder2 = rewrite.createMoveTarget((ASTNode)elseStatment);
                Block replacingBody2 = ast.newBlock();
                replacingBody2.statements().add(childPlaceholder2);
                rewrite.set((ASTNode)ifStatement, (StructuralPropertyDescriptor)IfStatement.ELSE_STATEMENT_PROPERTY, (Object)replacingBody2, null);
                if (elseStatment != child) {
                    missingBlockFound = true;
                }
            }
            if (missingBlockFound && foundElse) {
                String label2 = CorrectionMessages.QuickAssistProcessor_replacethenelsewithblock_description;
                Image image2 = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
                ASTRewriteCorrectionProposal proposal2 = new ASTRewriteCorrectionProposal(label2, context.getCompilationUnit(), rewrite, 5, image2);
                resultingCollections.add(proposal2);
            }
        }
        return true;
    }

    private static boolean getInvertEqualsProposal(IInvocationContext context, ASTNode node, Collection resultingCollections) {
        MethodInvocation replacement;
        ASTNode parent = node.getParent();
        if (!(parent instanceof MethodInvocation)) {
            return false;
        }
        MethodInvocation method = (MethodInvocation)parent;
        String identifier = method.getName().getIdentifier();
        if (!"equals".equals(identifier) && !"equalsIgnoreCase".equals(identifier)) {
            return false;
        }
        List arguments = method.arguments();
        if (arguments.size() != 1) {
            return false;
        }
        Expression right = (Expression)arguments.get(0);
        ITypeBinding binding = right.resolveTypeBinding();
        if (binding != null && !binding.isClass() && !binding.isInterface()) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        Expression left = method.getExpression();
        AST ast = method.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        if (left == null) {
            replacement = ast.newMethodInvocation();
            replacement.setName((SimpleName)rewrite.createCopyTarget((ASTNode)method.getName()));
            replacement.arguments().add(ast.newThisExpression());
            replacement.setExpression((Expression)rewrite.createCopyTarget((ASTNode)right));
            rewrite.replace((ASTNode)method, (ASTNode)replacement, null);
        } else if (right instanceof ThisExpression) {
            replacement = ast.newMethodInvocation();
            replacement.setName((SimpleName)rewrite.createCopyTarget((ASTNode)method.getName()));
            replacement.arguments().add(rewrite.createCopyTarget((ASTNode)left));
            rewrite.replace((ASTNode)method, (ASTNode)replacement, null);
        } else {
            Expression leftExpression = left;
            while (leftExpression instanceof ParenthesizedExpression) {
                leftExpression = ((ParenthesizedExpression)left).getExpression();
            }
            rewrite.replace((ASTNode)right, rewrite.createCopyTarget((ASTNode)leftExpression), null);
            if (right instanceof CastExpression || right instanceof Assignment || right instanceof ConditionalExpression || right instanceof InfixExpression) {
                ParenthesizedExpression paren = ast.newParenthesizedExpression();
                paren.setExpression((Expression)rewrite.createCopyTarget((ASTNode)right));
                rewrite.replace((ASTNode)left, (ASTNode)paren, null);
            } else {
                rewrite.replace((ASTNode)left, rewrite.createCopyTarget((ASTNode)right), null);
            }
        }
        String label = CorrectionMessages.QuickAssistProcessor_invertequals_description;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        LinkedCorrectionProposal proposal = new LinkedCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean getArrayInitializerToArrayCreation(IInvocationContext context, ASTNode node, Collection resultingCollections) {
        if (!(node instanceof ArrayInitializer)) {
            return false;
        }
        ArrayInitializer initializer = (ArrayInitializer)node;
        ASTNode parent = initializer.getParent();
        while (parent instanceof ArrayInitializer) {
            initializer = (ArrayInitializer)parent;
            parent = parent.getParent();
        }
        ITypeBinding typeBinding = initializer.resolveTypeBinding();
        if (!(parent instanceof VariableDeclaration) || typeBinding == null || !typeBinding.isArray()) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = node.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        String label = CorrectionMessages.QuickAssistProcessor_typetoarrayInitializer_description;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        LinkedCorrectionProposal proposal = new LinkedCorrectionProposal(label, context.getCompilationUnit(), rewrite, 1, image);
        ImportRewrite imports = proposal.createImportRewrite(context.getASTRoot());
        String typeName = imports.addImport(typeBinding);
        ArrayCreation creation = ast.newArrayCreation();
        creation.setInitializer((ArrayInitializer)rewrite.createMoveTarget((ASTNode)initializer));
        creation.setType((ArrayType)ASTNodeFactory.newType(ast, typeName));
        rewrite.replace((ASTNode)initializer, (ASTNode)creation, null);
        resultingCollections.add(proposal);
        return true;
    }

    public static boolean getCreateInSuperClassProposals(IInvocationContext context, ASTNode node, Collection resultingCollections) throws CoreException {
        if (!(node instanceof SimpleName) || !(node.getParent() instanceof MethodDeclaration)) {
            return false;
        }
        MethodDeclaration decl = (MethodDeclaration)node.getParent();
        if (decl.getName() != node || decl.resolveBinding() == null || Modifier.isPrivate((int)decl.getModifiers())) {
            return false;
        }
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        IMethodBinding binding = decl.resolveBinding();
        ITypeBinding[] paramTypes = binding.getParameterTypes();
        ITypeBinding[] superTypes = Bindings.getAllSuperTypes(binding.getDeclaringClass());
        if (resultingCollections == null) {
            int i = 0;
            while (i < superTypes.length) {
                ITypeBinding curr = superTypes[i];
                if (curr.isFromSource() && Bindings.findOverriddenMethodInType(curr, binding) == null) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        List params = decl.parameters();
        String[] paramNames = new String[paramTypes.length];
        int i = 0;
        while (i < params.size()) {
            SingleVariableDeclaration param = (SingleVariableDeclaration)params.get(i);
            paramNames[i] = param.getName().getIdentifier();
            ++i;
        }
        i = 0;
        while (i < superTypes.length) {
            ITypeBinding typeDecl;
            ICompilationUnit targetCU;
            IMethodBinding method;
            ITypeBinding curr = superTypes[i];
            if (curr.isFromSource() && (method = Bindings.findOverriddenMethodInType(curr, binding)) == null && (targetCU = ASTResolving.findCompilationUnitForBinding(cu, astRoot, typeDecl = curr.getTypeDeclaration())) != null) {
                String label = Messages.format(CorrectionMessages.QuickAssistProcessor_createmethodinsuper_description, new String[]{BasicElementLabels.getJavaElementName(curr.getName()), BasicElementLabels.getJavaElementName(binding.getName())});
                resultingCollections.add(new NewDefiningMethodProposal(label, targetCU, (ASTNode)astRoot, typeDecl, binding, paramNames, 6));
            }
            ++i;
        }
        return true;
    }

    private static boolean getConvertForLoopProposal(IInvocationContext context, ASTNode node, Collection resultingCollections) {
        ForStatement forStatement = QuickAssistProcessor.getEnclosingForStatementHeader(node);
        if (forStatement == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        ConvertLoopFix fix = ConvertLoopFix.createConvertForLoopToEnhancedFix(context.getASTRoot(), forStatement);
        if (fix == null) {
            return false;
        }
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("cleanup.convert_to_enhanced_for_loop", "true");
        ConvertLoopCleanUp cleanUp = new ConvertLoopCleanUp(options);
        FixCorrectionProposal proposal = new FixCorrectionProposal(fix, cleanUp, 1, image, context);
        proposal.setCommandId(CONVERT_FOR_LOOP_ID);
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean getConvertIterableLoopProposal(IInvocationContext context, ASTNode node, Collection resultingCollections) {
        ForStatement forStatement = QuickAssistProcessor.getEnclosingForStatementHeader(node);
        if (forStatement == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        ConvertLoopFix fix = ConvertLoopFix.createConvertIterableLoopToEnhancedFix(context.getASTRoot(), forStatement);
        if (fix == null) {
            return false;
        }
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("cleanup.convert_to_enhanced_for_loop", "true");
        ConvertLoopCleanUp cleanUp = new ConvertLoopCleanUp(options);
        FixCorrectionProposal proposal = new FixCorrectionProposal(fix, cleanUp, 1, image, context);
        proposal.setCommandId(CONVERT_FOR_LOOP_ID);
        resultingCollections.add(proposal);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private static ForStatement getEnclosingForStatementHeader(ASTNode node) {
        if (!(node instanceof ForStatement)) ** GOTO lbl10
        return (ForStatement)node;
lbl-1000:
        // 1 sources

        {
            parent = node.getParent();
            if (parent instanceof ForStatement) {
                locationInParent = node.getLocationInParent();
                if (locationInParent == ForStatement.EXPRESSION_PROPERTY || locationInParent == ForStatement.INITIALIZERS_PROPERTY || locationInParent == ForStatement.UPDATERS_PROPERTY) {
                    return (ForStatement)parent;
                }
                return null;
            }
            node = parent;
lbl10:
            // 2 sources

            ** while (node != null)
        }
lbl11:
        // 1 sources

        return null;
    }

    private static boolean getMakeVariableDeclarationFinalProposals(IInvocationContext context, Collection resultingCollections) {
        SelectionAnalyzer analyzer = new SelectionAnalyzer(Selection.createFromStartLength(context.getSelectionOffset(), context.getSelectionLength()), false);
        context.getASTRoot().accept((ASTVisitor)analyzer);
        ASTNode[] selectedNodes = analyzer.getSelectedNodes();
        if (selectedNodes.length == 0) {
            return false;
        }
        VariableDeclarationFix fix = VariableDeclarationFix.createChangeModifierToFinalFix(context.getASTRoot(), selectedNodes);
        if (fix == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        Hashtable<String, String> options = new Hashtable<String, String>();
        options.put("cleanup.make_variable_declarations_final", "true");
        options.put("cleanup.make_local_variable_final", "true");
        options.put("cleanup.make_parameters_final", "true");
        options.put("cleanup.make_private_fields_final", "true");
        VariableDeclarationCleanUp cleanUp = new VariableDeclarationCleanUp(options);
        FixCorrectionProposal proposal = new FixCorrectionProposal(fix, cleanUp, 5, image, context);
        resultingCollections.add(proposal);
        return true;
    }

    private static boolean getInlineLocalProposal(IInvocationContext context, ASTNode node, Collection proposals) throws CoreException {
        if (!(node instanceof SimpleName)) {
            return false;
        }
        SimpleName name = (SimpleName)node;
        IBinding binding = name.resolveBinding();
        if (!(binding instanceof IVariableBinding)) {
            return false;
        }
        IVariableBinding varBinding = (IVariableBinding)binding;
        if (varBinding.isField() || varBinding.isParameter()) {
            return false;
        }
        ASTNode decl = context.getASTRoot().findDeclaringNode((IBinding)varBinding);
        if (!(decl instanceof VariableDeclarationFragment) || decl.getLocationInParent() != VariableDeclarationStatement.FRAGMENTS_PROPERTY) {
            return false;
        }
        if (proposals == null) {
            return true;
        }
        InlineTempRefactoring refactoring = new InlineTempRefactoring((VariableDeclaration)decl);
        if (refactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
            String label = CorrectionMessages.QuickAssistProcessor_inline_local_description;
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            RefactoringCorrectionProposal proposal = new RefactoringCorrectionProposal(label, context.getCompilationUnit(), refactoring, 5, image);
            proposal.setCommandId(INLINE_LOCAL_ID);
            proposals.add(proposal);
        }
        return true;
    }

    private static boolean getMissingCaseStatementProposals(IInvocationContext context, ASTNode node, Collection proposals) {
        if (!(node instanceof SwitchStatement)) {
            return false;
        }
        SwitchStatement switchStatement = (SwitchStatement)node;
        if (context.getSelectionOffset() + context.getSelectionLength() >= switchStatement.getExpression().getStartPosition()) {
            return false;
        }
        ITypeBinding expressionBinding = switchStatement.getExpression().resolveTypeBinding();
        if (expressionBinding == null || !expressionBinding.isEnum()) {
            return false;
        }
        String[] missingEnumCases = LocalCorrectionsSubProcessor.evaluateMissingEnumConstantCases(expressionBinding, switchStatement.statements());
        if (missingEnumCases.length == 0) {
            return false;
        }
        if (proposals == null) {
            return true;
        }
        proposals.add(LocalCorrectionsSubProcessor.createMissingEnumConstantCaseProposals(context, switchStatement, missingEnumCases));
        return true;
    }

    private static boolean getConvertLocalToFieldProposal(IInvocationContext context, ASTNode node, Collection proposals) throws CoreException {
        if (!(node instanceof SimpleName)) {
            return false;
        }
        SimpleName name = (SimpleName)node;
        IBinding binding = name.resolveBinding();
        if (!(binding instanceof IVariableBinding) || name.getLocationInParent() != VariableDeclarationFragment.NAME_PROPERTY) {
            return false;
        }
        IVariableBinding varBinding = (IVariableBinding)binding;
        if (varBinding.isField() || varBinding.isParameter()) {
            return false;
        }
        VariableDeclarationFragment decl = (VariableDeclarationFragment)name.getParent();
        if (decl.getLocationInParent() != VariableDeclarationStatement.FRAGMENTS_PROPERTY) {
            return false;
        }
        if (proposals == null) {
            return true;
        }
        PromoteTempToFieldRefactoring refactoring = new PromoteTempToFieldRefactoring((VariableDeclaration)decl);
        if (refactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
            String label = CorrectionMessages.QuickAssistProcessor_convert_local_to_field_description;
            Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
            LinkedProposalModel linkedProposalModel = new LinkedProposalModel();
            refactoring.setLinkedProposalModel(linkedProposalModel);
            RefactoringCorrectionProposal proposal = new RefactoringCorrectionProposal(label, context.getCompilationUnit(), refactoring, 5, image);
            proposal.setLinkedProposalModel(linkedProposalModel);
            proposal.setCommandId(CONVERT_LOCAL_TO_FIELD_ID);
            proposals.add(proposal);
        }
        return true;
    }

    private static class RefactoringCorrectionProposal
    extends CUCorrectionProposal {
        private final Refactoring fRefactoring;

        public RefactoringCorrectionProposal(String name, ICompilationUnit cu, Refactoring refactoring, int relevance, Image image) {
            super(name, cu, null, relevance, image);
            this.fRefactoring = refactoring;
        }

        protected void init(Refactoring refactoring) throws CoreException {
        }

        protected TextChange createTextChange() throws CoreException {
            this.init(this.fRefactoring);
            if (this.fRefactoring.checkFinalConditions((IProgressMonitor)new NullProgressMonitor()).hasFatalError()) {
                return new TextFileChange("fatal error", (IFile)this.getCompilationUnit().getResource());
            }
            return (TextChange)this.fRefactoring.createChange((IProgressMonitor)new NullProgressMonitor());
        }
    }
}

