/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.internal.corext.template.java.CompilationUnitContext;
import org.eclipse.jdt.internal.corext.template.java.CompilationUnitContextType;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.JavaUIStatus;
import org.eclipse.jdt.internal.ui.text.correction.AssistContext;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.SurroundWith;
import org.eclipse.jdt.internal.ui.text.template.contentassist.SurroundWithTemplateProposal;
import org.eclipse.jdt.internal.ui.text.template.contentassist.TemplateProposal;
import org.eclipse.jdt.internal.ui.viewsupport.ColoringLabelProvider;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickAssistProcessor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.part.FileEditorInput;

public class QuickTemplateProcessor
implements IQuickAssistProcessor {
    private static final String $_LINE_SELECTION = "${line_selection}";
    private static final String $_WORD_SELECTION = "${word_selection}";

    public boolean hasAssists(IInvocationContext context) throws CoreException {
        ICompilationUnit cu = context.getCompilationUnit();
        IDocument document = this.getDocument(cu);
        int offset = context.getSelectionOffset();
        int length = context.getSelectionLength();
        if (length == 0) {
            return false;
        }
        try {
            int startLine = document.getLineOfOffset(offset);
            int endLine = document.getLineOfOffset(offset + length);
            IRegion region = document.getLineInformation(endLine);
            return startLine < endLine || length > 0 && offset == region.getOffset() && length == region.getLength();
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IJavaCompletionProposal[] getAssists(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        if (locations != null && locations.length > 0) {
            return new IJavaCompletionProposal[0];
        }
        try {
            int offset = context.getSelectionOffset();
            int length = context.getSelectionLength();
            if (length == 0) {
                return null;
            }
            ICompilationUnit cu = context.getCompilationUnit();
            IDocument document = this.getDocument(cu);
            String contentType = TextUtilities.getContentType((IDocument)document, (String)"___java_partitioning", (int)offset, (boolean)true);
            String contextId = contentType.equals("__java_javadoc") ? "javadoc" : "java";
            int startLine = document.getLineOfOffset(offset);
            int endLine = document.getLineOfOffset(offset + length);
            if (contextId.equals("java")) {
                IRegion endLineRegion = document.getLineInformation(endLine);
                if (endLine > startLine && endLineRegion.getOffset() == offset + length) {
                    endLineRegion = document.getLineInformation(--endLine);
                    length = endLineRegion.getOffset() + endLineRegion.getLength() - offset;
                }
                if (startLine == endLine) {
                    AssistContext invocationContext;
                    if (!(length != 0 && offset == endLineRegion.getOffset() && length == endLineRegion.getLength() || SurroundWith.isApplicable(invocationContext = new AssistContext(cu, offset, length)))) {
                        return null;
                    }
                } else {
                    offset = document.getLineOffset(startLine);
                    length = endLineRegion.getOffset() + endLineRegion.getLength() - offset;
                }
            }
            ArrayList resultingCollections = new ArrayList();
            this.collectSurroundTemplates(document, cu, offset, length, resultingCollections, contextId);
            this.sort(resultingCollections);
            return resultingCollections.toArray(new IJavaCompletionProposal[resultingCollections.size()]);
        }
        catch (BadLocationException e) {
            throw new CoreException(JavaUIStatus.createError(4, "", e));
        }
    }

    private void sort(ArrayList proposals) {
        Collections.sort(proposals, new Comparator(){

            public int compare(Object o1, Object o2) {
                IJavaCompletionProposal p1 = (IJavaCompletionProposal)o1;
                IJavaCompletionProposal p2 = (IJavaCompletionProposal)o2;
                return Collator.getInstance().compare(p1.getDisplayString(), p2.getDisplayString());
            }
        });
    }

    private IDocument getDocument(ICompilationUnit cu) throws JavaModelException {
        IFile file = (IFile)cu.getResource();
        IDocument document = JavaUI.getDocumentProvider().getDocument((Object)new FileEditorInput(file));
        if (document == null) {
            return new Document(cu.getSource());
        }
        return document;
    }

    private void collectSurroundTemplates(IDocument document, ICompilationUnit cu, int offset, int length, Collection result, String contextId) throws BadLocationException, CoreException {
        CompilationUnitContextType contextType = (CompilationUnitContextType)JavaPlugin.getDefault().getTemplateContextRegistry().getContextType(contextId);
        CompilationUnitContext context = contextType.createContext(document, offset, length, cu);
        context.setVariable("selection", document.get(offset, length));
        context.setForceEvaluation(true);
        int start = context.getStart();
        int end = context.getEnd();
        Region region = new Region(start, end - start);
        AssistContext invocationContext = new AssistContext(cu, start, end - start);
        Statement[] selectedStatements = SurroundWith.getSelectedStatements(invocationContext);
        Template[] templates = JavaPlugin.getDefault().getTemplateStore().getTemplates();
        int i = 0;
        while (i != templates.length) {
            Template currentTemplate = templates[i];
            if (this.canEvaluate((TemplateContext)context, currentTemplate)) {
                if (selectedStatements != null) {
                    Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
                    SurroundWithTemplateProposal proposal = new SurroundWithTemplateProposal(cu, currentTemplate, context, (IRegion)region, image, selectedStatements);
                    Object[] arg = new String[]{currentTemplate.getName(), currentTemplate.getDescription()};
                    String decorated = Messages.format(CorrectionMessages.QuickTemplateProcessor_surround_label, arg);
                    proposal.setDisplayString(ColoringLabelProvider.decorateStyledString(new StyledString(currentTemplate.getName()), decorated, StyledString.QUALIFIER_STYLER));
                    result.add(proposal);
                } else {
                    TemplateProposal proposal = new TemplateProposal(currentTemplate, (TemplateContext)context, (IRegion)region, JavaPluginImages.get("org.eclipse.jdt.ui.template_obj.gif")){

                        public boolean validate(IDocument doc, int off, DocumentEvent event) {
                            return false;
                        }
                    };
                    Object[] arg = new String[]{currentTemplate.getName(), currentTemplate.getDescription()};
                    String decorated = Messages.format(CorrectionMessages.QuickTemplateProcessor_surround_label, arg);
                    proposal.setDisplayString(ColoringLabelProvider.decorateStyledString(new StyledString(currentTemplate.getName()), decorated, StyledString.QUALIFIER_STYLER));
                    result.add(proposal);
                }
            }
            ++i;
        }
    }

    private boolean canEvaluate(TemplateContext context, Template template) {
        String contextId = context.getContextType().getId();
        if ("javadoc".equals(contextId) ? template.getPattern().indexOf($_LINE_SELECTION) == -1 && template.getPattern().indexOf($_WORD_SELECTION) == -1 : template.getPattern().indexOf($_LINE_SELECTION) == -1) {
            return false;
        }
        TemplateContextType contextType = JavaPlugin.getDefault().getTemplateContextRegistry().getContextType(template.getContextTypeId());
        return contextType instanceof CompilationUnitContextType;
    }
}

