/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.Collection;
import java.util.Hashtable;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.internal.corext.fix.IProposableFix;
import org.eclipse.jdt.internal.corext.fix.PotentialProgrammingProblemsFix;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.fix.ICleanUp;
import org.eclipse.jdt.internal.ui.fix.PotentialProgrammingProblemsCleanUp;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.proposals.FixCorrectionProposal;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IProblemLocation;

public final class SerialVersionSubProcessor {
    public static final void getSerialVersionProposals(IInvocationContext context, IProblemLocation location, Collection proposals) {
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)location);
        Assert.isNotNull((Object)proposals);
        IProposableFix[] fixes = PotentialProgrammingProblemsFix.createMissingSerialVersionFixes(context.getASTRoot(), location);
        if (fixes != null) {
            proposals.add(new SerialVersionProposal(fixes[0], 9, context, true));
            proposals.add(new SerialVersionProposal(fixes[1], 9, context, false));
        }
    }

    public static final class SerialVersionProposal
    extends FixCorrectionProposal {
        private boolean fIsDefaultProposal;

        public SerialVersionProposal(IProposableFix fix, int relevance, IInvocationContext context, boolean isDefault) {
            super(fix, SerialVersionProposal.createCleanUp(isDefault), relevance, JavaPluginImages.get("org.eclipse.jdt.ui.add_correction.gif"), context);
            this.fIsDefaultProposal = isDefault;
        }

        private static ICleanUp createCleanUp(boolean isDefault) {
            Hashtable<String, String> options = new Hashtable<String, String>();
            options.put("cleanup.add_serial_version_id", "true");
            if (isDefault) {
                options.put("cleanup.add_default_serial_version_id", "true");
            } else {
                options.put("cleanup.add_generated_serial_version_id", "true");
            }
            return new PotentialProgrammingProblemsCleanUp(options);
        }

        public boolean isDefaultProposal() {
            return this.fIsDefaultProposal;
        }

        public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
            if (this.fIsDefaultProposal) {
                return CorrectionMessages.SerialVersionDefaultProposal_message_default_info;
            }
            return CorrectionMessages.SerialVersionHashProposal_message_generated_info;
        }
    }
}

