/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.swt;

import org.eclipse.birt.chart.device.swt.SwtRendererImpl;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.data.Action;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Display;

public final class RegionAction {
    private final StructureSource _oSource;
    private Rectangle _bb;
    private final Action _ac;

    private RegionAction(StructureSource source, Rectangle bb, Action ac) {
        this._oSource = source;
        this._ac = ac;
        this._bb = bb;
    }

    RegionAction(StructureSource oSource, Location[] loa, Action ac, double dTranslateX, double dTranslateY, double dScale, Region clipping) {
        this._oSource = oSource;
        int[] i2a = SwtRendererImpl.getCoordinatesAsInts(loa, 2, dTranslateX, dTranslateY, dScale);
        Region sh = new Region();
        sh.add(i2a);
        if (clipping != null) {
            sh.intersect(clipping);
        }
        this._ac = ac;
        this._bb = sh.getBounds();
        sh.dispose();
    }

    RegionAction(StructureSource oSource, Bounds bo, Action ac, double dTranslateX, double dTranslateY, double dScale, Region clipping) {
        this._oSource = oSource;
        bo = BoundsImpl.copyInstance((Bounds)bo);
        bo.translate(dTranslateX, dTranslateY);
        bo.scale(dScale);
        Rectangle rect = new Rectangle((int)bo.getLeft(), (int)bo.getTop(), (int)bo.getWidth(), (int)bo.getHeight());
        Region sh = new Region();
        sh.add(rect);
        if (clipping != null) {
            sh.intersect(clipping);
        }
        this._ac = ac;
        this._bb = sh.getBounds();
        sh.dispose();
    }

    RegionAction(StructureSource oSource, Bounds boEllipse, double dStart, double dExtent, boolean bSector, Action ac, double dTranslateX, double dTranslateY, double dScale, Region clipping) {
        this._oSource = oSource;
        boEllipse = BoundsImpl.copyInstance((Bounds)boEllipse);
        boEllipse.translate(dTranslateX, dTranslateY);
        boEllipse.scale(dScale);
        double x = boEllipse.getLeft();
        double y = boEllipse.getTop();
        double width = boEllipse.getWidth();
        double height = boEllipse.getHeight();
        Path ph = new Path((Device)Display.getDefault());
        ph.addArc((float)x, (float)y, (float)width, (float)height, (float)dStart, (float)dExtent);
        if (bSector) {
            ph.lineTo((float)(x + width / 2.0), (float)(y + height / 2.0));
        }
        ph.close();
        this._ac = ac;
        float[] b = new float[4];
        ph.getBounds(b);
        this._bb = new Rectangle((int)b[0], (int)b[1], (int)b[2], (int)b[3]);
        ph.dispose();
    }

    public final Action getAction() {
        return this._ac;
    }

    public final StructureSource getSource() {
        return this._oSource;
    }

    public RegionAction copy() {
        Rectangle nbb = null;
        if (this._bb != null) {
            nbb = new Rectangle(this._bb.x, this._bb.y, this._bb.width, this._bb.height);
        }
        return new RegionAction(this._oSource, nbb, this._ac);
    }

    public boolean contains(Point p, GC gc) {
        return this.contains(p.x, p.y, gc);
    }

    public boolean contains(double x, double y, GC gc) {
        if (this._bb != null) {
            return this._bb.contains((int)x, (int)y);
        }
        return false;
    }

    public void dispose() {
    }

    public boolean isEmpty() {
        if (this._bb != null) {
            return this._bb.isEmpty();
        }
        return true;
    }
}

