/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.launchConfigurations;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.AntUtil;
import org.eclipse.ant.internal.ui.launchConfigurations.AntJRETab;
import org.eclipse.ant.internal.ui.launchConfigurations.AntLaunchConfigurationMessages;
import org.eclipse.ant.internal.ui.model.AntElementNode;
import org.eclipse.ant.internal.ui.model.AntProjectNode;
import org.eclipse.ant.internal.ui.model.AntTargetNode;
import org.eclipse.ant.internal.ui.model.AntTaskNode;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.externaltools.internal.launchConfigurations.ExternalToolsUtil;

public class AntLaunchShortcut
implements ILaunchShortcut {
    private boolean fShowDialog = false;
    private static final int MAX_TARGET_APPEND_LENGTH = 30;
    private static final String DEFAULT_TARGET = "default";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public void launch(ISelection selection, String mode) {
        IStructuredSelection structuredSelection;
        Object object;
        if (selection instanceof IStructuredSelection && (object = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof IAdaptable) {
            IResource resource;
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((resource = (IResource)iAdaptable.getAdapter((Class)clazz)) != null) {
                if (!"xml".equalsIgnoreCase(resource.getFileExtension())) {
                    if (resource.getType() == 1) {
                        resource = resource.getParent();
                    }
                    resource = this.findBuildFile((IContainer)resource);
                }
                if (resource != null) {
                    IFile file = (IFile)resource;
                    this.launch(file.getFullPath(), file.getProject(), mode, null);
                    return;
                }
            } else if (object instanceof AntElementNode) {
                this.launch((AntElementNode)object, mode);
                return;
            }
        }
        this.antFileNotFound();
    }

    public void launch(AntElementNode node, String mode) {
        String selectedTargetName = null;
        if (node instanceof AntTargetNode) {
            AntTargetNode targetNode = (AntTargetNode)node;
            selectedTargetName = targetNode.isDefaultTarget() ? "" : targetNode.getTarget().getName();
        } else if (node instanceof AntProjectNode) {
            selectedTargetName = "";
        } else if (node instanceof AntTaskNode) {
            AntTaskNode taskNode = (AntTaskNode)node;
            selectedTargetName = taskNode.getTask().getOwningTarget().getName();
        }
        if (selectedTargetName == null) {
            return;
        }
        IFile file = node.getBuildFileResource();
        if (file != null) {
            this.launch(file.getFullPath(), file.getProject(), mode, selectedTargetName);
            return;
        }
        IWorkbenchPage page = AntUIPlugin.getActiveWorkbenchWindow().getActivePage();
        IPath filePath = null;
        IEditorPart editor = page.getActiveEditor();
        if (editor != null) {
            ILocationProvider locationProvider;
            IEditorInput editorInput = editor.getEditorInput();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ui.editors.text.ILocationProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((locationProvider = (ILocationProvider)editorInput.getAdapter((Class)clazz)) != null && (filePath = locationProvider.getPath((Object)editorInput)) != null) {
                this.launch(filePath, null, mode, selectedTargetName);
                return;
            }
        }
        this.antFileNotFound();
    }

    private void antFileNotFound() {
        AntLaunchShortcut.reportError(AntLaunchConfigurationMessages.AntLaunchShortcut_Unable, null);
    }

    protected List collectConfigurations(IPath filepath, String targetname) {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType("org.eclipse.ant.AntLaunchConfigurationType");
        if (type != null) {
            try {
                ILaunchConfiguration[] configs = manager.getLaunchConfigurations(type);
                ArrayList<ILaunchConfiguration> list = new ArrayList<ILaunchConfiguration>();
                String targetattr = null;
                String[] targets = null;
                IPath location = null;
                int i = 0;
                while (i < configs.length) {
                    if (configs[i].exists()) {
                        try {
                            location = ExternalToolsUtil.getLocation((ILaunchConfiguration)configs[i]);
                            if (location != null && location.equals((Object)filepath)) {
                                targetattr = configs[i].getAttribute("org.eclipse.ui.externaltools.ATTR_ANT_TARGETS", "");
                                targets = AntUtil.parseString(targetattr, ",");
                                if (targets.length == 0) {
                                    if (targetattr.equals(targetname) || targetname == null) {
                                        list.add(configs[i]);
                                    }
                                } else if (Arrays.asList(targets).contains(targetname == null ? DEFAULT_TARGET : targetname)) {
                                    list.add(configs[i]);
                                }
                            }
                        }
                        catch (CoreException coreException) {}
                    }
                    ++i;
                }
                return list;
            }
            catch (CoreException coreException) {}
        }
        return new ArrayList();
    }

    public static String getNewLaunchConfigurationName(IPath filePath, String projectName, String targetAttribute) {
        StringBuffer buffer = new StringBuffer();
        if (projectName != null) {
            buffer.append(projectName);
            buffer.append(' ');
            buffer.append(filePath.lastSegment());
        } else {
            buffer.append(filePath.lastSegment());
        }
        if (targetAttribute != null) {
            buffer.append(" [");
            if (targetAttribute.length() > 33) {
                buffer.append(targetAttribute.substring(0, 30));
                buffer.append("...");
            } else {
                buffer.append(targetAttribute);
            }
            buffer.append(']');
        }
        String name = DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(buffer.toString());
        return name;
    }

    /*
     * Unable to fully structure code
     */
    public void launch(IPath filePath, IProject project, String mode, String targetAttribute) {
        configuration = null;
        backingfile = null;
        if (project != null) {
            backingfile = project.getFile(filePath.removeFirstSegments(1));
        }
        if ((configs = this.collectConfigurations(backingfile != null && backingfile.exists() != false ? backingfile.getLocation() : filePath, targetAttribute)).isEmpty()) {
            configuration = AntLaunchShortcut.createDefaultLaunchConfiguration(filePath, project != null && project.exists() != false ? project : null);
            try {
                if (targetAttribute == null || targetAttribute.equals(configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_ANT_TARGETS", ""))) ** GOTO lbl25
                projectName = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
                newName = AntLaunchShortcut.getNewLaunchConfigurationName(filePath, projectName, targetAttribute);
                copy = configuration.getWorkingCopy();
                copy.rename(newName);
                copy.setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_TARGETS", targetAttribute);
                configuration = copy.doSave();
            }
            catch (CoreException exception) {
                AntLaunchShortcut.reportError(MessageFormat.format((String)AntLaunchConfigurationMessages.AntLaunchShortcut_Exception_launching, (Object[])new String[]{filePath.toFile().getName()}), exception);
                return;
            }
        } else if (configs.size() == 1) {
            configuration = (ILaunchConfiguration)configs.get(0);
        } else {
            configuration = AntLaunchShortcut.chooseConfig(configs);
            if (configuration == null) {
                return;
            }
        }
lbl25:
        // 5 sources

        if (configuration != null) {
            this.launch(mode, configuration);
        } else {
            this.antFileNotFound();
        }
    }

    private void launch(String mode, ILaunchConfiguration configuration) {
        if (this.fShowDialog) {
            if (!DebugUITools.saveBeforeLaunch()) {
                return;
            }
            Status status = new Status(1, "org.eclipse.ant.ui", 1000, "", null);
            String groupId = mode.equals("debug") ? "org.eclipse.debug.ui.launchGroup.debug" : "org.eclipse.ui.externaltools.launchGroup";
            DebugUITools.openLaunchConfigurationDialog((Shell)AntUIPlugin.getActiveWorkbenchWindow().getShell(), (ILaunchConfiguration)configuration, (String)groupId, (IStatus)status);
        } else {
            DebugUITools.launch((ILaunchConfiguration)configuration, (String)mode);
        }
    }

    private IFile findBuildFile(IContainer parent) {
        String[] names = this.getBuildFileNames();
        if (names == null) {
            return null;
        }
        IContainer lparent = parent;
        IResource file = null;
        while (file == null || file.getType() != 1) {
            int i = 0;
            while (i < names.length) {
                String string = names[i];
                file = lparent.findMember(string);
                if (file != null && file.getType() == 1) break;
                ++i;
            }
            lparent = lparent.getParent();
            if (lparent != null) continue;
            return null;
        }
        return (IFile)file;
    }

    private String[] getBuildFileNames() {
        IPreferenceStore prefs = AntUIPlugin.getDefault().getPreferenceStore();
        String buildFileNames = prefs.getString("ant.findBuildFileNames");
        if (buildFileNames.length() == 0) {
            return null;
        }
        return AntUtil.parseString(buildFileNames, ",");
    }

    public static ILaunchConfiguration createDefaultLaunchConfiguration(IFile file) {
        return AntLaunchShortcut.createDefaultLaunchConfiguration(file.getFullPath(), file.getProject());
    }

    public static ILaunchConfiguration createDefaultLaunchConfiguration(IPath filePath, IProject project) {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType("org.eclipse.ant.AntLaunchConfigurationType");
        String projectName = project != null ? project.getName() : null;
        String name = AntLaunchShortcut.getNewLaunchConfigurationName(filePath, projectName, null);
        try {
            ILaunchConfigurationWorkingCopy workingCopy = type.newInstance(null, name);
            if (project != null) {
                workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression("workspace_loc", filePath.toString()));
            } else {
                workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", filePath.toString());
            }
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, "org.eclipse.ant.ui.AntClasspathProvider");
            CommonTab tab = new CommonTab();
            tab.setDefaults(workingCopy);
            tab.dispose();
            if (project != null) {
                workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, project.getName());
            }
            AntJRETab jreTab = new AntJRETab();
            jreTab.setDefaults(workingCopy);
            jreTab.dispose();
            IFile file = AntUtil.getFileForLocation(filePath.toString(), null);
            workingCopy.setMappedResources(new IResource[]{file});
            return workingCopy.doSave();
        }
        catch (CoreException e) {
            AntLaunchShortcut.reportError(MessageFormat.format((String)AntLaunchConfigurationMessages.AntLaunchShortcut_2, (Object[])new String[]{filePath.toString()}), e);
            return null;
        }
    }

    public static List findExistingLaunchConfigurations(IFile file) {
        ILaunchManager manager;
        ILaunchConfigurationType type;
        IPath filePath;
        ArrayList<ILaunchConfiguration> validConfigs = new ArrayList<ILaunchConfiguration>();
        if (file != null && (filePath = file.getLocation()) != null && (type = (manager = DebugPlugin.getDefault().getLaunchManager()).getLaunchConfigurationType("org.eclipse.ant.AntLaunchConfigurationType")) != null) {
            try {
                ILaunchConfiguration[] configs = manager.getLaunchConfigurations(type);
                int i = 0;
                while (i < configs.length) {
                    try {
                        if (filePath.equals((Object)ExternalToolsUtil.getLocation((ILaunchConfiguration)configs[i]))) {
                            validConfigs.add(configs[i]);
                        }
                    }
                    catch (CoreException coreException) {}
                    ++i;
                }
            }
            catch (CoreException e) {
                AntLaunchShortcut.reportError(AntLaunchConfigurationMessages.AntLaunchShortcut_3, e);
            }
        }
        return validConfigs;
    }

    public static ILaunchConfiguration chooseConfig(List configs) {
        if (configs.isEmpty()) {
            return null;
        }
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(Display.getDefault().getActiveShell(), (ILabelProvider)labelProvider);
        dialog.setElements((Object[])configs.toArray(new ILaunchConfiguration[configs.size()]));
        dialog.setTitle(AntLaunchConfigurationMessages.AntLaunchShortcut_4);
        dialog.setMessage(AntLaunchConfigurationMessages.AntLaunchShortcut_5);
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    public void launch(IEditorPart editor, String mode) {
        IEditorInput input = editor.getEditorInput();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IFile file = (IFile)input.getAdapter((Class)clazz);
        IPath filepath = null;
        if (file != null) {
            filepath = file.getFullPath();
        }
        if (filepath == null) {
            ILocationProvider locationProvider;
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.ui.editors.text.ILocationProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((locationProvider = (ILocationProvider)input.getAdapter((Class)clazz2)) != null) {
                filepath = locationProvider.getPath((Object)input);
            }
        }
        if (filepath != null && "xml".equals(filepath.getFileExtension())) {
            this.launch(filepath, file == null ? null : file.getProject(), mode, null);
            return;
        }
        this.antFileNotFound();
    }

    protected static void reportError(String message, Throwable throwable) {
        Object status = null;
        status = throwable instanceof CoreException ? ((CoreException)throwable).getStatus() : new Status(4, "org.eclipse.ant.ui", 0, message, throwable);
        ErrorDialog.openError((Shell)AntUIPlugin.getActiveWorkbenchWindow().getShell(), (String)AntLaunchConfigurationMessages.AntLaunchShortcut_Error_7, (String)AntLaunchConfigurationMessages.AntLaunchShortcut_Build_Failed_2, (IStatus)status);
    }

    public void setShowDialog(boolean showDialog) {
        this.fShowDialog = showDialog;
    }
}

