/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.simpleconfigurator.manipulator;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.internal.frameworkadmin.equinox.EquinoxFwConfigFileParser;
import org.eclipse.equinox.internal.frameworkadmin.utils.Utils;
import org.eclipse.equinox.internal.provisional.configuratormanipulator.ConfiguratorManipulator;
import org.eclipse.equinox.internal.provisional.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.provisional.frameworkadmin.BundlesState;
import org.eclipse.equinox.internal.provisional.frameworkadmin.ConfigData;
import org.eclipse.equinox.internal.provisional.frameworkadmin.LauncherData;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;

public class SimpleConfiguratorManipulatorImpl
implements ConfiguratorManipulator {
    private static final boolean DEBUG = false;
    static String CONFIG_LOCATION = "bundles.info";
    private static final String FILE_PROTOCOL = "file:";
    private static final BundleInfo[] NULL_BUNDLEINFOS = new BundleInfo[0];
    private Set manipulators = new HashSet();
    public static final String PARAMETER_BASEURL = "org.eclipse.equinox.simpleconfigurator.baseUrl";
    public static final String PROP_KEY_EXCLUSIVE_INSTALLATION = "org.eclipse.equinox.simpleconfigurator.exclusiveInstallation";
    public static final String CONFIG_LIST = "bundles.info";
    public static final String CONFIGURATOR_FOLDER = "org.eclipse.equinox.simpleconfigurator";
    public static final String PROP_KEY_CONFIGURL = "org.eclipse.equinox.simpleconfigurator.configUrl";
    public static final String TARGET_CONFIGURATOR_NAME = "org.eclipse.equinox.simpleconfigurator";
    public static final String SERVICE_PROP_VALUE_CONFIGURATOR_SYMBOLICNAME = "org.eclipse.equinox.simpleconfigurator";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static URL getConfigLocation(Manipulator manipulator) throws IllegalStateException {
        File targetFile;
        File fwConfigLoc = manipulator.getLauncherData().getFwConfigLocation();
        File baseDir = null;
        if (fwConfigLoc == null) {
            baseDir = manipulator.getLauncherData().getHome();
            if (baseDir == null) {
                if (manipulator.getLauncherData().getLauncher() == null) throw new IllegalStateException("All of fwConfigFile, home, launcher are not set.");
                baseDir = manipulator.getLauncherData().getLauncher().getParentFile();
            }
        } else {
            baseDir = fwConfigLoc.exists() ? (fwConfigLoc.isDirectory() ? fwConfigLoc : fwConfigLoc.getParentFile()) : (fwConfigLoc.getName().endsWith(".ini") ? fwConfigLoc.getParentFile() : fwConfigLoc);
        }
        try {
            baseDir = new File(baseDir, "org.eclipse.equinox.simpleconfigurator");
            targetFile = new File(baseDir, CONFIG_LIST);
            try {
                Utils.createParentDir((File)targetFile);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
        return targetFile.toURL();
    }

    static boolean isPrerequisiteBundles(String location, LocationInfo info) {
        boolean ret = false;
        if (info.prerequisiteLocations == null) {
            return false;
        }
        int i = 0;
        while (i < info.prerequisiteLocations.length) {
            if (location.equals(info.prerequisiteLocations[i])) {
                ret = true;
                break;
            }
            ++i;
        }
        return ret;
    }

    static boolean isSystemBundle(String location, LocationInfo info) {
        if (info.systemBundleLocation == null) {
            return false;
        }
        return location.equals(info.systemBundleLocation);
    }

    static boolean isSystemFragmentBundle(String location, LocationInfo info) {
        boolean ret = false;
        if (info.systemFragmentedBundleLocations == null) {
            return false;
        }
        int i = 0;
        while (i < info.systemFragmentedBundleLocations.length) {
            if (location.equals(info.systemFragmentedBundleLocations[i])) {
                ret = true;
                break;
            }
            ++i;
        }
        return ret;
    }

    private static boolean isTargetConfiguratorBundle(BundleInfo[] bInfos) {
        int i = 0;
        while (i < bInfos.length) {
            if (SimpleConfiguratorManipulatorImpl.isTargetConfiguratorBundle(bInfos[i].getLocation())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isTargetConfiguratorBundle(String location) {
        String symbolic = Utils.getPathFromClause((String)Utils.getManifestMainAttributes((String)location, (String)"Bundle-SymbolicName"));
        return "org.eclipse.equinox.simpleconfigurator".equals(symbolic);
    }

    private void algorithm(int initialSl, SortedMap bslToList, BundleInfo configuratorBInfo, List setToInitialConfig, List setToSimpleConfig, LocationInfo info) {
        int configuratorSL = configuratorBInfo.getStartLevel();
        Integer sL0 = (Integer)bslToList.keySet().iterator().next();
        List list0 = (List)bslToList.get(sL0);
        if (sL0 == 0) {
            Iterator ite2 = list0.iterator();
            while (ite2.hasNext()) {
                BundleInfo bInfo = (BundleInfo)ite2.next();
                if (!SimpleConfiguratorManipulatorImpl.isSystemBundle(bInfo.getLocation(), info)) continue;
                setToSimpleConfig.add(bInfo);
                break;
            }
        }
        Iterator ite = bslToList.keySet().iterator();
        while (ite.hasNext()) {
            BundleInfo bInfo;
            Integer sL = (Integer)ite.next();
            List list = (List)bslToList.get(sL);
            if (sL < configuratorSL) {
                Iterator ite2 = list.iterator();
                while (ite2.hasNext()) {
                    bInfo = (BundleInfo)ite2.next();
                    if (SimpleConfiguratorManipulatorImpl.isSystemBundle(bInfo.getLocation(), info)) continue;
                    setToInitialConfig.add(bInfo);
                }
                continue;
            }
            if (sL > configuratorSL) {
                Iterator ite2 = list.iterator();
                while (ite2.hasNext()) {
                    bInfo = (BundleInfo)ite2.next();
                    if ((SimpleConfiguratorManipulatorImpl.isPrerequisiteBundles(bInfo.getLocation(), info) || SimpleConfiguratorManipulatorImpl.isSystemFragmentBundle(bInfo.getLocation(), info)) && !SimpleConfiguratorManipulatorImpl.isSystemBundle(bInfo.getLocation(), info)) {
                        setToInitialConfig.add(bInfo);
                    }
                    setToSimpleConfig.add(bInfo);
                }
                continue;
            }
            boolean found = false;
            Iterator ite2 = list.iterator();
            while (ite2.hasNext()) {
                BundleInfo bInfo2 = (BundleInfo)ite2.next();
                if (found) {
                    if (!SimpleConfiguratorManipulatorImpl.isSystemBundle(bInfo2.getLocation(), info) && (SimpleConfiguratorManipulatorImpl.isPrerequisiteBundles(bInfo2.getLocation(), info) || SimpleConfiguratorManipulatorImpl.isSystemFragmentBundle(bInfo2.getLocation(), info))) {
                        setToInitialConfig.add(bInfo2);
                    }
                    setToSimpleConfig.add(bInfo2);
                    continue;
                }
                if (SimpleConfiguratorManipulatorImpl.isTargetConfiguratorBundle(bInfo2.getLocation())) {
                    found = true;
                } else if (!SimpleConfiguratorManipulatorImpl.isSystemBundle(bInfo2.getLocation(), info)) {
                    setToInitialConfig.add(bInfo2);
                }
                setToSimpleConfig.add(bInfo2);
            }
        }
        setToInitialConfig.add(configuratorBInfo);
    }

    private boolean checkResolve(BundleInfo bInfo, BundlesState state) {
        if (bInfo == null) {
            throw new IllegalArgumentException("bInfo is null.");
        }
        if (!state.isResolved()) {
            state.resolve(false);
        }
        if (!state.isResolved(bInfo)) {
            this.printoutUnsatisfiedConstraints(bInfo, state);
            return false;
        }
        return true;
    }

    private boolean divideBundleInfos(Manipulator manipulator, List setToInitialConfig, List setToSimpleConfig, int initialBSL) throws IOException {
        BundlesState state = manipulator.getBundlesState();
        BundleInfo[] targetBundleInfos = null;
        targetBundleInfos = state.isFullySupported() ? state.getExpectedState() : manipulator.getConfigData().getBundles();
        BundleInfo configuratorBInfo = null;
        int i = 0;
        while (i < targetBundleInfos.length) {
            if (SimpleConfiguratorManipulatorImpl.isTargetConfiguratorBundle(targetBundleInfos[i].getLocation()) && targetBundleInfos[i].isMarkedAsStarted()) {
                configuratorBInfo = targetBundleInfos[i];
                break;
            }
            ++i;
        }
        if (configuratorBInfo == null && !this.manipulators.contains(manipulator)) {
            return false;
        }
        if (this.manipulators.contains(manipulator) && targetBundleInfos.length == 0) {
            this.manipulators.remove(manipulator);
        } else if (!this.manipulators.contains(manipulator)) {
            this.manipulators.add(manipulator);
        }
        if (state.isFullySupported()) {
            state.resolve(false);
        }
        LocationInfo info = new LocationInfo();
        this.setSystemBundles(state, info);
        if (configuratorBInfo != null) {
            this.setPrerequisiteBundles(configuratorBInfo, state, info);
            SortedMap bslToList = this.getSortedMap(initialBSL, targetBundleInfos);
            this.algorithm(initialBSL, bslToList, configuratorBInfo, setToInitialConfig, setToSimpleConfig, info);
        }
        return true;
    }

    private SortedMap getSortedMap(int initialSl, BundleInfo[] bInfos) {
        TreeMap<Integer, LinkedList<BundleInfo>> bslToList = new TreeMap<Integer, LinkedList<BundleInfo>>();
        int i = 0;
        while (i < bInfos.length) {
            LinkedList<BundleInfo> list;
            Integer sL = new Integer(bInfos[i].getStartLevel());
            if (sL == -1) {
                sL = new Integer(initialSl);
            }
            if ((list = (LinkedList<BundleInfo>)bslToList.get(sL)) == null) {
                list = new LinkedList<BundleInfo>();
                bslToList.put(sL, list);
            }
            list.add(bInfos[i]);
            ++i;
        }
        return bslToList;
    }

    private BundleInfo[] orderingInitialConfig(List setToInitialConfig) {
        LinkedList<BundleInfo> notToBeStarted = new LinkedList<BundleInfo>();
        LinkedList<BundleInfo> toBeStarted = new LinkedList<BundleInfo>();
        Iterator ite2 = setToInitialConfig.iterator();
        while (ite2.hasNext()) {
            BundleInfo bInfo = (BundleInfo)ite2.next();
            if (bInfo.isMarkedAsStarted()) {
                toBeStarted.add(bInfo);
                continue;
            }
            notToBeStarted.add(bInfo);
        }
        setToInitialConfig.clear();
        setToInitialConfig.addAll(notToBeStarted);
        setToInitialConfig.addAll(toBeStarted);
        return Utils.getBundleInfosFromList((List)setToInitialConfig);
    }

    private void printoutUnsatisfiedConstraints(BundleInfo bInfo, BundlesState state) {
    }

    private BundleInfo[] loadConfiguration(URL url, File launcherLocation) throws IOException {
        if (url == null) {
            return NULL_BUNDLEINFOS;
        }
        try {
            url.openStream();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return NULL_BUNDLEINFOS;
        }
        List bundleInfoList = SimpleConfiguratorManipulatorImpl.readConfiguration(url, launcherLocation);
        return Utils.getBundleInfosFromList((List)bundleInfoList);
    }

    public static List readConfiguration(URL url, File base) throws IOException {
        ArrayList<BundleInfo> bundles = new ArrayList<BundleInfo>();
        try {
            BufferedReader r = new BufferedReader(new InputStreamReader(url.openStream()));
            try {
                String line;
                URL baseUrl = new URL(url, "./");
                while ((line = r.readLine()) != null) {
                    if (line.startsWith("#") || (line = line.trim()).length() == 0) continue;
                    if (line.startsWith("org.eclipse.equinox.simpleconfigurator.baseUrl=")) {
                        String baseUrlSt = line.substring("org.eclipse.equinox.simpleconfigurator.baseUrl=".length());
                        if (!baseUrlSt.endsWith("/")) {
                            baseUrlSt = String.valueOf(baseUrlSt) + "/";
                        }
                        baseUrl = new URL(url, baseUrlSt);
                        continue;
                    }
                    StringTokenizer tok = new StringTokenizer(line, ",", true);
                    String symbolicName = tok.nextToken();
                    if (symbolicName.equals(",")) {
                        symbolicName = null;
                    } else {
                        tok.nextToken();
                    }
                    String version = tok.nextToken();
                    if (version.equals(",")) {
                        version = null;
                    } else {
                        tok.nextToken();
                    }
                    String urlSt = tok.nextToken();
                    if (urlSt.equals(",")) {
                        urlSt = symbolicName != null && version != null ? String.valueOf(symbolicName) + "_" + version + ".jar" : null;
                    } else {
                        tok.nextToken();
                    }
                    try {
                        new URL(urlSt);
                    }
                    catch (MalformedURLException malformedURLException) {
                        urlSt = Utils.getUrlInFull((String)urlSt, (URL)baseUrl).toExternalForm();
                    }
                    int sl = Integer.parseInt(tok.nextToken().trim());
                    tok.nextToken();
                    boolean markedAsStarted = Boolean.valueOf(tok.nextToken());
                    urlSt = SimpleConfiguratorManipulatorImpl.makeAbsolute(urlSt, base != null ? base.toURL() : null);
                    BundleInfo bInfo = new BundleInfo(symbolicName, version, urlSt, sl, markedAsStarted);
                    bundles.add(bInfo);
                }
            }
            catch (Throwable throwable) {
                try {
                    r.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                r.close();
            }
            catch (IOException iOException) {}
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return bundles;
    }

    public BundleInfo[] save(Manipulator manipulator, boolean backup) throws IOException {
        LinkedList setToInitialConfig = new LinkedList();
        LinkedList setToSimpleConfig = new LinkedList();
        ConfigData configData = manipulator.getConfigData();
        if (!this.divideBundleInfos(manipulator, setToInitialConfig, setToSimpleConfig, configData.getInitialBundleStartLevel())) {
            return configData.getBundles();
        }
        URL configuratorConfigUrl = SimpleConfiguratorManipulatorImpl.getConfigLocation(manipulator);
        if (!configuratorConfigUrl.getProtocol().equals("file")) {
            new IllegalStateException("configuratorConfigUrl should start with \"file\".\nconfiguratorConfigUrl=" + configuratorConfigUrl);
        }
        File outputFile = new File(configuratorConfigUrl.getFile());
        SimpleConfiguratorManipulatorImpl.saveConfiguration(setToSimpleConfig, outputFile, EquinoxFwConfigFileParser.getOSGiInstallArea((LauncherData)manipulator.getLauncherData()), backup);
        configData.setFwIndependentProp(PROP_KEY_CONFIGURL, outputFile.toURL().toExternalForm());
        return this.orderingInitialConfig(setToInitialConfig);
    }

    public static void saveConfiguration(List bundleInfoList, File outputFile, File base, boolean backup) throws IOException {
        File dest;
        if (backup && outputFile.exists() && !outputFile.renameTo(dest = Utils.getSimpleDataFormattedFile((File)outputFile))) {
            throw new IOException("Fail to rename from (" + outputFile + ") to (" + dest + ")");
        }
        Collections.sort(bundleInfoList, new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 instanceof BundleInfo && o2 instanceof BundleInfo) {
                    return ((BundleInfo)o1).getSymbolicName().compareTo(((BundleInfo)o2).getSymbolicName());
                }
                return 0;
            }
        });
        if (bundleInfoList.size() > 0) {
            Utils.createParentDir((File)outputFile);
            BufferedWriter bw = new BufferedWriter(new FileWriter(outputFile));
            Iterator ite = bundleInfoList.iterator();
            while (ite.hasNext()) {
                BundleInfo bInfo = (BundleInfo)ite.next();
                String location = bInfo.getLocation();
                if (bInfo.getSymbolicName() == null) {
                    bw.write(",");
                } else {
                    bw.write(String.valueOf(bInfo.getSymbolicName()) + ",");
                }
                if (bInfo.getVersion() == null) {
                    bw.write(",");
                } else {
                    bw.write(String.valueOf(bInfo.getVersion()) + ",");
                }
                location = SimpleConfiguratorManipulatorImpl.makeRelative(location, base != null ? base.toURL() : null);
                bw.write(String.valueOf(location) + ",");
                bw.write(String.valueOf(bInfo.getStartLevel()) + "," + bInfo.isMarkedAsStarted());
                bw.newLine();
            }
            bw.flush();
            bw.close();
        } else {
            File parentDir;
            if (outputFile.exists()) {
                outputFile.delete();
            }
            if ((parentDir = outputFile.getParentFile()).exists()) {
                parentDir.delete();
            }
        }
    }

    private static String makeRelative(IPath toRel, IPath base) {
        String baseDevice;
        String relDevice = toRel.getDevice();
        if (!(relDevice == (baseDevice = base.getDevice()) || relDevice != null && relDevice.equalsIgnoreCase(baseDevice))) {
            return toRel.toOSString();
        }
        int i = base.matchingFirstSegments(toRel);
        if (i == 0) {
            return toRel.toOSString();
        }
        String result = "";
        int j = 0;
        while (j < base.segmentCount() - i) {
            result = String.valueOf(result) + "../";
            ++j;
        }
        if (i == toRel.segmentCount()) {
            return ".";
        }
        result = String.valueOf(result) + toRel.setDevice(null).removeFirstSegments(i).toOSString();
        return result;
    }

    public static String makeRelative(String urlString, URL rootURL) {
        int index = urlString.indexOf(FILE_PROTOCOL);
        if (index == -1) {
            return urlString;
        }
        index += 5;
        boolean done = false;
        URL url = null;
        String file = urlString;
        while (!done) {
            try {
                url = new URL(file);
                file = url.getFile();
            }
            catch (MalformedURLException malformedURLException) {
                done = true;
            }
        }
        if (url == null || !new File(url.getFile()).isAbsolute()) {
            return urlString;
        }
        String rootString = rootURL.toExternalForm();
        return String.valueOf(urlString.substring(0, index)) + SimpleConfiguratorManipulatorImpl.makeRelative((IPath)new Path(urlString.substring(index)), (IPath)new Path(rootString.substring(rootString.indexOf(FILE_PROTOCOL) + 5)));
    }

    public static String makeAbsolute(String original, String rootPath) {
        Path path = new Path(original);
        if (path.isAbsolute()) {
            return original;
        }
        Path root = new Path(rootPath);
        return root.addTrailingSeparator().append(original.replace(':', '}')).toOSString().replace('}', ':');
    }

    public static String makeAbsolute(String urlString, URL rootURL) {
        int index = urlString.indexOf(FILE_PROTOCOL);
        if (index == -1) {
            return urlString;
        }
        index += 5;
        boolean done = false;
        URL url = null;
        String file = urlString;
        while (!done) {
            try {
                url = new URL(file);
                file = url.getFile();
            }
            catch (MalformedURLException malformedURLException) {
                done = true;
            }
        }
        if (url == null || new File(url.getFile()).isAbsolute()) {
            return urlString;
        }
        return String.valueOf(urlString.substring(0, index - 5)) + SimpleConfiguratorManipulatorImpl.makeAbsolute(urlString.substring(index), rootURL.toExternalForm());
    }

    void setPrerequisiteBundles(BundleInfo configuratorBundleInfo, BundlesState state, LocationInfo info) {
        if (state.isFullySupported() && !this.checkResolve(configuratorBundleInfo, state)) {
            this.printoutUnsatisfiedConstraints(configuratorBundleInfo, state);
            return;
        }
        BundleInfo[] prerequisites = state.getPrerequisteBundles(configuratorBundleInfo);
        info.prerequisiteLocations = new String[prerequisites.length];
        int i = 0;
        while (i < prerequisites.length) {
            info.prerequisiteLocations[i] = prerequisites[i].getLocation();
            ++i;
        }
    }

    void setSystemBundles(BundlesState state, LocationInfo info) {
        BundleInfo systemBundleInfo = state.getSystemBundle();
        if (systemBundleInfo == null) {
            return;
        }
        if (state.isFullySupported() && !this.checkResolve(systemBundleInfo, state)) {
            this.printoutUnsatisfiedConstraints(systemBundleInfo, state);
            return;
        }
        info.systemBundleLocation = systemBundleInfo.getLocation();
        BundleInfo[] fragments = state.getSystemFragmentedBundles();
        info.systemFragmentedBundleLocations = new String[fragments.length];
        int i = 0;
        while (i < fragments.length) {
            info.systemFragmentedBundleLocations[i] = fragments[i].getLocation();
            ++i;
        }
    }

    public void updateBundles(Manipulator manipulator) throws IOException {
        int i;
        BundleInfo[] currentBInfos;
        BundlesState bundleState = manipulator.getBundlesState();
        if (bundleState == null) {
            return;
        }
        if (bundleState.isFullySupported()) {
            bundleState.resolve(true);
        }
        if (!SimpleConfiguratorManipulatorImpl.isTargetConfiguratorBundle(currentBInfos = bundleState.getExpectedState())) {
            return;
        }
        Properties properties = new Properties();
        String[] jvmArgs = manipulator.getLauncherData().getJvmArgs();
        int i2 = 0;
        while (i2 < jvmArgs.length) {
            int index;
            if (jvmArgs[i2].startsWith("-D") && (index = jvmArgs[i2].indexOf("=")) > 0 && jvmArgs[i2].length() > 2) {
                String key = jvmArgs[i2].substring(2, index);
                String value = jvmArgs[i2].substring(index + 1);
                properties.setProperty(key, value);
            }
            ++i2;
        }
        Utils.appendProperties((Properties)properties, (Properties)manipulator.getConfigData().getFwIndependentProps());
        boolean exclusiveInstallation = Boolean.valueOf(properties.getProperty(PROP_KEY_EXCLUSIVE_INSTALLATION));
        URL configuratorConfigUrl = SimpleConfiguratorManipulatorImpl.getConfigLocation(manipulator);
        BundleInfo[] toInstall = this.loadConfiguration(configuratorConfigUrl, EquinoxFwConfigFileParser.getOSGiInstallArea((LauncherData)manipulator.getLauncherData()));
        LinkedList<BundleInfo> toUninstall = new LinkedList<BundleInfo>();
        if (exclusiveInstallation) {
            i = 0;
            while (i < currentBInfos.length) {
                boolean install = false;
                int j = 0;
                while (j < toInstall.length) {
                    if (currentBInfos[i].getLocation().equals(toInstall[j].getLocation())) {
                        install = true;
                        break;
                    }
                    ++j;
                }
                if (!install) {
                    toUninstall.add(currentBInfos[i]);
                }
                ++i;
            }
        }
        i = 0;
        while (i < toInstall.length) {
            try {
                bundleState.installBundle(toInstall[i]);
            }
            catch (RuntimeException runtimeException) {}
            ++i;
        }
        if (exclusiveInstallation) {
            Iterator ite = toUninstall.iterator();
            while (ite.hasNext()) {
                BundleInfo bInfo = (BundleInfo)ite.next();
                bundleState.uninstallBundle(bInfo);
            }
        }
        bundleState.resolve(true);
        manipulator.getConfigData().setBundles(bundleState.getExpectedState());
    }

    public void cleanup(Manipulator manipulator) {
        File outputFile = new File(SimpleConfiguratorManipulatorImpl.getConfigLocation(manipulator).getFile());
        outputFile.delete();
        if (outputFile.getParentFile().isDirectory()) {
            outputFile.getParentFile().delete();
        }
    }

    class LocationInfo {
        String[] prerequisiteLocations = null;
        String systemBundleLocation = null;
        String[] systemFragmentedBundleLocations = null;

        LocationInfo() {
        }
    }
}

