/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.java.ui;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.AbstractContextListener;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.ui.IContextUiStartup;
import org.eclipse.mylyn.internal.java.ui.ActiveFoldingEditorTracker;
import org.eclipse.mylyn.internal.java.ui.InterestUpdateDeltaListener;
import org.eclipse.mylyn.internal.java.ui.JavaEditingMonitor;
import org.eclipse.mylyn.internal.java.ui.JavaUiUtil;
import org.eclipse.mylyn.internal.java.ui.LandmarkMarkerManager;
import org.eclipse.mylyn.internal.java.ui.TypeHistoryManager;
import org.eclipse.mylyn.internal.java.ui.editor.ActiveFoldingListener;
import org.eclipse.mylyn.monitor.ui.MonitorUi;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.BundleContext;

public class JavaUiBridgePlugin
extends AbstractUIPlugin {
    public static final String ID_PLUGIN = "org.eclipse.mylyn.java.ui";
    public static final String AUTO_FOLDING_ENABLED = "org.eclipse.mylyn.context.ui.editor.folding.enabled";
    private static JavaUiBridgePlugin INSTANCE;
    private ActiveFoldingEditorTracker editorTracker;
    private TypeHistoryManager typeHistoryManager;
    private LandmarkMarkerManager landmarkMarkerManager;
    private JavaEditingMonitor javaEditingMonitor;
    private InterestUpdateDeltaListener javaElementChangeListener;
    private static final String MYLYN_FIRST_RUN = "org.eclipse.mylyn.ui.first.run.0_4_9";

    public void start(BundleContext context) throws Exception {
        super.start(context);
        INSTANCE = this;
        this.initDefaultPrefs();
        if (this.getPreferenceStore().getBoolean(MYLYN_FIRST_RUN)) {
            this.getPreferenceStore().setValue(MYLYN_FIRST_RUN, false);
            new UIJob("Initialize Content Assist"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    JavaUiUtil.installContentAssist(JavaPlugin.getDefault().getPreferenceStore(), true);
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    private void lazyStart() {
        this.landmarkMarkerManager = new LandmarkMarkerManager();
        ContextCore.getContextManager().addListener((AbstractContextListener)this.landmarkMarkerManager);
        this.javaEditingMonitor = new JavaEditingMonitor();
        MonitorUi.getSelectionMonitors().add(this.javaEditingMonitor);
        this.installEditorTracker(PlatformUI.getWorkbench());
        this.javaElementChangeListener = new InterestUpdateDeltaListener();
        JavaCore.addElementChangedListener((IElementChangedListener)this.javaElementChangeListener);
        try {
            this.typeHistoryManager = new TypeHistoryManager();
            ContextCore.getContextManager().addListener((AbstractContextListener)this.typeHistoryManager);
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(4, ID_PLUGIN, "Could not install type history manager: incompatible Eclipse version", t));
        }
    }

    private void initDefaultPrefs() {
        this.getPreferenceStore().setDefault(MYLYN_FIRST_RUN, true);
    }

    private void lazyStop() {
        if (this.typeHistoryManager != null) {
            ContextCore.getContextManager().removeListener((AbstractContextListener)this.typeHistoryManager);
        }
        if (this.landmarkMarkerManager != null) {
            ContextCore.getContextManager().removeListener((AbstractContextListener)this.landmarkMarkerManager);
        }
        if (this.javaEditingMonitor != null) {
            MonitorUi.getSelectionMonitors().remove((Object)this.javaEditingMonitor);
        }
        if (this.javaElementChangeListener != null) {
            JavaCore.removeElementChangedListener((IElementChangedListener)this.javaElementChangeListener);
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.lazyStop();
        super.stop(context);
        INSTANCE = null;
    }

    private void installEditorTracker(IWorkbench workbench) {
        this.editorTracker = new ActiveFoldingEditorTracker();
        this.editorTracker.install(workbench);
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow w = iWorkbenchWindowArray[n2];
            IWorkbenchPage page = w.getActivePage();
            if (page != null) {
                IEditorReference[] references;
                IEditorReference[] iEditorReferenceArray = references = page.getEditorReferences();
                int n3 = references.length;
                int n4 = 0;
                while (n4 < n3) {
                    IEditorReference reference = iEditorReferenceArray[n4];
                    IEditorPart part = reference.getEditor(false);
                    if (part != null && part instanceof JavaEditor) {
                        JavaEditor editor = (JavaEditor)part;
                        this.editorTracker.registerEditor(editor);
                        ActiveFoldingListener.resetProjection(editor);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    public static JavaUiBridgePlugin getDefault() {
        return INSTANCE;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)ID_PLUGIN, (String)path);
    }

    public ActiveFoldingEditorTracker getEditorTracker() {
        return this.editorTracker;
    }

    public static class JavaUiBridgeStartup
    implements IContextUiStartup {
        public void lazyStartup() {
            JavaUiBridgePlugin.getDefault().lazyStart();
        }
    }
}

