/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.java.ui;

import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.text.java.CompletionProposalComputerRegistry;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaUiUtil {
    private static final Point SMALL_SIZE = new Point(16, 16);
    private static final String SEPARATOR_CODEASSIST = "\u0000";
    public static final String ASSIST_MYLYN_TYPE = "org.eclipse.mylyn.java.javaTypeProposalCategory";
    public static final String ASSIST_MYLYN_NOTYPE = "org.eclipse.mylyn.java.javaNoTypeProposalCategory";
    public static final String ASSIST_JDT_TYPE = "org.eclipse.jdt.ui.javaTypeProposalCategory";
    public static final String ASSIST_JDT_NOTYPE = "org.eclipse.jdt.ui.javaNoTypeProposalCategory";
    public static final String ASSIST_JDT_TEMPLATE = "org.eclipse.jdt.ui.templateProposalCategory";
    public static final String ASSIST_MYLYN_TEMPLATE = "org.eclipse.mylyn.java.templateProposalCategory";

    public static boolean isDefaultAssistActive(String computerId) {
        Set<String> disabledIds = JavaUiUtil.getDisabledIds(JavaPlugin.getDefault().getPreferenceStore());
        return !disabledIds.contains(computerId);
    }

    public static void installContentAssist(IPreferenceStore javaPrefs, boolean mylynContentAssist) {
        Set<String> disabledIds = JavaUiUtil.getDisabledIds(javaPrefs);
        if (!mylynContentAssist) {
            disabledIds.remove(ASSIST_JDT_TYPE);
            disabledIds.remove(ASSIST_JDT_NOTYPE);
            disabledIds.remove(ASSIST_JDT_TEMPLATE);
            disabledIds.add(ASSIST_MYLYN_NOTYPE);
            disabledIds.add(ASSIST_MYLYN_TYPE);
            disabledIds.add(ASSIST_MYLYN_TEMPLATE);
        } else {
            disabledIds.add(ASSIST_JDT_TYPE);
            disabledIds.add(ASSIST_JDT_NOTYPE);
            disabledIds.add(ASSIST_JDT_TEMPLATE);
            disabledIds.remove(ASSIST_MYLYN_NOTYPE);
            disabledIds.remove(ASSIST_MYLYN_TYPE);
            disabledIds.remove(ASSIST_MYLYN_TEMPLATE);
        }
        String newValue = "";
        for (String id : disabledIds) {
            newValue = String.valueOf(newValue) + id + SEPARATOR_CODEASSIST;
        }
        javaPrefs.setValue("content_assist_disabled_computers", newValue);
        CompletionProposalComputerRegistry.getDefault().reload();
    }

    private static Set<String> getDisabledIds(IPreferenceStore javaPrefs) {
        String oldValue = javaPrefs.getString("content_assist_disabled_computers");
        StringTokenizer tokenizer = new StringTokenizer(oldValue, SEPARATOR_CODEASSIST);
        HashSet<String> disabledIds = new HashSet<String>();
        while (tokenizer.hasMoreTokens()) {
            disabledIds.add((String)tokenizer.nextElement());
        }
        return disabledIds;
    }

    public static ImageDescriptor decorate(ImageDescriptor base, int decorations) {
        JavaElementImageDescriptor imageDescriptor = new JavaElementImageDescriptor(base, decorations, SMALL_SIZE);
        return imageDescriptor;
    }

    public static IJavaElement getJavaElement(ConcreteMarker marker) {
        ICompilationUnit cu;
        block8: {
            if (marker == null) {
                return null;
            }
            IResource res = marker.getResource();
            cu = null;
            if (!(res instanceof IFile)) break block8;
            IFile file = (IFile)res;
            if (file.getFileExtension().equals("java")) {
                cu = JavaCore.createCompilationUnitFrom((IFile)file);
                break block8;
            }
            return null;
        }
        try {
            if (cu != null) {
                IJavaElement je = cu.getElementAt(marker.getMarker().getAttribute("charStart", 0));
                return je;
            }
            return null;
        }
        catch (JavaModelException ex) {
            if (!ex.isDoesNotExist()) {
                ExceptionHandler.handle((CoreException)((Object)ex), (String)"error", (String)"could not find java element");
            }
            return null;
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.java.ui", "Could not find element for: " + marker, t));
            return null;
        }
    }

    public static String getFullyQualifiedName(IJavaElement je) {
        if (!(je instanceof IMember)) {
            return null;
        }
        IMember m = (IMember)je;
        if (m.getDeclaringType() == null) {
            return ((IType)m).getFullyQualifiedName();
        }
        return String.valueOf(m.getDeclaringType().getFullyQualifiedName()) + "." + m.getElementName();
    }

    @Deprecated
    public static void closeActiveEditors(boolean javaOnly) {
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow workbenchWindow = iWorkbenchWindowArray[n2];
            IWorkbenchPage page = workbenchWindow.getActivePage();
            if (page != null) {
                IEditorReference[] references;
                IEditorReference[] iEditorReferenceArray = references = page.getEditorReferences();
                int n3 = references.length;
                int n4 = 0;
                while (n4 < n3) {
                    IEditorReference reference = iEditorReferenceArray[n4];
                    IEditorPart part = reference.getEditor(false);
                    if (part != null) {
                        if (javaOnly && part.getEditorInput() instanceof IFileEditorInput && part instanceof JavaEditor) {
                            JavaEditor editor = (JavaEditor)part;
                            editor.close(true);
                        } else if (part instanceof JavaEditor) {
                            ((AbstractTextEditor)part).close(true);
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }
}

