/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.swt.custom;

import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.FormWidgetFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TabbedPropertyTitle
extends Composite {
    private CLabel label;
    private Image image = null;
    private String text = null;
    private static final String BLANK = "";
    public int marginWidth = 4;
    public int marginHeight = 4;
    private FormWidgetFactory factory;

    public TabbedPropertyTitle(Composite parent, FormWidgetFactory factory) {
        super(parent, 524288);
        this.factory = factory;
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (TabbedPropertyTitle.this.image == null && (TabbedPropertyTitle.this.text == null || TabbedPropertyTitle.this.text.equals(TabbedPropertyTitle.BLANK))) {
                    TabbedPropertyTitle.this.label.setVisible(false);
                } else {
                    TabbedPropertyTitle.this.label.setVisible(true);
                    TabbedPropertyTitle.this.drawTitleBackground(e);
                }
            }
        });
        factory.getColors().initializeSectionToolBarColors();
        this.setBackground(factory.getColors().getBackground());
        this.setForeground(factory.getColors().getForeground());
        FormLayout layout = new FormLayout();
        layout.marginWidth = 11;
        layout.marginHeight = 5;
        this.setLayout((Layout)layout);
        this.label = factory.createCLabel(this, BLANK);
        this.label.setBackground(new Color[]{factory.getColors().getColor("org.eclipse.ui.forms.TB_BG"), factory.getColors().getColor("org.eclipse.ui.forms.TB_BG")}, new int[]{100}, true);
        this.label.setFont(JFaceResources.getBannerFont());
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        this.label.setLayoutData((Object)data);
    }

    protected void drawTitleBackground(PaintEvent e) {
        Color bg = this.factory.getColors().getColor("org.eclipse.ui.forms.TB_BG");
        Color gbg = this.factory.getColors().getColor("org.eclipse.ui.forms.TB_BG");
        Color border = this.factory.getColors().getColor("org.eclipse.ui.forms.TB_BORDER");
        Rectangle bounds = this.getClientArea();
        Object tsize = null;
        Point labelSize = null;
        int twidth = bounds.width - this.marginWidth - this.marginWidth;
        if (this.label != null) {
            labelSize = this.label.computeSize(-1, -1, true);
        }
        if (labelSize != null) {
            twidth -= labelSize.x + 4;
        }
        int tvmargin = 4;
        int theight = this.getHeight();
        if (tsize != null) {
            theight += Math.max(theight, tsize.y);
        }
        if (labelSize != null) {
            theight = Math.max(theight, labelSize.y);
        }
        int midpoint = (theight += tvmargin + tvmargin) * 66 / 100;
        int rem = theight - midpoint;
        GC gc = e.gc;
        gc.setForeground(bg);
        gc.setBackground(gbg);
        gc.fillGradientRectangle(this.marginWidth, this.marginHeight, bounds.width - 1 - this.marginWidth - this.marginWidth, midpoint - 1, true);
        gc.setForeground(gbg);
        gc.setBackground(this.getBackground());
        gc.fillGradientRectangle(this.marginWidth, this.marginHeight + midpoint - 1, bounds.width - 1 - this.marginWidth - this.marginWidth, rem - 1, true);
        gc.setForeground(border);
        gc.drawLine(this.marginWidth, this.marginHeight + 2, this.marginWidth, this.marginHeight + theight - 1);
        gc.drawLine(this.marginWidth, this.marginHeight + 2, this.marginWidth + 2, this.marginHeight);
        gc.drawLine(this.marginWidth + 2, this.marginHeight, bounds.width - this.marginWidth - 3, this.marginHeight);
        gc.drawLine(bounds.width - this.marginWidth - 3, this.marginHeight, bounds.width - this.marginWidth - 1, this.marginHeight + 2);
        gc.drawLine(bounds.width - this.marginWidth - 1, this.marginHeight + 2, bounds.width - this.marginWidth - 1, this.marginHeight + theight - 1);
    }

    public void setTitle(String text, Image image) {
        this.text = text;
        this.image = image;
        if (text != null) {
            this.label.setText(text);
        } else {
            this.label.setText(BLANK);
        }
        this.label.setImage(image);
        this.redraw();
    }

    public int getHeight() {
        Shell shell = new Shell();
        GC gc = new GC((Drawable)shell);
        gc.setFont(this.getFont());
        Point point = gc.textExtent(BLANK);
        ++point.x;
        int textOrImageHeight = Math.max(point.x, 16);
        gc.dispose();
        shell.dispose();
        return textOrImageHeight + 8;
    }
}

