/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views;

import org.eclipse.birt.report.designer.internal.ui.editors.parts.event.IFastConsumerProcessor;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.AbstractModelEventProcessor;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.ContentEvent;
import org.eclipse.birt.report.model.api.command.NameEvent;

public class DataViewEventProcessor
extends AbstractModelEventProcessor
implements IFastConsumerProcessor {
    public static String EVENT_CONTENT = "Event Content";
    public static String VARIABLE_NAME = "Variable Name";

    public DataViewEventProcessor(AbstractModelEventProcessor.IModelEventFactory factory) {
        super(factory);
    }

    protected AbstractModelEventProcessor.ModelEventInfoFactory createModelEventInfoFactory() {
        return new DataViewModelEventInfoFactory();
    }

    protected boolean includeEventType(int type) {
        return true;
    }

    public boolean isOverdued() {
        return this.getFactory().isDispose();
    }

    protected static class DataViewContentModelEventInfo
    extends AbstractModelEventProcessor.ModelEventInfo {
        private DataViewContentModelEventInfo(DesignElementHandle focus, NotificationEvent ev) {
            super(focus, ev);
            assert (ev instanceof ContentEvent);
            this.setContent(((ContentEvent)ev).getContent());
        }

        public boolean canAcceptModelEvent(AbstractModelEventProcessor.ModelEventInfo info) {
            return false;
        }

        public Object getContent() {
            return this.getOtherInfo().get(EVENT_CONTENT);
        }

        public void setContent(Object obj) {
            this.getOtherInfo().put(EVENT_CONTENT, obj);
        }
    }

    private static class DataViewModelEventInfoFactory
    implements AbstractModelEventProcessor.ModelEventInfoFactory {
        private DataViewModelEventInfoFactory() {
        }

        public AbstractModelEventProcessor.ModelEventInfo createModelEventInfo(DesignElementHandle focus, NotificationEvent ev) {
            switch (ev.getEventType()) {
                case 0: {
                    if (ev instanceof ContentEvent && focus instanceof ModuleHandle) {
                        ContentEvent event = (ContentEvent)ev;
                        if (event.getAction() == 2) {
                            DesignElementHandle contentHandle = event.getContent().getHandle(focus.getRoot().getModule());
                            if (contentHandle instanceof ParameterHandle) {
                                return new DataViewParameterModelEventInfo((ParameterHandle)contentHandle, ev);
                            }
                        } else {
                            if (event.getAction() == 1) {
                                return new DataViewContentModelEventInfo(focus, ev);
                            }
                            return new RefreshModelEventInfo(focus, ev);
                        }
                    }
                }
                case 3: {
                    if (focus instanceof ParameterHandle) {
                        return new DataViewParameterModelEventInfo((ParameterHandle)focus, ev);
                    }
                }
                case 5: {
                    if (!(focus instanceof ParameterHandle)) break;
                    return new DataViewParameterModelEventInfo((ParameterHandle)focus, ev);
                }
            }
            return new RefreshModelEventInfo(focus, ev);
        }
    }

    protected static class DataViewParameterModelEventInfo
    extends AbstractModelEventProcessor.ModelEventInfo {
        private DataViewParameterModelEventInfo(ParameterHandle focus, NotificationEvent ev) {
            super((DesignElementHandle)focus, ev);
            assert (ev instanceof ContentEvent);
            switch (ev.getEventType()) {
                case 0: {
                    this.setVariableName(focus.getName());
                }
                case 3: {
                    if (ev instanceof NameEvent) {
                        this.setVariableName(((NameEvent)ev).getOldName());
                    }
                }
                case 5: {
                    this.setVariableName(focus.getName());
                }
            }
        }

        public boolean canAcceptModelEvent(AbstractModelEventProcessor.ModelEventInfo info) {
            return false;
        }

        public Object getVariableName() {
            return this.getOtherInfo().get(VARIABLE_NAME);
        }

        public void setVariableName(Object obj) {
            this.getOtherInfo().put(VARIABLE_NAME, obj);
        }
    }

    protected static class RefreshModelEventInfo
    extends AbstractModelEventProcessor.ModelEventInfo {
        private RefreshModelEventInfo(DesignElementHandle focus, NotificationEvent ev) {
            super(focus, ev);
        }

        public boolean canAcceptModelEvent(AbstractModelEventProcessor.ModelEventInfo info) {
            return info.getType() != 0;
        }
    }
}

