/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.page;

import org.eclipse.birt.report.designer.internal.ui.dialogs.FormatChangeEvent;
import org.eclipse.birt.report.designer.internal.ui.dialogs.IFormatChangeListener;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.AttributePage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.FormatDataTimeDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.section.FormatDateTimeSection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class FormatDateTimeAttributePage
extends AttributePage {
    private FormatDateTimeSection formatSection;
    private FormatDataTimeDescriptorProvider provider;

    public void buildUI(Composite parent) {
        super.buildUI(parent);
        this.container.setLayout((Layout)new GridLayout(1, false));
        this.provider = new FormatDataTimeDescriptorProvider();
        this.formatSection = new FormatDateTimeSection(this.container, 0, true);
        this.formatSection.setProvider(this.provider);
        this.addSection("FORMATDATETIME_FORMAT", this.formatSection);
        this.createSections();
        this.layoutSections();
        this.formatSection.addFormatChangeListener(new IFormatChangeListener(){

            public void formatChange(FormatChangeEvent event) {
                if (FormatDateTimeAttributePage.this.formatSection.getFormatControl().isDirty() && FormatDateTimeAttributePage.this.formatSection.getFormatControl().isFormatModified()) {
                    try {
                        FormatDateTimeAttributePage.this.provider.save(new String[]{event.getCategory(), event.getPattern()});
                    }
                    catch (Exception e) {
                        ExceptionHandler.handle((Throwable)e);
                    }
                    if (event.getCategory() != null || event.getPattern() != null) {
                        FormatDateTimeAttributePage.this.refresh();
                    }
                }
            }
        });
    }
}

