/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.provider;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.CategoryPage;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.views.attributes.ICategoryPage;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ICategoryProvider;
import org.eclipse.jface.text.Assert;

public class CategoryProvider
implements ICategoryProvider {
    private ICategoryPage[] categories;

    public CategoryProvider(String categoryKey, String category, Class pageClass) {
        this(new String[]{categoryKey}, new String[]{category}, new Class[]{pageClass});
    }

    public CategoryProvider(String[] categoryKeys, String[] categories, Class[] pageClasses) {
        Assert.isLegal((categories.length == pageClasses.length ? 1 : 0) != 0);
        this.categories = new ICategoryPage[categories.length];
        int i = 0;
        while (i < categories.length) {
            String displayLabel = Messages.getString((String)categories[i]);
            this.categories[i] = new CategoryPage(categoryKeys[i], displayLabel, pageClasses[i]);
            ++i;
        }
    }

    public void addCategory(String categoryKey, String categorie, Class pageClass) {
        CategoryPage page = new CategoryPage(categoryKey, categorie, pageClass);
        this.addCategory(page);
    }

    public void addCategory(String categoryKey, String categorie, Class pageClass, int index) {
        CategoryPage page = new CategoryPage(categoryKey, categorie, pageClass);
        this.addCategory(page, index);
    }

    public void addCategory(ICategoryPage category) {
        this.addCategory(category, this.categories.length);
    }

    public void addCategory(ICategoryPage category, int index) {
        List<ICategoryPage> temp = Arrays.asList(this.categories);
        LinkedList<ICategoryPage> list = new LinkedList<ICategoryPage>();
        list.addAll(temp);
        list.add(index, category);
        this.categories = new ICategoryPage[list.size()];
        list.toArray(this.categories);
    }

    public int getCategoryIndex(ICategoryPage category) {
        return this.getCategoryIndex(category.getCategoryKey());
    }

    public int getCategoryIndex(String categoryKey) {
        int i = 0;
        while (i < this.categories.length) {
            if (this.categories[i].getCategoryKey().equals(categoryKey)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public ICategoryPage[] getCategories() {
        return this.categories;
    }
}

