/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.FormatChangeEvent;
import org.eclipse.birt.report.designer.internal.ui.dialogs.IFormatChangeListener;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDescriptorProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.FormatDateTimePattern;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;

public class FormatDataTimeDescriptorProvider
implements IDescriptorProvider {
    private Object input;
    private Date defaultDate;
    private String[][] choiceArray = null;
    private String[] formatTypes = null;
    private List listeners = new ArrayList();
    public String DATETIEM_FORMAT_TYPE_UNFORMATTED = "Unformatted";
    public String DATETIEM_FORMAT_TYPE_CUSTOM = "Custom";
    public String NUMBER_FORMAT_TYPE_CUSTOM = "Custom";
    public String DATETIEM_FORMAT_TYPE_GENERAL_DATE = "General Date";
    public String DATETIEM_FORMAT_TYPE_LONG_DATE = "Long Date";
    public String DATETIEM_FORMAT_TYPE_MUDIUM_DATE = "Medium Date";
    public String DATETIEM_FORMAT_TYPE_SHORT_DATE = "Short Date";
    public String DATETIEM_FORMAT_TYPE_LONG_TIME = "Long Time";
    public String DATETIEM_FORMAT_TYPE_MEDIUM_TIME = "Medium Time";
    public String DATETIEM_FORMAT_TYPE_SHORT_TIME = "Short Time";

    public String getDisplayName() {
        return null;
    }

    public Object load() {
        if (DEUtil.getInputElements((Object)this.input).isEmpty()) {
            return null;
        }
        String baseCategory = ((DesignElementHandle)DEUtil.getInputFirstElement((Object)this.input)).getPrivateStyle().getDateTimeFormatCategory();
        String basePattern = ((DesignElementHandle)DEUtil.getInputFirstElement((Object)this.input)).getPrivateStyle().getDateTimeFormat();
        for (DesignElementHandle handle : DEUtil.getInputElements((Object)this.input)) {
            String category = handle.getPrivateStyle().getDateTimeFormatCategory();
            String pattern = handle.getPrivateStyle().getDateTimeFormat();
            if ((baseCategory == null && category == null || baseCategory != null && baseCategory.equals(category)) && (basePattern == null && pattern == null || basePattern != null && basePattern.equals(pattern))) continue;
            return null;
        }
        return new String[]{baseCategory, basePattern};
    }

    public void save(Object value) throws SemanticException {
        String[] result = (String[])value;
        if (result.length == 2) {
            CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
            stack.startTrans(Messages.getString((String)"FormatDateTimeAttributePage.Trans.SetDateTimeFormat"));
            for (DesignElementHandle element : DEUtil.getInputElements((Object)this.input)) {
                try {
                    if (result[0] == null && result[1] == null) {
                        element.setProperty("dateTimeFormat", null);
                        continue;
                    }
                    element.getPrivateStyle().setDateTimeFormatCategory(result[0]);
                    element.getPrivateStyle().setDateTimeFormat(result[1]);
                }
                catch (SemanticException e) {
                    ExceptionHandler.handle((Throwable)e);
                    stack.rollbackAll();
                    return;
                }
            }
            stack.commit();
        }
    }

    public void setInput(Object input) {
        this.input = input;
    }

    public FormatDataTimeDescriptorProvider() {
        this.defaultDate = new Date();
    }

    private String getDisplayName4Category(String category) {
        return ChoiceSetFactory.getStructDisplayName((String)"DateTimeFormatValue", (String)"category", (String)category);
    }

    public String[][] getTableItems() {
        ArrayList<String[]> itemList = new ArrayList<String[]>();
        String[][] items = new String[][]{{this.getDisplayName4Category("General Date"), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"General Date")).format(this.defaultDate), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"General Date")).getFormatCode()}, {this.getDisplayName4Category("Long Date"), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"Long Date")).format(this.defaultDate), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"Long Date")).getFormatCode()}, {this.getDisplayName4Category("Medium Date"), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"Medium Date")).format(this.defaultDate), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"Medium Date")).getFormatCode()}, {this.getDisplayName4Category("Short Date"), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"Short Date")).format(this.defaultDate), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"Short Date")).getFormatCode()}, {this.getDisplayName4Category("Long Time"), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"Long Time")).format(this.defaultDate), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"Long Time")).getFormatCode()}, {this.getDisplayName4Category("Medium Time"), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"Medium Time")).format(this.defaultDate), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"Medium Time")).getFormatCode()}, {this.getDisplayName4Category("Short Time"), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"Short Time")).format(this.defaultDate), new DateFormatter(FormatDateTimePattern.getPatternForCategory((String)"Short Time")).getFormatCode()}};
        itemList.addAll(Arrays.asList(items));
        String[] customPatterns = FormatDateTimePattern.getCustormPatternCategorys();
        int i = 0;
        while (i < customPatterns.length) {
            itemList.add(new String[]{FormatDateTimePattern.getDisplayName4CustomCategory((String)customPatterns[i]), new DateFormatter(FormatDateTimePattern.getCustormFormatPattern((String)customPatterns[i])).format(this.defaultDate), FormatDateTimePattern.getCustormFormatPattern((String)customPatterns[i])});
            ++i;
        }
        return (String[][])itemList.toArray((T[])new String[0][3]);
    }

    public String getCategory4UIDisplayName(String displayName) {
        if (this.initChoiceArray() != null) {
            int i = 0;
            while (i < this.choiceArray.length) {
                if (this.formatTypes[i].equals(displayName)) {
                    return this.choiceArray[i][1];
                }
                ++i;
            }
        }
        return displayName;
    }

    public String[][] initChoiceArray() {
        if (this.choiceArray == null) {
            IChoiceSet set = ChoiceSetFactory.getStructChoiceSet((String)"DateTimeFormatValue", (String)"category");
            IChoice[] choices = set.getChoices();
            if (choices.length > 0) {
                this.choiceArray = new String[choices.length][2];
                int i = 0;
                int j = 0;
                while (i < choices.length) {
                    this.choiceArray[j][0] = choices[i].getDisplayName();
                    this.choiceArray[j][1] = choices[i].getName();
                    ++j;
                    ++i;
                }
            } else {
                this.choiceArray = new String[0][0];
            }
        }
        return this.choiceArray;
    }

    public String[] getFormatTypes() {
        if (this.initChoiceArray() != null) {
            this.formatTypes = new String[this.choiceArray.length];
            int i = 0;
            while (i < this.choiceArray.length) {
                String fmtStr = "";
                String category = this.choiceArray[i][1];
                if (category.equals("Custom") || category.equals("Unformatted")) {
                    fmtStr = this.choiceArray[i][0];
                } else {
                    String pattern = FormatDateTimePattern.getPatternForCategory((String)category);
                    fmtStr = new DateFormatter(pattern).format(this.defaultDate);
                }
                this.formatTypes[i] = fmtStr;
                ++i;
            }
        } else {
            this.formatTypes = new String[0];
        }
        return this.formatTypes;
    }

    public int getIndexOfCategory(String category) {
        if (this.initChoiceArray() != null) {
            int i = 0;
            while (i < this.choiceArray.length) {
                if (this.choiceArray[i][1].equals(category)) {
                    return i;
                }
                ++i;
            }
        }
        return 0;
    }

    public void fireFormatChanged(String newCategory, String newPattern) {
        if (this.listeners.isEmpty()) {
            return;
        }
        FormatChangeEvent event = new FormatChangeEvent((Object)this, "dateTimeFormat", newCategory, newPattern);
        for (Object listener : this.listeners) {
            if (!(listener instanceof IFormatChangeListener)) continue;
            ((IFormatChangeListener)listener).formatChange(event);
        }
    }

    public void addFormatChangeListener(IFormatChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public String getPattern(String displayName) {
        String category = ChoiceSetFactory.getStructPropValue((String)"DateTimeFormatValue", (String)"category", (String)displayName);
        return FormatDateTimePattern.getPatternForCategory((String)category);
    }
}

