/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.provider;

import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDescriptorProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.GroupElementHandle;
import org.eclipse.birt.report.model.api.GroupPropertyHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;

public class PropertyDescriptorProvider
implements IDescriptorProvider {
    protected String property;
    protected String element;
    protected Object input;

    public PropertyDescriptorProvider(String property, String element) {
        this.property = property;
        this.element = element;
    }

    public Object load() {
        String value = null;
        if (this.input instanceof GroupElementHandle) {
            value = ((GroupElementHandle)this.input).getStringProperty(this.property);
        } else if (this.input instanceof List) {
            value = DEUtil.getGroupElementHandle((List)((List)this.input)).getStringProperty(this.property);
        }
        return value == null ? "" : value;
    }

    public void save(Object value) throws SemanticException {
        if (this.input instanceof GroupElementHandle) {
            ((GroupElementHandle)this.input).setProperty(this.property, value);
        } else if (this.input instanceof List) {
            DEUtil.getGroupElementHandle((List)((List)this.input)).setProperty(this.property, value);
        }
    }

    public String getDisplayName() {
        String name = null;
        if (this.input instanceof GroupElementHandle && this.input != null) {
            IElementPropertyDefn propertyDefn = ((GroupElementHandle)this.input).getPropertyHandle(this.property).getPropertyDefn();
            if (propertyDefn != null) {
                name = propertyDefn.getDisplayName();
            }
        } else {
            IElementPropertyDefn propertyDefn = DesignEngine.getMetaDataDictionary().getElement(this.element).getProperty(this.property);
            if (propertyDefn != null) {
                name = Messages.getString((String)propertyDefn.getDisplayNameID());
            }
        }
        if (name == null) {
            return "";
        }
        return name;
    }

    public String getLocalStringValue() {
        if (this.input instanceof GroupElementHandle) {
            String value = ((GroupElementHandle)this.input).getLocalStringProperty(this.property);
            if (value == null) {
                return "";
            }
            return value;
        }
        return "";
    }

    public void setInput(Object input) {
        this.input = input;
    }

    protected String getElement() {
        return this.element;
    }

    protected String getProperty() {
        return this.property;
    }

    public boolean isReadOnly() {
        GroupPropertyHandle propertyHandle;
        if (this.input instanceof GroupElementHandle && (propertyHandle = ((GroupElementHandle)this.input).getPropertyHandle(this.property)) != null) {
            return propertyHandle.isReadOnly();
        }
        return false;
    }
}

