/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.AbstractFormHandleProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.SortingModelProvider;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.command.PropertyEvent;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;

public class SortingHandleProvider
extends AbstractFormHandleProvider {
    protected List contentInput;
    private String[] columnKeys = new String[]{"key", "direction"};
    private static int[] columnWidth = new int[]{250, 250};
    protected SortingModelProvider modelAdapter = new SortingModelProvider();
    private String[] columnNames;
    private CellEditor[] editors;

    public String[] getColumnNames() {
        if (this.columnNames == null) {
            this.columnNames = this.modelAdapter.getColumnNames(this.columnKeys);
        }
        return this.columnNames;
    }

    public String getDisplayName() {
        return Messages.getString((String)"SortingHandleProvider.Label.SortOn");
    }

    public CellEditor[] getEditors(Table table) {
        if (this.editors == null) {
            this.editors = new CellEditor[this.columnKeys.length];
            this.editors[0] = new TextCellEditor((Composite)table);
            this.editors[1] = new TextCellEditor((Composite)table);
        }
        return this.editors;
    }

    public boolean doMoveItem(int oldPos, int newPos) throws PropertyValueException {
        return this.modelAdapter.moveItem(this.contentInput.get(0), oldPos, newPos);
    }

    public boolean doDeleteItem(int pos) throws PropertyValueException {
        return this.modelAdapter.deleteItem(this.contentInput.get(0), pos);
    }

    public boolean doAddItem(int pos) throws SemanticException {
        return this.modelAdapter.doAddItem(this.contentInput.get(0), pos);
    }

    public boolean doEditItem(int pos) {
        return this.modelAdapter.doEditItem(this.contentInput.get(0), pos);
    }

    public String getColumnText(Object element, int columnIndex) {
        String key = this.columnKeys[columnIndex];
        return this.modelAdapter.getText(element, key);
    }

    public String getImagePath(Object element, int columnIndex) {
        return null;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof List) {
            this.contentInput = (List)inputElement;
        } else {
            this.contentInput = new ArrayList();
            this.contentInput.add(inputElement);
        }
        Object[] elements = this.modelAdapter.getElements(this.contentInput);
        return elements;
    }

    public boolean canModify(Object element, String property) {
        return false;
    }

    public Object getValue(Object element, String property) {
        int index = Arrays.asList(this.columnNames).indexOf(property);
        String columnText = this.getColumnText(element, index);
        return columnText;
    }

    public boolean modify(Object data, String property, Object value) throws NameException, SemanticException {
        String strValue;
        int index = Arrays.asList(this.columnNames).indexOf(property);
        String key = this.columnKeys[index];
        if (value instanceof Integer) {
            int intValue = (Integer)value;
            if (intValue == -1) {
                CCombo combo = (CCombo)this.editors[index].getControl();
                strValue = combo.getText();
            } else {
                String[] choices = this.modelAdapter.getChoiceSet(this.contentInput.get(0), this.columnKeys[index]);
                strValue = choices[intValue];
            }
        } else {
            strValue = (String)value;
        }
        return this.modelAdapter.setStringValue(this.contentInput.get(0), data, key, strValue);
    }

    public int[] getColumnWidths() {
        return columnWidth;
    }

    public boolean needRefreshed(NotificationEvent event) {
        String propertyName;
        return event instanceof PropertyEvent && "sort".equals(propertyName = ((PropertyEvent)event).getPropertyName());
    }

    public boolean isEditable() {
        return ((ReportItemHandle)DEUtil.getInputFirstElement((Object)this.input)).getDataBindingType() != 2;
    }
}

